package RT::MIME;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;

use base 'Exporter';
our @EXPORT_OK = qw(mime_parse);

use MIME::Parser;

sub mime_parse($;%) {
	my ( $data, %options ) = @_;
	%options = ( output_to_core => 1, tmp_to_core => 1, %options );
	my $parser = MIME::Parser->new;
	while ( my ( $option, $value ) = each %options ) {
		$parser->$option($value);
	}

	if ( ref $data eq 'SCALAR' ) { $parser->parse_data($data) }
	else { $parser->parse($data) }
}

1
