package RT::AddOns;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use Dbase::Globals qw(map_descr);

our %AddOn = map_descr rt_queue => 'addon,!hide' unless $ENV{TESTING};
while ( my ($addon) = each %AddOn ) {
	eval 'use ' . ( my $package = "RT::AddOn::\u$addon" );
	die "Error loading $package: $@\n" if length $@;
}

sub call($$$;@) {
	my $package = shift;
	my $addon   = shift;
	my $method  = shift;
	eval 'require ' . ( my $apackage = "RT::AddOn::\u$addon" );
	$apackage->$method(@_);
}

sub dispatch($$$;@) {
	my $package = shift;
	my $queue   = shift or die 'Queue name missing';
	my $method  = shift or die 'Method name missing';
	my @return_values;

	# sicherheitshalber nicht each(), um in jedem Fall alle AddOns
	# zu berücksichtigen, vgl. z. B. RT#435135.
	for my $addon ( keys %AddOn ) {
		my $addon_package = "RT::AddOn::\u$addon";
		no warnings 'once';
		no strict 'refs';
		push @return_values, $addon_package->$method(@_)
		  if $RT::queues{$queue}{$addon}
		  || ${ $addon_package . '::all_queues' }{$method};
	}
	if (wantarray) { @return_values }
	elsif (@return_values) {
		no warnings 'uninitialized';
		join '; ', @return_values;
	}
	else { undef }
}

1;
