package RT::AddOn::Show_similar;

use utf8;
use warnings; no warnings qw(once redefine uninitialized);
use strict;
use base 'RT::AddOn';

use Dbase::Globals qw(get_descr);
use Dbase::Help qw(DoSelect);
use RT::ui::web::support qw(req_url);

use constant MAX_TICKETS => 3;

sub show_form {
	my ( $package, $req, $request ) = @_;
	( my $serial = $req->{serial_num} ) =~ /^\d+\z/ or die;

	my ( @tickets, $even_more );
	DoSelect {
		my %ticket = (
			id                => shift,
			beginn            => shift,
			ist_alt           => shift,
			status            => get_descr( tickets => shift ),
			queue             => shift,
			ist_gleiche_queue => shift,
			area              => shift,
			bearbeiter        => shift,
		);
		if ( $ticket{ist_alt} && @tickets >= MAX_TICKETS ) {
			$even_more = 1;
			last;
		}
		else { push @tickets, \%ticket }
		
	}
	<<_
	SELECT    aehnliches_ticket.id,
	          DATE_FORMAT(FROM_UNIXTIME(aehnliches_ticket.beginn), '%Y-%m-%d %H:%i'),
	          DATE_ADD( FROM_UNIXTIME(aehnliches_ticket.beginn), INTERVAL 1 MONTH ) < NOW(),
	          aehnliches_ticket.status,
	          queue.name,
	          ticket.queue = aehnliches_ticket.queue,
		  queue_areas.name,
	          person.user
	FROM      ( ticket, ticket aehnliches_ticket )
	JOIN      queue       ON       queue.id = aehnliches_ticket.queue
	LEFT JOIN person      ON      person.id = aehnliches_ticket.bearbeiter
	LEFT JOIN queue_areas ON queue_areas.id = aehnliches_ticket.queue_area
	WHERE     ticket.id             = $serial
	      AND ticket.id             > aehnliches_ticket.id
	      AND ticket.subject        = aehnliches_ticket.subject
	      AND aehnliches_ticket.id  = aehnliches_ticket.ticket
	ORDER BY  aehnliches_ticket.beginn DESC
_
	  or return;

	require RT::CGI4AddOn;
	my $cgi = RT::CGI4AddOn->new;
	print $cgi->table(
		{
			border      => 1,
			cellpadding => 4,
			cellspacing => 0,
		},
		$cgi->caption(
			$cgi->strong(
				  ( $even_more ? 'n&auml;chst' : '' )
				. '&auml;ltere'
				  . ( @tickets == 1 ? 's Ticket' : ' Tickets' )
				  . ' mit gleichem Titel:'
			)
		),
		$cgi->Tr(
			{ bgcolor => '#ccccff' },
			$cgi->th( [qw/Nr ge&ouml;ffnet Status Queue Area Bearbeiter/] )
		),
		map {
			my $ticket = $_;
			$ticket->{link} = $cgi->a(
				{
					href => req_url(
						$request,
						display    => 'History',
						serial_num => $_->{id},
					)
				},
				$_->{id}
			);
			$ticket->{link} = $cgi->strong( $ticket->{link} )
			  if $ticket->{ist_gleiche_queue};
			$cgi->Tr(
				{ bgcolor => $ticket->{ist_alt} ? '#ccffcc' : '#ffffcc' },
				map $cgi->td( $ticket->{$_} || '-' ),
				qw(link beginn status queue area bearbeiter)
			  )
		  } @tickets
	  ),
	  $cgi->br;
}

1;
