#!/usr/bin/perl

use utf8;
use strict;
use warnings;
no warnings 'redefine';
use CGI::Carp qw(fatalsToBrowser);
use Umlaut qw(utf8modus);

BEGIN {
	unshift @INC, ( $ENV{'POPHOME'} || '@POPHOME@' ) . '/lib'
		unless $ENV{'KUNDE_NO_PERLPATH'};
	eval "use Apache2::RequestRec;";
	eval "use Apache;" if $@;
}

use Cf qw($BGCOLOR);
use Dbase::Globals qw(
  content
  def_or_minus
  find_descr
  flush_std_cache
  get_kunde
  get_person
  is_hotline
  iso_intervall
  name_kunde
  test_flag
);
use Dbase::Help qw(Do DoFn DoSelect isodate isotime unixdate unixtime
	qquote DoTime DoTrans in_test);
use Loader qw(db_stunden_konflikt log_update update_hotline_cache);
use CGI qw(:standard remote_user center delete_all popup_menu);
use noris::Ticket::API qw(clean_connection_pool get_pooled_connection);

use Encode qw();
use UTFkram qw(decode_anything);
use HTTPerror qw(run);

utf8modus(\*STDOUT);

sub enc($) {
	my($txt) = @_;
	return "&nbsp;" unless defined $txt;
	return decode_anything($txt);
}


run {
my $user;
eval { $user = Apache2::RequestRec->user(); };
$user = Apache->request->connection->user() if $@;
die "kein User bekannt.\n" unless $user;

# für spätere Aufrufe von stunden_bereich():
local $ENV{TICKET_API_USER} = $user;

my $person	= get_person($user);
my $ze_textfield;
if (defined(my $flag_ze_textfield  = find_descr pwdomain=>'ze_textfield')) {
	$ze_textfield = DoFn "SELECT pwuse & (1<<$flag_ze_textfield) FROM person WHERE id = $person";
}
{
    no warnings 'once';
    $Db::current_user = $person;
}

my $id	 	= param('id');
my $end_last= param('end_last');
my $action	= param('action');
my $saction = $action; $saction =~ s/^(?:set_)?/set_/;
my $debug   = "";

$RT::warnung="";
sub warnung {
	$RT::warnung .= br if content($RT::warnung);
	$RT::warnung .= shift;
}
#local $SIG{__WARN__} = sub {
#	my $msg = "";
#	($msg = "@_") =~ s/\n/br/eg;
#	$warnung .= $msg;
#};

my $year	= param('year');
my $month	= param('month');
my $day		= param('day');
my $datum	= param('datum');
if ($datum) {
	require Date::Parse;
	if (my $time = Date::Parse::str2time($datum)) {
		($year, $month, $day) = (localtime $time)[5,4,3];
		$year += 1900;
		$month++;
	} else {
		require HTML::Entities;
		warnung('"'
			  . HTML::Entities::encode($datum)
			  . qq(" ist kein gültiges Datum.) );
	}
}

my $bhour = param("bhour");
my $bminute = param("bminute");
my $ehour = param("ehour");
my $eminute = param("eminute");

my $kunde = param("kunde");
my $kurztext = param("kurztext");
if ( defined $kurztext ) {
	$kurztext = decode_anything($kurztext);
	$kurztext =~ y/\0-\037/ /s;
	$kurztext =~ s/^\s+//;
	$kurztext =~ s/\s+\z//;
}
my $ticket = param("ticket"); # Eingabe
my $redo = param("redo");
my $art = param("art");

my $was = param("was");

delete_all();

my ( %art, @art, %artFaktor, %artFlags, $artStd, @art_9bis17 );
{
	DoSelect {
		my ( $id, $name, $faktor, $flags ) = @_;
		$artStd = $id unless defined $artStd;

		return if test_flag( stunden_art => hide => $flags );
		push( @art, $id );
		$art{$id}       = ucfirst $name;
		$artFaktor{$id} = $faktor;
		$artFlags{$id}  = $flags;
		push @art_9bis17, $id if test_flag( stunden_art => '9bis17', $flags );
	}
	'SELECT id, name, faktor, flags FROM stunden_art ORDER BY id';
}

if($id) {
	# alter Eintrag wurde aufgerufen
	my($kt,$d,$l,$u,$k,$t,$a) = DoFn("select infotext,beginn,dauer,person,kunde,ticket,art from stunden where id = $id");
	$kurztext=$kt unless content $kurztext;
	die "User: $u $person $user\n" unless $u == $person;
	($year,$month,$day) = isodate($d) unless $year;

	if(not defined $bhour) {
		($year,$month,$day,$bhour,$bminute) = isotime($d);
		(undef,undef,undef,$ehour,$eminute) = isotime($d+$l);
		$ehour = 24 if $ehour == 0 and $eminute == 0;
	}
	$kunde = name_kunde($k) unless defined $kunde;
	$ticket = $t unless defined $ticket;
	$art = $a unless defined $art;
}

$art = $artStd unless defined $art;

my $today;
if($end_last) {
	$today	= $end_last;
	($year,$month,$day) = isodate($today);
} elsif($year) {
	$today	= unixdate($year,$month,$day);
} else {
	$today	= DoTime;
	($year,$month,$day) = isodate($today);
}
$today   = unixdate(isodate($today));  # toss time
my $tomor   = unixdate(isodate($today+25*60*60+2));
my $heute = ($today<=DoTime() and $tomor > DoTime());

$end_last = DoTime() if $heute;

my $ny=$year;
my $nm=$month;
if(++$nm > 12) { $ny++; $nm=1; }

my $thism	= unixdate($year,$month,1);
my $nextm	= unixdate($ny,$nm,1);

my $darf = DoFn("select abschluss from perso where person = $person");

my $kdnr	= get_kunde($kunde);

my $script;
if(defined $redo and $redo eq "y") {
$script = <<END;
 function show(URL1,F1)
 {  
  parent.frames[F1].location.href=URL1;
 }
END
} else {
$script = <<END;
 function show(URL1,F1)
 {  
 }
END
}

$script .= <<'1' . ( @art_9bis17 > 0 && <<2 ) . <<'3';
function checkLen(target) {
  var maxlength = "250";  //die maximale Zeichenlaenge
  strLen = target.value.length;
  if (strLen == 1 && target.value == " ") {
    target.value="";  strLen = 0;
  }
  charsLeft = maxlength-strLen;
  document.Manipulate.Anzahl.value = charsLeft;
}

function check_9bis17(target) {
1
	if ( ${\ join ' || ', map "target.value == $_", @art_9bis17 } ) {
		document.Manipulate.bhour.value = 9
		document.Manipulate.bminute.value = 0
		document.Manipulate.ehour.value = 17
		document.Manipulate.eminute.value = 0
	}
2
}
3

my($nhour,$nminute);
if($heute) {
	my $now = 5*60*int(DoTime()/5/60);
	(undef,undef,undef,$nhour,$nminute)=isotime($now);
	$script .= <<END;
function setToCurrentTime(h_field, m_field) {
        var d = new Date;
        var h = d.getHours(),
            m = Math.floor(d.getMinutes()/5) * 5;
	h_field.value = h;
	m_field.value = m;
}
END
}


if(not $id and not $year) {
	$action = "add";
	($year,$month,$day) = isodate(DoTime);
	warnung('keine CGI-Parameter!?');
}

if($action ne "more") {
	$debug.=".more";

	$was = "" if not defined $was;
	
	if(not defined $bhour or $bhour eq "") {
		my $bt;
		if($end_last) {
			$debug.=".el";
			my $bt2;
			if($heute) {
				$debug.=".heute";
				$bt = DoFn("select beginn+dauer as bd from stunden where person = $person and beginn+dauer >= $today and beginn+dauer < $end_last order by bd desc limit 1");
				$bt2 = DoFn("select beginn as bd from stunden where person = $person and beginn >= $today and beginn <= $end_last order by bd desc limit 1");
			} else {
				$debug.=".!heute";
				$bt = DoFn("select beginn+dauer as bd from stunden where person = $person and beginn+dauer >= $today and beginn+dauer < $end_last order by bd desc limit 1");
				$bt2 = DoFn("select beginn as bd from stunden where person = $person and beginn >= $today and beginn < $end_last order by bd desc limit 1");
			}
			$bt = $bt2 if not defined $bt or defined $bt2 and $bt2 > $bt;
		} else {
			$debug.=".!el";
			$bt = DoFn("select beginn+dauer as bd from stunden where person = $person and beginn+dauer >= $today and beginn+dauer < $tomor order by bd desc limit 1");
		}

		if($bt) {
			$bt = 5*60*int($bt/5/60);
			(undef,undef,undef,$bhour,$bminute)=isotime($bt) if $bt;
		} elsif($heute) {
			$bt = DoTime();
			$bt = 5*60*int($bt/5/60);
			(undef,undef,undef,$bhour,$bminute)=isotime($bt) if $bt;
			if($bhour >= 8) {
				$bhour = 8; $bminute = 0;
			}
		} else {
			$bhour = 8; $bminute = 0;
		}
	}
	if(not defined $ehour or $ehour eq "") {
		$debug.=".?eh";
		if($end_last) {
			$debug.=".end_last=$end_last";
			my($et,$et2);
			unless ($heute) {
				$debug.=".!heute";
				$et = DoFn("select beginn as bd from stunden where person = $person and beginn >= $end_last and beginn < $tomor order by bd limit 1");
				$et2 = DoFn("select beginn+dauer as bd from stunden where person = $person and beginn+dauer >= $end_last and beginn+dauer < $tomor order by bd limit 1");
			}
			$debug.=".!et" unless defined $et;
			$debug.=".et=$et" if defined $et;
			$et = $et2 if not defined $et or defined $et2 and $et2 < $et;
			$et = DoTime() if $heute and not defined $et;

			if(defined $et) {
				$debug.=".et";
				$et = 5*60*int($et/5/60);
				(undef,undef,undef,$ehour,$eminute)=isotime($et);
				if($ehour<$bhour or $ehour==$bhour and $eminute<$bminute) {
					$ehour=$bhour; $eminute=$bminute;
				}
			} else {
				$debug.=".!et";
				$ehour=$bhour; $eminute=$bminute;
			}
		} elsif($bhour<17) {
			$debug.=".bh=$bhour";
			$ehour=17; $eminute=0;
		} else {
			$debug.="..bh=$bhour";
			$ehour=$bhour; $eminute=$bminute;
		}
	}

	if($action eq "set_add" or $action eq "set_update") {

		sub check_time($$$) {
			$_[0] ||= 0;
			$_[1] ||= 0;
			if ( $_[0] == 0 || $_[0] == 24 and $_[1] == 0 ) { $_[0] = $_[2] }
			elsif ($_[0] =~ y/0-9//c
				|| $_[0] < 0
				|| $_[0] > 23
				|| $_[1] =~ y/0-9//c
				|| $_[1] % 5
				|| $_[1] >= 60 )
			{
				warnung(<<_) }
$_[0]:$_[1] ist keine g&uuml;ltige Uhrzeit.
Erlaubt sind nur Werte zwischen 0:00 und 24:00 Uhr in F&uuml;nf-Minuten-Schritten.
_
		}

		sub format_time($$) { sprintf '%02d:%02d', @_ }

		check_time( $bhour, $bminute,  0 );
		check_time( $ehour, $eminute, 24 );

		warnung('Beginn '
			  . format_time( $bhour, $bminute )
			  . ' >= Ende '
			  . format_time( $ehour, $eminute ) )
		  if !content $RT::warnung
		  and $ehour < $bhour || $ehour == $bhour && $eminute == $bminute;
	}

	if ( defined $ticket ) {

		# Whitespaces entfernen siehe #10107401
		$ticket =~ s/\s//g;
		if ( $ticket =~ /^\d+$/ ) {
			my $conn = get_pooled_connection();
			unless($conn->get_ticket($ticket)) {
				warnung(qq(Ticket "$ticket" nicht gefunden.));
				$ticket = "";
			}
		} elsif ( $ticket ne '' ) {
			warnung(qq(Ticket Nummer "$ticket" enthält nicht erlaubte Zeichen.));
		}
	} else {
		$ticket = "";
	}

}

if($RT::warnung ne "") {
	# tue nix
} elsif ($action eq "set_add" or $action eq "set_update") {
	my(@xid);
	my $beginn = unixtime($year,$month,$day, $bhour,$bminute,0);
	my $ende =
	     $ehour == 24
	  && $eminute == 0
	  ? unixtime( $year, $month, $day, 0, 0, 0 ) + 24 * 60**2
	  : unixtime( $year, $month, $day, $ehour, $eminute, 0 );
	my $dauer  = $ende - $beginn; 
	my $faktor = $artFaktor{$art};
	unless($kdnr) {
		warnung(qq(Kunde "$kunde" unbekannt.));
		$kdnr=1;
	} elsif(@xid = db_stunden_konflikt($person,$beginn,$ende,$id)) {
		warnung( 'Konflikte mit Eintrag ' . join( ' ', @xid ) . '.' );
	} elsif ( not content($kurztext) and not test_flag( stunden_art => ohne_text => $artFlags{$art} ) ) {
		warnung('Ohne Text geht hier gar nichts.');
	} elsif(($ticket or $kdnr!=1) and test_flag("stunden_art","keine_arbeit",$artFlags{$art})) {
		warnung('Dieser Eintrag darf keine Ticketnummer und keinen Kunden haben.');
	} elsif(not $ticket and test_flag("stunden_art","ticket",$artFlags{$art})) {
		warnung('Dieser Eintrag braucht eine Ticketnummer.');
	} elsif(defined $darf and $darf > unixdate($year,$month,$day)) {
		warnung('Dieser Tag darf nicht mehr ver&auml;ndert werden.');
	} else {
		$kurztext = undef unless content $kurztext;
		$ticket = "NULL" unless $ticket;

		my $fkt = $artFaktor{$art};

		DoTrans {
			if($action eq "set_add") {
				$id = Do("insert into stunden set person=$person, beginn=$beginn, dauer=$dauer, infotext=${\qquote $kurztext}, art=$art, ticket=$ticket, kunde=$kdnr");
				log_update("stunden","id",$id,undef,"beginn","dauer","*",undef,scalar isotime($beginn), iso_intervall $dauer);
			} else {
				my($obeg,$odau,$oinf,$oart,$otick,$oknd) = DoFn("select beginn,dauer,infotext,art,ticket,kunde from stunden where id=$id");
				log_update("stunden","id",$id,undef,"beginn","dauer",undef,scalar isotime($obeg), iso_intervall $odau) if $obeg!=$beginn or $odau!=$dauer;
				log_update("stunden","id",$id,undef,"infotext",undef,def_or_minus($oinf)) if def_or_minus($oinf) ne $kurztext;
				log_update("stunden","id",$id,undef,"art",undef,$oart) if $oart != $art;
				log_update("stunden","id",$id,undef,"ticket",undef, def_or_minus($otick)) if ($otick||0) != ($ticket eq "NULL" ? 0 : $ticket);
				log_update("stunden","id",$id,undef,"kunde",undef,$oknd) if $oknd != $kdnr;

				Do("update stunden set beginn=$beginn,dauer=$dauer,zeit=NULL, infotext=${\qquote $kurztext}, art=$art, ticket=$ticket, kunde=$kdnr where id=$id");

				flush_std_cache($person,$obeg,$odau);
				update_hotline_cache( $person, $obeg, $odau )
				  if is_hotline($oart);
			}
			flush_std_cache($person,$beginn,$dauer);
			update_hotline_cache( $person, $beginn, $dauer )
			  if is_hotline($art);
		};
		$end_last=$beginn+$dauer;

		print redirect("manipulate.pl?redo=y;action=add;year=$year;month=$month;day=$day;end_last=$end_last");
	}
}

print header( -charset=>'utf-8' ),
      start_html( -alink   => 'blue',
                  -bgcolor => $BGCOLOR,
                  -link    => 'blue',
                  -onLoad  => "show('view.pl?day=$day&month=$month&year=$year',1)",
                  -script  => $script,
                  -style   => { src => '/css/stunden.css', type=>'text/css' },
                  -text    => 'black',
                  -vlink   => 'blue',
                );

	print center("Fehler: ",i($RT::warnung)),br() if $RT::warnung ne "";

	my $iso = isodate($today);

	$debug=br().$debug if $debug ne "";
	print map({enc($_)}
	  start_form("POST","manipulate.pl",undef,'name=Manipulate'),
	  table({cellpadding=>0,cellspacing=>0,height=>"100%",width=>"100%",align=>"center"},
	    Tr(td({align=>'center',colspan=>'2'},center(h3('Stunden eintragen ',$id ? "(ID: $id)":'(neu)',
	       ' f&uuml;r '.textfield(-name=>'datum', -value => $datum || sprintf('%d-%02d-%02d', $year, $month, $day), -tabindex=>9))))),
			hidden("id",$id),
			hidden("action",$saction),

			Tr(td({width=>"40%"},
			table({cellpadding=>0,cellspacing=>0,align=>"center"}, "\n",
			Tr(td({align=>"right"},"Kunde:"),
				td({align=>"left" },textfield(-name=>'kunde', -value=>$kunde||'POP', -size=>10, -maxlength=>40, -tabindex=>1))), "\n",
			Tr(td({align=>'right', $ze_textfield ? () : (valign=>'top')}, 'Kurzbeschreibung:'),
				td({align=>"left",valign=>"top"},
				$ze_textfield
				? textfield(-name=>'kurztext', -value=>$kurztext, -size=>42, -maxlength=>250, -tabindex=>2)
				: textarea(-name=>'kurztext', -default=>$kurztext, -rows=>2, -columns=>40, -onChange=>'checkLen(this)', -onKeyup=>'checkLen(this)', -onFocus=>'checkLen(this)', -tabindex=>2).
				  br().
				  '(max. 250 Zeichen: noch '.textfield(-readOnly=>'readOnly', -size=>3, -name=>'Anzahl').' frei)'
				)), "\n",
			Tr(td({align=>"right"},"f&uuml;r Ticket:"),
				td({align=>"left" },textfield(-name=>'ticket', -value=>$ticket, -size=>7, -maxlength=>(in_test()?10:8), -tabindex=>3)))
		)), "\n", td({width=>"60%"},table({cellpadding=>0,cellspacing=>0},
			Tr(td({align=>"right"},"Art:"),
				td({align=>"left",colspan=>"2", },radio_group({name=>"art",values=>\@art, default=>(defined $art ? $art : $art[0]), linebreak=>0,labels=>\%art, onClick=>"check_9bis17(this)"}))), "\n",
			Tr(td({align=>"right"},"Beginn:"),
				td({align=>"left"},textfield(-name=>'bhour', -value=>$bhour, -size=>3, -maxlength=>2, -tabindex=>4).':'.
				textfield(-name=>'bminute', -value=>$bminute, -size=>3, -maxlength=>2, -tabindex=>5),
				$heute?i(a({href=>'',onClick=>'setToCurrentTime(document.Manipulate.bhour, document.Manipulate.bminute); return false;'},"(jetzt)")):"",
				), "\n",
			   td({align=>"left",valign=>"center",rowspan=>2},
			      submit(-name=>'was', -value=>($action eq 'update')?'Daten ändern':'Daten eintragen', -tabindex=>8))),"\n",
			Tr(td({align=>"right",valign=>"center"},"Ende:"),
				td({align=>"left",valign=>"center"}, textfield(-name=>'ehour', -value=>$ehour, -size=>3, -maxlength=>2, -tabindex=>6).':'.
				textfield(-name=>'eminute', -value=>$eminute, -size=>3, -maxlength=>2, -tabindex=>7),
				$heute?i(a({href=>'',onClick=>'setToCurrentTime(document.Manipulate.ehour, document.Manipulate.eminute); return false;'},"(jetzt)")):"",
				)), "\n",


			))),"\n",

			Tr(td({align=>'right', colspan=>2},
			  font({size=>"-1"},
			  "Bei Problemen bitte an ",a({href=>"mailto:perso\@noris.net"},"Perso")," wenden.")))),
			end_form());

	print end_html();

    # Da es nicht so wahrscheinlich ist, dass derselbe User so schnell
    # wieder an diesen Prozess gerät, schließen wir die Verbindung zur
    # Ticket-API, um nicht unnötig viele offen zu halten:
    clean_connection_pool($user);
};

