use strict;
use utf8;
use warnings;

package noris::Ticket::API::SelectResult;

use Moose;
use noris::Ticket::API::OTRS::SelectResult;
use noris::Ticket::API::RT::SelectResult;

has 'results' => (
    is         => 'ro',
    isa        => 'ArrayRef',    # bei neuerem Moose evtl.: ArrayRef[Object]
    auto_deref => 1,
);

has '_result_cursor' => (
    is      => 'rw',
    isa     => 'Int',
    default => 0,
);

sub next {
    my ($self) = @_;
    my @results = $self->results;
    my $value;
    my $result_cursor = $self->_result_cursor;
    while ( $result_cursor <= $#results ) {
        defined( $value = $results[$result_cursor]->next ) and last;
        $self->_result_cursor( ++$result_cursor );
    }

    noris::Ticket::API::_debug(
        result => sub {
            return 'Ticket API found no more records.' unless defined $value;
            require Data::Dump and Data::Dump->import('pp') unless defined &pp;
            'From '
              . ref( $results[$result_cursor] )
              . ' backend: '
              . pp($value);
        }
    );
    $value;
}

sub follow_tickets {
    my ( $self, %param ) = @_;

    return $self->new(
        results => [ map $_->follow_tickets(%param), $self->results ] );
}

sub foreach_row {
    my ($self, $fn) = @_;
    my $row;
    while (defined($row = $self->next())) {
        $fn->(@$row);
    }
}

sub count {
    my ($self) = @_;
    my $count = 0;
    $count += $_->count() for $self->results;
    $count;
}

1;
