use strict;
use utf8;
use warnings;

package noris::Ticket::API::RT::Field::Locked;

use Carp qw(confess);
use Dbase::Globals qw(aufzaehlung);
use Moose;

extends 'noris::Ticket::API::RT::Field::Standard';

sub rt2api {
    my ( $self, $db_value ) = @_;
    ( !defined $db_value && 'un' ) . 'lock';
}

sub where_in {
    my $self = shift;
    return 'NULL' unless @_;
    my %mode = (
        lock     => $self->db_name . ' IS NOT NULL',
        tmp_lock => 'NULL',
        unlock   => $self->db_name . ' IS NULL',
    );
    my @sql;
    for (@_) {
        defined( my $sql = $mode{$_} )
          or confess( 'Attribut '
              . $self->api_name
              . ' kann nur '
              . aufzaehlung( { letzter_trenner => 'oder' }, sort keys %mode )
              . ' sein' );
        push @sql, $sql;
    }

    # auch bei nur einem Element klammern,
    # um die Implementation von ->where_not_in zu erleichtern:
    '( ' . join( ' OR ', @sql ) . ' )';
}

sub where_not_in {
    my $self = shift;
    'NOT ' . $self->where_in(@_);
}

1;
