use strict;
use utf8;
use warnings;

package noris::Ticket::API::RT::Field::LinkObject;

use Carp qw(croak);
use Dbase::Help qw(like_list qquote);
use Moose;

extends 'noris::Ticket::API::RT::Field';

use constant SEPARATOR => "\0";

has db_table => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
);

has '+is_listfield' => ( default => 1 );

has '+joins' => (
    default => sub {
        my $self     = shift;
        my $db_table = $self->db_table;
        [
            "LEFT JOIN rt_incidents_$db_table RI_$db_table "
              . "ON RI_$db_table.incident = ticket.id",
            "LEFT JOIN $db_table ON $db_table.id = RI_$db_table.$db_table"
        ];
    }
);

has '+joins4query' => ( default => sub { [] } );

has '+select_name' => (
    default => sub {
        my $self    = shift;
        my $db_name = $self->db_name;
        "GROUP_CONCAT($db_name ORDER BY $db_name SEPARATOR "
          . qquote(SEPARATOR) . ')';
    },
);

sub rt2api {
    my ( $self, $db_value ) = @_;
    $db_value = '' unless defined $db_value;
    [ split /\Q${\SEPARATOR}/o, $db_value ];
}

sub where_has_any {
    my $self     = shift;
    my $db_table = $self->db_table;
    'EXISTS ( '
      . "SELECT * FROM $db_table"
      . " JOIN rt_incidents_$db_table"
      . " ON rt_incidents_$db_table.$db_table = $db_table.id"
      . " WHERE rt_incidents_$db_table.incident = ticket.id AND "
      . like_list( "$db_table.name", '', $self->_map_wildcards(@_) ) . ' )';
}

sub where_has_none {
    my $self = shift;
    'NOT ' . $self->where_has_any(@_);
}

1;
