use strict;
use utf8;
use warnings;

package noris::Ticket::API::RT::Field::Flag;

use Dbase::Globals qw(find_descr);
use Moose;
extends 'noris::Ticket::API::RT::Field::Standard';

has id => (
    is       => 'ro',
    isa      => 'Int',
    required => 1,
    lazy     => 1,
    default  => sub {
        my $self = shift;
        find_descr( $self->descr, $self->name, 1 );
    },
);
has descr => ( is => 'ro', isa => 'Str', required => 1 );

has name => ( is => 'ro', isa => 'Str', required => 1 );

has select_name => (
    is      => 'ro',
    isa     => 'Str',
    lazy    => 1,
    default => sub {
        my $self = shift;
        'IF( ' . $self->db_name . ' & (1<<' . $self->id . '), 1, 0 )';
    },
);

sub where_in {
    my ( $self, @values ) = @_;
    my %want;
    $want{ !!$_ } = undef for @values;
    unless ( keys %want )     { 'NULL' }
    elsif  ( keys %want > 1 ) { () }
    else {
        $self->db_name
          . ' & (1<<'
          . $self->id . ')' . ( exists $want{''} && ' = 0' );
    }
}

sub where_not_in {
    my ( $self, @values ) = @_;
    my %want;
    $want{ !!$_ } = undef for @values;
    unless ( keys %want )     { () }
    elsif  ( keys %want > 1 ) { 'NULL' }
    else {
        $self->db_name
          . ' & (1<<'
          . $self->id . ') = '
          . ( exists $want{1} && ' = 0' );
    }
}

1;
