use strict;
use utf8;
use warnings;

package noris::Ticket::API::RT::Field::CustomerVisibility;

use Carp qw(confess);
use Moose;

extends 'noris::Ticket::API::RT::Field::Standard';

use constant SQL => 'EXISTS ( SELECT * FROM ticket ticket_id, ticketid'
  . ' WHERE ticket_id.ticket = ticket.id'
  . ' AND ticketid.ticket = ticket_id.id'
  . ' AND ticketid.extern = "y" )';

has '+db_name' => ( default => 'IF ( ' . SQL . ', "visible", "invisible" )' );

sub where_in {
    my $self = shift;
    return 'NULL' unless @_;
    my %mode = ( visible => '', invisible => 'NOT ' );
    my $mode;
    for (@_) {
        defined( my $_mode = $mode{$_} )
          or confess( 'Attribut '
              . $self->api_name
              . ' kann nur '
              . aufzaehlung( { letzter_trenner => 'oder' }, sort keys %mode )
              . ' sein' );

        # sichtbare + unsichtbare = alle:
        return if defined $mode && $mode ne $_mode;

        $mode = $_mode;
    }
    $mode . SQL;
}

1;
