use strict;
use utf8;
use warnings;

package noris::Ticket::API::RT::Field;

use Carp qw(croak);
use Moose;
use overload '""' => sub { shift->api_name };

has api_name => ( is => 'ro', isa => 'Str', required => 1 );
has db_name  => ( is => 'ro', isa => 'Str', required => 1 );
has is_listfield => ( is => 'ro', isa => 'Bool', default => '' );

has select_name => (
    is       => 'ro',
    isa      => 'Str',
    required => 1,
	lazy     => 1,
    default  => sub { shift->db_name },
);

has joins => (
    is         => 'ro',
    isa        => 'ArrayRef',
    auto_deref => 1,
    lazy       => 1,            # Workaround für Bug in Etch-Moose
    default    => sub { [] },
);

has joins4query => (
    is         => 'ro',
    isa        => 'ArrayRef',
    auto_deref => 1,
    lazy       => 1,
    default    => sub { shift->joins },
);

sub api2rt {
    my ( $self, $api_value ) = @_;
	$api_value;
}

# ->rt2api() bekommt für jeden Datensatz den von der Datenbank gelieferten Wert
# übergeben und hat die Chance und Aufgabe, diesen umzuwandeln, bevor er an den
# Benutzer der API zurückgegeben wird. (Brauchen wir z. B. für Descr.)
sub rt2api {
    my ( $self, $sql_value ) = @_;
    $sql_value;
}

# ->where_*() bilden die verschiedenen Suchmethoden der API ab.
# Sie bekommen jeweils eine Liste der vom Benutzer spezifizierten Werte
# und geben einen SQL-Schnipsel zurück, der in den WHERE-Teil der Abfrage
# eingebaut wird.

sub unsupported_search {
    my ( $self, $operator ) = @_;
    croak(  qq(Suchbedingung "$operator" wird für Feld "$self")
          . ' nicht unterstützt.' );
}

for (qw(< <= = > >= has_any has_none in not_in like like_not range)) {
    no strict 'refs';
    my $operator = $_;
    *{"where_$_"} = sub { shift->unsupported_search($operator) };
}

sub _map_wildcards {
    shift;
    map {
        y/*/%/;
        $_;
    } @_;
}

1;
