package noris::REST::Backend::WebRT;

use utf8;
use strict;
use warnings;

use base 'Exporter';
our @EXPORT_OK = qw(status_text user2customers);

use Dbase::Globals qw(find_descr get_descr);
use Dbase::Help qw(DoFn DoSelect qquote);
use Memoize qw(memoize);
use noris::REST::Backend qw(error);

sub ticket_status($) { get_descr tickets => shift }
memoize 'ticket_status';

sub status_text($$$) {
	my ( $status_id, $bearbeiter, $info ) = @_;
	if (
		(
			my $status = ticket_status $status_id
			or return error "Undefinierter Ticket-Status Nr. $status_id."
		) eq 'open'
	  )
	{
		if ($bearbeiter) { 'in Bearbeitung' }
		else { 'angenommen' }
	}
	elsif ( $status eq 'stalled' ) {
		'zurückgestellt' . ( $info ? ': ' . $info : '' );
	}
	elsif ( $status eq 'resolved' ) {
		'abgeschlossen';
	}
	else {
		'(unbekannt)';
	}
}

sub user2customers($) {
	my ($user) = @_;
	my @kunden;
	DoSelect { push @kunden, @_ } <<_;
	SELECT   DISTINCT kunde.id
	FROM     kunde, kundemail, person
	WHERE    kundemail.dienst = ${\find_descr('dienst','rtweb')}
	     AND kundemail.kunde  = kunde.id
	     AND kundemail.person = person.id
	     AND ( kunde.ende IS NULL OR kunde.ende >= UNIX_TIMESTAMP(NOW()) )
	     AND person.user = ${\ qquote($user) }
	ORDER BY kunde.id
_
	join ',', @kunden
	  or error
qq(Der Benutzer "$user" kann keinem RT-Web-Account eines aktiven Kunden zugeordnet werden.);
}

1;
