#
## ACHTUNG -- dieser Code ist nicht mit Debugger und Ähnlichem bearbeitbar,
# wenn stdout/stderr durch ihn gefiltert wird!

package Db;

use Sys::Syslog qw(openlog syslog LOG_WARNING LOG_LOCAL1);
use Carp;
use POSIX qw(_exit);

unless($ENV{TESTING2}) {
	openlog($0, "pid", LOG_LOCAL1);
}

sub log_trace(;$) {
	# geklaut aus Fehler.pm
	my($err) = @_;
    no strict qw(subs);
	my @msg;
    if(defined $Apache::{request} or %{*Apache2::RequestRec::}) {
        @msg = split("\n",Carp::longmess("...Stack-Dump...\n"));
    } else {
        my $pid=open(FEHLER,"-|");
        unless($pid) {
            eval {
                print Carp::longmess("\n...Stack-Dump...\n");
                _exit(0);
            };
            print "EVAL: $@\n";
            _exit(0);
        }
        @msg = <FEHLER>;
        close(FEHLER);
    }

	if($ENV{TESTING2}) {
		open(LOG,">>","/tmp/log_$<") or die "Open: $!";
		binmode(LOG,":raw");
		print LOG "$err\n" if defined $err;
		print LOG "$_\n" for @msg;
		close(LOG);
	} else {
		syslog(LOG_WARNING, $err) if defined $err;
		syslog(LOG_WARNING, $_) for @msg;
	}
}


package Encode::Latinize;
use utf8;
use strict;
use warnings;

use base qw(Encode::Encoding);
use Encode qw();
use UTFkram qw(decode_anything);

__PACKAGE__->Define('latinize');

our $rec;
#open(DBG,">&STDOUT"); binmode(DBG,":raw"); select(DBG);$|=1;select(STDOUT);

sub encode($$;$) {
	my ($obj, $str, $chk) = @_;
	if($rec #or not Encode::is_utf8($str)
		) {
		#print DBG "REC ".Encode::is_utf8($str)." =$chk=\n";
		Db::log_trace("rekursiver encode-Aufruf");
		$_[1] = '' if $chk;
		return $str;
	}

	local $rec = 1;
	#print DBG "has ".Encode::is_utf8($str)." =$chk=\n";

	# Vorsicht: es kann sich hier um einen abgeschnippsten UTF8 handeln.
	# decode_anything() berücksichtigt das nicht wirklich.
	$str = decode_anything($str) unless Encode::is_utf8($str);
	my $res = Encode::encode("iso-8859-15",$str,$chk ? Encode::PERLQQ : 0);
	# |Encode::WARN_ON_ERR

	{	# Dieser Fehler ist komplett besch...
		# *Eigentlich* sollte das Encoding genau diesen Unfug verhindern,
		# und im Testskript (23) tut es das auch ...
		use bytes; no utf8;
		$str .= $1 if $res =~ s/([\xC0-\xDF])\z//;
	}
	$_[1] = $str if $chk;
	#print DBG "got ".Encode::is_utf8($res)." $res\n";
	return $res;
}
sub decode($$;$) {
	my ($obj, $str, $chk) = @_;
	my $res = Encode::decode("iso-8859-15",$str,$chk ? Encode::FB_QUIET : 0);
	$_[1] = $str if $chk;
	return $res;
}



package Encode::UTF8ize;
use utf8;
use strict;
use warnings;
use base qw(Encode::Encoding);
use Encode qw();
use UTFkram qw(safe_encode_utf8 decode_anything is_utf8);

__PACKAGE__->Define('utf8ize');

our $rec;
#open(DBG,">&STDOUT"); binmode(DBG,":raw");

sub encode($$;$){
	my ($obj, $str, $chk) = @_;
	#my $xstr = $str; Encode::_utf8_off($xstr);
	#print DBG "has ",Encode::is_utf8($str)," $xstr\n";
	if($rec) {
		Db::log_trace("rekursiver encode-Aufruf");
		Encode::_utf8_off($str);
		$_[1] = '' if $chk;
		return $str;
	}

	local $rec = 1;
	my $res;

	# Vorsicht: es kann sich hier um einen abgeschnippsten UTF8 handeln.
	# decode_anything() berücksichtigt das nicht wirklich.
	$str = decode_anything($str) unless Encode::is_utf8($str);
	if (Encode::is_utf8($str)) {
		$res = Encode::encode("utf8",$str,$chk ? Encode::PERLQQ : 0);
		# |Encode::WARN_ON_ERR : 0);
	} else {
		$res = $str;
		$str = "";
	}
	$_[1] = $str if $chk;
	return $res;
}

# Der "decode_buffer" ist ein Zwischenspeicher für unvollständig
# decodierte UTF8-Sequenzen. Rein theoretisch kann man diesen
# zurückliefern, indem man den String auf den nicht dekodierten Rest
# setzt; in der Praxis funktioniert das sehr instabil.
my $dup = 0;
sub decode($$;$) {
	my ($obj, $str, $chk) = @_;
	my $in_str = $str;

	my $do_next_time = "";
	$do_next_time = $1 if $str =~ s/([\xC0-\xDF]|[\xE0-\xEF][\x80-\xBF]{0,1}|[\xF0-\xF7][\x80-\xBF]{0,2})\z//;
	my $len = length($str);

	my $res = Encode::decode(is_utf8($str) ? "utf8" : "latin1", $str, Encode::FB_QUIET);

	my $residue = $str.$do_next_time;
	if($res eq "" and $residue ne "" and $residue eq $in_str and ++$dup > 2) {
		# Wir haben effektiv nichts getan, stecken also in einer Endlosschleife.
		Db::log_trace('Endlosschleife im UTF8-Decoder');
		$obj->{decode_buffer} = "";
	} else {
		$dup = 0;
	}
	$_[1] = $residue;
	return $res;
}


package Umlaut;

require Exporter;
use utf8;
use strict;
use warnings;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(textmodus binmodus utf8modus latinmodus);

$Db::utf8 = 0;
$Db::openflags = undef;

{
no warnings 'once';
unless(exists $ENV{MOD_PERL} ) #( or defined $DB::single)
{ no warnings 'uninitialized';

  ## encoding::_get_locale_encoding() liefert leider unter Etch kompletten Unfug
  if($ENV{'LC_ALL'} =~ /utf-?8/i or
     not $ENV{'LC_ALL'} and $ENV{'LANG'} =~ /utf-?8/i) {
	$Db::utf8 = 1;
  }

  ## wenn nicht Terminal, bleibe hoffentlich alles beim Alten
  if($Db::utf8) {
	#print "# UTF8 mode\n";
	binmode(STDIN,":raw :encoding(utf8ize)");
	binmode(STDOUT,":raw :encoding(utf8ize)");
	binmode(STDERR,":raw :encoding(UTF-8)");
	$Db::openflags = ":encoding(utf8ize)\0:encoding(utf8ize)";
  } else {
	#print "# latin1 mode\n";
	eval 'use open IO=>":encoding(latinize)"';
	binmode(STDIN,":raw :encoding(latinize)");
	binmode(STDOUT,":raw :encoding(latinize)");
	binmode(STDERR,":raw :encoding(ISO-8859-15)");
	$Db::openflags = ":encoding(latinize)\0:encoding(latinize)";
  }
}
}

sub textmodus($) {
	my($fh) = shift;
	eval {
		if($Db::utf8) {
			binmode($fh,":raw :encoding(utf8ize)");
		} else {
			binmode($fh,":raw :encoding(latinize)");
		}
	};
	# wenn Fehler: naja, ScalarArray und ähnliche Filehandles *haben*
	# keine BINMODE-Methode. Aber das ist OK. Hoffentlich.
}

sub binmodus($) {
	my($fh) = shift;
	eval {
		binmode($fh,":raw");
	};
	# wenn Fehler: naja, ScalarArray und ähnliche Filehandles *haben*
	# keine BINMODE-Methode. Aber das ist OK. Hoffentlich.
}

sub utf8modus($) {
	my($fh) = shift;
	eval {
		binmode($fh,":raw :encoding(utf8ize)");
	};
	# wenn Fehler: naja, ScalarArray und ähnliche Filehandles *haben*
	# keine BINMODE-Methode. Aber das ist OK. Hoffentlich.
}

sub latinmodus($) {
	my($fh) = shift;
	eval {
		binmode($fh,":raw :encoding(latinize)");
	};
	# wenn Fehler: naja, ScalarArray und ähnliche Filehandles *haben*
	# keine BINMODE-Methode. Aber das ist OK. Hoffentlich.
}

sub import {
    Umlaut->export_to_level(1, @_);
    ${^OPEN} = $Db::openflags;
}

1;

__END__

=head1 Funktionen zur "vernünftigen" Kodierung von Perl-stdin/stdout

Dieses Package stellt die Encodings "utf8ize" und "latinize" zur
Verfügung. Diese konvertieren bei der Ein/Ausgabe korrekt markierte
Perl-Strings so, dass am Ende eine vernünftige Ausgabe erscheint.

Inkorrekt markierte Strings und falsch kodierte Eingabe wird (im Gegensatz
zum Standardfall) entsprechend zurechtgebogen.

Außerdem wird es, abhängig von der aktuellen Locale, stdin/out/err
von vornherein so einstellen, dass das Opfer am Terminal die richtige
Kodierung sieht.

