package UTFkram;

use strict;
use warnings;
use Fehler qw(fehler);
use Encode qw();
use utf8;
use Fehler qw(fehler);
use MIME::Parser;
use noris::MIME::Words qw(encode_mimewords);

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(is_utf8 is_ascii is_latin decode_anything safe_encode_utf8
	utf8_to_latin latin_to_utf8
	fix_encoding fix_mime_encoding
	);

$Db::StrictChars = $ENV{KUNDE_STRICTCHARS};

#open(DBG,">&STDOUT"); binmode(DBG,":raw");

sub is_utf8($) {
    my($x) = @_;
	return 0 unless defined $x;

	# Dieser Code ignorierte bisher utf8-Restzeichen am Anfang und Ende
	# des Puffers, aber das wurde nirgends verwendet und führt zu
	# Problemen.

	# Dieser Teil erkennt einen doppelt-utf8-kodierten String
	# und ersetzt ihn durch sein normal kodiertes Äquivalent,
	# wenn möglich.
	if(utf8::is_utf8($x)) {
		die "Kodierungsproblem" if not utf8::valid($x);
		return 0 if $x =~ /[\x{0100}-\x{10ffff}]/;
		# return => der String hat Zeichen >0xFF.
		# Damit ist das Ding keine Folge von Bytes, somit kann ich ihn
		# auch nicht durch Encode::decode_utf8() laufen lassen.
		$x = Encode::encode("latin1",$x);
	}
	Encode::_utf8_on($x);
	return utf8::valid($x);
}

sub is_ascii($) {
    my($x) = @_;
	return 0 unless defined $x;

	die "Kodierungsproblem" if not utf8::valid($x);
    use bytes; # das geht schneller
    return ($x =~ /\A[\x00-\x7F]*\z/);
}

sub is_latin($) {
    my($x) = @_;
	return 0 unless defined $x;

    return is_ascii($x) || !is_utf8($x);
}

sub decode_anything($;$$) {
    my($x,$force,$charset) = @_;
	return undef unless defined $x;

    #my $xx = $x; Encode::_utf8_off($xx);
    #print DBG "_CHK2_".length($xx)."_ ".Encode::is_utf8($x)." $xx\n_CHK_\n";
    Encode::_utf8_off($x) unless utf8::valid($x);

    # 11.0xx.xxx 10.xxx.xxx
	# Wenn der String schon als UTF8 markiert ist und mit Zeichen
	# daherkommt, die in kein Byte passen, sind wir fertig.
	if(Encode::is_utf8($x) and $x =~ /[\x{0100}-\x{10ffff}]/) {
		if($force) {
			eval {
				my $xx = Encode::encode("iso-8859-1",$x,Encode::FB_CROAK);
				if(is_utf8($xx)) {
					$x = $xx;
					$force=1;
				}
			};
			$force=0 if $@;
		}
		return $x unless $force;
	}

	$charset="ISO-8859-15" unless defined $charset;

	if(!is_latin($x)) {
		if(Encode::is_utf8($x)) {
			# Upps, der String ist UTF8-kodiert, aber intern trotzdem
			# mit utf8-Flag versehen -- also effektiv doppelt kodiert.

			# fehler "Falsche Kodierung: $x" if $ENV{'TESTING2'};
			# nicht wirklich, siehe letzte Zeile in test/12_umlaut

			# Leider passiert das sofort, wenn perl einen "normalen"
			# utf8-String mit einem "kodierten" solchen zusammenfügt,
			# und es gibt KEINE Möglichkeit das abzustellen.

			# Wir entfernen folglich die "äußere" Kodierung.
			$x = Encode::encode("iso-8859-1",$x);
			# Jetzt ist der String noch utf8-kodiert, aber das Flag ist
			# aus. Wir müssen's also nur noch einschalten und der Text ist
			# sauber.
		}
		Encode::_utf8_on($x);
		my $xx = $x;
		{
			use bytes;
			$xx =~ s/(.{15})(?:[\xC0-\xDF]|[\xE0-\xEF][\x80-\xBF]?|[\xF0-\xF7][\x80-\xBF]{0,2})\z/$1/;
			$xx =~ s/\A[\x80-\xBF]{1,3}//;
		}
		fehler "Stringproblem" unless utf8::valid($xx);
	}
	if( eval { ($force or ! Encode::is_utf8($x)) and $x !~ /[\x{0100}-\x{10ffff}]/ } or $@) {
		# Hrmpf. Da liefert uns jemand Unfug.
		# Gehen wir mal davon aus, dass es sich um "nackten" Input handelt.
		# Wenn nicht, ist nichts zu machen.
		eval {
			$x = Encode::decode($charset,$x,Encode::FB_CROAK);
		};
		# print STDERR "Upps: $@\n" if $@;
	}
	# ... ansonsten ist das Ding schon latin1, und wir brauchen nix zu tun.
	fehler "UTF8-Blubb: $x" if $Db::StrictChars and $x =~ /\x{fffd}/;
    return $x;
}

sub safe_encode_utf8($) {
    my($x) = @_;
	return undef unless defined $x;

    my $xx = $x; Encode::_utf8_off($xx);
    #print DBG "_CHK3_".length($xx)."_ ".Encode::is_utf8($x)." $xx\n_CHK_\n";
    Encode::_utf8_off($x) unless utf8::valid($x);
    
    # 110xxxxx 10xxxxxx
	if(Encode::is_utf8($x)) {
		# Normaler String.
		fehler "UTF8-Blubb: $x" if $Db::StrictChars and $x =~ /\x{fffd}/;
		if(!is_latin($x)) {
			# Upps, der String ist UTF8-kodiert, aber intern trotzdem
			# mit utf8-Flag versehen -- also effektiv doppelt kodiert.
			fehler "Falsche Kodierung: $x" if $ENV{'TESTING2'};

			# Leider passiert das sofort, wenn perl einen "normalen"
			# utf8-String mit einem "kodierten" solchen zusammenfügt,
			# und es gibt KEINE Möglichkeit das abzustellen.

			# Wir entfernen folglich eine der Kodierungen.
			$x = Encode::decode("utf8",$x);

			# Das ist dasselbe wir oben, nur dass der String hier
			# als Bytestring hinterlassen wird statt wie oben als
			# mit dem utf8-Flag markierter String.
		}
		# andernfalls hoffen wir, dass im obigen Fall kein nicht-ASCII-
		# Zeichen in besagtem normalen String war.  :-/
	} else {
		# Das ist entweder UTF8, dann lassen wir es in Ruhe, oder ...
		$x = Encode::decode("iso-8859-15",$x) if is_latin($x);
		# ... "nackter" latin1+Euro, der an dieser Stelle intern
		# UTF8-kodiert ist.
	}
	# ... und um die interne UTF8-Kodierung, die $x jetzt evtl. hat,
	# sichtbar zu machen, machen wir einfach das Flag aus.
	Encode::_utf8_off($x);

    return $x;
}

sub fix_encoding($$) {
	my($str,$charset) = @_;
	$str = decode_anything($str,1,$charset);
	$str =~ s/\xA4/\x{20AC}/g; ## currency sign => euro
	eval {
		$str = Encode::encode($charset,$str,Encode::FB_CROAK);
	};
	if($@) {
		fehler("Unzureichendes charset") unless wantarray;
        eval {
            $charset = "ISO-8859-1";
            $str = Encode::encode($charset,$str, Encode::FB_CROAK);
        };
        eval {
            $charset = "ISO-8859-15";
            $str = Encode::encode($charset,$str, Encode::FB_CROAK);
        } if $@;
        do { # kein eval: utf8 hat zu funktionieren
            $charset = "UTF-8";
            $str = Encode::encode($charset,$str);
        } if $@;
	}
	wantarray ? ($str,$charset) : $str;
}

sub charset($);
sub charset($) {
	my($msg) = @_;
	my $charset = $msg->head->mime_attr('Content-Type.charset');
	return $charset if defined $charset;

	foreach my $part($msg->parts) {
		$charset = charset($part);
		return $charset if defined $charset;
	}
	undef;

}
sub fix_mime_encoding($);
sub fix_mime_encoding($) {
	my($msg) = @_;
	my $charset = $msg->head->mime_attr('Content-Type.charset');
	my $hcharset = charset($msg);
	my $nmod = 0;
	my @parts = $msg->parts;

	my $head = $msg->head;
	foreach my $tag($head->tags) {
		my $i = 0;
		while(defined(my $data = $head->get($tag,$i))) {
			unless(is_ascii($data)) {
				$nmod++;
				$head->replace($tag,encode_mimewords(decode_anything($data,1,$hcharset)),$i);
			}
		} continue {
			$i++;
		}
	}
	if(not @parts and $msg->mime_type =~ m#^message/rfc822#i and not exists $msg->{SubMessage}) {
		my $parser = new MIME::Parser(output_to_core=>"ALL",output_dir=>"/tmp");
		$parser->output_dir("/tmp");

		my($nmsg,$state) = $parser->parse($msg->bodyhandle->open("r"));
		if(ref $nmsg and ($state eq "" or $state eq "EOF")) {
			$msg->{SubMessage} = $nmsg;
		} else {
			$msg->{SubMessage} = "Bad MIME decoder state: '$state'";
		}
	}

	if(@parts) {
		## Prolog und Epilog werden nicht angefasst.
		## (die Dinger sind inzwischen selten; wenn, dann enthalten
		##  sie ASCII-Text aus der Konserve.)
		foreach my $part(@parts) {
			$nmod += fix_mime_encoding($part);
		}
		return $nmod;
	} elsif(ref $msg->{SubMessage}) {
		$nmod += fix_mime_encoding($msg->{SubMessage});
	} else {
		return $nmod unless $charset;
		my $str = $msg->bodyhandle->as_string;
		my($nstr,$ncharset) = fix_encoding($str,$charset);
		$nmod += 1 if $ncharset ne $charset or $nstr eq $str;

		$msg->head->mime_attr('Content-Type.charset',$ncharset);
		my $IO = $msg->bodyhandle->open("w") or fehler "MIME open $!";
		$IO->print($nstr) or fehler "MIME write $!";
		$IO->close or fehler "MIME close $!";
		return $nmod;
	}
}

1;

__END__

=head1 UTF8-Hilfsroutinen

Dieser Code versucht, UTF8 und latin1 sauber auseinanderzuhalten.

"Latin" bzw. "latin1" ist in diesem Kontext eine Altlast. In Wirklichkeit
bedeutet das Wort hier: "Zeichen können Werte > xFF haben".

Im Unterschied dazu bedeutet "UTF8": "Es gibt nur Bytes, und alles, was
nicht ASCII ist, ist explizit UTF8-kodiert".

Das Wort "explizit" ist hier wichtig, weil bei diesen Strings das
perl-UTF8-Flag *aus* sein sollte. Dagegen ist bei "latin1"-Strings
das UTF8-Flag in der Regel an.

Warumm die Jungs das Flag nicht "unicode" genannt haben, wird ewig ein
Rätsel bleiben ...


=head2 is_utf8( string )

Liefert einen wahren Wert, wenn der Text UTF8-kodiert ist.

Das perl-interne UTF8-Flag sollte aus sein, aber darauf kann man sich
nicht verlassen. Das wird von dieser Funktion folglich nicht geprüft.


=head2 is_ascii( string )

Liefert eine wahren Wert, wenn der Text ASCII-kodiert ist, also keine
Zeichen >x7F enthält.


=head2 is_latin( string )

Liefert einen wahren Wert, wenn der Text unicode-kodiert ist.

Kurzschreibweise für is_ascii() || !is_utf8().


=head2 decode_anything( string [ Force [ charset ] ] )

Funktion, die UTF8 (defakto *irgendwas*) nach Unicode konvertiert.
Dabei wird das perl-interne utf8-Flag gesetzt.

Ist das Argument ein ASCII- oder Unicode-String, wird es nicht modifiziert.

Im Rückgabewert ist das Perl-interne UTF8-Flag an.

Ist das Force-Flag gesetzt, so wird geprüft, ob eine utf8-Eingabe
versehentlich mit latin9 dekodiert wurde, und dies zu reparieren.

Default für den Zeichensatz ist latin9.


=head2 safe_encode_utf8( string )

Funktion, die Unicode nach UTF8 konvertiert.

Ist das Argument bereits utf8-kodiert, wird es nicht modifiziert.

Im Rückgabewert ist das Perl-interne UTF8-Flag aus.


=head2 fix_encoding( string charset )

Diese Funktion stellt sicher, dass der angegebene String auch wirklich im
angegebenen Charset kodiert ist. Ein korrigierter String wird
zurückgeliefert.

Wenn ein Fehler auftritt, wird im skalaren Kontext ein fehler() ausgelöst.
Im Listenkontext wird als zweites Element das korrekte (minimale) Charset
zurückgegeben.

Die Funktion geht davon aus, dass das Währungszeichen (latin1) in jedem
Fall ein Fehler ist und eigentlich ein Euro (latin9) gemeint ist.

=head2 fix_mime_encoding( msg )

Diese Funktion stellt sicher, dass sämtliche Teile einer MIME-Nachricht
wirklich im angegebenen Charset kodiert sind. Die Nachricht wird ansonsten
entsprechend modifiziert.

