=head1 Dbase::TestSupport

Supportfunktionen, die außer von den Tests auch von bin/domainmail genutzt
werden und die deshalb in Dbase::MailTest nichts zu suchen haben.

=cut

package Dbase::TestSupport;
## Achtung: wird von bin/domainmail verwendet.

use utf8;
use warnings;
use strict;
use Fehler qw(problem);
use Text::ParseWords qw(quotewords);
use Dbase::Help qw(Do DoFn DoSel DoN);
use Dbase::Globals qw(get_descr kpersinfo mime2mail name_kunde);
use Data::Dumper;
use Dbase::IP;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(sql_pre sql_post DebugDump);

sub sql_pre($) {
	my($msg) = @_;
	my $res;
	foreach my $stmt ($msg->head->get("x-sql-pre")) {
		chomp $stmt;
		my($table,$key,@set) = quotewords('\s+',1,$stmt);
		next unless @set;
		my @key = quotewords(',\s*',1,$key);
		$stmt = "update $table set ".join(", ",@set)." where ".join(" and ",@key);
		my $res = Do($stmt);
		$res .= $stmt."; ## $res\n";
	}
	$res;
}

sub sql_post($) {
	my($msg) = @_;
stmt:
	foreach my $stmt ($msg->head->get("x-sql-post")) {
		chomp $stmt;
		my($table,$key,@test) = quotewords('\s+',1,$stmt);
		next unless @test;
		my @key = quotewords(',\s*',1,$key);
		my(@var);
		foreach my $t(@test) {
			$t =~ s/^(\S+?)=//;
			push(@var,$1);
		}
		$stmt = "select ".join(",",@var)." from $table where ".join(" and ",@key);
		my $res = DoSel $stmt;
		my @data = $res->nextrow;
		unless(@data) {
			problem $stmt,"Fehler: keine Daten.";
			next;
		}
		my @dx = $res->nextrow;
		if(@dx) {
			problem $stmt,"Fehler: zu viele Zeilen.";
			next;
		}
		while(@data) {
			my $d = shift @data;
			my $v = shift @var;
			my $t = shift @test;
			if(defined $t and $t ne "NULL") {
				$t = "'$t'";
			} else {
				$t = "<undef>";
			}
			if(defined $d) {
				$d = "'$d'";
			} else {
				$d = "<undef>";
			}
			if($d ne $t) {
				problem $stmt,$v, "SOLL=$t", "IST=$d";
				next stmt;
			}
		}
	}
}

sub DebugDump(\%;$) {
	my($res,$name) = @_;
	$name = "Inhalt" unless defined $name;
	my %d = %$res; # Kopie
	if($d{'mail'}) {
		$d{'mail'} = "[".length($d{'mail'}->as_string)." Bytes]";
	}
	my $r = $d{'sendmail'};
	if($r) {
		$d{'sendmail'}=[]; # Kopie
		foreach my $m(@$r) {
			my @arg = @$m;
			my $m = $arg[0];
			if(ref $m eq "HASH") {
				problem $res,"Mail-Fehler";
				$arg[0] = "<unbekannt:HASH>";
			} else {
				$m = mime2mail($m);
				$arg[0] = "\n>>>\n$m<<<";
			}
			push(@{$d{'sendmail'}},\@arg);
		}
	}
	$r = $d{'trace_'};
	if($r) {
		$d{'trace_'} = [ sort map {join(" ", map { defined $_ ? $_ : "<undef>"} @$_)} @$r ];
	}
	$d{'event'} .= " ".get_descr("domainstatus",$d{'event'}) if $d{'event'};
	$d{'status'} .= " ".get_descr("domainstatus",$d{'status'}) if $d{'status'};
	$d{'nstatus'} .= " ".get_descr("domainstatus",$d{'nstatus'}) if $d{'nstatus'};
	$d{'hevent'} .= " ".get_descr("handlestatus",$d{'hevent'}) if $d{'hevent'};
	$d{'hstatus'} .= " ".get_descr("handlestatus",$d{'hstatus'}) if $d{'hstatus'};
	$d{'nhstatus'} .= " ".get_descr("handlestatus",$d{'nhstatus'}) if $d{'nhstatus'};
	$d{'art'} .= " ".get_descr("hm_mail",$d{'art'}) if $d{'art'};
	$d{'art2'} .= " ".get_descr("hm_mail",$d{'art2'}) if $d{'art2'};
	$d{'nic'} .= " ".get_descr("nic",$d{'nic'}) if $d{'nic'};
	$d{'domain'} .= " ".DoFn("select domain from domainkunde where id = $d{'domain'}","") if $d{'domain'};
	if($d{'ip'}) {
		my($adr,$bit) = DoFn("select ip6,bits from ipkunde where id = $d{'ip'}");
		$d{'ip'} .= " ".Dbase::IP->new_db($adr,$bit)->str;
	}
	$d{'person'} .= " ".kpersinfo($d{'person'}) if $d{'person'};
	$d{'kunde'} .= " ".name_kunde($d{'kunde'}) if $d{'kunde'};
	$d{'reseller'} .= " ".name_kunde($d{'reseller'}) if $d{'reseller'};
	my $da = Dumper(\%d);
	$da =~ s/\$VAR1 = //;
	1 while $da =~ s/\[\s*\n\s+/[ /m;
	1 while $da =~ s/\]\,\s*\n\s+\[/], [/m;
	1 while $da =~ s/\n\s+\]\s*\n(\s+)\]/\n$1] ]/m;
	"$name: $da";
}

1;
