use strict;
use utf8;
use warnings;

package Dbase::Object::Rack;

use Moose;
extends 'Dbase::Object';

use constant _attributes => {
    kunde => { bless => [qw/Dbase::Object::Kunde id/] },
    rz    => { bless => [qw/Dbase::Object::RZ id/] },
    map +( $_ => {} ), qw/he id info name x y/,
};

use constant _uniq_attributes => qw/id/;

# TODO: Das hier gehört in Dbase::Object; ich weiß nur noch nicht, wie:
while ( my $object_attr = each %{ __PACKAGE__->_attributes } ) {
    has $object_attr => (
        is   => 'rw',    # w für Attribute, die in Objekte umgewandelt werden
        lazy => 1,
        predicate => "has_$object_attr",
        default   => sub { shift->_load($object_attr) },
    );
}
while ( my ( $attr, $def ) = each %{ __PACKAGE__->_attributes } ) {
    defined( my $bless = $def->{bless} ) or next;
    my ( $package, @args ) = @$bless;
    around $attr => sub {
        my ( $orig, $self ) = @_;
        my $value = $self->$orig;
        return $value if !defined $value || ref $value;
        eval "require $package";
        die $@ if length $@;
        $self->$orig( $package->new( @args, $value ) );
    };
}

__PACKAGE__->meta->make_immutable;

no Moose;

1;

__END__

=encoding utf8

=head1 NAME

Dbase::Object::Rack - Objekt, das ein Rack repräsentiert

=head1 SYNOPSE

	use Dbase::Object::Rack;
	my $rack = Dbase::Object::Rack->new_cached( id => 42 );
	my $name = $rack->name;

=head2 KONSTRUKTOREN

=over 4

=item ->new( id => $rack_id )

Anlegen eines neuen Objekts

=item ->new_cached( id => $rack_id )

legt nur dann ein neues Objekt an, wenn nicht zuvor über diesen Konstruktur
bereits eines für dieselbe Rack-ID angelegt wurde.

=back

=head2 METHODEN

=over 4

=item ->id

zur Abfrage der Rack-ID

=item ->he

zur Abfrage der Anzahl der Höheneinheiten, die das Rack hat

=item ->name

zur Abfrage des Rack-Namens

=item ->kunde

zur Abfrage des Kundens, zu dem das Rack gehört (als
L<Dbase::Object::Kunde>-Objekt)

=item ->rz

zur Abfrage des Rechenzentrums, in dem das Rack steht (als
L<Dbase::Object::RZ>-Objekt)

=item ->x

=item ->y

zur Abfrage der Koordinaten des Racks innerhalb des L<RZs/->rz>

=back

