use strict;
use utf8;
use warnings;

package Dbase::Object::RZ;

use Moose;
extends 'Dbase::Object';

use constant _attributes => {
    standort => { bless => [qw/Dbase::Object::Person id/] },
    map +( $_ => {} ), qw/id name/,
};

use constant _uniq_attributes => qw/id name/;

# TODO: Das hier gehört in Dbase::Object; ich weiß nur noch nicht, wie:
while ( my $object_attr = each %{ __PACKAGE__->_attributes } ) {
    has $object_attr => (
        is   => 'rw',    # w für Attribute, die in Objekte umgewandelt werden
        lazy => 1,
        predicate => "has_$object_attr",
        default   => sub { shift->_load($object_attr) },
    );
}
while ( my ( $attr, $def ) = each %{ __PACKAGE__->_attributes } ) {
    defined( my $bless = $def->{bless} ) or next;
    my ( $package, @args ) = @$bless;
    around $attr => sub {
        my ( $orig, $self ) = @_;
        my $value = $self->$orig;
        return $value if !defined $value || ref $value;
        eval "require $package";
        die $@ if length $@;
        $self->$orig( $package->new( @args, $value ) );
    };
}

__PACKAGE__->meta->make_immutable;

no Moose;

1;

__END__

=encoding utf8

=head1 NAME

Dbase::Object::RZ - Objekt, das ein Rechenzentrum repräsentiert

=head1 SYNOPSE

	use Dbase::Object::RZ;
	my $rz = Dbase::Object::RZ->new_cached( name => 'nbg3' );
	my $person = $rz->standort;

=head2 KONSTRUKTOREN

=over 4

=item ->new( id => $rz_id )

=item ->new( id => $rz_name )

Anlegen eines neuen Objekts

=item ->new_cached( id => $rz_id )

=item ->new_cached( name => $rz_name )

legt nur dann ein neues Objekt an, wenn nicht zuvor über diesen Konstruktur
bereits eines für dieselbe RZ-ID angelegt wurde.

=back

=head2 METHODEN

=over 4

=item ->id

zur Abfrage der RZ-ID

=item ->name

zur Abfrage des RZ-Namens

=item ->standort

zur Abfrage des Standorts des Rechenzentrums (als
L<Dbase::Object::Person>-Objekt)

=back

