use strict;
use utf8;
use warnings;

package Dbase::Object::IP;

use Moose;
extends 'Dbase::Object';

use Dbase::IP;

use constant _attributes => {
    bits => {},
    ip6  => {},
    kunde => { bless => [qw/Dbase::Object::Kunde id/] },
    name => {},
};

has as_string => (
    isa     => 'Str',
    is      => 'ro',
    lazy    => 1,
    default => sub {
        my $self = shift;
        require Dbase::Globals;
        Dbase::Globals::ipinfo( $self->id );
    },
);

has ip => (
    isa     => 'Dbase::IP',
    is      => 'ro',
    lazy    => 1,
    default => sub {
        my $self = shift;
        Dbase::IP->new_db( $self->ip6, $self->bits );
    },
);

has '+_table' => ( default => 'ipkunde' );

# TODO: Das hier gehört in Dbase::Object; ich weiß nur noch nicht, wie:
while ( my $object_attr = each %{ __PACKAGE__->_attributes } ) {
    has $object_attr => (
        is   => 'rw',    # w für Attribute, die in Objekte umgewandelt werden
        lazy => 1,
        predicate => "has_$object_attr",
        default   => sub { shift->_load($object_attr) },
    );
}
while ( my ( $attr, $def ) = each %{ __PACKAGE__->_attributes } ) {
    defined( my $bless = $def->{bless} ) or next;
    my ( $package, @args ) = @$bless;
    around $attr => sub {
        my ( $orig, $self ) = @_;
        my $value = $self->$orig;
        return $value if !defined $value || ref $value;
        eval "require $package";
        die $@ if length $@;
        $self->$orig( $package->new( @args, $value ) );
    };
}

__PACKAGE__->meta->make_immutable;

no Moose;

1;

__END__

=encoding utf8

=head1 NAME

Dbase::Object::IP - Objekt, das ein IP-Objekt repräsentiert

=head1 SYNOPSE

  use Dbase::Object::IP;
  my $hardware = Dbase::Object::IP->new( id => 42 );
  my $str = $ip->as_string;

=head2 KONSTRUKTOREN

=over 4

=item ->new( id => $ip_id )

Anlegen eines neuen IP-Objekts

=back

=head2 METHODEN

=over 4

=item ->id

zur Abfrage der IP-ID

=item ->bits

zur Abfrage der Bits laut Datenbank

=item ->ip

zur Abfrage der IP-Adresse als Dbase::IP-Objekt

=item ->ip6

zur Abfrage der IP-Adresse im datenbankinternen Format

=item ->kunde

zur Abfrage des Kunden, zu dem das IP-Adressobjekt gehört (als
L<Dbase::Object::Kunde>-Objekt)

=item ->name

zur Abfrage des FQDNs

=back

