use strict;
use utf8;
use warnings;

package Dbase::Object::Hardware;

use Moose;
extends 'Dbase::Object';

use overload '""' => sub { shift->name },

  # zur Vermeidung von Endlos-Rekursion in Class::MOP::Attribute:
  bool => sub { 1 },
  ;

use constant _attributes => {
    enthalten_in => { bless => [qw/Dbase::Object::Hardware id/] },
    ip           => { bless => [qw/Dbase::Object::IP id/] },
    klasse       => { bless => [qw/Dbase::Descr descr hardware_klasse id/] },
    kunde        => { bless => [qw/Dbase::Object::Kunde id/] },
    name         => {},
    rack         => { bless => [qw/Dbase::Object::Rack id/] },
    standort     => { bless => [qw/Dbase::Object::Person id/] },
    status       => { bless => [qw/Dbase::Descr descr hardware_status id/] },
    typ          => { bless => [qw/Dbase::Descr descr hardware_typ    id/] },
};

has as_string => (
    isa     => 'Str',
    is      => 'ro',
    lazy    => 1,
    default => sub {
        my $self = shift;
        '#' . $self->id . ':' . $self->name;
    },
);

has effektiver_standort => (
    isa     => 'Dbase::Object::Person',
    is      => 'ro',
    lazy    => 1,
    default => sub {
        my $self = shift;
        if ( defined( my $standort = $self->standort ) ) { return $standort }
        if ( defined( my $rack = $self->rack ) ) {
            return $self->rack->rz->standort;
        }
        if ( defined( my $enthalten_in = $self->enthalten_in ) ) {
            return $self->enthalten_in->effektiver_standort;
        }
        die 'Hardware #' . $self->id . " hat keinen Standort!?\n";
    },
);

has text => (
    is      => 'ro',
    lazy    => 1,
    default => sub {
        my $self = shift;
        no warnings 'once';
        require Loader and Loader->import(qw/list_hardware lister/)
          unless defined &list_hardware && defined &lister;
        lister(5);
        list_hardware( $self->id );
        lister(0);
        $Db::output;
    },
);

# TODO: Das hier gehört in Dbase::Object; ich weiß nur noch nicht, wie:
while ( my $object_attr = each %{ __PACKAGE__->_attributes } ) {
    has $object_attr => (
        is   => 'rw',    # w für Attribute, die in Objekte umgewandelt werden
        lazy => 1,
        predicate => "has_$object_attr",
        default   => sub { shift->_load($object_attr) },
    );
}
while ( my ( $attr, $def ) = each %{ __PACKAGE__->_attributes } ) {
    defined( my $bless = $def->{bless} ) or next;
    my ( $package, @args ) = @$bless;
    around $attr => sub {
        my ( $orig, $self ) = @_;
        my $value = $self->$orig;
        return $value if !defined $value || ref $value;
        eval "require $package";
        die $@ if length $@;
        $self->$orig( $package->new( @args, $value ) );
    };
}

__PACKAGE__->meta->make_immutable;

no Moose;

1;

__END__

=encoding utf8

=head1 NAME

Dbase::Object::Hardware - Objekt, das ein Hardware-Objekt repräsentiert

=head1 SYNOPSE

  use Dbase::Object::Hardware;
  my $hardware = Dbase::Object::Hardware->new( id => 42 );
  my $text = $hardware->text;

=head2 KONSTRUKTOREN

=over 4

=item ->new( id => $kundennummer, [ name => $kundenname ] )

Anlegen eines neuen Hardware Objekts

=back

=head2 METHODEN

=over 4

=item ->effektiver_standort

zur Abfrage des effektiven Standorts der Hardware (als
L<Dbase::Object::Person>-Objekt);
bei (in Racks oder andere Hardware) eingebauter Hardware wird dabei (ggf.
rekursiv) der Standort des RZs, zu dem das Rack gehört, bzw. der Standort dieser
anderen Hardware ermittelt.

=item ->enthalten_in

zur Abfrage der übergeordneten Hardware (als L<Dbase::Object::Hardware>-Objekt,
oder C<undef>, sofern die Hardware nicht in eine andere eingebaut ist)

=item ->id

zur Abfrage der Datenbank-ID des Hardware-Objekts

=item ->kunde

zur Abfrage des Kunden, zu dem die Hardware gehört (als
L<Dbase::Object::Kunde>-Objekt)

=item ->rack

zur Abfrage des Racks, in das die Hardware eingebaut ist (als
L<Dbase::Object::Rack>-Objekt oder C<undef>, sofern die Hardware nicht im
Housing ist)

=item ->status

=item ->typ

zur Abfrage des Hardware-Status bzw. -Typs als L<Dbase::Descr>-Objekt

=item ->text

zur Abfrage des in "Kunde" vordefinierten Texts

=back

