=head1 Dbase::OTRS

Hilfsfunktionen zum Arbeiten mit OTRS.

Diese Bibliothek wird nur noch vom RT genutzt und soll auch zusammen mit dem RT
sterben.
Alle anderen Programme müssen zum Zugriff auf Ticketsysteme die
L<noris::Ticket::API> verwenden

=head2 Funktionen

=over 4

=item TicketID (Nummer)

Liefert die (invariante) ID eines Tickets, gegeben die (sichtbare) Nummer.

C<undef>, wenn das Ticket nicht existiert.


=back

=cut

package Dbase::OTRS;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(TicketID QueueDaten);

use utf8;
use warnings;
use strict;

use Cf qw($OTRS);
use Dbase::Help qw(DoFn qquote);
my $otrs;

sub TicketID($) {
	# OTRS-Ticketnummer => Ticket-ID
	my($nr) = @_;
	$otrs = Dbase->new(DB => "OTRS") unless defined $otrs;
	my $id =
	  $otrs->DoFn( "select writeonly id from $OTRS.ticket where tn="
		  . qquote($nr)
		  . ' and valid_id=1' );
	return $id;
}

sub QueueDaten($) {
	# RT-Queue-Name => (OTRS-Queue-Nr,-Name)
	my($qname) = @_;
	$otrs = Dbase->new(DB => "OTRS") unless defined $otrs;
	my($nr,$name) = $otrs->DoFn(<<_);
   SELECT writeonly $OTRS.queue.id,$OTRS.queue.name
     FROM $OTRS.system_address, $OTRS.queue
    WHERE $OTRS.queue.id = $OTRS.system_address.queue_id
      AND system_address.valid_id = 1
      AND $OTRS.system_address.value0 like ${\qquote $qname."@%"}
 ORDER BY $OTRS.queue.id
    LIMIT 1
_
	return ($nr,$name);

}

1;
