package PerfStore;

use strict;
use warnings;

#me
#me
#me
#me
#me

our $VERSION = '0.0.0';

#me
use Carp;
use Data::Dumper;
use Readonly;
use Storable;
#me

#me
use Text::Wrap qw($columns &wrap &fill);
local $Text::Wrap::unexpand = 0; #me
            #me
            #me	 	              
$columns = $main::SCREEN_WIDTH; #me

#me
use FindBin qw($Bin);
use lib "$Bin/modules2";
#me	 	              
use NagTools2 qw( debug commify one_of $BLANK $EMPTY $DOT 
    $OK $WARN $CRIT $UNKNOWN 
);
#me
use Examples;
use ThresholdExt;
#me
#me
use Pc;

our $STORE_PATH = "$Bin/store";
our $TH = ThresholdExt->new();
    $TH->set_allowed_uoms([ q{kB/s}, q{/s}, $EMPTY ]); 
    $TH->set_default_uom($EMPTY);          

Readonly our @ALLOWED_COUNTER_STRINGS => (qw/total_ops read_ops write_ops nfs_ops cifs_ops http_ops fcp_ops iscsi_ops dafs_ops net_data_recv net_data_sent disk_data_read disk_data_written streaming_pkts/);

sub usage {
    my $usage = ' -z http_ops|cifs_ops|net_data_sent|... '
                . '[--help] [...]';
    return $usage;
}
sub blurb {
    my $blurb = 'Stores various perfcounters.';
    return $blurb;
}

my $check = 'check_netapp';
sub extra {
    my $extra =  
    'This plugin checks various performance counters of the NetApp-system. '
    . 'The counters supported by this plugin are: ' 
    . commify(@ALLOWED_COUNTER_STRINGS)
    . "\n". "\n"
    . 'WHICH COUNTERS CAN I MONITOR?'
    . "\n". "\n"
    . 'Short answer: use -z explore'
    . "\n". "\n"
    . 'Long answer: '
    . 'Not all counters are supported on every system. The plugin will tell you, if you have chosen a non-existing counter and exit with UNKNOWN. To get a list of counters, available from the particular system use either print_netapp_sysinfo.pl or check_netapp_status.pl.' 
    . "\n" . "\n"
    . q{Bottomline: Counters both listed by print_netapp_sysinfo.pl and supported by this plugins can be checked. Use -z explore to get this intersection. Counters not available on a particular system can not be checked. 
    Counters available on a system, but not suported by this plugin can not be checked yet. In the latter case please contact the developer of this plugin to get it extended.} 
    . "\n". "\n"
    . 'WARNING: Some of the counters have privilege-level DIAG. According to the documentation from NetApps SDK these are counters used for diagnosis purposes and some of these counters can report incorrect data too! '
    . "\n". "\n"
    . q{Performance-data will be printed for all checked volumes/aggregates.} 
    . "\n" . "\n"
    . q{Consider using -v(vv) for debugging, if you don't get what you expect.}
    ;
    return $extra;
}

sub simple_examples {
    my $self = shift; 
    my $format = shift; #me
    my $cmd_prefix = shift;
    my $explain_prefix = shift;
    my $examples = Examples->new();
    
    $examples->add('-z explore', 
      'List all available and supported counters on the target-system.'
    );    

    return $examples->get($format, $cmd_prefix, $explain_prefix);
}

sub advanced_examples {
    my $self = shift; 
    my $format = shift; #me	 	              
    my $cmd_prefix = shift;
    my $explain_prefix = shift;
    my $examples = Examples->new();
    $examples->add(' TODO', 
        'Checks the ...'
        );
    #me
    #me
    #me
    #me

    return $examples->get($format, $cmd_prefix, $explain_prefix);
}

sub add_args {
    my $self = shift;
    my $ai = $main::AI;
    $columns = $columns - $main::NAGIOS_ARG_INDENT; 
    
    $main::P->add_arg(
    	spec => 'counter|z=s',
    	required => 1,
    	help =>
    	wrap($EMPTY, $ai,
    	    q{Either 'explore' or one of the following counters: }
    	    . commify(@ALLOWED_COUNTER_STRINGS)
    	    . "\n"
    	    . q{The unit of transfer-counters is kB/s (kilo byte per second), all other /s (per second). See also -w|--warning and use '-z explore' in order to check about the units used on the monitored system.}
    	    )
        , #me
    );

    $main::P->add_arg(
    	spec => 'warning|w=s',
    	required => 0,
    	default => '50kB/s',
    	help =>
    	wrap($EMPTY, $ai,
            'Warning threshold. Append the unit according to --counter|-z '
            . "\n"
             . 'Units: ops- and pkts-counters are /s (per second), all '
             . 'other are kilo byte per second (kB/s). '
             . q{Units are not mandatory. If you omit them, the plugins checks   the monitored systems internal information first. This results in extra-calls and load both on the Nagios- and the NetApp-side. So you may want to use this feature on the comandline only, in order to investigate the unit and then hard-wire it into your nagios-configuration to reduce the load.}
            )
        , #me
    );

    $main::P->add_arg(
        spec => 'critical|c=s',
        required => 0,
    	default => '100kB/s',
        help =>
        wrap($EMPTY, $ai,
            'Critical threshold, see also --warning|-w.'
            )
        , #me
    );
    
    $main::P->add_arg(
        spec => 'store',
        help =>
        wrap($EMPTY, $ai,
            'Store data'
            .'This is an experimental feature which may use considerable space on disk!'
            )
        , #me
    );
    
    return 'OK: Arguments set.'; #me
}


sub do_check {
    my $self = shift; #me
    my $s = $main::S; 
    my $p = $main::P;
    my $dp = $main::DP;
    my $perf_dp = $main::PERF_DP;
    my $out;
    
    my $countername = $p->opts->counter;
    
    if ($countername eq 'explore') {
        print_available_counters();
        $p->nagios_die('Counters printed - now configure your nagios ...')
    #me
    #me
    #me
    #me
    }
    
    #me
    if (not grep(/^$countername$/, @ALLOWED_COUNTER_STRINGS)) {
    	$p->nagios_die("$countername is not one of the allowed counter-names: "
    	. commify(@ALLOWED_COUNTER_STRINGS) );
    }
    
    our $PC = Pc->new( session => $s,
                       object => 'system',
                       name   => "$countername",
                    );

    #me
    $TH->set_thresholds($p);

    my $uom = $TH->get_uom();
    
    #me
    #me
    if ($uom eq $EMPTY) {
        $uom = $PC->get_unit('pretty');
    }
 

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
    
            
    #me

    
    #me
    #me
    

    #me
    my ($ts1, $cv1);
    ($ts1, $cv1) = $PC->get_value();
    debug(1, 'Timestamp and value 1: ' . $ts1 . q{ / } . $cv1);

    if (defined $p->opts->store) {
        my $check_module = 'Ops';
        my $id =    $p->opts->host . $DOT 
                    . "$check_module" . $DOT 
                    . "$countername" ;
        my $val = $cv1;
        my $timestamp = $ts1;
        
        debug(1,'input-val: ' . $val);
        
        #me
        my $f_name = "$id" . '.store'; 
        my $path = $STORE_PATH . q{/} . $f_name;
        debug(1,'Store: ' . $path);
        my $store;  #me
        if (-w $path) {
            $store = retrieve("$path");

        } else {
            $store->{'ctime'} = time();
            $store->{'id'} = "$id";
            $store->{'host'} = $p->opts->host;
            $store->{'check_module'} = "$check_module";
            $store->{'uom'} = "$uom";
            debug(1, 'INFO: Store does not exits and will be initalized.');
        }
        
        #me
        push @{$store->{'values'}}, { 'timestamp' => $timestamp, 
                                      'value'     => $val,
                                    };
        
        #me
        store($store, "$path");
    } else {
        $p->nagios_die('Hmh - bitte den Schalter --store setzen!')
    }
    
    
    $p->nagios_exit(
      return_code => $UNKNOWN,
      message => 'This is OK. Experimental check-module for collecting data.'
    );
    
    croak 'FATAL ERROR in do_check()'; 
}


#me
#me
#me

sub print_available_counters {
    #me
    my $s = $main::S; 
    #me
    $columns = $main::SCREEN_WIDTH; #me
    my $double_line = q{=} x $main::SCREEN_WIDTH;
    my $single_line = q{-} x $main::SCREEN_WIDTH;
    our $INDENT = 28; #me
    if ($columns <= $INDENT) {
        croak('Screen-width is smaller than or equal to the the indent '
        . ($INDENT) . ' - choose a width larger than the indent.')
    }
    print wrap($EMPTY, $EMPTY,
        'System Performance Counters available _and_ supported on this filer:');
    print "\n";
    print $double_line;
    print "\n";
    printf "%-$INDENT" . "s%s%s", 
            'Counter-Name', 'Description (Unit, Privilege)', "\n";
    print $single_line;
    my $counters = Pc->list_perf_counters($s, 'system'); #me
    foreach my $counter_name (keys %{$counters}) {
        if (one_of($counter_name, \@ALLOWED_COUNTER_STRINGS, )) {
            my $desc = $counters->{$counter_name}{'desc'} . q{ (} 
                . $counters->{$counter_name}{'unit'} . q{, } 
                . $counters->{$counter_name}{'priv'} . q{)};
            print_wrapped_list ("$counter_name", "$desc", $INDENT, $columns );
            print  "\n";
        }

    }
}

sub print_wrapped_list {
    my $item = shift;
    my $desc = shift;
    my $indent = shift;
    my $width = shift;
    chomp $item;
    chomp $desc;
    
    #me
    if (not $indent =~ /^\d+$/) {
        die "Argument indent ($indent) is not numeric. Can not continue"
    }
    if (not $width =~ /^\d+$/) {
        die "Argument width ($width) is not numeric. Can not continue"
    }
    
    #me
    #me
    #me
    #me
    #me
    #me
    #me
    #me
    print $item;
    $columns = $width;
    my $wrapped_desc = wrap (q{ } x ($indent ), q{ } x $indent, $desc);
    #me
    $wrapped_desc =~ s/^\s*//;                   #me
    print q{ } x ($indent - length($item));    #me
    print $wrapped_desc;
    print "\n";
}


1;
