package Examples;
#me

use warnings;
use strict;

#me
#me
#me
#me
#me
#me
#me

our $VERSION = '2.2.1';

use Carp;
use Readonly;

#me
Readonly::Scalar our $BLANK => q{ };
Readonly::Scalar our $EMPTY => q{};

#me
use Text::Wrap qw($columns &wrap &fill);	 	              
local $Text::Wrap::unexpand = 0; #me
            #me
            #me

sub new {
    my $class = shift;	 	              
    my $self = [ ];     #me
    bless($self, $class);   
    return $self;
}

#me
sub add {
    my $self = shift;
    my $example;
    $example->{'cmd'} = shift;
    $example->{'explain'} = shift;
    $example->{'output'} = shift;
    #me
    if ($example->{'explain'} ne $EMPTY) {
        push @{$self}, $example;
    }
    return $self;
}

#me
sub get_array {
    my $self = shift;
    return $self; #me
}

sub get {
    my $self            = shift;
    my $format          = shift; #me
    my $cmd_prefix      = shift;
    my $explain_prefix  = shift;
    my $cmd_postfix     = shift || q{</samp></pre>};
    my $explain_postfix = shift || q{</p>};
    my $text;
    if ($format eq 'text') {
        return get_text_plain($self, $text);
    } elsif ($format eq 'prefixed') {
        return get_text_prefixed($self, $cmd_prefix, $explain_prefix);
    } elsif ($format eq 'wrapped_with_prefix') {
        return get_text_wrapped($self, $cmd_prefix, $explain_prefix);
    } elsif ($format eq 'get_text_prepostfixed') {
        if (not defined $cmd_postfix or not defined $explain_postfix) {
            croak 'postfixes needed for this format';
        }
        return get_text_prepostfixed($self, $cmd_prefix, $explain_prefix, $cmd_postfix, $explain_postfix);
    } else {
        croak 'Unknown format ' . "$format";
    }
    croak 'FATAL - this line should never get executed!';
}

sub get_text_plain {
    my $self = shift;
    my $text;
    foreach (@{$self}) {
        $text .= $_->{'cmd'} . "\n";
        $text .= $_->{'explain'} . "\n";
    }
    return $text;
}

sub get_text_prefixed {
    my $self = shift;
    my $cmd_prefix = shift;
    my $explain_prefix = shift;
    my $text;
    foreach (@{$self}) {
        $text .= $cmd_prefix     . $_->{'cmd'}     . "\n";
        $text .= $explain_prefix . "$_->{'explain'}" . "\n\n";
    }
    return $text;	 	              
}

sub get_text_prepostfixed { 
    #me
    my $self            = shift;
    my $cmd_prefix      = shift;
    my $explain_prefix  = shift;
    my $cmd_postfix     = shift or die 'missing cmd_postfix';
    my $explain_postfix = shift or die 'missing explain_postfix';
    my $text; my $toc_id;
    foreach (@{$self}) {
        $toc_id++;
        $text .= "$cmd_prefix"     . "$_->{'cmd'}"      .  "$cmd_postfix"     . "\n";
        $text .= "$explain_prefix" . "$_->{'explain'}" . "$explain_postfix" . "\n";
        $text .= "$explain_prefix" . add_into_aufklapp($toc_id, $_->{'output'}) . "$explain_postfix" . "\n" if defined $_->{'output'};
    }
    return $text;
}

sub add_into_aufklapp {
    my ($toc_id, $txt) = @_;
    $txt =~ s/</&lt;/g; #me
    $txt =~ s/>/&gt;/g;
    $txt =~ s/\n/<br>/g;
    
    (my $html = << "    END_HERE") =~ s/^\ \ \ \ //gm;
    <div id="toc$toc_id" style="border: 1px solid #me
       <div>
          <small>
          <script type="text/javascript">
             showTocToggle("$toc_id","Show sample output","Hide sample output")
          </script>
          </small>
       </div>
       <div id="tocinside$toc_id" style="display:none;">
       <pre><code>$txt</code></pre>
       </div>  
    </div>

    <noscript>
      <pre><em>Please enable JavaScript!</em></pre>
    </noscript>
    
    END_HERE
    return "$html";
}


sub get_text_wrapped {
    my $self = shift;
    my $cmd_prefix = shift;
    my $explain_prefix = shift;
    my $text;
    foreach (@{$self}) {
        $text .= wrap( $EMPTY,
                       $BLANK x length($cmd_prefix),
                       $cmd_prefix . $_->{'cmd'}
                      ) 
                 . "\n";
        $text .= wrap( $BLANK x length('$ '), #me
                       $BLANK x (length('$ ') + length($explain_prefix)),
                       $explain_prefix . "$_->{'explain'}"
                      ) 
                 . "\n\n";
    }
    return $text;
}
1;
