package PerfDisk;

use strict;
use warnings;
no warnings 'redefine'; # für tt bin/build

use Carp; use Carp::Heavy;
use Data::Dumper;
use Readonly;

use FindBin qw($Bin);
use lib "$Bin/../../modules/Il"; # .../check_netapp/modules/Il/
use NagTools2 2.3.5 qw( :debug :special_chars :text_format :web);


# ===========================================================================
# = Texte  - ab hier wird übersetzt =
# ===========================================================================

# ===========================================================================
# Verwendbare Variablen in den Texten:
#
# $BR           = line-break = Zeilenumbruch (entspricht "\nl")
# $PAR          = paragraph = Absatzumbruch (entspricht "\nl\nl")
# $VERBOSE_HINT = Hinweis -v einzusetzen
# 
#
# Newlines (Zeilenumbrüche) sind innerhalb von '', "", ... NICHT erlaubt!
#
# ===========================================================================

sub Dox::blurb {
    my $content =
        q{Check for system disks resource utilisation.};
    return $content; 
}

# CONTENT is used for both extra and web_counter_table
Readonly our $CONTENT =>
    q{This plugin checks all disks in a NetApp system for their utilisation (Percentage of time where at least one request is outstanding on the disk).}
    . $BLANK . q{Optional: the check can be limited to the disks of a single aggregate.}
    . $BR # unter dem $BR wird noch eine Counterliste automatisch angehängt (nicht am Web)
; # Ende von my $content 

sub Dox::extra {
    my $content = $CONTENT; 
    return $content;
} 


#
# Examples: Hier ist jeweils nur txt => zu übersetzen
# 

sub Dox::simple_examples {
    my $examples = 
        [
            {
                cmd => qq{$EMPTY},
                txt => q{Checks each of the disks using the default thresholds. The default-values for the thresholds are documented in the section for the '--warning'-switch.}
            },
            {
                cmd => q{-w 83% -c 95%},
                txt => q{Checks each of the disks - warns if utilisation is greater than 83%.}
            },
            {
                cmd => q{-w 83 -c 95},
                txt => q{Same as above, but auto-detecting the unit.}
                    . $BLANK . q{Please read the help section about --warning to understand the effect this feature might have on the performance.}
            },
        ]
    ; # Ende von my $examples =
    return $examples;
}

sub Dox::web_counter_table { # called from TT:helplib:get_counter_table
    # single counter check - so no documentation about the counter necessary
    
    my $c = q{<p>You neither need nor can specify the counters for this plugin.</p>};
    $c .= qq{<p>$CONTENT</p>};
    return $c;
}

sub Dox::advanced_examples {
    my $examples = 
        [
            {
                cmd => q{--explore=instances},
                txt => q{Retrieves the name of each disk and the aggregate it belongs to.}
                # Ü: Das ist eine Liste aller Platten wobei vermerkt ist, zu welchem Aggregat die einzelne Platte gehört.
            },
            {
                cmd => q{--aggr=aggr0 -w 60% -c 80%},
                txt => q{Only checks disks that belong to aggr0 - warns if utilisation is greater than 60%.}
            },
        ]
    ; # Ende von my $examples =
    return $examples;
}


# ===========================================================================
# = ENDE der Texte - ab hier ist nichts mehr zu übersetzen =
# ===========================================================================

1;  # return true