package CheckPlugin;

#me

use warnings;
use strict;

use Carp; use Carp::Heavy;
use Readonly;
use English '-no_match_vars';
use Data::Dumper;
use List::MoreUtils qw( any );

use FindBin qw($Bin);
use lib "$Bin/../modules/il";
use NagTools2 qw(
    i debug commify one_of
    data_ontap_version
    :special_chars
    $AI
    $WWW_URL
	$GLOBAL_DOVC
);

#me	 	              
Readonly my $CREATE_DUMP_FOR_MOCKING => 0;

#me
use Text::Wrap qw( $columns &wrap &fill );
local $Text::Wrap::unexpand = 0;  #me
                                  #me	 	              
                                  #me


#me
#me
#me
#me
#me

our $VERSION = '2.3.2';

#me
#me
#me
#me
#me
#me
#me
#me
#me

sub new {

#me
#me
#me
#me
#me

    my ($an5, %an0) = @_;
    
    #me
    if (not defined $an0{'dp_out'}) {croak 'missing dp_out'}
    if (not defined $an0{'dp_perf'}) {croak 'missing dp_perf'}
    if (not defined $an0{'argument_indent'}) {croak 'missing argument_indent'}
    if (not defined $an0{'nagios_arg_indent'}) {croak 'missing nagios_arg_indent'}
    if (not defined $an0{'ontapi_minor_version'}) {croak 'missing ontapi_minor_version'}
    if (not defined $an0{'ontapi_major_version'}) {croak 'missing ontapi_major_version'}
    
    my $an6 = bless{
        _progname   => $an0{'progname'} || croak ('missing or undefined progname'),
        _dp_out     => $an0{'dp_out'},
        _dp_perf    => $an0{'dp_perf'},
        _screen_w   => $an0{'screen_width'} || croak ('missing screen_width'),
        _ai         => $an0{'argument_indent'},
        _nag_ai     => $an0{'nagios_arg_indent'},
        
        _credentials_max_length => $an0{'credentials_max_length'} 
            || croak ('missing credentials_max_length'),
            
        _ontapi_major_version   => $an0{'ontapi_major_version'},
        _ontapi_minor_version   => $an0{'ontapi_minor_version'},
        _max_length_single_line => $an0{'max_length_single_line'}
            || croak('missing max_length_single_line') ,
        _max_length_multi_line      => $an0{'max_length_multi_line'}
            || croak('missing max_length_multi_line'),
        _max_length_cmd             => $an0{'max_length_cmd'}
            || croak('missing max_length_cmd'),
        _debug => $an0{'debug'},
        _version => $an0{'version'},
        _timeout => $an0{'timeout'} || croak('missing arg timeout') ,
        _dovc => $an0{'dovc'},
    }, $an5;
    return $an6;
}

sub init_session_object {
    my $an6 = shift;
    my $an7 = shift;
    my $an8 = shift;	 	              
    

#me
#me
#me
#me
#me

    my $an9 = $an6->open_session($an7, $an8);
    $an6->set_session($an9);
    return $an6;
}

sub open_session {
    my $an6 = shift;
    my $an7 = shift;
    my $an8 = shift;
    

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $an10 = $an6->get_p();

    my $an9 = NaServer->new( $an10->opts->host, $an6->{'_ontapi_major_version'},
        $an6->{'_ontapi_minor_version'} );

    #me
    if ($an10->opts->ssl eq 'no') {
        check_out( $an9->set_transport_type('HTTP') );
        debug(1, 'Using HTTP as transport-type');
    } elsif ($an10->opts->ssl eq 'yes') {
        check_out( $an9->set_transport_type('HTTPS') );
        debug(1, 'Using HTTPS as transport-type');
    } else {
        $an10->nagios_die('Invalid value for --ssl, must be either yes or no.')
    }

    if ( defined $an10->opts->vfiler ) {
        check_out( $an9->set_vfiler($an10->opts->vfiler), $an10 );
    }
    #me
    #me
    #me
    check_out( $an9->set_admin_user( $an7, $an8 ), $an10 );
    check_out( $an9->set_timeout( $an10->opts->timeout ), $an10 );    #me
    
    #me
    if ( $an6->{'_dovc'} ) {
		my $an11 = $an9->invoke( 'system-get-version');

		if ($an11->results_status() eq 'failed'){
			$an10->nagios_die(
				$an11->results_reason() . $DOT
				. $BLANK .  q{Changing the value of --ssl *may* help.} 
			);
		} 
		
        my $an12 = data_ontap_version($an9);
        if (not defined $an12) {
            $an10->nagios_die('Can not get DataONTAP-version from filer.');
        }
        debug(1, "DataONTAP version: $an12");
        my @an2 = (
                                    qr{7\.2},
                                    qr{7\.3},
                                    qr{8\.0.*7-Mode}i,  #me
                                    qr{8\.1.*7-Mode}i,  #me
                                 )
        ; #me
        if ( not any {$an12 =~ /$_/} @an2 ) {
            $an10->nagios_die("Unsupported DataONTAP-version ($an12). "
                            . ' Supported Versions: '
                            . commify(@an2)
                          );
        }
        return $an9; #me
    } else {
        return $an9; #me
    };
    
}

sub set_dovc {
	
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

	my $an6 = shift;
	my $an13 = shift;
	croak 'undefined val' if not defined $an13;
	if ($an13) {
		if  ( lc($GLOBAL_DOVC) eq 'off' ) {
			carp '$GLOBAL_DOVC overrules set_dovc(1)';
			$an6->{'_dovc'} = 0;
			return $an6->{'_dovc'};
		} else {
			$an6->{'_dovc'} = 1;
		}
	} else {
		$an6->{'_dovc'} = 0
	}
	return $an6->{'_dovc'};
}

sub set_session {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $an6 = shift;
    $an6->{'_session'} = shift || croak('session undefined');
    return $an6;
}


#me
#me
#me
#me
#me
#me

sub get_p {
    my $an6 = shift;
    return $an6->{'_p'};
}

sub get_progname {
    my $an6 = shift;
    return $an6->{'_progname'};
}

sub get_decimal_precision_output{
    my $an6 = shift;
    return $an6->{'_decimal_precision_output'};
}

sub define_output_format {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $an6 = shift;
    my $an10 = $an6->{'_p'};
    my $KV;    #me
    my $BR;    #me
    my $SLS;   #me
    my $MAX_MSG_LENGTH; #me


    #me
    if ($an10->opts->output =~ /^m[a-z]{0,4}/ms) {   #me
        $KV   = q{: };   
        if ($an10->opts->html_tags) {
            $BR = q{<BR>};
        } else {
            $BR = q{, };
        }
        $SLS  = qq{\n};
        $MAX_MSG_LENGTH = $an6->{'_max_length_multi_line'}
            ;   #me
    } elsif ($an10->opts->output =~ /^s[a-z]{0,5}/ms) {  #me
        $KV   = q{=};
        $BR   = q{, };
        if ($an10->opts->html_tags) {
            $SLS = q{<BR>};
        } else {
            $SLS = q{; };
        }
        $MAX_MSG_LENGTH = $an6->{'_max_length_single_line'}
            ;   #me
    } elsif ($an10->opts->output =~ /^c[a-z]{0,8}/ms) {  #me
        $KV             = q{: };
        $BR             = qq{\n};
        $SLS            = qq{\n};
        $MAX_MSG_LENGTH = $an6->{'_max_length_cmd'};
    } else {
        $an10->nagios_die('Invalid value for argument --output.' . $BLANK
            . q{Must be either 'single', 'multi' or 'cmd'.});
    }
    $an6->{'_output_format'}{'br'}                     = $BR;
    $an6->{'_output_format'}{'key_value_seperator'}    = $KV;
    $an6->{'_output_format'}{'short_long_service_seperator'} = $SLS;
    $an6->{'_output_format'}{'max_msg_length'}         = $MAX_MSG_LENGTH;
    return $an6;
}

sub get_output_formspec {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my ($an6, $an14) = @_;
    if (defined $an6->{'_output_format'}{$an14}) {
        return $an6->{'_output_format'}{$an14};
    } else {
        croak 'Undefined output_format: ' . $an14;
    }
}

sub init_p {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $an6 = shift;
    my $PROGNAME = $an6->{'_progname'};
    my $PLUG = ref $an6; #me
    $columns = $an6->{'_screen_w'}; #me
    my $an15 = q{=} x $an6->{'_screen_w'} . "\n";
    my $an16 = q{-} x $an6->{'_screen_w'} . "\n";

    my $an17;
    if ( $PLUG->advanced_examples('text') ) {
        $an17 = 
            "\n\n"
            . 'ADVANCED EXAMPLES:'
            . "\n"
            . $an16 .
            wrap($EMPTY,$EMPTY,
              'Note: Host- and credential-arguments are not specified.' 
              . q{ Please fill out '...' with -H hostname and -u user%pass in the examples below.}
              . "\n"
              . 'Instead of \'-u user%pass\' you can use \'-f auth.txt\' to read '
              . 'the credentials from a plain text-file.' . "\n"
            ) 
            . $an16
            . $PLUG->advanced_examples('wrapped_with_prefix', "\$ check_netapp.pl $PLUG ... ", '==> ')
         
    } else {
        $an17 = $EMPTY;
    }
    
    my $an10 = Nagios::Plugin->new(
        usage => wrap($EMPTY, q{ } x length('Usage: '), "Usage: $PROGNAME $PLUG -H <hostname|IP> -u <username%%an1>" . $PLUG->usage),
        version => $an6->{'_version'},
        blurb => wrap($EMPTY, $EMPTY, $PLUG->blurb), 
    	license => "Copyright 2009-2011 by Ingo Lantschner\nAuthor: Ingo Lantschner",
    	url => "$WWW_URL",
    	extra => "\n" . "\n"
    	    . 'DESCRIPTION:' . 
    	    "\n" . "\n"
    	    . fill($EMPTY,$EMPTY, $PLUG->extra)
    	    . "\n\n\n"
    	    . 'SIMPLE EXAMPLES:'
    	    . "\n\n"
    	    . wrap ($EMPTY,$EMPTY,
    	            $PLUG->simple_examples('wrapped_with_prefix', 
    	            "\$ check_netapp.pl $PLUG -H filer -u user\%pass ",
    	            '==> ')
    	           ) 
            . $an17
        , #me
        timeout => $an6->{'_timeout'},
    );

    $an10->add_arg(
        spec     => 'host|H=s',
        required => 1,
        help     => q{IP-address or hostname of the filer.},
    );

    $an10->add_arg(
        spec => 'user|u=s',
        help =>
            wrap($EMPTY, $AI,
                    'Username and password for login to the filer. Delimiter '
                    . 'is a %-sign. F.e. nagios%MyPass. '
                ) 
            . "\n" 
            . wrap($AI, $AI, 
                    'This option overrides --authfile'
                  )
        , #me
    );
    Readonly my $an18 => q{/usr/local/nagios/etc/netapp_credentials};
    $an10->add_arg(
        spec => 'authfile|f=s',
        default => qq{$an18},
        help => 
            '-f, --authfile=<path>'
            . "\n"
            . wrap($AI, $AI,
                    'Authentication file with login and password.'
                    . q{ Defaults to '} . "$an18" . q{'}
                    . "\n"
                    . 'File syntax:'
                   ) 
            . "\n"
            . "$AI" . ($BLANK x 2) . 'username=<login>' . "\n"
            . "$AI" . ($BLANK x 2) . 'password=<password>'. "\n"
            . wrap($AI, $AI,
                    'Hint: Leading and terminating whitespace will get removed from '
                    . 'the username or the password. So usernames and passwords '
                    . 'with leading or terminating whitespace are not possible. '
                    . '(Anyway, a very bad practice and mostly impossible.)'
                   )
        , #me
    );

    $an10->add_arg(
        spec    => 'show_password',
        help =>
            wrap($EMPTY, $AI,
                'Only usefull for debugging and if -v|--verbose is set. '
                . 'Normaly only stars are printed (according to the number of '
                . 'characters) for the password in verbose output. If set, the '
                . 'password is shown in clear-text.'
                )
        , #me
    );

    $an10->add_arg(
        spec    => 'output=s',
        default => 'multi',
        help =>
            wrap($EMPTY, $AI,
                'Wether to use single-line output (compatible with Nagios 2.x) or '
                . 'multi-line. This does not influence how detailed the output is, '
                . 'but how it is structured (with or without newline in between).'
                . "\n" . q{Defaults to 'multi'.}
                )
    );

     $an10->add_arg(
        spec    => 'color',
        help =>
            wrap($EMPTY, $AI,
                'Colored output f.e. for instances in over-all checks. '
                . '--html_tags is required for color-support.'
                )
    );
    
    $an10->add_arg(
        spec    => 'html_tags',
        help =>
            wrap($EMPTY, $AI,
                'Use html-tags in the output for line-breaks and color-codeing. '
                . 'Required for --color. You may have to edit cgi.cfg in Nagios '
                . 'and set \'escape_html_tags=0\'.'
                )
    );

    $an10->add_arg(
        spec    => 'ssl=s',
        default => 'yes',
        help =>
            wrap($EMPTY, $AI,
                q{Use ssl-encryption - defaults to 'yes'. }
                . q{Set to 'no', if you want to use unencrypted http instead of }
                . q{https.}
                )
    );

    $an10->add_arg(
        spec    => 'vfiler=s',
        help =>
            wrap($EMPTY, $AI,
                q{optional, vFiler to check in a MultiStore environment.}
                . q{ Requires Data ONTAP 7.2.1 or later.}
                )
    );
    
    $an6->{'_p'} = $an10;
    return $an10;
}
sub add_args_to_p{

#me
#me
#me
#me
#me
#me

    return;
}
sub getopts {

#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $an6 = shift;
    my $an10 = $an6->get_p();
    $an10->getopts or croak '$an10->getopts failed';

    



    if ($CREATE_DUMP_FOR_MOCKING) {
        dump_mock(
            data => $an10,
            file => 'CheckNetApp_pm_p',
            in => 'n/a',
            desc => 'N::P object after $an10->getopts',
        );
    }
    $an6->{'_debug'} = $an10->opts->verbose;
    debug(1, 'Debugging-level reset to' . $BLANK . $an6->{'_debug'} . $BLANK 
             . 'according to -v(vv)');
             

    if ($an10->opts->color and not $an10->opts->html_tags) {
        $an10->nagios_die('Invalid paramter combination, --color requires --html_tags');
    }
    
    if ( defined $an6->{'_m'} ) {

        my $an19 = $an6->{'_m'};
        $an19->select_metric($an10);

    }
    return $an6;
}

sub get_debug {
    my $an6 = shift;
    return $an6->{'_debug'};
}

sub get_credentials {
    my $an6 = shift;
    #me
    my $an10 = $an6->get_p();
    my ($an7, $an8);
    my $an20 = $an10->opts->authfile;
    if ( defined $an10->opts->user ) {
        if ( $an10->opts->user =~ m{
                                    ([a-z0-9\-_]+)    #me
                                    %                 #me
                                    (.*)        #me
                                }xms 
            ) {
            $an7 = $1;
            $an8 = $2;
        }
        else {
            $an10->nagios_die(
                'Wrong credentials-format! (Must be -u username%an1)');
            croak 'FATAL ERROR';
        }
    }
    elsif ( defined $an20 ) {
        open my $an21, '<', $an20 #me
            or $an10->nagios_die('Unable to open auth file '
                                . $D_QUOT . $an20 . $D_QUOT );  
        while (<$an21>) {
            if (s/^[ \t]*username[ \t]*=//ms) { #me
                s/^\s+//ms;                        #me
                s/\s+$//ms;                        #me
                $an7 = $_;
            }
            if (s/^[ \t]*password[ \t]*=//ms) { #me
                s/^\s+//ms;                        #me
                s/\s+$//ms;                        #me
                $an8 = $_;
            }
        }
        close $an21 or die "ERROR closing $an20: $OS_ERROR\n";
        if ( not(defined $an7 && defined $an8) ) {
            $an10->nagios_die('Auth file must contain both username and password');
        }
    } else {
        $an10->nagios_die('Provide either username/password (--user) or auth file (--authfile)');
    }
    if ($main::DEBUG > 0) {
        print {*STDERR} "username: >>$an7<< (without the >>  <<)\n";
        if ($an10->opts->show_password) {
            print {*STDERR} "password: >>$an8<< (without the >>  <<)\n";
        } else {
            my $an22 = 
                'Hint: To see the password in clear-text, use --show_password together with -v.';
            print {*STDERR} 'password: >>' . q{*} x length($an8) . 
                '<< (without the >>  <<)' . "\n" . 
                $an22 . "\n";
        }
    }
    if ( length($an7) > $an6->{'_credentials_max_length'}
            or length($an8) > $an6->{'_credentials_max_length'} ) {
        $an10->nagios_die('Username and password must not have more than' 
                        . $BLANK . $an6->{'_credentials_max_length'}
                        . $BLANK . 'characters.'
        );
        croak 'FATAL ERROR - this line should never get executed';
    } elsif (not $an7 =~ /[a-zA-Z0-9\-_]/ms ){
        $an10->nagios_die('Invalid characters in username');
    } else { return ( $an7, $an8 ) }
    croak 'FATAL ERROR - this line should never get executed';
}

sub get_timeout {
    my $an6 = shift;
    my $an10 = $an6->get_p();
    return $an10->opts->timeout;
}

#me
#me
#me

sub _print_wrapped_list {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $an23 = shift;
    my $an24 = shift;
    my $an25 = shift;
    my $an26 = shift;
    chomp $an23;
    chomp $an24;
    
    #me
    if (not $an25 =~ /^\d+$/) {
        croak "Argument indent ($an25) is not numeric. Can not continue"
    }
    if (not $an26 =~ /^\d+$/) {
        croak "Argument width ($an26) is not numeric. Can not continue"
    }
    
    #me
    #me
    #me
    #me
    #me
    #me
    #me
    #me
    print $an23;
    $columns = $an26;
    my $an27 = wrap (q{ } x ($an25 ), q{ } x $an25, $an24);
    #me
    $an27 =~ s/^\s*//;                   #me
    print q{ } x ($an25 - length($an23));    #me
    print $an27;
    print "\n";
    return;
}

#me
#me
#me
#me
#me
#me
#me
#me
#me

sub set_supported_counters {
#me
#me
#me
#me
#me
#me
#me
#me
#me
    my $an6 = shift;
    my $an28 = shift || croak 'missing ref to COUNTERS_SUPPORTED';
    my $an29 = shift || croak 'mssing string naming the perf-object';
    my $an30 = shift; 
    
    $an6->{'_counters_supported'} = $an28;
    $an6->{'_perf_object'} = $an29;
    $an6->{'_perf_array'} =  $an30;

    return $an6;
}

sub print_available_counters {

#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me
#me

    my $an6 = shift;
    my $an31 = shift;
    my $an29 = shift;          #me
    my ($an32, @an3, $an28);
    
    #me
    #me
    #me
    #me
    if (not defined $an31) {
        $an28 = $an6->{'_counters_supported'};
        $an31 = \{keys %$an28}; #me
        $an29 = $an6->{'_perf_object'};
        
        if (defined $an6->{'_perf_array'}) {
            $an32 =  $an6->{'_perf_array'}; # f.e. 'cp_count'; this is the counter-name, if the counter is an array
            my @an4;
            foreach (values %{$an28}) {
                push @an4, $_->{'label'};
            }
            @an3 = @an4;
        }
    } 
    
    my $an9 = $an6->{'_session'}; 
    #me
    Readonly my $SCREEN_WIDTH => $an6->{'_screen_w'};
    $columns = $SCREEN_WIDTH; #me
    my $an15 = q{=} x $SCREEN_WIDTH;
    my $an16 = q{-} x $SCREEN_WIDTH;
    Readonly my $INDENT => 28; #me
    if ($columns <= $INDENT) {
        croak('Screen-width is smaller than or equal to the the indent '
        . ($INDENT) . ' - choose a width larger than the indent.')
    }
    print wrap($EMPTY, $EMPTY,
        'Performance counters available on this filer:');
    print "\n";
    print $an15;
    print "\n";
    printf "%-$INDENT" . "s%s%s", 
            'Counter-Name', 'Description (Unit, Privilege)', "\n";
    print $an16 . "\n";

    if ($an32) {
        my $an4 = Pc->list_perf_counter_labels($an9, "$an29", "$an32"); #me
            
        foreach my $an33 (keys %$an4) {
            if ( any {$_ eq $an33} @an3 ) {
                my $an24 =  "$an33" . q{ (} 
                    . $an4->{$an33}{'unit'} . q{, } 
                    . $an4->{$an33}{'priv'} . q{)};
                my $an34;
                foreach my $an14 (keys %{$an28}) {
                    if ($an28->{$an14}{'label'} eq $an33 ) {
                        $an34 = $an14;
                        last;
                    }
                }
                _print_wrapped_list ("$an34", "$an24", $INDENT, $columns );
                print  "\n";
            }
        }
    } else {
        my $an35 = Pc->list_perf_counters($an9, "$an29"); #me
        foreach my $an36 (keys %{$an35}) {
            if ( any {$_ eq $an36} @{$an31} ) {
                my $an24 = $an35->{$an36}{'desc'} . q{ (} 
                    . $an35->{$an36}{'unit'} . q{, } 
                    . $an35->{$an36}{'priv'} . q{)};
                _print_wrapped_list ("$an36", "$an24", $INDENT, $columns );
                print  "\n";
            }
        }
    }
    
    return;
}

#me
#me
#me

sub require_dox {
    
    #me
    #me
    
    my $an37 = shift;       #me
    my $an38 = shift;
    my $an39 = "$an38/$an37.pm";
    eval {
        require "$an39"; #me
    } or croak "ERROR: Could not require $an39 ($EVAL_ERROR)";
    return;
}

sub blurb {
    my $an37 = shift;       #me
    return $an37->Dox::blurb(); #me
}

sub extra {
    my $an37 = shift;       #me
    return $an37->Dox::extra(); #me
}

sub simple_examples {
    my $an37 = shift;       #me
    my $an40 = shift;     #me
    my $an41 = shift;
    my $an42 = shift;
    my $an43 = Examples->new();
    foreach my $an44 (@{$an37->Dox::simple_examples()}) {
        $an43->add( $an44->{'cmd'}, $an44->{'txt'}, $an44->{'out'} );
    }
    return $an43->get($an40, $an41, $an42);
}

sub advanced_examples {
    my $an37 = shift;       #me
    my $an40 = shift;     #me
    my $an41 = shift;
    my $an42 = shift;
    my $an43 = Examples->new();
    foreach my $an44 (@{$an37->Dox::advanced_examples()}) {
        $an43->add( $an44->{'cmd'}, $an44->{'txt'} );
    }
    return $an43->get($an40, $an41, $an42);
}


#me
#me
#me
sub check_out {
    my $an11 = shift;
    my $an10 = shift;
    if ( ref($an11) eq 'NaElement' ) {
        if ( $an11->results_errno != 0 ) {
            my $an45 = $an11->results_reason();
            $an10->nagios_die('ERROR: ' . $an45);
        } else {
            return 'OK';    #me
        }
    } 
    return 'OK: No error reported from filer'; #me
}


1;
