#!/usr/bin/perl
use strict;
use DBI;
use DBD::mysql;
use Getopt::Std;

my %opts;
getopts ":-h:-p:-u:",\%opts;

if (!defined $opts{'h'}) {
	print &usage;
	exit 3;
} elsif (!defined $opts{'u'}) {
	print &usage;
	exit 3;
}

sub usage () {
	print "USAGE:\t$0 -h hostname -u username -p password\n";
}

my $driver = "mysql";
my $dsn = "DBI:$driver:database=pop;hostname=$opts{'h'}";
my $dbh = DBI->connect($dsn, $opts{'u'}, "$opts{'p'}");

unless (defined $dbh) {
	print "Can't connect to mysql Server: $@\n";
	exit 2;
}

my $sth = $dbh->prepare("select id from nextid where name='lastupdate'");
$sth->execute();

my $now = time;
my $last = 0;

while (my @arg = $sth->fetchrow_array()) {
	$last = $arg[0];
}

$sth->finish();

my $timeshift = $now - $last;

if ($last == 0) {
	print "Der Zeitstempel konnte nicht abgefragt werden\n";
	exit 1;
} elsif ($timeshift < 10) {
	print "Alles OK\n";
	exit 0;
} elsif ($timeshift > 10 and $timeshift < 500) {
	print "Die Datenreplikation scheint Verzoegert zu sein: $timeshift Sekunden\n";
	exit 1;
} elsif ($timeshift > 500) {
	print "Die Replikation ist stark verzoegert: $timeshift Sekunden\n";
	exit 2;
}

exit 0;
