#!/usr/local/bin/perl -w

package noris::NetSaint::Status;

=cut


=head1 NAME

noris::NetSaint::Status

=head1 BESCHREIBUNG

Library fuer NetSaint-Plugins,
um diesen ganzen Status-Krempel einheitlich zu erledigen.
Wird intern von noris::NetSaint verwendet.

=head1 AUTOR

Martin H. Sluka E<lt>sluka@noris.netE<gt>
fr die noris network AG

=head1 TICKET

RT#38488

=cut

use lib '/usr/lib/nagios/plugins';
use utils qw(%ERRORS);
use strict;

use Carp;

our $VERSION = 20070718.0;

use constant D2W => { reverse %ERRORS };

use overload
  '""'  => sub { D2W->{ ${ +shift } } },
  '0+'  => sub { ${ +shift } },
  '<=>' => sub {
    my ( $self, $other ) = @_;
    $other = ref($self)->new($other) unless ref $other;
    abs $$self <=> abs $$other || $$self <=> $$other;
  },
  cmp => sub {
    my ( $self, $other ) = @_;
    $other = ref($self)->new($other) unless ref $other;
    abs $$self <=> abs $$other || $$self <=> $$other;
  };

sub new {
    my $package = shift;
    if ( ref( my $status = @_ ? shift : $ERRORS{UNKNOWN} ) ) {
        $status;
    }
    else {
        unless ( $status =~ /^-?\d+\z/ ) {
            croak "Unknown status '$status'" unless exists $ERRORS{ uc $status };
            $status = $ERRORS{ uc $status };
        }
        bless \$status, $package;
    }
}

1
