<?php

header("Content-Type: text/html; charset=UTF-8");

set_time_limit(300);
if(file_exists("/etc/noris-mailgrep-web/mailgrep-config.php")) {
    require("/etc/noris-mailgrep-web/mailgrep-config.php");
} else {
    die("Please configure /etc/noris-mailgrep-web/mailgrep-config.php with the example file there.");
}
require("include/variablen.php");
require("include/funktionen.php");

if (isset($_POST['mail']) && $_POST['mailtext'] != "") {
    mail($_POST['ticketnr'] . '@rt.noris.net', 'Webmailgrep Ergebnis', $_POST['mailtext'], 'From: mailgrep <mailgrep@noris.net>');
    $mailversandt = true;
}


if (isset($_POST['reset'])) {
    unset($_POST);
}
$search_string = (isset($_POST['search'])) ? addslashes($_POST['search']) : '';
$secondsearch_string = (isset($_POST['secondsearch'])) ? html_filter($_POST['secondsearch']) : '';

$error = false;
?>

<!doctype html>
<html>
<head>
    <title>Mailgrep – Webfrontend</title>
    <meta name="Content-Type" content="text/html; charset=UTF-8">
    <link rel="stylesheet" type="text/css" href="css/such.css">
    <script src="js/datetimepicker.js"></script>
    <script src="js/mailgrep.js"></script>
</head>
<body>
<div class="container">
    <div class="main">
        <h1>Mailgrep - Webfrontend</h1>

        <p>* Optionale Angaben</p>

        <form name="suchform" action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
            <fieldset>
                <legend class="nummer">Wo?</legend>
                <?php
                $server_checked = false;
                echo "<table class='tablespezial' border='0'>\n<tr>\n";
                foreach ($server as $key => $value) {
                    echo '                    <td><input class="eingabefeld" type="checkbox" id="' . $key . '"  name="' . $key . '" value="' . $key . '"';
                    if (isset($_POST[$key]) && $_POST[$key] == $key) {
                        echo 'checked';
                        $server_checked = true;
                    }
                    echo '>';
                    echo '<div class="eingabename"><label for="' . $key . '"><abbr title="-' . $key . '">' . $value . '</abbr></label></div></td>' . "\n";
                }
                echo "</tr></table>";
                if (!$server_checked && isset($_POST['submit']) && $_POST['submit'] == 'Suchen') {
                    echo '<div class="errorzeile">&nbsp;Wo willst du denn suchen ?</div>';
                    $error = true;
                }
                ?>
            </fieldset>
            <fieldset>
                <legend class="nummer">Wann?</legend>
                <table class='tablespezial'>
                    <tr>
                        <td>
                            <div class="eingabenamezeit"><abbr title="-from">von</abbr></div>
                        </td>
                        <td>
                            <input id="fr10_minutes" class="eingabefeld" type="radio" name="from"
                                   value="10 minutes" <?php if (isset($_POST['from']) && $_POST['from'] == "10 minutes") {
                                echo "checked";
                                $ischeckedfrom = true;
                            } ?>>

                            <div class="eingabenamezeit"><label for="fr10_minutes">vor 10
                                    min</label></div>
                        </td>
                        <td>
                            <input id="fr1_hour" class="eingabefeld" type="radio" name="from"
                                   value="1 hour" <?php if (isset($_POST['from']) && $_POST['from'] == "1 hour") {
                                echo "checked";
                                $ischeckedfrom = true;
                            } ?>>

                            <div class="eingabenamezeit"><label for="fr1_hour">vor 1 h</label></div>
                        </td>
                        <td>
                            <input id="fr6_hour" class="eingabefeld" type="radio" name="from"
                                   value="6 hour" <?php if (isset($_POST['from']) && $_POST['from'] == "6 hour") {
                                echo "checked";
                                $ischeckedfrom = true;
                            } ?>>

                            <div class="eingabenamezeit"><label for="fr6_hour">vor 6 h</label></div>
                        </td>
                        <td>
                            <input id="fr1_day" class="eingabefeld" type="radio" name="from"
                                   value="1 day" <?php if (isset($_POST['from']) && $_POST['from'] == "1 day") {
                                echo "checked";
                                $ischeckedfrom = true;
                            } ?>>

                            <div class="eingabenamezeit"><label for="fr1_day">vor 1 d</label></div>
                        </td>
                        <td>
                            <input id="custom" class="eingabefeld" type="radio" name="from"
                                   value="custom" <?php if (isset($_POST['from']) && $_POST['from'] == "custom") {
                                echo "checked";
                                $ischeckedfrom = true;
                            } ?>>

                            <div class="eingabenamezeit"><label for="custom">individuell</label>
                            </div>
                        </td>
                        <td>
                            <input onclick="setCheckedCustom('fromtext');" class="inputtext"
                                   type="text" name="fromtext" id="fromtext"
                                   value="<?php echo (isset($_POST['from']) && $_POST['from'] == "custom" && isset($_POST['fromtext'])) ? $_POST['fromtext'] : ''; ?>">
                            <a href="javascript:NewCal('fromtext','yyyyMMdd',true,24)"><img
                                    src="grepbilder/cal.gif" width="16" height="16"
                                    alt="Pick a date"></a>
                        </td>
                        <td>
                            <div class="eingabenamezeit">&nbsp;</div>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <div class="eingabenamezeit"><abbr title="-to">bis*</abbr></div>
                        </td>
                        <td>
                            <input id="to10_minutes" class="eingabefeld" type="radio" name="to"
                                   value="10 minutes" <?php if (isset($_POST['to']) && $_POST['to'] == "10 minutes") echo "checked"; ?>>

                            <div class="eingabenamezeit"><label for="to10_minutes">vor 10
                                    min</label></div>
                        </td>
                        <td>
                            <input id="to1_hour" class="eingabefeld" type="radio" name="to"
                                   value="1 hour" <?php if (isset($_POST['to']) && $_POST['to'] == "1 hour") echo "checked"; ?>>

                            <div class="eingabenamezeit"><label for="to1_hour">vor 1 h</label></div>
                        </td>
                        <td>
                            <input id="to6_hour" class="eingabefeld" type="radio" name="to"
                                   value="6 hour" <?php if (isset($_POST['to']) && $_POST['to'] == "6 hour") echo "checked"; ?>>

                            <div class="eingabenamezeit"><label for="to6_hour">vor 6 h</label></div>
                        </td>
                        <td>
                            <input id="to1_day" class="eingabefeld" type="radio" name="to"
                                   value="1 day" <?php if (isset($_POST['to']) && $_POST['to'] == "1 day") echo "checked"; ?>>

                            <div class="eingabenamezeit"><label for="to1_day">vor 1 d</label></div>
                        </td>
                        <td>
                            <input id="tocustom" class="eingabefeld" type="radio" name="to"
                                   value="custom" <?php if (isset($_POST['to']) && $_POST['to'] == "custom") echo "checked"; ?>>

                            <div class="eingabenamezeit"><label for="tocustom">individuell</label>
                            </div>
                        </td>
                        <td>
                            <input onclick="setCheckedCustom('totext');" class="inputtext"
                                   type="text" name="totext" id="totext"
                                   value="<?php echo (isset($_POST['to']) && $_POST['to'] == "custom" && isset($_POST['totext'])) ? $_POST['totext'] : ''; ?>">
                            <a href="javascript:NewCal('totext','yyyyMMdd',true,24)"><img
                                    src="grepbilder/cal.gif" width="16" height="16"
                                    alt="Pick a date"></a>
                        </td>
                        <td>
                            <input id="tonone" class="eingabefeld" type="radio" name="to"
                                   value="none" <?php if (!isset($_POST['to']) || $_POST['to'] == "none") echo "checked"; ?>>

                            <div class="eingabenamezeit"><label for="tonone">none</label></div>
                        </td>
                    </tr>
                </table>
                <?php

                if (isset($_POST['submit'])) {
                    $jetzt = time();
                    if (isset($_POST['from'])) {
                        if ($_POST['from'] == 'custom') {
                            $fromtimestamp = strtotime(html_filter($_POST['fromtext']));
                        } else {
                            $fromtimestamp = datumcheck($jetzt, $_POST['from']);
                        }
                    }
                    if (isset($_POST['to'])) {
                        if ($_POST['to'] == 'custom') {
                            $totimestamp = strtotime(html_filter($_POST['totext']));
                        } else {
                            $totimestamp = datumcheck($jetzt, $_POST['to']);
                        }
                    }
                    # echo $fromtimestamp." ".strftime('%Y-%m-%d  %H:%M:%S',$fromtimestamp)."<br>";
                    # echo $totimestamp." ".strftime('%Y-%m-%d  %H:%M:%S',$totimestamp);

                    if (isset($_POST['to']) && $_POST['to'] != "none" && $fromtimestamp >= $totimestamp) {
                        if ($_POST['totext'] != "" || $_POST['to'] != "custom") {
                            echo "<div class=\"errorzeile\">&nbsp;Ungültige Eingabe: Startzeit (" . strftime('%Y-%m-%d  %H:%M:%S', $fromtimestamp) . ") ist größer oder gleich wie die Endzeit (" . strftime('%Y-%m-%d  %H:%M:%S', $totimestamp) . ")</div>";
                        } else {
                            echo "<div class=\"errorzeile\">&nbsp;Wann willst du denn suchen ?</div>";
                        }
                        $error = true;
                    } else {
                        if (!$ischeckedfrom
                            || (isset($_POST['from']) && $_POST['from'] == 'custom' && html_filter($_POST['fromtext']) == "")
                            || (isset($_POST['to']) && $_POST['to'] == 'custom' && html_filter($_POST['totext']) == "")
                        ) {
                            echo "<div class=\"errorzeile\">&nbsp;Wann willst du denn suchen ?</div>";
                            $error = true;
                        }
                    }
                }
                ?>
            </fieldset>
            <fieldset>
                <legend class="nummer">Was?</legend>
                <table border="0">
                    <tr>
                        <td>
                            <div class="eingabename"><abbr title="-string">Suchbegriff</abbr>
                            </div>
                        </td>
                        <td><input class="inputtext" type="text" name="search"
                                   value="<?php echo htmlspecialchars($_POST['search']) ?>" size="80"></td>
                    </tr>
                    <tr>
                        <td>
                            <div class="eingabename">
                                <select name="orand" size="1">
                                    <option
                                        class="eingabename" <?php if (isset($_POST['orand']) && $_POST['orand'] == "Oder*") {
                                        echo "selected";
                                    } ?>>Oder*
                                    </option>
                                    <option
                                        class="eingabename" <?php if (isset($_POST['orand']) && $_POST['orand'] == "Und*") {
                                        echo "selected";
                                    } ?>>Und*
                                    </option>
                                </select>

                            </div>
                        </td>
                        <td><input class="inputtext" type="text" name="secondsearch"
                                   value="<?php echo htmlspecialchars($_POST['secondsearch']) ?>"
                                   size="80"></td>
                    </tr>
                </table>
                <?php
                if (html_filter($_POST['search']) == "" && isset($_POST['submit'])) {
                    echo "<div class=\"errorzeile\">&nbsp;Wonach willst du denn suchen ?</div>";
                    $error = true;
                }
                ?>
            </fieldset>
            <fieldset>
                <legend class="nummer">Wie?*</legend>
                <table class='tablespezial' border="0">
                    <?php
                    foreach ($what_options as $key => $options) {
                        echo '<tr>' . "\n";
                        foreach ($options as $optvalue => $opttext) {
                            $optchecked = false;
                            if (isset($_POST[$key]) && $_POST[$key] == $optvalue) {
                                $optchecked = true;
                            } else {
                                if (!isset($_POST[$key]) && $opttext == 'none') {
                                    $optchecked = true;
                                }
                            }
                            echo '<td>';
                            echo draw_radio_field($key, $optvalue, $opttext, $optchecked, 'none');
                            echo '</td>' . "\n";
                        }
                        echo '</tr>' . "\n";
                    }
                    $optchecked = '';
                    if (isset($_POST['display-servername']) && $_POST['display-servername'] == 'display-servername') {
                        $optchecked = ' checked';
                    }
                    ?>
                    <tr>
                        <td>
                            <input class="eingabefeld" type="checkbox" id="display-servername"
                                   name="display-servername"
                                   value="display-servername"<?php echo $optchecked ?>>

                            <div class="eingabename"><label for="display-servername"><abbr
                                        title="-display-servername">Server mit
                                        anzeigen</abbr></label></div>
                        </td>
                        <?php
                        $optchecked = '';
                        if (isset($_POST['nomerge-bounces']) && $_POST['nomerge-bounces'] == 'nomerge-bounces') {
                            $optchecked = ' checked';
                        }
                        ?>
                        <td>
                            <input class="eingabefeld" type="checkbox" id="nomerge-bounces"
                                   name="nomerge-bounces" value="nomerge-bounces"<?php echo $optchecked ?>>

                            <div class="eingabename"><label for="nomerge-bounces"><abbr
                                        title="-nomerge-bounces">Bounces nicht mit
                                        anzeigen</abbr></label></div>
                        </td>

                    </tr>
                </table>
            </fieldset>
            <fieldset>
                <legend class="nummer">Suchen!</legend>
                <table border="0">
                    <tr>
                        <td>
                            <input class="inputtext" type="submit" name="submit" value="Suchen">
                        </td>
                        <td><input class="inputtext" type="submit" name="reset" value="Löschen">
                        </td>
                    </tr>
                </table>
                <?php
                if ($mailversandt) {
                    echo "<div class='erfolgszeile'>Maillogs wurde an das Ticket #" . $_POST['ticketnr'] . " verschickt</div>";
                }
                if (isset($_POST['submit']) && !$error) {
                    echo "<hr class='looksfielset' width='95%'\>";
                    echo '<table border="0">';
                    echo '<tr><td><div class="eingabename">Ticketnummer </div></td><td><input class="inputtext" type="text" id="ticketnr" name="ticketnr" maxlength="' . $ticketlength . '" size="' . $ticketlength . '"></td></tr>';
                    echo '<tr><td colspan="2"><input class="inputtext" type="submit" name="mail" value="E-Mail versenden" onclick="return copytext();"></td>';
                    echo '</table>';
                    echo '<textarea class="verstecken"  cols=100 rows=30 name="mailtext" id="mailtext"></textarea>';
                }
                ?>
            </fieldset>
        </form>
        <?php
        if (isset($_POST['submit']) && !$error) {
            $mailgrep_search_string = '';
            foreach ($server as $key => $value) {
                if (isset($_POST[$key])) {
                    $mailgrep_search_string .= " -" . $_POST[$key];
                }
            }
            foreach ($what_options as $key => $value) {
                if (isset($_POST[$key]) && $_POST[$key] != "none") {
                    $mailgrep_search_string .= " -" . $_POST[$key];
                }
            }

            if (isset($_POST['display-servername'])) {
                $mailgrep_search_string .= " -" . $_POST['display-servername'];
            }
            if (isset($_POST['nomerge-bounces'])) {
                $mailgrep_search_string .= " -" . $_POST['nomerge-bounces'];
            }
            if (isset($_POST['to']) && $_POST['to'] != "none") {
                if (($_POST['to'] == 'custom')) {
                    $to_time = html_filter($_POST['totext']);
                } else {
                    $to_time = html_filter($_POST['to']) . ' ago';
                }
                $mailgrep_search_string .= ' -to ' . escapeshellarg($to_time);
            }
            if (isset($_POST['from'])) {
                if (($_POST['from'] == 'custom')) {
                    $from_time = html_filter($_POST['fromtext']);
                } else {
                    $from_time = html_filter($_POST['from']) . ' ago';
                }
                $mailgrep_search_string .= ' -from ' . escapeshellarg($from_time);
            }
            if (isset($_POST['search']) && $_POST['search'] != "") {
                $mailgrep_search_string .= ' -string ' . escapeshellarg($search_string);
            }
            if (isset($_POST['secondsearch']) && $_POST['secondsearch'] != "") {
                if (isset($_POST['orand']) && $_POST['orand'] == "Oder*") {
                    $mailgrep_search_string .= ' -or-string ' . escapeshellarg($secondsearch_string);
                } else {
                    if (isset($_POST['orand']) && $_POST['orand'] == "Und*") {
                        $mailgrep_search_string .= ' -string ' . escapeshellarg($secondsearch_string);
                    }
                }
            }

            $mailgrep_command = mailgrep_make_command($mailgrep, $mailgrep_search_string, $mailgrep_args);
            echo '<fieldset>' . "\n";
            echo '<legend class="nummer">Ergebnis!</legend>';
            echo '<p class="code">' . $mailgrep_command . '</p>' . "\n";
            ob_flush(); flush();

            list($mailgrep_exitcode, $mailgrep_stdout, $mailgrep_stderr) = mailgrep($mailgrep_command);

            if (!(strlen($mailgrep_stderr) === 0)) {
                echo '<pre id="stderr">' . $mailgrep_stderr . "</pre>";
                echo '<p>Mailgrep hatte da ein paar Schwierigkeiten (Fehlercode ' . $mailgrep_exitcode . ').';
            }

            echo '<pre id="output" class="ausgabe">';
            // Output the search result
            echo $mailgrep_stdout;

            echo '</pre>';
            echo '</fieldset>';
        }
        ?>

        <script>
            // Ticket: 11554383
            // Whenever we check multiple "Wo?" checkboxes, the "Server mit anzeigen" checkbox should be checked too.
            (function () {
                // See: http://stackoverflow.com/a/14408904
                function getElementsById(ids) {
                    var idList = ids.split(" ");
                    var results = [], item;
                    for (var i = 0; i < idList.length; i++) {
                        item = document.getElementById(idList[i]);
                        if (item) {
                            results.push(item);
                        }
                    }
                    return (results);
                }


                var wo_checkboxes = getElementsById("in out imap intern intra krempel vhost www");
                var show_servernames_checkbox = document.getElementById("display-servername");

                for (var i = 0; i < wo_checkboxes.length; i++) {
                    wo_checkboxes[i].onchange = function () {

                        // Go through all checkboxes enough are clicked, show the prefix
                        var num_checkboxes_clicked = 0;
                        for (var i = 0; i < wo_checkboxes.length; i++) {
                            if (wo_checkboxes[i].checked == true) {
                                num_checkboxes_clicked++;

                                if (num_checkboxes_clicked >= 2) {
                                    show_servernames_checkbox.checked = true;
                                    break;
                                }
                            }
                        }
                    };
                }
            })();
        </script>
</body>
</html>
