<?php
function datumcheck($jetzt, $input)
{
    switch ($input) {
        case "10 minutes":
            return ($jetzt - 600);
        case "1 hour":
            return ($jetzt - 3600);
        case "6 hour":
            return ($jetzt - 21600);
        case "1 day":
            return ($jetzt - 86400);
    }
}

function html_filter($value)
{
    $value = strip_tags(trim($value));
    return ($value);
}

function draw_radio_field($name, $value, $text = '', $checked = false, $noabbr = '')
{
    $field = '<input class="eingabefeld" type="radio" id="' . $name . $value . '" name="' . $name . '" value="' . $value . '"';
    if ($checked) {
        $field .= ' checked';
    }
    $field .= '>' . "\n";

    if ($text != '' && $text != $noabbr) {
        $field .= '<div class="eingabename">' . "\n";
        $field .= '  <label for="' . $name . $value . '"><abbr title="-' . $value . '">' . $text . '</abbr></label>';
        $field .= '</div>';
    } else {
        if ($text == $noabbr) {
            $field .= '<div class="eingabename">' . "\n";
            $field .= '  <label for="' . $name . $value . '">' . $text . '</label>';
            $field .= '</div>';
        }
    }

    return $field;
}

function mailgrep($mailgrep_command)
{
    $stdout_file = tempnam(sys_get_temp_dir(), 'noris-mailgrep-web_stdout_');
    $stderr_file = tempnam(sys_get_temp_dir(), 'noris-mailgrep-web_stderr_');
    $full_command = $mailgrep_command . ' 1>' . $stdout_file . ' 2>' . $stderr_file;

    system($full_command, $exitcode);

    $stdout_str = file_get_contents($stdout_file);
    unlink($stdout_file);

    $stderr_str = file_get_contents($stderr_file);
    unlink($stderr_file);

    return [$exitcode, $stdout_str, $stderr_str];
}

function mailgrep_make_command($mailgrep, $search_string, $mailgrep_args)
{
    return "$mailgrep $search_string $mailgrep_args";
}
