use strict;
use warnings;
use utf8;
use 5.014;
use Test::More tests => 1;

use NNIS::MessageBus::Util qw(deserialize_nmf);

my %input = (
    '_resultset' => [
        {
            id => 1,
            _target => 'application',
        },
    ],
    '_objectset' => {
        'application' => [
            {
                id          => 1,
                name        => 'Some App',
                software    => {
                    id      => 2,
                    _target => 'software',
                    _title  => 'A Software, really!',
                },
                host        => {
                    id      => 55,
                    _target => 'host',
                },
                'infotext'  => 'Blubb',
            },
        ],
        'software' => [
            {
                id          => 2,
                name        => 'My Software',
                infotext    => 'Bla',
            }
        ],
    },
);

my @expected = (
    {
    'id' => 1,
    'host' => {
                'id' => 55,
                '_target' => 'host'
                },
    'infotext' => 'Blubb',
    'name' => 'Some App',
    'software' => {
                    'id' => 2,
                    'infotext' => 'Bla',
                    'name' => 'My Software',
                    '_title' => 'A Software, really!'
                    }
    }
);

is_deeply([deserialize_nmf(\%input)], \@expected, 'deserialize_nmf');
