use 5.014;
use strict;
use warnings;
use utf8;
use Test::More tests => 2;

use NNIS::MessageBus::MultiCondVar qw(multi_cv);

{
    my $cv = multi_cv();
    my $res = '';
    $cv->add_cb(sub { $res .= 'a' });
    $cv->add_cb(sub { $res .= 'b' });
    $cv->send;
    $cv->recv;

    is $res, 'ab', 'called both callbacks';
}

{
    my $cv = multi_cv();
    my $res = '';
    $cv->add_cb(sub { $res .= 'a' });
    $cv->send;
    $cv->add_cb(sub { $res .= 'b' });
    $cv->recv;

    is $res, 'ab', 'add_cb after send also works';
}



1;
