use 5.014;
use strict;
use warnings;
use utf8;

use Test::More tests => 5;

use Test::MockObject;
use JSON::XS qw(decode_json);

use NNIS::MessageBus::Connector;
use NNIS::MessageBus::Connection;

sub setup_mock {
    my $mock = shift;
    $mock->mock(delete_queue => sub {
        my ($self, %param) = @_; $param{on_sucess}->send
    });
}

my $mock_chan = Test::MockObject->new();
my %publish_args;
$mock_chan->mock(publish => \&mock_publish);
setup_mock($mock_chan);

my $response_address = 'amqp-gen123';
my $connector = NNIS::MessageBus::Connector->new(
    source_service   => 'test_s',
    response_address => $response_address,
    timeout          => 0,
);
$connector->{_producer_connections}[0] = NNIS::MessageBus::Connection->new(
    source_service   => 'test_s',
    response_address => $response_address,
    timeout          => 0,
    channel          => $mock_chan,
    connector        => $connector,
);

ok $connector, 'Can create connector object';

sub mock_publish {
    my $self = shift;
    %publish_args = @_;
    my $nmf = decode_json $publish_args{body};
    $publish_args{nmf} = $nmf;

    my $message_id = $nmf->{'nmf-header'}{'message-id'};
    $connector->connection->{_pending_responses}->{ $message_id }->send( 42 )
};

SKIP: {
    skip 'tests out of date', 4;
    my $result = $connector->ask(
        routing_key => 'a.b.c',
        type        => 'ListStuff',
        payload     => {},
    );

    is $publish_args{routing_key}, 'a.b.c', 'Routing key';
    is $publish_args{exchange},    'a.b',   'Exchange';
    is $result, 42, 'Correct result';

# timeouts
    $mock_chan = Test::MockObject->new();
    $mock_chan->set_true('publish');
    setup_mock($mock_chan);
    $connector = NNIS::MessageBus::Connector->new(
        source_service   => 'test_s',
        response_address => $response_address,
        timeout          => 0.1,
    );
    $connector->{_connections}[0] = NNIS::MessageBus::Connection->new(
        source_service   => 'test_s',
        response_address => $response_address,
        timeout          => 0.1,
        channel          => $mock_chan,
    );

    my $res = eval {
        $connector->ask(
            routing_key => 'a.b.c',
            type        => 'ListStuff',
            payload     => {},
        );
        1;
    };

    is $res, undef, 'Timeout works';
}
