#===============================================================#
#                                                               #
# ID                                                            #
#                                                               #
# perf_vol_latency.py                                           #
#                                                               #
# Copyright (c) 2011 NetApp, Inc. All rights reserved.          #
# Specifications subject to change without notice.              #
#                                                               #
# This Sample code is supported from DataFabric Manager 3.7.1   #
# onwards.                                                      #
# However few of the functionalities of the sample code may     #
# work on older versions of DataFabric Manager.                 #
#===============================================================#

import sys
import time
sys.path.append("../../../../../../../lib/python/NetApp")
from NaServer import *

def main() :
    perf_out = invoke_perf_zapi()
    extract_perf_counter_data(perf_out)
    print_output()
    sys.exit (1)

    
def invoke_perf_zapi() :
    # Initialize server context
    server_ctx = NaServer (dfm, 1, 0)
    server_ctx.set_transport_type("HTTP")
    server_ctx.set_style("LOGIN")
    server_ctx.set_admin_user(user, pw)
    server_ctx.set_server_type("DFM")
    server_ctx.set_port(8088)

    # Create API request
    perf_in = NaElement("perf-get-counter-data")
    perf_in.child_add_string("duration", 6000)
    perf_in.child_add_string("number-samples", 50)
    perf_in.child_add_string("time-consolidation-method", "average")

    instance_info = NaElement("instance-counter-info")
    instance_info.child_add_string("object-name-or-id", aggr_name)

    counter_info = NaElement("counter-info")
    perf_obj_ctr = NaElement("perf-object-counter")
    perf_obj_ctr.child_add_string("object-type", "volume")
    perf_obj_ctr.child_add_string("counter-name", "avg_latency")

    counter_info.child_add(perf_obj_ctr)
    instance_info.child_add(counter_info)
    perf_in.child_add(instance_info)

    # Invoke API
    perf_out = server_ctx.invoke_elem(perf_in)
    
    if(perf_out.results_status() == "failed") :
        print(perf_out.results_reason() + "\n")
        sys.exit(2)
    
    return perf_out


def extract_perf_counter_data(perf_out):
    gen_time_arr = 1
    instance = perf_out.child_get("perf-instances")
    instances = instance.children_get()

    if(instances != None):    
        for rec in instances :
            vol_name = rec.child_get_string("instance-name")
        
            if (vol_name) :
                vol_arr.append(vol_name)
        
            counters = rec.child_get("counters")
            perf_cnt_data = counters.children_get()
        
            for rec1 in perf_cnt_data :
                counter_str = rec1.child_get_string("counter-data")
                # counter-data is in time1:val1,time2:val2,..,timen:valn format.
                # Extract data from this format.
                counter_arr = counter_str.split (',')
            
                for time_val in counter_arr :
                    time_val_arr = [float(s) for s in time_val.split(':')]
                
                    if(gen_time_arr) :
                        time_arr.append(time.localtime(time_val_arr[0]))
                
                    data_arr.append(time_val_arr[1])
            
                gen_time_arr = 0


def print_output() :
    j = 0
    k = 0
    iter = 0
    nsamples = len(time_arr)
    data_arr_len = len(data_arr)
    sys.stdout.write("Time\t\t\t\t")
    for vol_name in vol_arr :
        sys.stdout.write(vol_name)
        sys.stdout.write("\t")
    
    print ("\n")

    for iter in range(nsamples):
        sys.stdout.write(time.asctime(time_arr[iter]))
        sys.stdout.write("\t")
        
        k = iter
        while(k < data_arr_len):
            sys.stdout.write(str(data_arr[k]))
            sys.stdout.write("\t\t")
            k = k + nsamples
        
        print("\n")

        
def print_help() :
    print ("\nCommand:\n")
    print ("perf_vol_latency.py <dfm> <user> <password> <aggr-name>\n")
    print ("<dfm>       -- DFM Server name\n")
    print ("<user>      -- User name\n")
    print ("<password>  -- Password\n")
    print ("<aggr-name> -- Name of the aggregate in format storage:aggrName\n")
    print ("-" * 80 + "\n")

    print ("This sample code prints average latency of all the volumes \n")
    print ("present in the given aggregate. This data can be used to \n")
    print ("generate distribution chart for volume average latency. \n")
    print ("To generate the graph, redirect output of this sample code to\n")
    print ("an Excel sheet.\n")
    sys.exit (1)

# Command line arguments
args = len(sys.argv) - 1

if(args < 4):
    print_help()

dfm = sys.argv[1]
user = sys.argv[2]
pw  = sys.argv[3]
aggr_name = sys.argv[4]
time_arr = []
data_arr = []
vol_arr = []

#Invoke routine
main()

'''#=========================== POD ============================#

=head1 NAME

  perf_vol_latency.py - Get average latency of all volumes present in an
  aggregate.


=head1 SYNOPSIS

  perf_vol_latency.py <dfm> <user> <password> <aggr-name>

=head1 ARGUMENTS

  <dfm>
  DFM Server name.

  <user>
  User name.

  <password>
  Password.

  <aggr-name>
  Name of the aggregate in format storage:aggrName.

=head1 SEE ALSO

  NaElement.py, NaServer.py

=head1 COPYRIGHT

 Copyright (c) 2009 NetApp, Inc. All rights reserved.
 Specifications subject to change without notice.

=cut'''

