##
# $Id$
# 
# Copyright (c) 2015 Network Appliance, Inc.
# All rights reserved.
# 
# This file was generated at Jul 15, 2015 9:17:37 PM
##

package OntapClusterAPI;

use strict;

use constant FIELD_SCALAR => 0x0;
use constant FIELD_TYPEDEF => 0x1;
use constant FIELD_ARRAY => 0x2;
use constant FIELD_OPTIONAL => 0x4;
use constant FIELD_ENCRYPTED => 0x8;

my $APIS = {
    'active-directory-account-create' => {
        'category' => 'active-directory',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'account-name' => {
                'type' => 'netbios-name',
                'flags' => 0,
                'scope' => [],
            },
            'admin-password' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'admin-username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force-account-overwrite' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'organizational-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'active-directory-account-delete' => {
        'category' => 'active-directory',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'admin-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'admin-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'active-directory-account-get-iter' => {
        'category' => 'active-directory',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'active-directory-account-config',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'active-directory-account-config',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'active-directory-account-config',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'active-directory-account-modify' => {
        'category' => 'active-directory',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'admin-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'admin-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force-account-overwrite' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'active-directory-account-password-change' => {
        'category' => 'active-directory',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'active-directory-account-password-reset' => {
        'category' => 'active-directory',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'admin-password' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'admin-username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-add' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'allocation-units' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'allow-mixed-rpm' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'allow-same-carrier' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'cache-raid-group-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cache-raid-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checksum-style' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size-with-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'force-cache-size' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
            },
            'force-spare-pool' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'group-selection-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-pool-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'pre-check' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'raid-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-pool' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'upgrade-64bit-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'bad-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'pre-check-results' => {
                'type' => 'warning-code',
                'flags' => 7,
                'scope' => [],
            },
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'upgrade-64bit-cookie' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'aggr-autobalance-aggregate-state-get-iter' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'aggr-autobalance-aggregate-state',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'aggr-autobalance-aggregate-state',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'aggr-autobalance-aggregate-state',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-autobalance-config-get' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'aggr-autobalance-config',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'aggr-autobalance-config',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'aggr-autobalance-config-modify' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'available-threshold-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hold-duration-after-move' => {
                'type' => 'time-interval',
                'flags' => 4,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'move-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'state-polling-interval' => {
                'type' => 'time-interval',
                'flags' => 4,
                'scope' => [],
            },
            'unbalanced-threshold-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-activity-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-inactive-delay-threshold' => {
                'type' => 'time-interval',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-autobalance-notification-get-iter' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'aggr-autobalance-notification',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'aggr-autobalance-notification',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'aggr-autobalance-notification',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-autobalance-volume-state-get-iter' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'aggr-autobalance-volume-state',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'aggr-autobalance-volume-state',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'aggr-autobalance-volume-state',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-check-spare-low' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'is-spare-low' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-create' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'allow-mixed-rpm' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'allow-same-carrier' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'autobalance-state' => {
                'type' => 'autobalance-aggregate-state',
                'flags' => 4,
                'scope' => [],
            },
            'block-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'checksum-style' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-size-with-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'encrypt' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'excluded-from-autobalance' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-small-aggregate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster', 'ontap-d'],
            },
            'force-spare-pool' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-pool-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-mirrored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'nodes' => {
                'type' => 'node-name',
                'flags' => 6,
                'scope' => ['ontap-cluster'],
            },
            'pre-check' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'raid-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'raid-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'rpm' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'spare-pool' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'striping' => {
                'type' => 'striping-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'bad-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'pre-check-results' => {
                'type' => 'warning-code',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'aggr-destroy' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'plex' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'aggr-get-filer-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'allowed-raidtypes' => {
                'type' => 'raidtype-info',
                'flags' => 3,
                'scope' => [],
            },
            'checksum-types' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'default-raidtype' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-types' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'max-named-disks-per-request' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'min-aggr-disk-count' => {
                'type' => 'min-aggr-disk-count-info',
                'flags' => 7,
                'scope' => [],
            },
            'raidgroup-size' => {
                'type' => 'raidgroup-size-info',
                'flags' => 3,
                'scope' => [],
            },
            'root-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshots-max' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-get-iter' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'aggr-attributes',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'aggr-attributes',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'aggr-attributes',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-mirror' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'allow-mixed-rpm' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'allow-same-carrier' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-pool-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'override-vfiler-ownership' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'pre-check' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'bad-disks' => {
                'type' => 'disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'pre-check-results' => {
                'type' => 'warning-code',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'aggr-modify-raid-type' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'raid-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-offline' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force-offline' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'plex' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'unmount-volumes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-online' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force-online' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'plex' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'aggr-options-list-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'options' => {
                'type' => 'aggr-option-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'aggr-relocation' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'aggregate-list' => {
                'type' => 'string',
                'flags' => 2,
                'scope' => [],
            },
            'destination-node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-ndo-controller-upgrade' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-override-destination-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-override-vetoes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-relocate-to-higher-version' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'source-node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-relocation-status' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'aggr-relocation-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'aggr-relocation-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'aggr-relocation-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-rename' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'new-aggregate-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-restrict' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unmount-volumes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-scrub-list-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'scrub-details' => {
                'type' => 'scrub-detail-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'aggr-scrub-resume' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'plex' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'raidgroup' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'aggr-scrub-start' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'plex' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'raidgroup' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'aggr-scrub-stop' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'plex' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'raidgroup' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'aggr-scrub-suspend' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'plex' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'raidgroup' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'aggr-set-option' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-space-get-iter' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'space-information',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'space-information',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'space-information',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-spare-get-iter' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'aggr-spare-disk-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'aggr-spare-disk-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'aggr-spare-disk-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-status-get-iter' => {
        'category' => 'aggr',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'aggr-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'aggr-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'aggr-status-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggr-verify-list-info' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'verify-details' => {
                'type' => 'verify-detail-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'aggr-verify-resume' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-verify-start' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fix-plex' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'log-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-verify-stop' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggr-verify-suspend' => {
        'category' => 'aggr',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'av-get-engine-info' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'current-activation-code' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-activation-code' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'license-expiry-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'license-key' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'license-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'prod-info' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'seats' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'update-url' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vendor' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'av-get-engine-options' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'av-engine-option',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'av-engine-option',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'av-get-log' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'datetime' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'av-event-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'av-event-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'av-get-remedy-info' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'action' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'directory' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'extension' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'repair' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'av-get-version-info' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'last-update-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'spyware-pattern-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'virus-pattern-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vsapi-32-bit-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vsapi-64-bit-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'av-log-iter' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'av-event-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'av-event-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'av-event-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'av-set-engine-info' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'current-activation-code' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'desired-activation-code' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'license-expiry-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'license-key' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'license-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'prod-info' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'seats' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'update-url' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vendor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'av-set-engine-options' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cache-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'decompressed-file-count-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'decompressed-file-size-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'decompression-layers-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'decompression-size-factor' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'group-archive-unpack' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'heuristic-analysis' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-spyware-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'macro-analysis' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-recursion-depth' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'mime-lines-to-scan' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'proxy-host' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'proxy-login' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'proxy-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'proxy-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'scan-mime' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'av-set-log' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'datetime' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'vendor-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'vendor-string' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'av-event-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'av-set-remedy-info' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'action' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'directory' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'extension' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'option' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'repair' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'av-set-version-info' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cluster-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'component-updated' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'spyware-pattern-version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'virus-pattern-version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vsapi-32-bit-version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vsapi-64-bit-version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'av-start-update' => {
        'category' => 'antivirus',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'sync' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'audit-get' => {
        'category' => 'audit',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'audit-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'audit-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'audit-modify' => {
        'category' => 'audit',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cli-get' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'cli-set' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'http-get' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'http-set' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ontapi-get' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ontapi-set' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-get' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-set' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-budget-get' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-budget-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'subsystem' => {
                'type' => 'asup-subsystems',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'autosupport-budget-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'autosupport-budget-get-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-budget-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-budget-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-budget-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-budget-get-total-records' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-budget-modify' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'subsystem' => {
                'type' => 'asup-subsystems',
                'flags' => 0,
                'scope' => [],
            },
            'time-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-check-connectivity' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'aod-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'post-url-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'put-url-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-check-connectivity-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-connectivity-check-info',
                'flags' => 5,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-connectivity-check-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-connectivity-check-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-check-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-check-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-check-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-check-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-compliant-get' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-compliant-info',
                'flags' => 5,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'plaintext' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'autosupport-compliant-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'autosupport-compliant-get-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-compliant-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-compliant-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-compliant-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-compliant-get-total-records' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-config-get' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'autosupport-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'autosupport-config-get-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-config-get-total-records' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-config-modify' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'from' => {
                'type' => 'mail-address',
                'flags' => 4,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-local-collection-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nht-data-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-node-in-subject' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-ondemand-download-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-ondemand-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-ondemand-remote-diag-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-perf-data-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-private-data-removed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-reminder-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-support-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-throttle-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mail-hosts' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'max-download-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-http-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-smtp-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-upload-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'minimum-private-data-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'noteto' => {
                'type' => 'mail-address',
                'flags' => 6,
                'scope' => [],
            },
            'ondemand-polling-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ondemand-server-url' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-address' => {
                'type' => 'mail-address',
                'flags' => 6,
                'scope' => [],
            },
            'payload-format' => {
                'type' => 'compression-format',
                'flags' => 4,
                'scope' => [],
            },
            'periodic-tx-window' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'post-url' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'proxy-url' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'put-url' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'retry-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'retry-interval' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'support-address' => {
                'type' => 'mail-address',
                'flags' => 6,
                'scope' => [],
            },
            'to' => {
                'type' => 'mail-address',
                'flags' => 6,
                'scope' => [],
            },
            'transport' => {
                'type' => 'asup-transport',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-destinations-get' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-destinations-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'autosupport-destinations-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'autosupport-destinations-get-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-destinations-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-destinations-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-destinations-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-destinations-get-total-records' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-download-get' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-download-info',
                'flags' => 5,
                'scope' => [],
            },
            'id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'autosupport-download-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'autosupport-download-get-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-download-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-download-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-download-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-history-cancel' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destination' => {
                'type' => 'asup-destination',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'seq-num' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-history-get' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'destination' => {
                'type' => 'asup-destination',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'seq-num' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'autosupport-history-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'autosupport-history-get-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-history-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-history-get-total-records' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-history-retransmit' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'seq-num' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'uri' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-invoke' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'asup-invoke-style',
                'flags' => 0,
                'scope' => [],
            },
            'uri' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-invoke-core-upload' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'case-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'core-filename' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'uri' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-invoke-diagnostic' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'message-subject' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'subsystems' => {
                'type' => 'asup-subsystems',
                'flags' => 2,
                'scope' => [],
            },
            'uri' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-invoke-performance-archive' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'case-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'duration' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'end-date' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'start-date' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'uri' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-invoke-splog' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'log-sequence' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'remote-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'uri' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'autosupport-manifest-get-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-manifest-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-manifest-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-manifest-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-manifest-get-total-records' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-trigger-get' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-trigger-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'trigger' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'autosupport-trigger-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'autosupport-trigger-get-iter' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'autosupport-trigger-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'autosupport-trigger-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'autosupport-trigger-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-trigger-get-total-records' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'autosupport-trigger-modify' => {
        'category' => 'autosupport',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'basic-additional' => {
                'type' => 'asup-subsystems',
                'flags' => 6,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'noteto-enabled' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'time-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'to-enabled' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'trigger' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'troubleshooting-additional' => {
                'type' => 'asup-subsystems',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cf-aggregate-giveback-status' => {
        'category' => 'cf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cf-aggregate-giveback-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cf-aggregate-giveback-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cf-aggregate-giveback-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cf-force-takeover' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'cf-get-iter' => {
        'category' => 'cf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'storage-failover-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'storage-failover-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'storage-failover-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cf-get-partner' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster', 'vfiler'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'partner' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cf-giveback' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'only-cfo-aggregates' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'override-vetoes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'require-partner-waiting' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'cf-hwassist-stats' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'hwassist-stats-abnormal-reboot' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-bad-nvram-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-keep-alive' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-loss-of-heartbeat' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-post-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-cycle-via-rlm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-cycle-via-sp' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-loss' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-off-via-rlm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-power-off-via-sp' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-reset-via-rlm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-reset-via-sp' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-ss-mismatch' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-test' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-times-throttled' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-unknown-alerts' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hwassist-stats-watchdog-reset' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'no-stats' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'cf-hwassist-stats-clear' => {
        'category' => 'cf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'cf-hwassist-status' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'keep-alive-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'local-hwassist-inactive-corrective-action' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'local-hwassist-inactive-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'local-hwassist-ipaddr' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'local-hwassist-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'local-hwassist-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'no-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-inactive-corrective-action' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-inactive-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-ipaddr' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'partner-hwassist-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'cf-hwassist-test' => {
        'category' => 'cf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'hwassist-test-result' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cf-mode-set' => {
        'category' => 'cf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'mode' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cf-modify-iter' => {
        'category' => 'cf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'options-related-info-modify',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'options-related-info-modify',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'cf-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'cf-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'cf-service-disable' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'cf-service-enable' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'cf-status' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster', 'vfiler'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'backup-io-times' => {
                'type' => 'mailbox-io-times-info',
                'flags' => 5,
                'scope' => ['ontap-cluster'],
            },
            'backup-mailbox-status' => {
                'type' => 'mailbox-status-info',
                'flags' => 7,
                'scope' => ['ontap-cluster'],
            },
            'booting-received' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'control-partner-aggregates' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'current-giveback-module' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'current-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'current-resource-table-entry' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'current-resource-table-entry-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'current-takeover-module' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'current-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'fanta-reloc-aggr-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'firmware-received' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'giveback-failure-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'giveback-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'interconnect-links' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'interconnect-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-interconnect-up' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'kill-packets' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'local-firmware-progress' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'local-firmware-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'local-in-headswap' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-cluster'],
            },
            'local-mailbox-disks' => {
                'type' => 'sf-disk-info',
                'flags' => 7,
                'scope' => ['ontap-cluster'],
            },
            'local-missing-disks' => {
                'type' => 'sf-disk-info',
                'flags' => 7,
                'scope' => ['ontap-cluster'],
            },
            'logs-unsynced-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'max-resource-table-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'new-partner-sysid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-cluster'],
            },
            'node-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nvram-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'partner' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'partner-firmware-progress' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'partner-firmware-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'partner-in-headswap' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-c', 'ontap-cluster'],
            },
            'partner-mailbox-disks' => {
                'type' => 'sf-disk-info',
                'flags' => 7,
                'scope' => ['ontap-cluster'],
            },
            'partner-missing-disks' => {
                'type' => 'sf-disk-info',
                'flags' => 7,
                'scope' => ['ontap-cluster'],
            },
            'partner-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'partner-nvram-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'primary-io-times' => {
                'type' => 'mailbox-io-times-info',
                'flags' => 5,
                'scope' => ['ontap-cluster'],
            },
            'primary-mailbox-status' => {
                'type' => 'mailbox-status-info',
                'flags' => 7,
                'scope' => ['ontap-cluster'],
            },
            'resource-table' => {
                'type' => 'resource-table-info',
                'flags' => 7,
                'scope' => ['ontap-cluster'],
            },
            'sf-options' => {
                'type' => 'sf-options-info',
                'flags' => 5,
                'scope' => ['ontap-cluster'],
            },
            'state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'takeover-by-partner-not-possible-reason' => {
                'type' => 'takeover-info',
                'flags' => 7,
                'scope' => ['ontap-cluster'],
            },
            'takeover-by-partner-possible' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'takeover-failure-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'takeover-of-partner-not-possible-reason' => {
                'type' => 'takeover-info',
                'flags' => 7,
                'scope' => ['ontap-cluster'],
            },
            'takeover-possible' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'takeover-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-c Possible values are: <ul> <li>none - Not in takeover </li> <li>takeover_normal - Operator initiated takeover <li>takeover_immediate - Operator initiated forced takeover</li> <li>takeover_ndu - Takeover initiated as part of NDU </li> <li>takeover_forced - Operator initiated forced takeover', 'ontap-cluster', 'possible data loss</li> <li>takeover_early - Takeover occuring during bootup of a filer </li> <li>takeover_operator_exp - Takeover occuring after operator timeout expired </li> <li>takeover_post_failed - Takeover occuring on POST failure </li> <li>takeover_panic - Takeover on panic </li> <li>takeover_shortuptime - Takeover after quick toggling between up & down states <li> <li>takeover_sparecore_exp - Takeover on panic timeout expiry </li> <li>takeover_reboot_exp - Takeover on reboot timer expiry </li> <li>takeover_booting_exp - Takeover on booting timer expiry </li> <li>takeover_nfo_shutdown - Takeover on negotiated failover shutdown </li> <li>takeover_nfo_timer - Takeover on negotiated failover timer expiry </li> <li>takeover_mdp - Takeover on multi-disk panic </li> <li>takeover_reboot - Takeover on reboot </li> <li>takeover_halt - Takeover on halt</li> <li>takeover_clam - CLAM triggered takeover </li> <li>takeover_hwassist - H/w assisted takeover </li> </ul>'],
            },
            'takeover-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'time-since-takeover' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'time-until-auto-giveback' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'time-until-takeover' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'timeouts' => {
                'type' => 'timeout-info',
                'flags' => 1,
                'scope' => ['ontap-cluster'],
            },
            'transit-event-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
    },
    'cf-takeover' => {
        'category' => 'cf',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'allow-disk-inventory-mismatch' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'bypass-optimization' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-quorum-warnings' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'immediate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'skip-lif-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'version-mismatch-ok' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'cf-takeover-status' => {
        'category' => 'cf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'takeover-status',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'takeover-status',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'takeover-status',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cg-commit' => {
        'category' => 'cg',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'cg-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cg-start' => {
        'category' => 'cg',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'snapmirror-label' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'snapshot' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-d', 'ontap-vserver'],
            },
            'volumes' => {
                'type' => 'volume-name',
                'flags' => 2,
                'scope' => ['ontap-c', 'ontap-vserver', 'vfiler'],
            },
        },
        'outputs' => {
            'cg-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-branchcache-create' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'hash-store-max-size' => {
                'type' => 'size',
                'flags' => 4,
                'scope' => [],
            },
            'hash-store-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'operating-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'server-key' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'versions' => {
                'type' => 'cifs-bc-version-control',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'cifs-branchcache',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'cifs-branchcache-flush' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cifs-branchcache-get' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-branchcache',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cifs-branchcache',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cifs-branchcache-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-branchcache',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-branchcache',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-branchcache',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-branchcache-hash' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'recurse' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-branchcache-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'flush-hashes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'hash-store-max-size' => {
                'type' => 'size',
                'flags' => 4,
                'scope' => [],
            },
            'hash-store-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'operating-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'server-key' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'versions' => {
                'type' => 'cifs-bc-version-control',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-branchcache-remove' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'flush-hashes' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-character-mapping-create' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'mapping' => {
                'type' => 'string',
                'flags' => 2,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'cifs-character-mapping',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'cifs-character-mapping-destroy' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-character-mapping-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-character-mapping',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-character-mapping',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-character-mapping',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-character-mapping-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'mapping' => {
                'type' => 'string',
                'flags' => 2,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-domain-discovered-servers-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-domain-discovered-servers',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-domain-discovered-servers',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-domain-discovered-servers',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-domain-discovered-servers-reset' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cifs-domain-name-mapping-search-add' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'trusted-domains' => {
                'type' => 'realm-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-domain-name-mapping-search-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-domain-name-mapping-search',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-domain-name-mapping-search',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-domain-name-mapping-search',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-domain-name-mapping-search-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'trusted-domains' => {
                'type' => 'realm-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-domain-name-mapping-search-remove' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'trusted-domains' => {
                'type' => 'realm-name',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-domain-password-schedule-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-domain-password-schedule',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-domain-password-schedule',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-domain-password-schedule',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-domain-password-schedule-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'is-schedule-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-day-of-week' => {
                'type' => 'cron-day-of-week',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-randomized-minute' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-time-of-day' => {
                'type' => 'time-of-day',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-weekly-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-domain-preferred-dc-add' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'preferred-dc' => {
                'type' => 'string',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-domain-preferred-dc-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-domain-preferred-dc',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-domain-preferred-dc',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-domain-preferred-dc',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-domain-preferred-dc-remove' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'preferred-dc' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-domain-trusts-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-domain-trusts',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-domain-trusts',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-domain-trusts',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-domain-trusts-rediscover' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cifs-home-directory-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-home-directory',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-home-directory',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-home-directory',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-home-directory-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'is-home-dirs-access-for-admin-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-home-dirs-access-for-public-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-home-directory-search-path-add' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-home-directory-search-path-delete' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-home-directory-search-path-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-home-directory-search-path',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-home-directory-search-path',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-home-directory-search-path',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-home-directory-search-path-remove' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-home-directory-search-path-reorder' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'to-position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-group-create' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'cifs-local-group',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'cifs-local-group-delete' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-group-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-local-group',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-local-group',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-local-group',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-local-group-members-add-members' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
            'member-names' => {
                'type' => 'cifs-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-group-members-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-local-group-members',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-local-group-members',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-local-group-members',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-local-group-members-remove-members' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
            'member-names' => {
                'type' => 'cifs-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-group-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-group-rename' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
            'new-group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-user-create' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'full-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-account-disabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
            'user-password' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-user-delete' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'user-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-user-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-local-user',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-local-user',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-local-user',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-local-user-membership-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-local-user-membership',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-local-user-membership',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-local-user-membership',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-local-user-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'full-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-account-disabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-user-rename' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'new-user-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-local-user-set-password' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'user-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
            'user-password' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-nbtstat-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-nbtstat',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-nbtstat',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-nbtstat',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-options-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-options',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-options',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-options',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-options-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'client-session-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'default-unix-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'default-unix-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-system-sector-size' => {
                'type' => 'cifs-filesystem-sector-size',
                'flags' => 4,
                'scope' => [],
            },
            'guest-unix-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-admin-users-mapped-to-root-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-advanced-sparse-file-support-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-advertise-dfs-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-copy-offload-direct-copy-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-copy-offload-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dac-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-exportpolicy-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-fake-open-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-local-auth-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-local-users-and-groups-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-read-only-delete-enabled' => {
                'type' => 'enable',
                'flags' => 4,
                'scope' => [],
            },
            'is-referral-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-search-short-names-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-shadowcopy-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-smb2-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-smb3-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-trusted-domain-enum-search-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-unix-extensions-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-unix-nt-acl-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-use-junctions-as-reparse-points-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-file-write-zero-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-mpx' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-opens-same-file-per-tree' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-same-tree-connect-per-session' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-same-user-sessions-per-connection' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-watches-set-per-tree' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'read-grants-execute' => {
                'type' => 'enable',
                'flags' => 4,
                'scope' => [],
            },
            'restrict-anonymous' => {
                'type' => 'anonymous-restriction-level',
                'flags' => 4,
                'scope' => [],
            },
            'shadowcopy-dir-depth' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'smb1-max-buffer-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'wins-servers' => {
                'type' => 'inet-address',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-password-change' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cifs-password-reset' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'admin-password' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'admin-username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-privilege-add-privilege' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'privileges' => {
                'type' => 'cifs-privilege-entries',
                'flags' => 2,
                'scope' => [],
            },
            'user-or-group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-privilege-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-privilege',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-privilege',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-privilege',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-privilege-remove-privilege' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'privileges' => {
                'type' => 'cifs-privilege-entries',
                'flags' => 2,
                'scope' => [],
            },
            'user-or-group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-privilege-reset-privilege' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'user-or-group-name' => {
                'type' => 'cifs-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-security-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-security',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-security',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-security',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-security-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'admin-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'admin-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-aes-encryption-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-password-complexity-required' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-signing-required' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-smb-encryption-required' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'kerberos-clock-skew' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'kerberos-kdc-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'kerberos-renew-age' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'kerberos-ticket-age' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lm-compatibility-level' => {
                'type' => 'lm-compatibility-level',
                'flags' => 4,
                'scope' => [],
            },
            'use-start-tls-for-ad-ldap' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-server-add-netbios-aliases' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'netbios-aliases' => {
                'type' => 'netbios-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-server-create' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'admin-password' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'admin-username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'administrative-status' => {
                'type' => 'service-state',
                'flags' => 4,
                'scope' => [],
            },
            'cifs-server' => {
                'type' => 'netbios-name',
                'flags' => 0,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'default-site' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force-account-overwrite' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'netbios-aliases' => {
                'type' => 'netbios-name',
                'flags' => 6,
                'scope' => [],
            },
            'organizational-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-server-delete' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'admin-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'admin-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force-account-delete' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-server-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-server-config',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-server-config',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-server-config',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-server-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'admin-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'admin-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'administrative-status' => {
                'type' => 'service-state',
                'flags' => 4,
                'scope' => [],
            },
            'cifs-server' => {
                'type' => 'netbios-name',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'default-site' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force-account-overwrite' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ou' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-server-remove-netbios-aliases' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'netbios-aliases' => {
                'type' => 'netbios-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-server-start' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cifs-server-stop' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cifs-session-close' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'auth-mechanism' => {
                'type' => 'auth-mechanism',
                'flags' => 4,
                'scope' => [],
            },
            'connection-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'continuously-available' => {
                'type' => 'cifs-ca-protection',
                'flags' => 4,
                'scope' => [],
            },
            'is-session-signed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'lif-address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'protocol-version' => {
                'type' => 'cifs-dialects',
                'flags' => 4,
                'scope' => [],
            },
            'session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'smb-encryption-status' => {
                'type' => 'smb-encryption',
                'flags' => 4,
                'scope' => [],
            },
            'unix-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'windows-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-session-file-close' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'connection-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'file-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'session-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-session-file-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-session-file',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-session-file',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-session-file',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-session-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-session',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-session',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-session',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-share-access-control-create' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'permission' => {
                'type' => 'cifs-access-perms',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'share' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-group-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-or-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'cifs-share-access-control',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'cifs-share-access-control-delete' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'share' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-group-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-or-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-access-control-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-share-access-control',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-share-access-control',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-share-access-control',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-share-access-control-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'permission' => {
                'type' => 'cifs-access-perms',
                'flags' => 4,
                'scope' => [],
            },
            'share' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-group-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-or-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-create' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'attribute-cache-ttl' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dir-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'file-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'force-group-for-create' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-path-validation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-connections-per-share' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'offline-files-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'share-properties' => {
                'type' => 'cifs-share-properties',
                'flags' => 6,
                'scope' => [],
            },
            'symlink-properties' => {
                'type' => 'cifs-share-symlink-properties',
                'flags' => 6,
                'scope' => [],
            },
            'vscan-fileop-profile' => {
                'type' => 'vscan-fileop-profile',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'cifs-share',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'cifs-share-delete' => {
        'category' => 'cifs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-share-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-share',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-share',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-share',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-share-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'attribute-cache-ttl' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dir-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'file-umask' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'force-group-for-create' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-path-validation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-connections-per-share' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'offline-files-mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'share-properties' => {
                'type' => 'cifs-share-properties',
                'flags' => 6,
                'scope' => [],
            },
            'symlink-properties' => {
                'type' => 'cifs-share-symlink-properties',
                'flags' => 6,
                'scope' => [],
            },
            'vscan-fileop-profile' => {
                'type' => 'vscan-fileop-profile',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-symlink-create' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'cifs-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'cifs-server' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'locality' => {
                'type' => 'cifs-symlink-locality',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unix-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'cifs-symlink',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'cifs-symlink-delete' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'unix-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-symlink-get-iter' => {
        'category' => 'cifs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-symlink',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cifs-symlink',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cifs-symlink',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-symlink-modify' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'cifs-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cifs-server' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'locality' => {
                'type' => 'cifs-symlink-locality',
                'flags' => 4,
                'scope' => [],
            },
            'share-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'unix-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-user-home-directory-path-get' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cifs-user-home-directory-path',
                'flags' => 5,
                'scope' => [],
            },
            'username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cifs-user-home-directory-path',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'volume-charmap-get' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'charmap' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'volume-charmap-set' => {
        'category' => 'cifs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'charmap' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'volume-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clock-get-clock' => {
        'category' => 'clock',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'is-compliance-clock' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'local-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'utc-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clock-get-timezone' => {
        'category' => 'clock',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
            'timezone' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timezone-UTC' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timezone-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clone-autodelete' => {
        'category' => 'clone',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'clone-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'enable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clone-autodelete-status' => {
        'category' => 'clone',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'clone-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'clone-autodelete-info' => {
                'type' => 'clone-autodelete-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'clone-create' => {
        'category' => 'clone',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'autodelete' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'block-ranges' => {
                'type' => 'block-range',
                'flags' => 7,
                'scope' => [],
            },
            'destination-exists' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'destination-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-locks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-streams' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'qos-policy-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'space-reserve' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'token-uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clone-deletion-add-extension' => {
        'category' => 'clone',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'extensions' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'volume-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clone-deletion-get-iter' => {
        'category' => 'clone',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'clone-deletion-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'clone-deletion-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'clone-deletion-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clone-deletion-minimum-size' => {
        'category' => 'clone',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'minimum-size' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'volume-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clone-deletion-remove-extension' => {
        'category' => 'clone',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'extensions' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'volume-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clone-split-load-get-iter' => {
        'category' => 'clone',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'clone-split-load-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'clone-split-load-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'clone-split-load-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clone-token-create' => {
        'category' => 'clone',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'reserve-size' => {
                'type' => 'size',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'token-uuid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'clone-token-delete' => {
        'category' => 'clone',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'token-uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'clone-token-get' => {
        'category' => 'clone',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'token-uuid' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'clone-token-info' => {
                'type' => 'clone-token-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'clone-token-modify-expiry-limit' => {
        'category' => 'clone',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'reservation-duration-limit' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-contact-get' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-contact',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-contact',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-contact-modify' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'business-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'city' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'country' => {
                'type' => 'country-code',
                'flags' => 4,
                'scope' => [],
            },
            'primary-alt-phone' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-email' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-phone' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-alt-phone' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-email' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-phone' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'zip-code' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-create' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cluster-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'license' => {
                'type' => 'license-code-v2',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-create-join-progress-get' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-create-join-progress-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-create-join-progress-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-identity-get' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-identity-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-identity-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-identity-modify' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cluster-contact' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cluster-location' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cluster-name' => {
                'type' => 'cluster-name-simple',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-join' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cluster-ip-address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'cluster-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-log-forward-create' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destination' => {
                'type' => 'remote-inet-address',
                'flags' => 0,
                'scope' => [],
            },
            'facility' => {
                'type' => 'syslog-facility',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'cluster-log-forward-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'cluster-log-forward-destroy' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destination' => {
                'type' => 'remote-inet-address',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-log-forward-get' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-log-forward-info',
                'flags' => 5,
                'scope' => [],
            },
            'destination' => {
                'type' => 'remote-inet-address',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-log-forward-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-log-forward-get-iter' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-log-forward-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-log-forward-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-log-forward-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-log-forward-modify' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destination' => {
                'type' => 'remote-inet-address',
                'flags' => 0,
                'scope' => [],
            },
            'facility' => {
                'type' => 'syslog-facility',
                'flags' => 4,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-log-forward-statistics-get' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-log-forward-statistics',
                'flags' => 5,
                'scope' => [],
            },
            'destination' => {
                'type' => 'remote-inet-address',
                'flags' => 0,
                'scope' => [],
            },
            'log' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-log-forward-statistics',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-log-forward-statistics-get-iter' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-log-forward-statistics',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-log-forward-statistics',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-log-forward-statistics',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-node-get' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-node-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-node-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-node-get-iter' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-node-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-node-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-node-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-node-modify' => {
        'category' => 'cluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'is-node-eligible' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-node-epsilon' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-image-get' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-image-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-id' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-image-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-image-get-download-progress' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'failure-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'progress-status' => {
                'type' => 'cluster-image-download-status',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-image-get-iter' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-image-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-image-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-image-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-image-node-update-progress-info' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'node-update-progress-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'node-update-progress-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-image-package-delete' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'package-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-image-package-download' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'package-url' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-image-package-download-abort' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cluster-image-package-local-get' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-image-package-local-info',
                'flags' => 5,
                'scope' => [],
            },
            'package-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-image-package-local-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-image-package-local-get-iter' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-image-package-local-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-image-package-local-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-image-package-local-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-image-update' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'estimate-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-rolling' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-validation-warning' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'nodes' => {
                'type' => 'node-name',
                'flags' => 6,
                'scope' => [],
            },
            'package-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'pause-after' => {
                'type' => 'non-disruptive-update-pause-after',
                'flags' => 4,
                'scope' => [],
            },
            'stabilize-minutes' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-image-update-cancel' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cluster-image-update-history-get-iter' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-update-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-update-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-update-history-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-image-update-log-get-iter' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-update-transaction-log-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-update-transaction-log-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-update-transaction-log-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-image-update-pause' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'cluster-image-update-progress-get-iter' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-image-ndu-phase-list-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-image-ndu-phase-list-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-image-ndu-phase-list-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-image-update-progress-info' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ndu-progress-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ndu-progress-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-image-update-resume' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ignore-post-update-checks-failures' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-image-validate' => {
        'category' => 'cluster-image',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'package-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cluster-image-validation-report-list' => {
                'type' => 'cluster-image-validation-report-list-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'cluster-peer-authn-offer-cancel' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'peer-cluster-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-peer-authn-offer-get' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-peer-authn-offer',
                'flags' => 5,
                'scope' => [],
            },
            'peer-cluster-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-peer-authn-offer',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-peer-authn-offer-get-iter' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-peer-authn-offer',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-peer-authn-offer',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-peer-authn-offer',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-peer-authn-offer-modify' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'offer-expiration' => {
                'type' => 'datetime',
                'flags' => 0,
                'scope' => [],
            },
            'peer-cluster-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-peer-connection-destroy' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'connection-type' => {
                'type' => 'cluster-peer-connection-type',
                'flags' => 0,
                'scope' => [],
            },
            'file-descriptor' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'peer-cluster-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-peer-connections-get' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'connection-type' => {
                'type' => 'cluster-peer-connection-type',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'cluster-peer-connections',
                'flags' => 5,
                'scope' => [],
            },
            'file-descriptor' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'peer-cluster-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-peer-connections',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-peer-connections-get-iter' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-peer-connections',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-peer-connections',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-peer-connections',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-peer-create' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'address-family' => {
                'type' => 'cluster-peer-address-family',
                'flags' => 4,
                'scope' => [],
            },
            'ipspace-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'offer-expiration' => {
                'type' => 'datetime',
                'flags' => 4,
                'scope' => [],
            },
            'passphrase' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'peer-addresses' => {
                'type' => 'remote-inet-address',
                'flags' => 2,
                'scope' => [],
            },
            'rpc-connect-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'update-ping-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-peer-delete' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cluster-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-peer-get' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cluster-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'cluster-peer-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-peer-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-peer-get-iter' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-peer-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-peer-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-peer-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-peer-health-info-get' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-peer-health-info',
                'flags' => 5,
                'scope' => [],
            },
            'destination-cluster' => {
                'type' => 'cluster-name',
                'flags' => 0,
                'scope' => [],
            },
            'destination-node' => {
                'type' => 'peer-node-name',
                'flags' => 0,
                'scope' => [],
            },
            'originating-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-peer-health-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-peer-health-info-get-iter' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-peer-health-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-peer-health-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-peer-health-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-peer-modify' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'auth-status-admin' => {
                'type' => 'cluster-peer-auth-status-admin',
                'flags' => 4,
                'scope' => [],
            },
            'cluster-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'offer-expiration' => {
                'type' => 'datetime',
                'flags' => 4,
                'scope' => [],
            },
            'passphrase' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'peer-addresses' => {
                'type' => 'remote-inet-address',
                'flags' => 6,
                'scope' => [],
            },
            'rpc-connect-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'update-ping-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cluster-peer-ping-iter' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-peer-ping-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'cluster-peer-ping-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'cluster-peer-ping-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cluster-peer-policy-get' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'cluster-peer-policy',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'cluster-peer-policy',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'cluster-peer-policy-modify' => {
        'category' => 'cluster-peer',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'is-unauthenticated-access-permitted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'passphrase-minlength' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'config-backup-copy' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'backup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'from-node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'to-node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'config-backup-create' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'backup-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-type' => {
                'type' => 'backup-type',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'config-backup-delete' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'backup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'config-backup-download' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'backup-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-url' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'config-backup-info-get' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'backup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'config-backup-info-type',
                'flags' => 5,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'config-backup-info-type',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'config-backup-info-get-iter' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'config-backup-info-type',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'config-backup-info-type',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'config-backup-info-type',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'config-backup-rename' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'backup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'new-backup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'config-backup-settings-get' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'config-backup-settings-type',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'config-backup-settings-type',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'config-backup-settings-modify' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'backup-count1' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'backup-count2' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'backup-count3' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'destination-url' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'username-for-destination-url' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'config-backup-settings-password-set' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'password-for-destination-url' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'config-backup-upload' => {
        'category' => 'config-backup',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'backup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'destination-url' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'coredump-trigger' => {
        'category' => 'coredump',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dashboard-alarm-get' => {
        'category' => 'dashboard',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'dashboard-metric-type' => {
                'type' => 'dashboard-metric-type',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'dashboard-alarm-info',
                'flags' => 5,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'dashboard-alarm-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'dashboard-alarm-get-iter' => {
        'category' => 'dashboard',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'dashboard-alarm-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'dashboard-alarm-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'dashboard-alarm-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dashboard-alarm-get-total-records' => {
        'category' => 'dashboard',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dashboard-alarm-threshold-get' => {
        'category' => 'dashboard',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'dashboard-metric-type' => {
                'type' => 'dashboard-metric-type',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'dashboard-alarm-threshold-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'dashboard-alarm-threshold-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'dashboard-alarm-threshold-get-iter' => {
        'category' => 'dashboard',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'dashboard-alarm-threshold-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'dashboard-alarm-threshold-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'dashboard-alarm-threshold-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dashboard-alarm-threshold-get-total-records' => {
        'category' => 'dashboard',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dashboard-alarm-threshold-modify' => {
        'category' => 'dashboard',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'critical-threshold' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dashboard-metric-type' => {
                'type' => 'dashboard-metric-type',
                'flags' => 0,
                'scope' => [],
            },
            'is-user-notification-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'polling-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-units' => {
                'type' => 'threshold-unit',
                'flags' => 4,
                'scope' => [],
            },
            'warning-threshold' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-alert-definition-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'alert-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-alert-definition-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-alert-definition-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-alert-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'alert-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alerting-resource' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 5,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-alert-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-alert-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-alert-modify' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'acknowledge' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'acknowledger' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'alert-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alerting-resource' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'suppress' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'suppressor' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-config-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-config-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-delete-alert' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'alert-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'alerting-resource' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-policy-definition-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-policy-definition-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-policy-definition-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-policy-modify' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'enable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-autosupport-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-status-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-status',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-status',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-subscriptions-create' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-type' => {
                'type' => 'hm-event-type',
                'flags' => 0,
                'scope' => [],
            },
            'fail-thresh' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-notify-period' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-hm' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'notify-table' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'psc-option' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'subscription-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'time-gap-notify' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'diagnosis-subscriptions-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 5,
                'scope' => [],
            },
            'event-type' => {
                'type' => 'hm-event-type',
                'flags' => 0,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-hm' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'subscription-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-subscriptions-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-subscriptions-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-subscriptions-modify' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-type' => {
                'type' => 'hm-event-type',
                'flags' => 0,
                'scope' => [],
            },
            'fail-thresh' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-notify-period' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'monitor' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-hm' => {
                'type' => 'hm-type',
                'flags' => 0,
                'scope' => [],
            },
            'notify-dest-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'notify-table' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'psc-option' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'subscription-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'time-gap-notify' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'diagnosis-subsystem-config-get' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'subsystem' => {
                'type' => 'hm-subsystem',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'diagnosis-subsystem-config-get-iter' => {
        'category' => 'diagnosis',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'diagnosis-subsystem-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'diagnosis-subsystem-config-modify' => {
        'category' => 'diagnosis',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'refresh-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'subsystem' => {
                'type' => 'hm-subsystem',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-fail' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-immediate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-remove' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-sanown-assign' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'auto' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'checksum' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'copy-owner-from' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-data-partition' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-root-partition' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'pool' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-sanown-filer-list-info' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'disk-sanown-filer-details' => {
                'type' => 'disk-sanown-filer-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'disk-sanown-list-info' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'ownership-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'disk-sanown-details' => {
                'type' => 'disk-sanown-detail-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'disk-sanown-reassign' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'new-owner-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'old-owner-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-sanown-remove-ownership' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk-list' => {
                'type' => 'disk-name',
                'flags' => 6,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-data-partition' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-root-partition' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-unfail' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'make-spare' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-update-disk-fw' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'disk-list' => {
                'type' => 'disk-name',
                'flags' => 6,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'disk-zero-spares' => {
        'category' => 'disk',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'disk-encrypt-get' => {
        'category' => 'disk-encrypt',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'disk-encrypt-info',
                'flags' => 5,
                'scope' => [],
            },
            'disk-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'disk-encrypt-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'disk-encrypt-get-iter' => {
        'category' => 'disk-encrypt',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'disk-encrypt-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'disk-encrypt-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'disk-encrypt-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'disk-encrypt-modify' => {
        'category' => 'disk-encrypt',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'data-key-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disk-name' => {
                'type' => 'disk-name',
                'flags' => 0,
                'scope' => [],
            },
            'fips-key-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-encrypt-modify-iter' => {
        'category' => 'disk-encrypt',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'data-key-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'fips-key-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'disk-encrypt-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'disk-encrypt-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'disk-encrypt-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'disk-encrypt-sanitize' => {
        'category' => 'disk-encrypt',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'disk-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-encrypt-sanitize-iter' => {
        'category' => 'disk-encrypt',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'disk-encrypt-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'disk-encrypt-sanitize-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'disk-encrypt-sanitize-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'disk-encrypt-status-get' => {
        'category' => 'disk-encrypt',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'disk-encrypt-show-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'disk-encrypt-show-status-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'disk-encrypt-status-get-iter' => {
        'category' => 'disk-encrypt',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'disk-encrypt-show-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'disk-encrypt-show-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'disk-encrypt-show-status-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ems-autosupport-log' => {
        'category' => 'ems',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'app-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'auto-support' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'computer-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'event-source' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'log-level' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-config-get' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-config-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ems-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'ems-config-modify' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'console' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'console-log-level' => {
                'type' => 'emsseverity',
                'flags' => 4,
                'scope' => [],
            },
            'mail-from' => {
                'type' => 'mail-address',
                'flags' => 4,
                'scope' => [],
            },
            'mail-server' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-log-show-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-target-event-bytes' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-target-log-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'suppression' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'trace-log-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-destination-create' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'hide-parameters' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mail' => {
                'type' => 'mail-address',
                'flags' => 6,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snmp' => {
                'type' => 'remote-ip',
                'flags' => 6,
                'scope' => [],
            },
            'snmp-community' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'syslog' => {
                'type' => 'remote-ip',
                'flags' => 6,
                'scope' => [],
            },
            'syslog-facility' => {
                'type' => 'syslog-facility',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'ems-destination-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'ems-destination-destroy' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-destination-destroy-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-destination-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'ems-destination-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'ems-destination-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'ems-destination-get' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-destination-info',
                'flags' => 5,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ems-destination-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'ems-destination-get-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-destination-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-destination-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ems-destination-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ems-destination-modify' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'hide-parameters' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mail' => {
                'type' => 'mail-address',
                'flags' => 6,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snmp' => {
                'type' => 'remote-ip',
                'flags' => 6,
                'scope' => [],
            },
            'snmp-community' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'syslog' => {
                'type' => 'remote-ip',
                'flags' => 6,
                'scope' => [],
            },
            'syslog-facility' => {
                'type' => 'syslog-facility',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-destination-modify-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'ems-destination-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-destination-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'ems-destination-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'ems-destination-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'ems-mail-history-destroy' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'seq-num' => {
                'type' => 'seqnum',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-mail-history-destroy-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-mail-history-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'ems-mail-history-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'ems-mail-history-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'ems-mail-history-get' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-mail-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'seq-num' => {
                'type' => 'seqnum',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ems-mail-history-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'ems-mail-history-get-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-mail-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-mail-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ems-mail-history-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ems-message-get' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-message-info',
                'flags' => 5,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'seq-num' => {
                'type' => 'seqnum',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ems-message-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'ems-message-get-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-message-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-message-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ems-message-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ems-routing-add-destination' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destinations' => {
                'type' => 'ems-destination',
                'flags' => 2,
                'scope' => [],
            },
            'message-name' => {
                'type' => 'ems-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-routing-get' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-routing-info',
                'flags' => 5,
                'scope' => [],
            },
            'message-name' => {
                'type' => 'ems-id',
                'flags' => 0,
                'scope' => [],
            },
            'severity' => {
                'type' => 'eventseverity',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ems-routing-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'ems-routing-get-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-routing-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-routing-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ems-routing-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ems-routing-modify' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destinations' => {
                'type' => 'ems-destination',
                'flags' => 6,
                'scope' => [],
            },
            'frequency-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'message-name' => {
                'type' => 'ems-id',
                'flags' => 0,
                'scope' => [],
            },
            'time-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-routing-modify-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'ems-routing-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-routing-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'ems-routing-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'ems-routing-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'ems-routing-remove-destination' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destinations' => {
                'type' => 'ems-destination',
                'flags' => 2,
                'scope' => [],
            },
            'message-name' => {
                'type' => 'ems-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-snmp-history-destroy' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'seq-num' => {
                'type' => 'seqnum',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ems-snmp-history-destroy-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-snmp-history-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'ems-snmp-history-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'ems-snmp-history-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'ems-snmp-history-get' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-snmp-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'seq-num' => {
                'type' => 'seqnum',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ems-snmp-history-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'ems-snmp-history-get-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-snmp-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-snmp-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ems-snmp-history-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ems-status-get' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'message-name' => {
                'type' => 'ems-id',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ems-status-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'ems-status-get-iter' => {
        'category' => 'ems',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ems-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ems-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ems-status-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'environment-sensors-get-iter' => {
        'category' => 'environment',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'environment-sensors-info',
                'flags' => 5,
                'scope' => [],
            },
            'discrete-sensor-state' => {
                'type' => 'sensor-state-enum',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'environment-sensors-info',
                'flags' => 5,
                'scope' => [],
            },
            'sensor-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sensor-type' => {
                'type' => 'sensor-type-enum',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-sensor-state' => {
                'type' => 'sensor-state-enum',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'environment-sensors-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'export-policy-create' => {
        'category' => 'exports',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'export-policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'export-policy-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'export-policy-destroy' => {
        'category' => 'exports',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'export-policy-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'export-policy-get' => {
        'category' => 'exports',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'export-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'export-policy-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'export-policy-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'export-policy-get-iter' => {
        'category' => 'exports',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'export-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'export-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'export-policy-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'export-policy-rename' => {
        'category' => 'exports',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'new-policy-name' => {
                'type' => 'export-policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'export-policy-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'export-rule-create' => {
        'category' => 'exports',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'anonymous-user-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'client-match' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'export-chown-mode' => {
                'type' => 'exportchownmode',
                'flags' => 4,
                'scope' => [],
            },
            'export-ntfs-unix-security-ops' => {
                'type' => 'exportntfsunixsecops',
                'flags' => 4,
                'scope' => [],
            },
            'is-allow-dev-is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-allow-set-uid-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'access-protocol',
                'flags' => 6,
                'scope' => [],
            },
            'ro-rule' => {
                'type' => 'security-flavor',
                'flags' => 2,
                'scope' => [],
            },
            'rule-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rw-rule' => {
                'type' => 'security-flavor',
                'flags' => 2,
                'scope' => [],
            },
            'super-user-security' => {
                'type' => 'security-flavor',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'export-rule-destroy' => {
        'category' => 'exports',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'rule-index' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'export-rule-get' => {
        'category' => 'exports',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'export-rule-info',
                'flags' => 5,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'rule-index' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'export-rule-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'export-rule-get-create-defaults' => {
        'category' => 'exports',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'attributes' => {
                'type' => 'export-rule-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'defaults' => {
                'type' => 'export-rule-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'export-rule-get-iter' => {
        'category' => 'exports',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'export-rule-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'export-rule-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'export-rule-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'export-rule-modify' => {
        'category' => 'exports',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'anonymous-user-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'client-match' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'export-chown-mode' => {
                'type' => 'exportchownmode',
                'flags' => 4,
                'scope' => [],
            },
            'export-ntfs-unix-security-ops' => {
                'type' => 'exportntfsunixsecops',
                'flags' => 4,
                'scope' => [],
            },
            'is-allow-dev-is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-allow-set-uid-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'access-protocol',
                'flags' => 6,
                'scope' => [],
            },
            'ro-rule' => {
                'type' => 'security-flavor',
                'flags' => 6,
                'scope' => [],
            },
            'rule-index' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'rw-rule' => {
                'type' => 'security-flavor',
                'flags' => 6,
                'scope' => [],
            },
            'super-user-security' => {
                'type' => 'security-flavor',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'export-rule-set-index' => {
        'category' => 'exports',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'new-rule-index' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'rule-index' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'exports-access-cache-all-vservers-get' => {
        'category' => 'exports',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'access-cache-attributes-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'access-cache-attributes-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'exports-access-cache-all-vservers-modify' => {
        'category' => 'exports',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'harvest-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'refresh-period-negative' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'refresh-period-positive' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fc-config-adapter-disable' => {
        'category' => 'fc',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'fc-config-adapter-enable' => {
        'category' => 'fc',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'fc-config-list-info' => {
        'category' => 'fc',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fc-config',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fc-config',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fc-config',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fc-config-set-adapter-fc-type' => {
        'category' => 'fc',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'fc-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-config-down' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-config-up' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-get-iter' => {
        'category' => 'fcp',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fcp-config-adapter-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fcp-config-adapter-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fcp-config-adapter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-adapter-set-speed' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'speed' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-adapter-stats-get-iter' => {
        'category' => 'fcp',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fcp-adapter-stats-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fcp-adapter-stats-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fcp-adapter-stats-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-initiator-get-iter' => {
        'category' => 'fcp',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fcp-adapter-initiators-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fcp-adapter-initiators-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fcp-adapter-initiators-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-interface-get-iter' => {
        'category' => 'fcp',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fcp-interface-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fcp-interface-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fcp-interface-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-node-get-name' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-node-set-name' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-port-name-get-iter' => {
        'category' => 'fcp',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fcp-port-name-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fcp-port-name-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fcp-port-name-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-port-name-set' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'fcp-adapter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-service-create' => {
        'category' => 'fcp',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'force-node-name' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'start' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-service-destroy' => {
        'category' => 'fcp',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'fcp-service-get-iter' => {
        'category' => 'fcp',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fcp-service-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fcp-service-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fcp-service-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-service-start' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'fcp-service-status' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
            'is-available' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-service-stop' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'fcp-wwpnalias-get-iter' => {
        'category' => 'fcp',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'aliases-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'aliases-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'aliases-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-wwpnalias-remove' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'alias' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'wwpn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-wwpnalias-set' => {
        'category' => 'fcp',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'alias' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'wwpn' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcport-get-link-state' => {
        'category' => 'fcport',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'adapter-link-state' => {
                'type' => 'link-state-info',
                'flags' => 3,
                'scope' => [],
            },
            'adapter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'feature-status-list-info' => {
        'category' => 'feature',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
            'managed-feature-status-list' => {
                'type' => 'managed-feature-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'feature-usage-get-iter' => {
        'category' => 'feature',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'usage-state-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'usage-state-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'usage-state-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'feature-usage-summary-get-iter' => {
        'category' => 'feature',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'usage-summary-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'usage-summary-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'usage-summary-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-assign-qos' => {
        'category' => 'file',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'caching-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qos-policy-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'volume-name',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-create-directory' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'perm' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-create-symlink' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'symlink' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-delete-directory' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-delete-file' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-get-file-info' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'file-info' => {
                'type' => 'file-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'file-get-space-reservation-info' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-fill-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-overwrite-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-hole-range-query-iter' => {
        'category' => 'file',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'offset' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'hole-range-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-inode-info-get-iter' => {
        'category' => 'file',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'inode-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'inode-info',
                'flags' => 1,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'inode-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-list-directory-iter' => {
        'category' => 'file',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'file-info',
                'flags' => 7,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'query' => {
                'type' => 'file-info',
                'flags' => 7,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'file-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-punch-hole-iter' => {
        'category' => 'file',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'attributes-list' => {
                'type' => 'hole-range-info',
                'flags' => 3,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'file-read-file' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'offset' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'stream-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
        },
        'outputs' => {
            'data' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-read-symlink' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'symlink' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-rename-file' => {
        'category' => 'file',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'from-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'to-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-set-space-reservation-info' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'is-fill-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-overwrite-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-truncate-file' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-usage-get' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'start-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'total-bytes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unique-bytes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-usage-result-get' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'cookie' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'total-bytes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unique-bytes' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-usage-start' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'start-offset' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'cookie' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-write-file' => {
        'category' => 'file',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'data' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'offset' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'overwrite' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'stream-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
        },
        'outputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-directory-security-get' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'cifs-share-name' => {
                'type' => 'cifs-share-name',
                'flags' => 4,
                'scope' => [],
            },
            'expand-mask' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'inode' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lookup-names' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'volume-name',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'acls' => {
                'type' => 'fsecurity-acl',
                'flags' => 6,
                'scope' => [],
            },
            'dos-attributes' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'effective-style' => {
                'type' => 'security-style-enum',
                'flags' => 0,
                'scope' => [],
            },
            'expanded-dos-attr' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'inode' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'security-style' => {
                'type' => 'security-style-enum',
                'flags' => 0,
                'scope' => [],
            },
            'text-dos-attr' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'unix-group-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'unix-mode-bits' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'unix-user-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'file-directory-security-ntfs-create' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'control-flags-raw' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'group' => {
                'type' => 'name-or-sid',
                'flags' => 4,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 0,
                'scope' => [],
            },
            'owner' => {
                'type' => 'name-or-sid',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'file-directory-security-ntfs',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'file-directory-security-ntfs-dacl-add' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'access-type' => {
                'type' => 'access-type',
                'flags' => 0,
                'scope' => [],
            },
            'account' => {
                'type' => 'name-or-sid',
                'flags' => 0,
                'scope' => [],
            },
            'advanced-rights' => {
                'type' => 'advanced-access-rights',
                'flags' => 6,
                'scope' => [],
            },
            'apply-to' => {
                'type' => 'inheritance-level',
                'flags' => 6,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 0,
                'scope' => [],
            },
            'rights' => {
                'type' => 'access-rights',
                'flags' => 4,
                'scope' => [],
            },
            'rights-raw' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-ntfs-dacl-get-iter' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'file-directory-security-ntfs-dacl',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'file-directory-security-ntfs-dacl',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'file-directory-security-ntfs-dacl',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-directory-security-ntfs-dacl-modify' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'access-type' => {
                'type' => 'access-type',
                'flags' => 0,
                'scope' => [],
            },
            'account' => {
                'type' => 'name-or-sid',
                'flags' => 0,
                'scope' => [],
            },
            'advanced-rights' => {
                'type' => 'advanced-access-rights',
                'flags' => 6,
                'scope' => [],
            },
            'apply-to' => {
                'type' => 'inheritance-level',
                'flags' => 6,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 0,
                'scope' => [],
            },
            'rights' => {
                'type' => 'access-rights',
                'flags' => 4,
                'scope' => [],
            },
            'rights-raw' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-ntfs-dacl-remove' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'access-type' => {
                'type' => 'access-type',
                'flags' => 0,
                'scope' => [],
            },
            'account' => {
                'type' => 'name-or-sid',
                'flags' => 0,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-ntfs-delete' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-ntfs-get-iter' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'file-directory-security-ntfs',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'file-directory-security-ntfs',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'file-directory-security-ntfs',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-directory-security-ntfs-modify' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'control-flags-raw' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'group' => {
                'type' => 'name-or-sid',
                'flags' => 4,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 0,
                'scope' => [],
            },
            'owner' => {
                'type' => 'name-or-sid',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-ntfs-sacl-add' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'account' => {
                'type' => 'name-or-sid',
                'flags' => 0,
                'scope' => [],
            },
            'advanced-rights' => {
                'type' => 'advanced-access-rights',
                'flags' => 6,
                'scope' => [],
            },
            'apply-to' => {
                'type' => 'inheritance-level',
                'flags' => 6,
                'scope' => [],
            },
            'audit-access-type' => {
                'type' => 'audit-access-type',
                'flags' => 0,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 0,
                'scope' => [],
            },
            'rights' => {
                'type' => 'access-rights',
                'flags' => 4,
                'scope' => [],
            },
            'rights-raw' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-ntfs-sacl-get-iter' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'file-directory-security-ntfs-sacl',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'file-directory-security-ntfs-sacl',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'file-directory-security-ntfs-sacl',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-directory-security-ntfs-sacl-modify' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'account' => {
                'type' => 'name-or-sid',
                'flags' => 0,
                'scope' => [],
            },
            'advanced-rights' => {
                'type' => 'advanced-access-rights',
                'flags' => 6,
                'scope' => [],
            },
            'apply-to' => {
                'type' => 'inheritance-level',
                'flags' => 6,
                'scope' => [],
            },
            'audit-access-type' => {
                'type' => 'audit-access-type',
                'flags' => 0,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 0,
                'scope' => [],
            },
            'rights' => {
                'type' => 'access-rights',
                'flags' => 4,
                'scope' => [],
            },
            'rights-raw' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-ntfs-sacl-remove' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'account' => {
                'type' => 'name-or-sid',
                'flags' => 0,
                'scope' => [],
            },
            'audit-access-type' => {
                'type' => 'audit-access-type',
                'flags' => 0,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-policy-create' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'file-security-policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'file-directory-security-policy',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'file-directory-security-policy-delete' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'file-security-policy-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-policy-get-iter' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'file-directory-security-policy',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'file-directory-security-policy',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'file-directory-security-policy',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-directory-security-policy-task-add' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'access-control' => {
                'type' => 'access-control',
                'flags' => 4,
                'scope' => [],
            },
            'ntfs-mode' => {
                'type' => 'ntfs-propagation-mode',
                'flags' => 4,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 6,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'file-security-policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'security-type' => {
                'type' => 'security-type',
                'flags' => 4,
                'scope' => [],
            },
            'task-index-number' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-policy-task-get-iter' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'file-directory-security-policy-task',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'file-directory-security-policy-task',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'file-directory-security-policy-task',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-directory-security-policy-task-modify' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'ntfs-mode' => {
                'type' => 'ntfs-propagation-mode',
                'flags' => 4,
                'scope' => [],
            },
            'ntfs-sd' => {
                'type' => 'file-security-ntfs-sd',
                'flags' => 6,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'file-security-policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'security-type' => {
                'type' => 'security-type',
                'flags' => 4,
                'scope' => [],
            },
            'task-index-number' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-policy-task-remove' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'file-security-policy-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-remove-slag' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'file-directory-security-set' => {
        'category' => 'file-directory-security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'file-security-policy-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fileservice-audit-config-create' => {
        'category' => 'fileservice-audit',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'destination' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'events' => {
                'type' => 'audit-events',
                'flags' => 6,
                'scope' => [],
            },
            'format' => {
                'type' => 'audit-format',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'rotate-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rotate-schedule-day' => {
                'type' => 'cron-day-of-month',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-schedule-dayofweek' => {
                'type' => 'cron-day-of-week',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-schedule-hour' => {
                'type' => 'cron-hour',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-schedule-minute' => {
                'type' => 'cron-minute',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-schedule-month' => {
                'type' => 'cron-month',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-size' => {
                'type' => 'psize',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'fileservice-audit-config',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'fileservice-audit-config-get' => {
        'category' => 'fileservice-audit',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fileservice-audit-config',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'fileservice-audit-config',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'fileservice-audit-config-get-iter' => {
        'category' => 'fileservice-audit',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fileservice-audit-config',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fileservice-audit-config',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fileservice-audit-config',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fileservice-audit-config-get-total-records' => {
        'category' => 'fileservice-audit',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fileservice-audit-config-modify' => {
        'category' => 'fileservice-audit',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'audit-guarantee' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'destination' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'events' => {
                'type' => 'audit-events',
                'flags' => 6,
                'scope' => [],
            },
            'format' => {
                'type' => 'audit-format',
                'flags' => 4,
                'scope' => [],
            },
            'rotate-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rotate-schedule-day' => {
                'type' => 'cron-day-of-month',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-schedule-dayofweek' => {
                'type' => 'cron-day-of-week',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-schedule-hour' => {
                'type' => 'cron-hour',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-schedule-minute' => {
                'type' => 'cron-minute',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-schedule-month' => {
                'type' => 'cron-month',
                'flags' => 6,
                'scope' => [],
            },
            'rotate-size' => {
                'type' => 'psize',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fileservice-audit-disable' => {
        'category' => 'fileservice-audit',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'fileservice-audit-enable' => {
        'category' => 'fileservice-audit',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fileservice-audit-remove' => {
        'category' => 'fileservice-audit',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fileservice-audit-rotate-log' => {
        'category' => 'fileservice-audit',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'flash-device-get-iter' => {
        'category' => 'flash',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'flash-device-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'flash-device-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'flash-device-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'flash-device-list-info' => {
        'category' => 'flash',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'slot-number' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'flash-device-info' => {
                'type' => 'flash-device-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'flash-get-thresholds' => {
        'category' => 'flash',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'profile' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'flash-threshold-profile' => {
                'type' => 'flash-threshold-profile',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'flash-thresholds-get-iter' => {
        'category' => 'flash',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'flash-threshold-profile',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'flash-threshold-profile',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'flash-threshold-profile',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'flexcache-cache-policy-create' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cache-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'deleg-lru-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'prefer-local-cache' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'time-to-live-directories' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'time-to-live-files' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'time-to-live-metafiles' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-to-live-other' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-to-live-symbolic' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'flexcache-cache-policy-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'flexcache-cache-policy-destroy' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cache-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'flexcache-cache-policy-get' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cache-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'flexcache-cache-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'flexcache-cache-policy-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'flexcache-cache-policy-get-iter' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'flexcache-cache-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'flexcache-cache-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'flexcache-cache-policy-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'flexcache-cache-policy-modify' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cache-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'deleg-lru-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'prefer-local-cache' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'time-to-live-directories' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-to-live-files' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-to-live-metafiles' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-to-live-other' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-to-live-symbolic' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'flexcache-create' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'origin-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'flexcache-delete' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'origin-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'flexcache-get' => {
        'category' => 'flexcache',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'cache-volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'flexcache-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'flexcache-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'flexcache-get-iter' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'flexcache-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'flexcache-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'flexcache-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'flexcache-options-get' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'flexcache-options-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'flexcache-options-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'flexcache-options-modify' => {
        'category' => 'flexcache',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'delegations-high-watermark' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'delegations-low-watermark' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'per-cache-statistics' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-disable-policy' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-enable-policy' => {
        'category' => 'fpolicy',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'sequence-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => ['ontap-vserver'],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-passthrough-read-connection-get-iter' => {
        'category' => 'fpolicy',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fpolicy-passthrough-read-connection-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fpolicy-passthrough-read-connection-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fpolicy-passthrough-read-connection-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-policy-create' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'allow-privileged-access' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'engine-name' => {
                'type' => 'engine-name',
                'flags' => 0,
                'scope' => [],
            },
            'events' => {
                'type' => 'event-name',
                'flags' => 2,
                'scope' => [],
            },
            'is-mandatory' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-passthrough-read-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'privileged-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'fpolicy-policy-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'fpolicy-policy-delete' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'policy-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-policy-event-create' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'event-name' => {
                'type' => 'event-name',
                'flags' => 0,
                'scope' => [],
            },
            'file-operations' => {
                'type' => 'fpolicy-operation',
                'flags' => 6,
                'scope' => [],
            },
            'filter-string' => {
                'type' => 'fpolicy-filter',
                'flags' => 6,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'fpolicy-proto',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume-operation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'fpolicy-event-options-config',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'fpolicy-policy-event-delete' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'event-name' => {
                'type' => 'event-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-policy-event-get-iter' => {
        'category' => 'fpolicy',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fpolicy-event-options-config',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fpolicy-event-options-config',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fpolicy-event-options-config',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-policy-event-modify' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'event-name' => {
                'type' => 'event-name',
                'flags' => 0,
                'scope' => [],
            },
            'file-operations' => {
                'type' => 'fpolicy-operation',
                'flags' => 6,
                'scope' => [],
            },
            'filter-string' => {
                'type' => 'fpolicy-filter',
                'flags' => 6,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'fpolicy-proto',
                'flags' => 4,
                'scope' => [],
            },
            'volume-operation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-policy-external-engine-create' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'certificate-ca' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'certificate-common-name' => {
                'type' => 'common-name',
                'flags' => 4,
                'scope' => [],
            },
            'certificate-serial' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'engine-name' => {
                'type' => 'engine-name',
                'flags' => 0,
                'scope' => [],
            },
            'extern-engine-type' => {
                'type' => 'external-engine-type',
                'flags' => 4,
                'scope' => [],
            },
            'keep-alive-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-connection-retries' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-server-requests' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'port-number' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'primary-servers' => {
                'type' => 'ip-address',
                'flags' => 2,
                'scope' => [],
            },
            'recv-buffer-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'request-abort-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'request-cancel-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'send-buffer-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'server-progress-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'session-timeout' => {
                'type' => 'time-interval',
                'flags' => 4,
                'scope' => [],
            },
            'ssl-option' => {
                'type' => 'fpolicy-ssl-opts',
                'flags' => 0,
                'scope' => [],
            },
            'status-request-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'fpolicy-external-engine-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'fpolicy-policy-external-engine-delete' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'engine-name' => {
                'type' => 'engine-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-policy-external-engine-get-iter' => {
        'category' => 'fpolicy',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fpolicy-external-engine-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fpolicy-external-engine-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fpolicy-external-engine-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-policy-external-engine-modify' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'certificate-ca' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'certificate-common-name' => {
                'type' => 'common-name',
                'flags' => 4,
                'scope' => [],
            },
            'certificate-serial' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'engine-name' => {
                'type' => 'engine-name',
                'flags' => 0,
                'scope' => [],
            },
            'extern-engine-type' => {
                'type' => 'external-engine-type',
                'flags' => 4,
                'scope' => [],
            },
            'keep-alive-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-connection-retries' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-server-requests' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'port-number' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'primary-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'recv-buffer-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'request-abort-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'request-cancel-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'send-buffer-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'server-progress-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'session-timeout' => {
                'type' => 'time-interval',
                'flags' => 4,
                'scope' => [],
            },
            'ssl-option' => {
                'type' => 'fpolicy-ssl-opts',
                'flags' => 4,
                'scope' => [],
            },
            'status-request-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-policy-get-iter' => {
        'category' => 'fpolicy',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fpolicy-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fpolicy-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fpolicy-policy-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-policy-modify' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'allow-privileged-access' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'engine-name' => {
                'type' => 'engine-name',
                'flags' => 4,
                'scope' => [],
            },
            'events' => {
                'type' => 'event-name',
                'flags' => 6,
                'scope' => [],
            },
            'is-mandatory' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-passthrough-read-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'privileged-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-policy-scope-create' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'check-extensions-on-directories' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'export-policies-to-exclude' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'export-policies-to-include' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'file-extensions-to-exclude' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'file-extensions-to-include' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'shares-to-exclude' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'shares-to-include' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'volumes-to-exclude' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'volumes-to-include' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'fpolicy-scope-config',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'fpolicy-policy-scope-delete' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'policy-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-policy-scope-get-iter' => {
        'category' => 'fpolicy',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fpolicy-scope-config',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fpolicy-scope-config',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fpolicy-scope-config',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-policy-scope-modify' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'check-extensions-on-directories' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'export-policies-to-exclude' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'export-policies-to-include' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'file-extensions-to-exclude' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'file-extensions-to-include' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'shares-to-exclude' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'shares-to-include' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'volumes-to-exclude' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'volumes-to-include' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-policy-status-get-iter' => {
        'category' => 'fpolicy',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fpolicy-policy-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fpolicy-policy-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fpolicy-policy-status-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fpolicy-server-connect' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'server' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-server-disconnect' => {
        'category' => 'fpolicy',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'policy-name',
                'flags' => 0,
                'scope' => [],
            },
            'server' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fpolicy-server-status-get-iter' => {
        'category' => 'fpolicy',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'fpolicy-server-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'fpolicy-server-status-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'fpolicy-server-status-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'gpo-applied-info-get-iter' => {
        'category' => 'gpo',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'gpo-applied-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'gpo-applied-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'gpo-applied-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'gpo-get-iter' => {
        'category' => 'gpo',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'gpo-config',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'gpo-config',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'gpo-config',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'gpo-gpresult-info-get-iter' => {
        'category' => 'gpo',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'gpo-gpresult-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'gpo-gpresult-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'gpo-gpresult-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'gpo-modify' => {
        'category' => 'gpo',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'is-gpo-enabled' => {
                'type' => 'true-false',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'gpo-restricted-group-applied-info-get-iter' => {
        'category' => 'gpo',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'gpo-restricted-group-applied-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'gpo-restricted-group-applied-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'gpo-restricted-group-applied-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'gpo-restricted-group-defined-info-get-iter' => {
        'category' => 'gpo',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'gpo-restricted-group-defined-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'gpo-restricted-group-defined-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'gpo-restricted-group-defined-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'gpo-update' => {
        'category' => 'gpo',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'force-reapply-all-settings' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-mapping-create' => {
        'category' => 'group-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'name-mapping-direction',
                'flags' => 0,
                'scope' => [],
            },
            'pattern' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'replacement' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'group-mapping-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'group-mapping-delete' => {
        'category' => 'group-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'name-mapping-direction',
                'flags' => 0,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-mapping-get-iter' => {
        'category' => 'group-mapping',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'group-mapping-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'group-mapping-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'group-mapping-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-mapping-insert' => {
        'category' => 'group-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'name-mapping-direction',
                'flags' => 0,
                'scope' => [],
            },
            'pattern' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'replacement' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-mapping-modify' => {
        'category' => 'group-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'name-mapping-direction',
                'flags' => 0,
                'scope' => [],
            },
            'pattern' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'replacement' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-mapping-swap' => {
        'category' => 'group-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'with-position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-add' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-bind-portset' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-create' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'bind-portset' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'os-type' => {
                'type' => 'initiator-group-os-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-destroy' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-get-iter' => {
        'category' => 'igroup',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'initiator-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'initiator-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'initiator-group-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'igroup-lookup-lun' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'igroup-os-type-list' => {
        'category' => 'igroup',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'ostypes' => {
                'type' => 'system-api-enum-value-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'igroup-remove' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-rename' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator-group-new-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-set-attribute' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'attribute' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'igroup-unbind-portset' => {
        'category' => 'igroup',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-auth-generate-chap-password' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'secret' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-connection-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-connection-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-connection-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-connection-list-entry-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-add-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'radius' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-initiator-auth-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-security-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-security-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-security-entry-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-delete-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-initiator-get-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'auth-chap-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-get-default-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'auth-chap-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-initiator-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-initiator-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-initiator-list-entry-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-initiator-modify-chap-params' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'radius' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'remove-outbound' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-initiator-set-default-auth' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'auth-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'outbound-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'outbound-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'radius' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-interface-accesslist-add' => {
        'category' => 'iscsi',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-interface-accesslist-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-interface-accesslist-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-interface-accesslist-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-interface-accesslist-entry-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-interface-accesslist-remove' => {
        'category' => 'iscsi',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-interface-disable' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-interface-enable' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-interface-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-interface-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-interface-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-interface-list-entry-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-isns-config' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'isns-ip-addr' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-isns-create' => {
        'category' => 'iscsi',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'isns-ip-addr' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'start' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-isns-destroy' => {
        'category' => 'iscsi',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-isns-get-info' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-isns-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'isns-entity-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'isns-ip-addr' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'last-successful-update' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster', 'ontap-vserver'],
            },
            'last-update-attempt' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-cluster', 'ontap-vserver'],
            },
            'last-update-result' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster', 'ontap-vserver'],
            },
        },
    },
    'iscsi-isns-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-isns-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-isns-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-isns-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-isns-start' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-isns-stop' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-isns-update' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-node-get-name' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-node-set-name' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-service-create' => {
        'category' => 'iscsi',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'alias-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'start' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-service-destroy' => {
        'category' => 'iscsi',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-service-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-service-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-service-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-service-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-service-modify' => {
        'category' => 'iscsi',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'login-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-cmds-per-session' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-conn-per-session' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-error-recovery-level' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'retain-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'tcp-window-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-service-start' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-service-status' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-available' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-service-stop' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-session-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-session-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-session-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-session-list-entry-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-stats-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-stats-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-stats-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-stats-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-target-alias-clear-alias' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'iscsi-target-alias-get-alias' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'alias-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-alias-assigned' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-target-alias-set-alias' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'alias-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-tpgroup-create' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'tpgroup-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-tpgroup-destroy' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-tpgroup-get-iter' => {
        'category' => 'iscsi',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'iscsi-tpgroup-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'iscsi-tpgroup-list-entry-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'iscsi-tpgroup-list-entry-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'iscsi-tpgroup-interface-add' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'iscsi-tpgroup-interface-delete' => {
        'category' => 'iscsi',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'tpgroup-tag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-by-node-get' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'job-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'job-by-node-get-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'job-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-completed-get' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'job-completed-get-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'job-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-get' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'job-get-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'job-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-history-get' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'job-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'log-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'job-history-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'job-history-get-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-history-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'job-history-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-pause' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-pause-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-pause-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-pause-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'job-private-completed-get' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'job-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'job-private-completed-get-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'job-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-private-get' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'job-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'job-private-get-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'job-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-private-pause' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'job-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-private-pause-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-private-pause-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-private-pause-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'job-private-resume' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'job-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-private-resume-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-private-resume-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-private-resume-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'job-private-soft-pause' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'job-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-private-soft-pause-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-private-soft-pause-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-private-soft-pause-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'job-private-stop' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'job-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-private-stop-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-private-stop-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-private-stop-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'job-resume' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-resume-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-resume-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-resume-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'job-schedule-cron-create' => {
        'category' => 'job',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'job-schedule-cron-day' => {
                'type' => 'cron-day-of-month',
                'flags' => 6,
                'scope' => [],
            },
            'job-schedule-cron-day-of-week' => {
                'type' => 'cron-day-of-week',
                'flags' => 6,
                'scope' => [],
            },
            'job-schedule-cron-hour' => {
                'type' => 'cron-hour',
                'flags' => 6,
                'scope' => [],
            },
            'job-schedule-cron-minute' => {
                'type' => 'cron-minute',
                'flags' => 2,
                'scope' => [],
            },
            'job-schedule-cron-month' => {
                'type' => 'cron-month',
                'flags' => 6,
                'scope' => [],
            },
            'job-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'job-schedule-cron-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'job-schedule-cron-destroy' => {
        'category' => 'job',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'job-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-schedule-cron-destroy-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-schedule-cron-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-schedule-cron-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-schedule-cron-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'job-schedule-cron-get' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-schedule-cron-info',
                'flags' => 5,
                'scope' => [],
            },
            'job-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'job-schedule-cron-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'job-schedule-cron-get-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-schedule-cron-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-schedule-cron-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'job-schedule-cron-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-schedule-cron-modify' => {
        'category' => 'job',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'job-schedule-cron-day' => {
                'type' => 'cron-day-of-month',
                'flags' => 6,
                'scope' => [],
            },
            'job-schedule-cron-day-of-week' => {
                'type' => 'cron-day-of-week',
                'flags' => 6,
                'scope' => [],
            },
            'job-schedule-cron-hour' => {
                'type' => 'cron-hour',
                'flags' => 6,
                'scope' => [],
            },
            'job-schedule-cron-minute' => {
                'type' => 'cron-minute',
                'flags' => 6,
                'scope' => [],
            },
            'job-schedule-cron-month' => {
                'type' => 'cron-month',
                'flags' => 6,
                'scope' => [],
            },
            'job-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-schedule-get' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-schedule-info',
                'flags' => 5,
                'scope' => [],
            },
            'job-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'job-schedule-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'job-schedule-get-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-schedule-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-schedule-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'job-schedule-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-schedule-interval-create' => {
        'category' => 'job',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'job-schedule-interval-days' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-schedule-interval-hours' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-schedule-interval-minutes' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-schedule-interval-seconds' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'job-schedule-interval-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'job-schedule-interval-destroy' => {
        'category' => 'job',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'job-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-schedule-interval-destroy-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-schedule-interval-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-schedule-interval-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-schedule-interval-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'job-schedule-interval-get' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-schedule-interval-info',
                'flags' => 5,
                'scope' => [],
            },
            'job-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'job-schedule-interval-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'job-schedule-interval-get-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'job-schedule-interval-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-schedule-interval-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'job-schedule-interval-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-schedule-interval-modify' => {
        'category' => 'job',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'job-schedule-interval-days' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-schedule-interval-hours' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-schedule-interval-minutes' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-schedule-interval-seconds' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-soft-pause' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-soft-pause-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-soft-pause-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-soft-pause-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'job-stop' => {
        'category' => 'job',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'job-stop-iter' => {
        'category' => 'job',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'job-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'job-stop-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'job-stop-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'kerberos-config-get' => {
        'category' => 'kerberos',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'kerberos-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'kerberos-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'kerberos-config-get-iter' => {
        'category' => 'kerberos',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'kerberos-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'kerberos-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'kerberos-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'kerberos-config-modify' => {
        'category' => 'kerberos',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'admin-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'admin-user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-kerberos-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'keytab-uri' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'organizational-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'service-principal-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'kerberos-realm-create' => {
        'category' => 'kerberos',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'ad-server-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'ad-server-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'admin-server-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'admin-server-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'clock-skew' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'config-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'kdc-ip' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'kdc-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'kdc-vendor' => {
                'type' => 'kdc-vendor',
                'flags' => 0,
                'scope' => [],
            },
            'password-server-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'password-server-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'realm' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'kerberos-realm-delete' => {
        'category' => 'kerberos',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'config-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'realm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'kerberos-realm-get-iter' => {
        'category' => 'kerberos',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'kerberos-realm',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'kerberos-realm',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'kerberos-realm',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'kerberos-realm-modify' => {
        'category' => 'kerberos',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'ad-server-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'ad-server-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'admin-server-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'admin-server-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'clock-skew' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'config-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'kdc-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'kdc-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'kdc-vendor' => {
                'type' => 'kdc-vendor',
                'flags' => 4,
                'scope' => [],
            },
            'password-server-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'password-server-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'realm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ldap-client-create' => {
        'category' => 'ldap',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'ad-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'allow-ssl' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'base-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'base-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
            'bind-as-cifs-server' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'bind-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'bind-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'group-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
            'is-netgroup-byhost-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ldap-client-config' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'min-bind-level' => {
                'type' => 'ldap-auth-method',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-byhost-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-byhost-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
            'preferred-ad-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'query-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'schema' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'tcp-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-start-tls' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'user-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'ldap-client',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'ldap-client-delete' => {
        'category' => 'ldap',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'ldap-client-config' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ldap-client-get-iter' => {
        'category' => 'ldap',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ldap-client',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ldap-client',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ldap-client',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ldap-client-modify' => {
        'category' => 'ldap',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'ad-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'allow-ssl' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'base-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'base-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
            'bind-as-cifs-server' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'bind-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'bind-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'group-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
            'is-netgroup-byhost-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ldap-client-config' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'min-bind-level' => {
                'type' => 'ldap-auth-method',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-byhost-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-byhost-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
            'preferred-ad-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'query-timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'schema' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'tcp-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-start-tls' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-dn' => {
                'type' => 'ldap-dn',
                'flags' => 4,
                'scope' => [],
            },
            'user-scope' => {
                'type' => 'ldap-search-scope',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ldap-client-schema-copy' => {
        'category' => 'ldap',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'new-schema-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schema' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ldap-client-schema-delete' => {
        'category' => 'ldap',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'schema' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ldap-client-schema-get-iter' => {
        'category' => 'ldap',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ldap-client-schema',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ldap-client-schema',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ldap-client-schema',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ldap-client-schema-modify' => {
        'category' => 'ldap',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'cn-group-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cn-netgroup-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'enable-rfc2307bis' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'gecos-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'gid-number-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-of-unique-names-object-class' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'home-directory-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'login-shell-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'member-nis-netgroup-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'member-uid-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nis-mapentry-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nis-mapname-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nis-netgroup-object-class' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nis-netgroup-triple-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nis-object-class' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'posix-account-object-class' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'posix-group-object-class' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'schema' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'uid-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'uid-number-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'unique-member-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user-password-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'windows-account-attribute' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ldap-config-create' => {
        'category' => 'ldap',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'client-config' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'client-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'ldap-config',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'ldap-config-delete' => {
        'category' => 'ldap',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'ldap-config-get-iter' => {
        'category' => 'ldap',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ldap-config',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ldap-config',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ldap-config',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ldap-config-modify' => {
        'category' => 'ldap',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'client-config' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'client-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'license-v2-add' => {
        'category' => 'license-v2',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'codes' => {
                'type' => 'license-code-v2',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
            'license-v2-failure-list' => {
                'type' => 'license-v2-result',
                'flags' => 7,
                'scope' => [],
            },
            'license-v2-success-list' => {
                'type' => 'license-v2-added',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'license-v2-cleanup-list-info' => {
        'category' => 'license-v2',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'licenses' => {
                'type' => 'license-v2-cleanup',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'license-v2-delete' => {
        'category' => 'license-v2',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'package' => {
                'type' => 'licensed-package',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'node-serial-number',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'license-v2-delete-expired' => {
        'category' => 'license-v2',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'license-v2-delete-unused' => {
        'category' => 'license-v2',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'license-v2-entitlement-risk-get-iter' => {
        'category' => 'license-v2',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'license-v2-entitlement-risk-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'license-v2-entitlement-risk-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'license-v2-entitlement-risk-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'license-v2-list-info' => {
        'category' => 'license-v2',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'licenses' => {
                'type' => 'license-v2-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'license-v2-status-list-info' => {
        'category' => 'license-v2',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'license-v2-status' => {
                'type' => 'license-v2-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lock-break-iter' => {
        'category' => 'lock',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lock-info',
                'flags' => 5,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'lock-break-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'lock-break-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lock-get-iter' => {
        'category' => 'lock',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'lock-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lock-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'lock-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-alignment-get-iter' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'lun-align-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lun-align-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'lun-align-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-clear-persistent-reservation-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-copy-cancel' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'lun-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-copy-get-iter' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'lun-copy-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lun-copy-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'lun-copy-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-copy-modify' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'lun-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-throughput' => {
                'type' => 'size',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-copy-pause' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'lun-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-copy-resume' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'lun-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-copy-start' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'destination-vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
            'max-throughput' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'paths' => {
                'type' => 'lun-path-pair',
                'flags' => 3,
                'scope' => [],
            },
            'promote-early' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'reference-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-vserver' => {
                'type' => 'vserver-name',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-create-by-size' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'class' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'foreign-disk' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'ostype' => {
                'type' => 'lun-os-type',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'prefix-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'qos-policy-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'space-allocation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'space-reservation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'actual-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-create-from-file' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'class' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ostype' => {
                'type' => 'lun-os-type',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qos-policy-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'space-allocation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'space-reservation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'actual-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-destroy' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'destroy-fenced-lun' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-get-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-attributes' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'lun-attribute-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-get-comment' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'comment' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-geometry' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'bytes-per-sector' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'cylinders' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'max-resize-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'sectors-per-track' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tracks-per-cylinder' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-inquiry-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'firmware-revision' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'product-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vendor-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-iter' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'lun-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lun-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'lun-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-errors' => {
                'type' => 'volume-error',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-get-maxsize' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'lun-os-type',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'with-complete-snapshot-reserve' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'with-snapshot-reserve' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'without-snapshot-reserve' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-minsize' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'type' => {
                'type' => 'lun-os-type',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'min-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-occupied-size' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'occupied-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-persistent-reservation-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'persistent-reservation' => {
                'type' => 'persistent-reservation-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-get-select-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'creation-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'previous-serial' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'select-attribute' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-serial-number' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-space-reservation-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-get-vdisk-attributes' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'filer-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-has-scsi-reservations' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-reservation-held' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-import-create' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'foreign-disk' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-import-delete' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'foreign-disk' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-import-get-iter' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'lun-import-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lun-import-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'lun-import-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-import-pause' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-import-resume' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-import-start' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-import-stop' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-import-throttle' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'max-throughput-limit' => {
                'type' => 'size',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-import-verify-start' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-import-verify-stop' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-initiator-list-map-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'lun-maps' => {
                'type' => 'lun-map-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-initiator-logged-in' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-logged-in' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-map' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'additional-reporting-node' => {
                'type' => 'node-name',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'lun-id-assigned' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-map-add-reporting-nodes' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'destination-aggregate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-volume' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'igroup' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nodes' => {
                'type' => 'filer-id',
                'flags' => 6,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-map-get-iter' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'lun-map-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lun-map-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'lun-map-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-errors' => {
                'type' => 'volume-error',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-map-list-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'initiator-groups' => {
                'type' => 'initiator-group-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'lun-map-remove-reporting-nodes' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'igroup' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nodes' => {
                'type' => 'filer-id',
                'flags' => 6,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-move' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'new-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-move-cancel' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'lun-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-move-get-iter' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'lun-move-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lun-move-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'lun-move-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-move-modify' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'lun-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-throughput' => {
                'type' => 'size',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-move-pause' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'lun-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-move-resume' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'lun-index' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-move-start' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'max-throughput' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'paths' => {
                'type' => 'lun-path-pair',
                'flags' => 3,
                'scope' => [],
            },
            'promote-late' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'reference-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-offline' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-online' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-os-type-list' => {
        'category' => 'lun',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'ostypes' => {
                'type' => 'system-api-enum-value-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lun-port-has-scsi-reservations' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-reservation-held' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-resize' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'actual-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-set-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-comment' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'comment' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-device-id' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'device-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'device-id-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-qos-policy-group' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qos-policy-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-select-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'select-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-serial-number' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-space-alloc' => {
        'category' => 'lun',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'enable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-set-space-reservation-info' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'enable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-stats-get-iter' => {
        'category' => 'lun',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'lun-stats-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lun-stats-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'lun-stats-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-unmap' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'initiator-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-unset-attribute' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-unset-device-id' => {
        'category' => 'lun',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'device-id-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster', 'ontap-vserver'],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'metrocluster-check-aggregate-eligibility-get' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'aggregate' => {
                'type' => 'aggr-name',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'metrocluster-check-aggregate-eligibility-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'metrocluster-check-aggregate-eligibility-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'metrocluster-check-aggregate-eligibility-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-check-aggregate-eligibility-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-check-aggregate-eligibility-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-check-aggregate-eligibility-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-check-aggregate-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-check-aggregate-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-check-aggregate-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-check-aggregate-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-check-capture-status-get' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-check-capture-status-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'metrocluster-check-capture-status-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'metrocluster-check-cluster-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-check-cluster-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-check-cluster-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-check-cluster-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-check-config-replication-get' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-check-config-replication-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'metrocluster-check-config-replication-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'metrocluster-check-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-check-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-check-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-check-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-check-lif-repair-placement' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'lif' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'metrocluster-check-node-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-check-node-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-check-node-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-check-node-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-check-run' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'metrocluster-config-diff-get' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'config-cluster-diff-info',
                'flags' => 5,
                'scope' => [],
            },
            'destination-cluster-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'instance' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'keys' => {
                'type' => 'key-value-pair',
                'flags' => 2,
                'scope' => [],
            },
            'object' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-cluster-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'config-cluster-diff-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'metrocluster-config-diff-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'config-cluster-diff-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'config-cluster-diff-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'config-cluster-diff-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-config-replication-cluster-storage-configuration-get' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-cr-storage-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'metrocluster-cr-storage-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'metrocluster-config-replication-cluster-storage-configuration-modify' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'disallowed-aggregates' => {
                'type' => 'aggr-name',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'metrocluster-config-replication-resync-status-get' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-config-replication-resync-status-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'metrocluster-config-replication-resync-status-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'metrocluster-configure' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'refresh' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-get' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'metrocluster-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'metrocluster-heal' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'healing-phase' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-interconnect-adapter-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-interconnect-adapter',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-interconnect-adapter',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-interconnect-adapter',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-interconnect-mirror-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-interconnect-mirror',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-interconnect-mirror',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-interconnect-mirror',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-interconnect-mirror-multipath-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-interconnect-mirror-multipath',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-interconnect-mirror-multipath',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-interconnect-mirror-multipath',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-is-configured' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'is-mcc-config' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-node-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-node-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-node-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-node-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-operation-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-operation-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-operation-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-operation-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-progress-table-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-progress-table-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-progress-table-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-progress-table-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-show-lif-placement-failures-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-show-lif-placement-failures',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-show-lif-placement-failures',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-show-lif-placement-failures',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-switchback' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'override-cluster-stream-resync-errors' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'override-vetoes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'override-vserver-stream-resync-errors' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'simulate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-switchover' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'automatic' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-nvfail-all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'forced-on-disaster' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'override-vetoes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'retry-failed-nodes' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'simulate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-unconfigure' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'dr-group-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-vserver-get-iter' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'metrocluster-vserver-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'metrocluster-vserver-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'metrocluster-vserver-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metrocluster-vserver-resync' => {
        'category' => 'metrocluster',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cluster-name' => {
                'type' => 'cluster-name',
                'flags' => 0,
                'scope' => [],
            },
            'source-vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-create' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'name-mapping-direction',
                'flags' => 0,
                'scope' => [],
            },
            'pattern' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'replacement' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'name-mapping-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'name-mapping-delete' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'name-mapping-direction',
                'flags' => 0,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-get-iter' => {
        'category' => 'name-mapping',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'name-mapping-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'name-mapping-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'name-mapping-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'name-mapping-insert' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'name-mapping-direction',
                'flags' => 0,
                'scope' => [],
            },
            'pattern' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'replacement' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-modify' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'name-mapping-direction',
                'flags' => 0,
                'scope' => [],
            },
            'pattern' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'replacement' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-swap' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'direction' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'with-position' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-unix-group-add-user' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-unix-group-create' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'unix-group-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'name-mapping-unix-group-delete-user' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-unix-group-destroy' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-unix-group-get' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'unix-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'unix-group-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'name-mapping-unix-group-get-iter' => {
        'category' => 'name-mapping',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'unix-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'unix-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'unix-group-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'name-mapping-unix-group-modify' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'group-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-unix-user-create' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'full-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'user-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'unix-user-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'name-mapping-unix-user-destroy' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-mapping-unix-user-get' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'unix-user-info',
                'flags' => 5,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'unix-user-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'name-mapping-unix-user-get-iter' => {
        'category' => 'name-mapping',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'unix-user-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'unix-user-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'unix-user-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'name-mapping-unix-user-modify' => {
        'category' => 'name-mapping',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'full-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'user-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'name-service-dns-statistics-get-iter' => {
        'category' => 'nameservice',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'nameservice-dns-statistics',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'nameservice-dns-statistics',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'nameservice-dns-statistics',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'name-service-nis-show-bound' => {
        'category' => 'nameservice',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'nis-domain-show-bound',
                'flags' => 5,
                'scope' => [],
            },
            'nis-domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'nis-domain-show-bound',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'name-service-nis-show-bound-iter' => {
        'category' => 'nameservice',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'nis-domain-show-bound',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'nis-domain-show-bound',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'nis-domain-show-bound',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'name-service-nis-statistics-get-iter' => {
        'category' => 'nameservice',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'nameservice-nis-statistics',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'nameservice-nis-statistics',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'nameservice-nis-statistics',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-dns-statistics-clear' => {
        'category' => 'nameservice',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'name-server' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nameservice-get-hostname-from-ipv4' => {
        'category' => 'nameservice',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'show-source' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'canonical-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-get-ip-from-hostname' => {
        'category' => 'nameservice',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'address-family' => {
                'type' => 'address-family',
                'flags' => 4,
                'scope' => [],
            },
            'hostname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'show-source' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'ipaddress' => {
                'type' => 'ip-address',
                'flags' => 2,
                'scope' => [],
            },
            'source' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-get-ipv4-from-hostname' => {
        'category' => 'nameservice',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'hostname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'show-source' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'ipaddress' => {
                'type' => 'ip-address',
                'flags' => 2,
                'scope' => [],
            },
            'source' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-nis-statistics-clear' => {
        'category' => 'nameservice',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'server' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nameservice-nsswitch-create' => {
        'category' => 'nameservice',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'nameservice-database' => {
                'type' => 'nss-db-type',
                'flags' => 0,
                'scope' => [],
            },
            'nameservice-sources' => {
                'type' => 'nss-source-type',
                'flags' => 2,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'namservice-nsswitch-config-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'nameservice-nsswitch-destroy' => {
        'category' => 'nameservice',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'nameservice-database' => {
                'type' => 'nss-db-type',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nameservice-nsswitch-get' => {
        'category' => 'nameservice',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'namservice-nsswitch-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'nameservice-database' => {
                'type' => 'nss-db-type',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'namservice-nsswitch-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'nameservice-nsswitch-get-iter' => {
        'category' => 'nameservice',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'namservice-nsswitch-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'namservice-nsswitch-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'namservice-nsswitch-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nameservice-nsswitch-modify' => {
        'category' => 'nameservice',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'nameservice-database' => {
                'type' => 'nss-db-type',
                'flags' => 0,
                'scope' => [],
            },
            'nameservice-sources' => {
                'type' => 'nss-source-type',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ndmp-password-generate' => {
        'category' => 'ndmp',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ndmp-password-info',
                'flags' => 5,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ndmp-password-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-active-routes-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'address-type' => {
                'type' => 'ipaddresstype',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'net-active-routes-info',
                'flags' => 5,
                'scope' => [],
            },
            'destination' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'interface' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'subnet-group' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-active-routes-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-active-routes-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-active-routes-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-active-routes-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-active-routes-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-arp-active-entry-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node-name' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'remotehost' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'subnet-group-name' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
            'vserver-name' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-arp-active-entry-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-arp-operational-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'remote-host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'subnet-group' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-arp-operational-info',
                'flags' => 1,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'mac-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-arp-active-entry-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-arp-operational-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-arp-operational-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-arp-operational-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-arp-create' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'mac' => {
                'type' => 'mac-address',
                'flags' => 0,
                'scope' => [],
            },
            'remotehost' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-arp-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'remotehost' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-arp-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-arp-info',
                'flags' => 5,
                'scope' => [],
            },
            'remotehost' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-arp-info',
                'flags' => 1,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mac' => {
                'type' => 'mac-address',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-arp-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-arp-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-arp-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-arp-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-check-failover' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'lif-capacity-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'lif-capacity-info',
                'flags' => 5,
                'scope' => [],
            },
            'source-nodes' => {
                'type' => 'filer-id',
                'flags' => 2,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'lif-capacity-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-cluster-ping' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'destination-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'interface' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'interface-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'retry-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-source-port' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'wait' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'wait-response' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-cluster-ping6' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'buffer-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'destination-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disable-fragmentation-all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disable-fragmentation-unicast' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'interface' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'interface-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'packet-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'retry-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-source-port' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-connections-receive-window-size-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'receive-buffer',
                'flags' => 5,
                'scope' => [],
            },
            'network' => {
                'type' => 'network-type',
                'flags' => 0,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'protocol-layer4',
                'flags' => 0,
                'scope' => [],
            },
            'service' => {
                'type' => 'stream-protocol-service',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'receive-buffer',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-connections-receive-window-size-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'receive-buffer',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'receive-buffer',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'receive-buffer',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-connections-receive-window-size-modify' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'network' => {
                'type' => 'network-type',
                'flags' => 0,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'protocol-layer4',
                'flags' => 0,
                'scope' => [],
            },
            'receive-auto-tune' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'receive-buffer' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'service' => {
                'type' => 'stream-protocol-service',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ddns-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ddns-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-ddns-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-ddns-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ddns-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-ddns-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-ddns-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-ddns-modify' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'domain-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ttl' => {
                'type' => 'time-interval',
                'flags' => 4,
                'scope' => [],
            },
            'use-secure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-device-discovery-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-device-discovery-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-device-discovery-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-device-discovery-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-dns-create' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'attempts' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dns-state' => {
                'type' => 'enable',
                'flags' => 4,
                'scope' => [],
            },
            'domains' => {
                'type' => 'string',
                'flags' => 2,
                'scope' => [],
            },
            'name-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'net-dns-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-dns-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-dns-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-dns-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-dns-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-dns-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-dns-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-dns-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-dns-modify' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'attempts' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dns-state' => {
                'type' => 'enable',
                'flags' => 4,
                'scope' => [],
            },
            'domains' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'name-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-failover-group-add-targets' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'failover-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'targets' => {
                'type' => 'net-qualified-port-name',
                'flags' => 2,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-failover-group-create' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'failover-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'targets' => {
                'type' => 'net-qualified-port-name',
                'flags' => 2,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'net-failover-group-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-failover-group-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'failover-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-failover-group-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-failover-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'failover-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-failover-group-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-failover-group-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-failover-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-failover-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-failover-group-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-failover-group-modify' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'failover-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'targets' => {
                'type' => 'net-qualified-port-name',
                'flags' => 6,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-failover-group-remove-targets' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'failover-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'targets' => {
                'type' => 'net-qualified-port-name',
                'flags' => 2,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-failover-group-rename' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'failover-group' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'new-failover-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-firewall-config-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-firewall-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-firewall-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-firewall-config-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-firewall-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-firewall-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-firewall-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-firewall-config-modify' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-logging' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-firewall-config-modify-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'net-firewall-config-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-firewall-config-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'net-firewall-config-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'net-firewall-config-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'net-firewall-policy-create' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'allow-list' => {
                'type' => 'ip-and-mask',
                'flags' => 2,
                'scope' => [],
            },
            'policy' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'service' => {
                'type' => 'fw-service',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'net-firewall-policy-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-firewall-policy-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'policy' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'service' => {
                'type' => 'fw-service',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-firewall-policy-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-firewall-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'policy' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'service' => {
                'type' => 'fw-service',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-firewall-policy-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-firewall-policy-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-firewall-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-firewall-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-firewall-policy-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-firewall-policy-modify' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'allow-list' => {
                'type' => 'ip-and-mask',
                'flags' => 6,
                'scope' => [],
            },
            'policy' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'service' => {
                'type' => 'fw-service',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-hosts-create' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'aliases' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'host-ip-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'hostname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'hosts-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-hosts-destroy' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'host-ip-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-hosts-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'hosts-info',
                'flags' => 5,
                'scope' => [],
            },
            'host-ip-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'hosts-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-hosts-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'hosts-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'hosts-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'hosts-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-hosts-modify' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'aliases' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'host-ip-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'hostname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-interface-create' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'administrative-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'data-protocols' => {
                'type' => 'data-protocol',
                'flags' => 6,
                'scope' => [],
            },
            'dns-domain-name' => {
                'type' => 'dns-zone',
                'flags' => 4,
                'scope' => [],
            },
            'failover-group' => {
                'type' => 'failover-group',
                'flags' => 4,
                'scope' => [],
            },
            'failover-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'firewall-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force-subnet-association' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'home-node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'home-port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-auto-revert' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dns-update-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-ipv4-link-local' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'listen-for-dns-query' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'netmask' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'netmask-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'role' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'routing-group-name' => {
                'type' => 'routing-group',
                'flags' => 4,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 4,
                'scope' => [],
            },
            'use-failover-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'net-interface-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-interface-delete' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-interface-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-interface-info',
                'flags' => 5,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-interface-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-interface-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-interface-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-interface-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-interface-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-interface-migrate' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destination-node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'destination-port' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'lif' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-node' => {
                'type' => 'node-name',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-interface-modify' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'administrative-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dns-domain-name' => {
                'type' => 'dns-zone',
                'flags' => 4,
                'scope' => [],
            },
            'failover-group' => {
                'type' => 'failover-group',
                'flags' => 4,
                'scope' => [],
            },
            'failover-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'firewall-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'force-subnet-association' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'home-node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'home-port' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-auto-revert' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dns-update-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-ipv4-link-local' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'listen-for-dns-query' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'netmask' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'netmask-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'routing-group-name' => {
                'type' => 'routing-group',
                'flags' => 4,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 4,
                'scope' => [],
            },
            'use-failover-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-interface-modify-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'net-interface-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-interface-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'net-interface-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'net-interface-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'net-interface-revert' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ipspaces-create' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'net-ipspaces-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-ipspaces-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ipspaces-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'broadcast-domains' => {
                'type' => 'broadcast-domain-name',
                'flags' => 6,
                'scope' => [],
            },
            'ports' => {
                'type' => 'net-qualified-port-name',
                'flags' => 6,
                'scope' => [],
            },
            'vservers' => {
                'type' => 'vserver-name',
                'flags' => 2,
                'scope' => [],
            },
        },
    },
    'net-ipspaces-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ipspaces-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-ipspaces-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-ipspaces-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-ipspaces-rename' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'new-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ndp-active-neighbor-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'neighbor' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
            'subnet-group' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ndp-active-neighbor-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ndp-neighbor-cache-info',
                'flags' => 5,
                'scope' => [],
            },
            'neighbor' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
            'subnet-group' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vif-owner-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-ndp-neighbor-cache-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-ndp-active-neighbor-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ndp-neighbor-cache-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-ndp-neighbor-cache-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-ndp-neighbor-cache-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-ndp-default-router-delete-all' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ndp-default-router-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ndp-default-router-info',
                'flags' => 5,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
            'router-addr' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-ndp-default-router-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-ndp-default-router-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ndp-default-router-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-ndp-default-router-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-ndp-default-router-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-ndp-neighbor-create' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'mac-address' => {
                'type' => 'mac-address',
                'flags' => 0,
                'scope' => [],
            },
            'neighbor-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'ndp-neighbor-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-ndp-neighbor-destroy' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'neighbor-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ndp-neighbor-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ndp-neighbor-info',
                'flags' => 5,
                'scope' => [],
            },
            'neighbor-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ndp-neighbor-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-ndp-neighbor-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ndp-neighbor-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ndp-neighbor-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ndp-neighbor-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-ndp-prefix-delete-all' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-ndp-prefix-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ndp-prefix-info',
                'flags' => 5,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
            'prefix' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-ndp-prefix-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-ndp-prefix-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ndp-prefix-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-ndp-prefix-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-ndp-prefix-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-options-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
        },
        'outputs' => {
            'net-options' => {
                'type' => 'net-options',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-options-modify' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'net-options' => {
                'type' => 'net-options',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-placement-cache-delete' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'netmask-length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-placement-cache-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-placement-cache',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-placement-cache',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-placement-cache',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-placement-discover' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'mac' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'netmask-length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-port-broadcast-domain-add-ports' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ports' => {
                'type' => 'net-qualified-port-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
            'port-update-status-combined' => {
                'type' => 'broadcast-domain-port-status',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-port-broadcast-domain-create' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mtu' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ports' => {
                'type' => 'net-qualified-port-name',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
            'port-update-status-combined' => {
                'type' => 'broadcast-domain-port-status',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'net-port-broadcast-domain-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'port-update-status-combined' => {
                'type' => 'broadcast-domain-port-status',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'net-port-broadcast-domain-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'net-port-broadcast-domain-info',
                'flags' => 5,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-port-broadcast-domain-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-port-broadcast-domain-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-port-broadcast-domain-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-port-broadcast-domain-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-port-broadcast-domain-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-port-broadcast-domain-merge' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'into-broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-port-broadcast-domain-modify' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'mtu' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'port-update-status-combined' => {
                'type' => 'broadcast-domain-port-status',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'net-port-broadcast-domain-remove-ports' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ports' => {
                'type' => 'net-qualified-port-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
            'port-update-status-combined' => {
                'type' => 'broadcast-domain-port-status',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-port-broadcast-domain-rename' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'new-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-port-broadcast-domain-split' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'new-broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'ports' => {
                'type' => 'net-qualified-port-name',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-port-delete' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-port-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-port-info',
                'flags' => 5,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-port-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-port-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-port-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-port-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-port-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-port-ifgrp-add-port' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ifgrp-name' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-port-ifgrp-create' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'distribution-function' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ifgrp-name' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'net-ifgrp-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-port-ifgrp-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ifgrp-name' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-port-ifgrp-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-ifgrp-info',
                'flags' => 5,
                'scope' => [],
            },
            'ifgrp-name' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-ifgrp-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-port-ifgrp-remove-port' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ifgrp-name' => {
                'type' => 'lif-bindable',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-port-modify' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'administrative-duplex' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'administrative-flowcontrol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'administrative-speed' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'autorevert-delay' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-administrative-auto-negotiate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-administrative-up' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mtu' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'mtu-admin' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'port' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'role' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-port-modify-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'net-port-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-port-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'net-port-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'net-port-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'net-routes-create' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'destination' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
            'gateway' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'metric' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'net-vs-routes-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-routes-destroy' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'destination' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
            'gateway' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-routes-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-vs-routes-info',
                'flags' => 5,
                'scope' => [],
            },
            'destination' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
            'gateway' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-vs-routes-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-routes-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-vs-routes-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-vs-routes-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-vs-routes-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-routes-lifs-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-vs-routes-lif-info',
                'flags' => 5,
                'scope' => [],
            },
            'destination' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
            'gateway' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-vs-routes-lif-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-routes-lifs-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-vs-routes-lif-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-vs-routes-lif-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-vs-routes-lif-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-routing-group-route-create' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destination-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'gateway-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'metric' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'routing-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'routing-group-route-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-routing-group-route-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'destination-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'routing-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-routing-group-route-get' => {
        'category' => 'net',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'routing-group-route-info',
                'flags' => 5,
                'scope' => [],
            },
            'destination-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'routing-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'routing-group-route-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-routing-group-route-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'routing-group-route-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'routing-group-route-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'routing-group-route-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-san-lif-placement-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'adapter-type' => {
                'type' => 'adapter-type',
                'flags' => 0,
                'scope' => [],
            },
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 4,
                'scope' => [],
            },
            'ipspace-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'lifs-per-node' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'nodelist' => {
                'type' => 'node-name',
                'flags' => 6,
                'scope' => [],
            },
            'protocol' => {
                'type' => 'data-protocol',
                'flags' => 0,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'lif-placement' => {
                'type' => 'lif-placement-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'net-subnet-add-ranges' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force-update-lif-associations' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ip-ranges' => {
                'type' => 'ip-range',
                'flags' => 2,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-subnet-create' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'broadcast-domain' => {
                'type' => 'broadcast-domain-name',
                'flags' => 0,
                'scope' => [],
            },
            'force-update-lif-associations' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'gateway' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'ip-ranges' => {
                'type' => 'ip-range',
                'flags' => 6,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'subnet' => {
                'type' => 'ip-and-mask',
                'flags' => 0,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'net-subnet-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'net-subnet-destroy' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force-update-lif-associations' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-subnet-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-subnet-info',
                'flags' => 5,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'net-subnet-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-subnet-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'net-subnet-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'net-subnet-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'net-subnet-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'net-subnet-modify' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force-update-lif-associations' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'gateway' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'ip-ranges' => {
                'type' => 'ip-range',
                'flags' => 6,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subnet' => {
                'type' => 'ip-and-mask',
                'flags' => 4,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-subnet-remove-ranges' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force-update-lif-associations' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ip-ranges' => {
                'type' => 'ip-range',
                'flags' => 2,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-subnet-rename' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'new-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'subnet-name' => {
                'type' => 'subnet-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-traceroute6' => {
        'category' => 'net',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'debug-mode' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'destination-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'first-hop' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'gateway' => {
                'type' => 'remote-inet-address',
                'flags' => 4,
                'scope' => [],
            },
            'hop-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'interface' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'interface-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nqueries' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'numeric' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'packet-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-icmp6' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-udp' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'wait-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'raw-output' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'net-vlan-create' => {
        'category' => 'net',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'vlan-info' => {
                'type' => 'vlan-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-vlan-delete' => {
        'category' => 'net',
        'family' => ['ontap-c', 'ontap-cluster'],
        'inputs' => {
            'vlan-info' => {
                'type' => 'vlan-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'net-vlan-get' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'vlan-info',
                'flags' => 5,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'vlan-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'net-vlan-get-iter' => {
        'category' => 'net',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'vlan-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'vlan-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'vlan-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'netgroups-file-delete' => {
        'category' => 'netgroup',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'vserver-name' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
        },
    },
    'netgroups-file-get' => {
        'category' => 'netgroup',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'netgroups-file-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'member-netgroup' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'netgroups-file-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'netgroups-file-get-iter' => {
        'category' => 'netgroup',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'netgroups-file-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'netgroups-file-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'netgroups-file-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfs-disable' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'nfs-enable' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'nfs-exportfs-append-rules' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'rules' => {
                'type' => 'exports-rule-info',
                'flags' => 3,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'exported-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'loaded-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-append-rules-2' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'rules' => {
                'type' => 'exports-rule-info-2',
                'flags' => 3,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'exported-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'loaded-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-check-permission' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'pathname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'permission' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-permissible' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-delete-rules' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'all-pathnames' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'deleted-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
            'unexported-pathnames' => {
                'type' => 'pathname-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-list-rules' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'pathname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'rules' => {
                'type' => 'exports-rule-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-list-rules-2' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'pathname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'rules' => {
                'type' => 'exports-rule-info-2',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'nfs-exportfs-modify-rule' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'persistent' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'rule' => {
                'type' => 'exports-rule-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-exportfs-modify-rule-2' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'persistent' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'rule' => {
                'type' => 'exports-rule-info-2',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-get-supported-sec-flavors' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'sec-flavor' => {
                'type' => 'sec-flavor-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'nfs-service-create' => {
        'category' => 'nfs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'auth-sys-extended-groups' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'cached-cred-negative-ttl' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cached-cred-positive-ttl' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cached-transient-err-ttl' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'chown-mode' => {
                'type' => 'nfschownmode',
                'flags' => 4,
                'scope' => [],
            },
            'default-windows-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'default-windows-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'enable-ejukebox' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'extended-groups-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-nt-acl-for-root' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-mount-rootonly-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-netgroup-dns-domain-search' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfs-access-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfs-rootonly-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv2-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv3-connection-drop-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv3-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv3-fsid-change-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv4-fsid-change-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv4-numeric-ids-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-acl-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-migration-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-read-delegation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-referrals-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-req-open-confirm-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-write-delegation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-acl-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-acl-preserve-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-migration-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-pnfs-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-read-delegation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-referrals-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-state-protection-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-write-delegation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-v3-ms-dos-client-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-validate-qtree-export-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vstorage-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'map-unknown-uid-to-default-windows-user' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mountd-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'name-service-lookup-protocol' => {
                'type' => 'export-lookup-protos',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-trust-any-ns-switch-no-match' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4-acl-max-aces' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4-grace-seconds' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4-id-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4-lease-seconds' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv41-implementation-id-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv41-implementation-id-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv41-implementation-id-time' => {
                'type' => 'date',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4x-session-num-slots' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4x-session-slot-reply-cache-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nlm-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nsm-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ntacl-display-permissive-perms' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ntfs-unix-security-ops' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'permitted-enc-types' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'rpcsec-ctx-high' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rpcsec-ctx-idle' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rquotad-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'showmount' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'skip-root-owner-write-perm-check' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'nfs-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'nfs-service-destroy' => {
        'category' => 'nfs',
        'family' => ['ontap-vserver'],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'nfs-service-get' => {
        'category' => 'nfs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'nfs-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'nfs-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'nfs-service-get-create-defaults' => {
        'category' => 'nfs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'attributes' => {
                'type' => 'nfs-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'defaults' => {
                'type' => 'nfs-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'nfs-service-get-iter' => {
        'category' => 'nfs',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'nfs-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'nfs-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'nfs-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nfs-service-modify' => {
        'category' => 'nfs',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'auth-sys-extended-groups' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'cached-cred-negative-ttl' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cached-cred-positive-ttl' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'cached-transient-err-ttl' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'chown-mode' => {
                'type' => 'nfschownmode',
                'flags' => 4,
                'scope' => [],
            },
            'default-windows-group' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'default-windows-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'enable-ejukebox' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'extended-groups-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ignore-nt-acl-for-root' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-mount-rootonly-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-netgroup-dns-domain-search' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfs-access-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfs-rootonly-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv2-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv3-connection-drop-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv3-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv3-fsid-change-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv4-fsid-change-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv4-numeric-ids-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-acl-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-migration-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-read-delegation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-referrals-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-req-open-confirm-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv40-write-delegation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-acl-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-acl-preserve-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-migration-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-pnfs-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-read-delegation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-referrals-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-state-protection-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nfsv41-write-delegation-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-v3-ms-dos-client-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-validate-qtree-export-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-vstorage-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'map-unknown-uid-to-default-windows-user' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mountd-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'name-service-lookup-protocol' => {
                'type' => 'export-lookup-protos',
                'flags' => 4,
                'scope' => [],
            },
            'netgroup-trust-any-ns-switch-no-match' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4-acl-max-aces' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4-grace-seconds' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4-id-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4-lease-seconds' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv41-implementation-id-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv41-implementation-id-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv41-implementation-id-time' => {
                'type' => 'date',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4x-session-num-slots' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nfsv4x-session-slot-reply-cache-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nlm-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nsm-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ntacl-display-permissive-perms' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ntfs-unix-security-ops' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'permitted-enc-types' => {
                'type' => 'string',
                'flags' => 6,
                'scope' => [],
            },
            'rpcsec-ctx-high' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rpcsec-ctx-idle' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rquotad-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'showmount' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'skip-root-owner-write-perm-check' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nfs-status' => {
        'category' => 'nfs',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'is-drained' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nis-create' => {
        'category' => 'nis',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'is-active' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'nis-domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nis-servers' => {
                'type' => 'ip-address',
                'flags' => 2,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'nis-domain-config-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'nis-destroy' => {
        'category' => 'nis',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'nis-domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'nis-get' => {
        'category' => 'nis',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'nis-domain-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'nis-domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'nis-domain-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'nis-get-iter' => {
        'category' => 'nis',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'nis-domain-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'nis-domain-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'nis-domain-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'nis-modify' => {
        'category' => 'nis',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'is-active' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'nis-domain' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nis-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ntp-server-create' => {
        'category' => 'ntp-server',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'is-preferred' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'server-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'ntp-server-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'ntp-server-delete' => {
        'category' => 'ntp-server',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'server-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ntp-server-get' => {
        'category' => 'ntp-server',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ntp-server-info',
                'flags' => 5,
                'scope' => [],
            },
            'server-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'ntp-server-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'ntp-server-get-iter' => {
        'category' => 'ntp-server',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'ntp-server-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'ntp-server-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'ntp-server-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ntp-server-modify' => {
        'category' => 'ntp-server',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'is-preferred' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'server-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ntp-server-reset' => {
        'category' => 'ntp-server',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'use-public' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ntp-server-validate' => {
        'category' => 'ntp-server',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'server-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'options-get' => {
        'category' => 'options',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cluster-constraint' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'options-get-iter' => {
        'category' => 'options',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'option-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'option-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'option-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'options-list-info' => {
        'category' => 'options',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
        },
        'outputs' => {
            'options' => {
                'type' => 'option-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'options-modify-iter' => {
        'category' => 'options',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'attributes' => {
                'type' => 'option-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'option-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'options-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'options-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'options-set' => {
        'category' => 'options',
        'family' => ['ontap-c', 'ontap-d', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cluster-constraint' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-archive-config-get' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'archive-config-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'archive-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'perf-archive-config-modify' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'datastore-file-rotation' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'datastore-max-percent' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'datastore-max-retention' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'opm-file-rotation' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'perfstat-sampling-period' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-archive-create' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'archive' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'case-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'end-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'source-nodes' => {
                'type' => 'node-name',
                'flags' => 6,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'perf-archive-info',
                'flags' => 5,
                'scope' => [],
            },
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-archive-datastore-get-iter' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'age-filter' => {
                'type' => 'perf-archive-datafile-age-filter',
                'flags' => 4,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'perf-archive-datastore-info',
                'flags' => 5,
                'scope' => [],
            },
            'is-partial-shown' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'perf-archive-datastore-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'perf-archive-datastore-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-archive-destroy' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'archive' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-archive-get-iter' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'perf-archive-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'perf-archive-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'perf-archive-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-archive-modify' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'archive' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'case-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-object-counter-list-info' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'filter-data' => {
                'type' => 'filter-data',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
            'objectname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'counters' => {
                'type' => 'counter-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-object-get-instances' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'counters' => {
                'type' => 'counter',
                'flags' => 6,
                'scope' => [],
            },
            'filter-data' => {
                'type' => 'filter-data',
                'flags' => 4,
                'scope' => ['ontap-cluster', 'ontap-vserver'],
            },
            'instance-uuids' => {
                'type' => 'instance-uuid',
                'flags' => 6,
                'scope' => ['ontap-cluster', 'ontap-vserver'],
            },
            'instances' => {
                'type' => 'instance',
                'flags' => 6,
                'scope' => [],
            },
            'objectname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'privilege-level' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-cluster', 'ontap-vserver'],
            },
        },
        'outputs' => {
            'instances' => {
                'type' => 'instance-data',
                'flags' => 3,
                'scope' => [],
            },
            'timestamp' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-instance-list-info-iter' => {
        'category' => 'perf',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'instance-info',
                'flags' => 5,
                'scope' => [],
            },
            'filter-data' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'objectname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'query' => {
                'type' => 'instance-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'instance-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-list-info' => {
        'category' => 'perf',
        'family' => ['ontap-c', 'ontap-cluster', 'ontap-d', 'ontap-vserver'],
        'inputs' => {
            'filter-data' => {
                'type' => 'filter-data',
                'flags' => 4,
                'scope' => ['ontap-cluster'],
            },
        },
        'outputs' => {
            'objects' => {
                'type' => 'object-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-preset-create' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'expiration-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-archive-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'preset' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'preset-detail-infos' => {
                'type' => 'preset-detail-info',
                'flags' => 7,
                'scope' => [],
            },
            'privilege' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-preset-delete' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'preset' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-preset-detail-get' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'preset' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'expiration-end-date' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'expiration-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'generation-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-archive-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-read-only' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'preset' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'preset-detail-infos' => {
                'type' => 'preset-detail-info',
                'flags' => 3,
                'scope' => [],
            },
            'privilege' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-preset-get-iter' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'preset-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'preset-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'preset-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-preset-import' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'expiration-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-archive-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'preset' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'privilege' => {
                'type' => 'privilege-level',
                'flags' => 4,
                'scope' => [],
            },
            'source-uri' => {
                'type' => 'uri',
                'flags' => 0,
                'scope' => [],
            },
            'uri-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'uri-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-preset-modify' => {
        'category' => 'perf',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'expiration-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-archive-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'new-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'preset' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'privilege' => {
                'type' => 'privilege-level',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'portset-add' => {
        'category' => 'portset',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portset-port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'portset-create' => {
        'category' => 'portset',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portset-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'portset-destroy' => {
        'category' => 'portset',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'portset-get-iter' => {
        'category' => 'portset',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'portset-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'portset-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'portset-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'portset-remove' => {
        'category' => 'portset',
        'family' => ['ontap-c', 'ontap-vserver'],
        'inputs' => {
            'portset-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'portset-port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-policy-create' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'policy-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qos-policy-destroy' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'policy-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-policy-destroy-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-policy-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-policy-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-policy-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-policy-get' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'policy-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'qos-policy-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'qos-policy-get-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'qos-policy-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qos-policy-group-create' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'max-throughput' => {
                'type' => 'qos-tput',
                'flags' => 4,
                'scope' => [],
            },
            'policy-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'qos-policy-group-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'qos-policy-group-delete' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'policy-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-policy-group-delete-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-policy-group-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-policy-group-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-policy-group-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-policy-group-get' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-policy-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'policy-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'qos-policy-group-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'qos-policy-group-get-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-policy-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-policy-group-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'qos-policy-group-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qos-policy-group-modify' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'max-throughput' => {
                'type' => 'qos-tput',
                'flags' => 4,
                'scope' => [],
            },
            'policy-group' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-policy-group-modify-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'qos-policy-group-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-policy-group-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-policy-group-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-policy-group-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-policy-group-rename' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'new-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-policy-modify' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'cache-policy-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'policy-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
            'read-ahead-policy-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-policy-modify-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'qos-policy-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-policy-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-policy-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-policy-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-policy-read-ahead-create' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'align-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'default' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disk-response-factor' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-response-weight' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'early-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'force-dump' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-full' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-none' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'interarrival-weight' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'jitter' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-deadline' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-disk-response-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-gap' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-range' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-retire-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'metadata-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-disk-response-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-range' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-retire-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'overshoot' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'read-ahead-class' => {
                'type' => 'qos-class',
                'flags' => 4,
                'scope' => [],
            },
            'read-ahead-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'smallfile-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-async' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-feedback' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-timing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'qos-policy-read-ahead-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'qos-policy-read-ahead-destroy' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'read-ahead-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-policy-read-ahead-destroy-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-policy-read-ahead-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-policy-read-ahead-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-policy-read-ahead-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-policy-read-ahead-get' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-policy-read-ahead-info',
                'flags' => 5,
                'scope' => [],
            },
            'read-ahead-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'qos-policy-read-ahead-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'qos-policy-read-ahead-get-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-policy-read-ahead-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-policy-read-ahead-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'qos-policy-read-ahead-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qos-policy-read-ahead-modify' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'align-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'default' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disk-response-factor' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-response-weight' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'early-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'force-dump' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-full' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-none' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'interarrival-weight' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'jitter' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-deadline' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-disk-response-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-gap' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-range' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-retire-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'metadata-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-disk-response-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-range' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-retire-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'overshoot' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'read-ahead-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'smallfile-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-async' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-feedback' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-timing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-policy-read-ahead-modify-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'qos-policy-read-ahead-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-policy-read-ahead-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-policy-read-ahead-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-policy-read-ahead-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-settings-archived-workload-get' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-settings-archived-workload-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'qos-settings-archived-workload-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'qos-settings-archived-workload-modify' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'max-workloads' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-settings-control-get' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-settings-control-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'qos-settings-control-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'qos-settings-control-modify' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'enforcement' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'policy-deactivation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ratebucket-rebalance' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-settings-read-ahead-create' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'align-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'default' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disk-response-factor' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-response-weight' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'early-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'force-dump' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-full' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-none' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'interarrival-weight' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'jitter' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-deadline' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-disk-response-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-gap' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-range' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-retire-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'metadata-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-disk-response-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-file-histogram' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-range' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-retire-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'overshoot' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'read-ahead-class' => {
                'type' => 'qos-class',
                'flags' => 4,
                'scope' => [],
            },
            'read-ahead-setting-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'smallfile-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-async' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-feedback' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-histogram' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-timing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'qos-settings-read-ahead-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'qos-settings-read-ahead-destroy' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'read-ahead-setting-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-settings-read-ahead-destroy-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-settings-read-ahead-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-settings-read-ahead-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-settings-read-ahead-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-settings-read-ahead-get' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-settings-read-ahead-info',
                'flags' => 5,
                'scope' => [],
            },
            'read-ahead-setting-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'qos-settings-read-ahead-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'qos-settings-read-ahead-get-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-settings-read-ahead-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-settings-read-ahead-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'qos-settings-read-ahead-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qos-settings-read-ahead-modify' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'align-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'default' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disk-response-factor' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-response-weight' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'early-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'force-dump' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-full' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'force-none' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'interarrival-weight' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'jitter' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-deadline' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-disk-response-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-gap' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-range' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-retire-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'metadata-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-disk-response-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-file-histogram' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-range' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-retire-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'overshoot' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'read-ahead-setting-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'smallfile-blocks' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'use-async' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-feedback' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-histogram' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'use-timing' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-settings-read-ahead-modify-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'qos-settings-read-ahead-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-settings-read-ahead-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-settings-read-ahead-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-settings-read-ahead-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-stream-create' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'characteristics' => {
                'type' => 'qos-stream-characteristics',
                'flags' => 1,
                'scope' => [],
            },
            'workload-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'stream-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qos-stream-destroy' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'stream-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'workload-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-stream-destroy-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-stream-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-stream-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-stream-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-stream-get' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-stream-info',
                'flags' => 5,
                'scope' => [],
            },
            'stream-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'workload-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'qos-stream-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'qos-stream-get-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-stream-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-stream-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'qos-stream-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qos-test-smf-zapi-error' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'error-op-code' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-workload-create' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'workload-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'workload-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qos-workload-delete' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'workload-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-workload-delete-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-workload-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-workload-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-workload-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-workload-destroy' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'workload-uuid' => {
                'type' => 'uuid',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-workload-destroy-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-workload-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-workload-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-workload-destroy-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qos-workload-get' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-workload-info',
                'flags' => 5,
                'scope' => [],
            },
            'workload-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'qos-workload-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'qos-workload-get-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qos-workload-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-workload-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'qos-workload-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qos-workload-modify' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'read-ahead' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'workload-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qos-workload-modify-iter' => {
        'category' => 'qos',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'qos-workload-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qos-workload-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'qos-workload-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'qos-workload-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'qtree-create' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'export-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'oplocks' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'security-style' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-delete' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-delete-async' => {
        'category' => 'qtree',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qtree-list-iter' => {
        'category' => 'qtree',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'qtree-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'qtree-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'qtree-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qtree-modify' => {
        'category' => 'qtree',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'export-policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'oplocks' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'security-style' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-rename' => {
        'category' => 'qtree',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'new-qtree-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-add-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'perform-user-mapping' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-delete-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-get-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'perform-user-mapping' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'quota-error' => {
                'type' => 'quota-error',
                'flags' => 5,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-list-entries-iter' => {
        'category' => 'quota',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'quota-entry',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'quota-entry',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'quota-entry',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-modify-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'perform-user-mapping' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-off' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'quota-on' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
        },
    },
    'quota-policy-copy' => {
        'category' => 'quota',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'new-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-policy-create' => {
        'category' => 'quota',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-policy-delete' => {
        'category' => 'quota',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-policy-delete-iter' => {
        'category' => 'quota',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'quota-policy-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'quota-policy-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'quota-policy-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'quota-policy-get-iter' => {
        'category' => 'quota',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'quota-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'quota-policy-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'quota-policy-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-policy-rename' => {
        'category' => 'quota',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'new-policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-report-iter' => {
        'category' => 'quota',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'quota',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'quota',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'quota',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-resize' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result-error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'result-error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'result-jobid' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'result-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
        },
    },
    'quota-set-entry' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'perform-user-mapping' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'policy' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => ['ontap-vserver'],
            },
            'qtree' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'quota-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'soft-disk-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'soft-file-limit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'quota-status' => {
        'category' => 'quota',
        'family' => ['ontap-c', 'ontap-vserver', 'vfiler'],
        'inputs' => {
            'volume' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'percent-complete' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'quota-errors' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'substatus' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'quota-status-iter' => {
        'category' => 'quota',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'quota-status-attributes',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'quota-status-attributes',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'quota-status-attributes',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-trace-filter-create' => {
        'category' => 'sectrace',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'client-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'enabled' => {
                'type' => 'enable',
                'flags' => 4,
                'scope' => [],
            },
            'index' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'time-enabled' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'trace-allow' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'unix-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'windows-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'security-trace-filter-attributes',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'security-trace-filter-delete' => {
        'category' => 'sectrace',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'index' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-trace-filter-get-iter' => {
        'category' => 'sectrace',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'security-trace-filter-attributes',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-trace-filter-attributes',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'security-trace-filter-attributes',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-trace-filter-modify' => {
        'category' => 'sectrace',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'client-ip' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'enabled' => {
                'type' => 'enable',
                'flags' => 4,
                'scope' => [],
            },
            'index' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'time-enabled' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'trace-allow' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'unix-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'windows-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-trace-result-delete' => {
        'category' => 'sectrace',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'node' => {
                'type' => 'node-name',
                'flags' => 0,
                'scope' => [],
            },
            'seqnum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-trace-result-show' => {
        'category' => 'sectrace',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'security-trace-results-logs',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-trace-results-logs',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'security-trace-results-logs',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-login-create' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'application' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'authentication-method' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'role-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snmpv3-login-info' => {
                'type' => 'snmpv3-login-info',
                'flags' => 5,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-login-delete' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'application' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'authentication-method' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-login-delete-iter' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-login-account-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'security-login-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'security-login-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'security-login-get' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'application' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'authentication-method' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'security-login-account-info',
                'flags' => 5,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'security-login-account-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'security-login-get-iter' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'security-login-account-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-login-account-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'security-login-account-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-login-lock' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-login-modify' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'application' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'authentication-method' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'comment' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'role-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-login-modify-iter' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'security-login-account-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-login-account-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'security-login-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'security-login-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'security-login-modify-password' => {
        'category' => 'security',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'new-password' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-login-role-config-get' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'security-login-role-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'role-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'security-login-role-config-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'security-login-role-config-get-iter' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'security-login-role-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-login-role-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'security-login-role-config-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-login-role-config-modify' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'change-password-duration-in-days' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'last-passwords-disallowed-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lockout-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-failed-login-attempts' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-passwd-specialchar' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-password-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'min-username-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'password-expiration-duration' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'require-initial-password-update' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'require-password-alpha-numeric' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'require-username-alpha-numeric' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'role-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-login-role-config-modify-iter' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'security-login-role-config-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-login-role-config-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'security-login-role-config-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'security-login-role-config-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'security-login-role-create' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'access-level' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'command-directory-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'return-record' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'role-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'role-query' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'result' => {
                'type' => 'security-login-role-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'security-login-role-delete' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'command-directory-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'role-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-login-role-delete-iter' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-login-role-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'security-login-role-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'security-login-role-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'security-login-role-get' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'command-directory-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'security-login-role-info',
                'flags' => 5,
                'scope' => [],
            },
            'role-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'security-login-role-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'security-login-role-get-iter' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'security-login-role-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-login-role-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'security-login-role-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-login-role-modify' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'access-level' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'command-directory-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'role-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'role-query' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-login-role-modify-iter' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'attributes' => {
                'type' => 'security-login-role-info',
                'flags' => 1,
                'scope' => [],
            },
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-login-role-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'security-login-role-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'security-login-role-modify-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'security-login-unlock' => {
        'category' => 'security',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-ssh-add' => {
        'category' => 'security',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'ciphers' => {
                'type' => 'ciphers',
                'flags' => 6,
                'scope' => [],
            },
            'key-exchange-algorithms' => {
                'type' => 'kex-algorithms',
                'flags' => 6,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-ssh-get-iter' => {
        'category' => 'security',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'security-ssh-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'security-ssh-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'security-ssh-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-ssh-remove' => {
        'category' => 'security',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'ciphers' => {
                'type' => 'ciphers',
                'flags' => 6,
                'scope' => [],
            },
            'key-exchange-algorithms' => {
                'type' => 'kex-algorithms',
                'flags' => 6,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'vserver-name',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-ssh-reset' => {
        'category' => 'security',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'ciphers' => {
                'type' => 'ciphers',
                'flags' => 6,
                'scope' => [],
            },
            'key-exchange-algorithms' => {
                'type' => 'kex-algorithms',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-certificate-ca-issued-get' => {
        'category' => 'security-certificate',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'ca-serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'certificate-authority' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'certificate-ca-issued-info',
                'flags' => 5,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'certificate-ca-issued-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'security-certificate-ca-issued-get-iter' => {
        'category' => 'security-certificate',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'certificate-ca-issued-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'certificate-ca-issued-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'certificate-ca-issued-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-certificate-create' => {
        'category' => 'security-certificate',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'common-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'country' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'email-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'expire-days' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hash-function' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-system-internal-certificate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'locality' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'organization' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'organization-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-certificate-delete' => {
        'category' => 'security-certificate',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'certificate-authority' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'common-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-system-internal-certificate' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subtype' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vserver' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'security-certificate-delete-iter' => {
        'category' => 'security-certificate',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'continue-on-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-failure-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'certificate-info',
                'flags' => 1,
                'scope' => [],
            },
            'return-failure-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'return-success-list' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'failure-list' => {
                'type' => 'security-certificate-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-failed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'num-succeeded' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'success-list' => {
                'type' => 'security-certificate-delete-iter-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'security-certificate-file-get-iter' => {
        'category' => 'security-certificate',
        'family' => ['ontap-cluster'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'certificate-file-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'certificate-file-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'certificate-file-info',
                'flags' => 7,
                'scope' => [],
            },
            'next-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'num-records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-certificate-generate-csr' => {
        'category' => 'security-certificate',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'common-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'country' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'email-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hash-function' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'locality' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'organization' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'organization-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'size' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'csr' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'private-key' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'security-certificate-get' => {
        'category' => 'security-certificate',
        'family' => ['ontap-vserver'],
        'inputs' => {
            'certificate-authority' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'common-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'desired-attributes' => {
                'type' => 'certificate-info',
                'flags' => 5,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subtype' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes' => {
                'type' => 'certificate-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'security-certificate-get-iter' => {
        'category' => 'security-certificate',
        'family' => ['ontap-cluster', 'ontap-vserver'],
        'inputs' => {
            'desired-attributes' => {
                'type' => 'certificate-info',
                'flags' => 5,
                'scope' => [],
            },
            'max-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'query' => {
                'type' => 'certificate-info',
                'flags' => 5,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list'