##
# $Id$
# 
# Copyright (c) 2015 Network Appliance, Inc.
# All rights reserved.
# 
# This file was generated at Jul 15, 2015 9:17:41 PM
##

package OCUMClassicAPI;

use strict;

use constant FIELD_SCALAR => 0x0;
use constant FIELD_TYPEDEF => 0x1;
use constant FIELD_ARRAY => 0x2;
use constant FIELD_OPTIONAL => 0x4;
use constant FIELD_ENCRYPTED => 0x8;

my $APIS = {
    'aggregate-list-info-iter-end' => {
        'category' => 'aggregate',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggregate-list-info-iter-next' => {
        'category' => 'aggregate',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'aggregates' => {
                'type' => 'aggregate-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggregate-list-info-iter-start' => {
        'category' => 'aggregate',
        'family' => [],
        'inputs' => {
            'aggregate-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'block-type' => {
                'type' => 'file-system-block-type',
                'flags' => 4,
                'scope' => [],
            },
            'include-dataset-space-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-direct-member-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-unprotected' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'rbac-operation' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-filter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volumes-to-migrate' => {
                'type' => 'object-name-or-id',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggregate-modify' => {
        'category' => 'aggregate',
        'family' => [],
        'inputs' => {
            'aggregate-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'aggregate-space-management-add-operation' => {
        'category' => 'aggregate',
        'family' => [],
        'inputs' => {
            'space-management-operation-info' => {
                'type' => 'space-management-operation-info',
                'flags' => 1,
                'scope' => [],
            },
            'space-management-session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'aggregate-diff-space-infos' => {
                'type' => 'aggregate-space-info',
                'flags' => 3,
                'scope' => [],
            },
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'aggregate-space-management-begin' => {
        'category' => 'aggregate',
        'family' => [],
        'inputs' => {
            'aggregate-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'space-management-session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggregate-space-management-commit' => {
        'category' => 'aggregate',
        'family' => [],
        'inputs' => {
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'space-management-session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'aggregate-space-infos' => {
                'type' => 'aggregate-space-info',
                'flags' => 7,
                'scope' => [],
            },
            'space-management-results' => {
                'type' => 'space-management-result-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'aggregate-space-management-remove-operation' => {
        'category' => 'aggregate',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'space-management-op-type' => {
                'type' => 'space-management-op-type',
                'flags' => 0,
                'scope' => [],
            },
            'space-management-session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'aggregate-diff-space-infos' => {
                'type' => 'aggregate-space-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'aggregate-space-management-rollback' => {
        'category' => 'aggregate',
        'family' => [],
        'inputs' => {
            'space-management-session-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'alarm-create' => {
        'category' => 'alarm',
        'family' => [],
        'inputs' => {
            'alarm-info' => {
                'type' => 'alarm-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'alarm-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'alarm-destroy' => {
        'category' => 'alarm',
        'family' => [],
        'inputs' => {
            'alarm-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'alarm-get-defaults' => {
        'category' => 'alarm',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'alarm-defaults' => {
                'type' => 'alarm-defaults',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'alarm-list-info-iter-end' => {
        'category' => 'alarm',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'alarm-list-info-iter-next' => {
        'category' => 'alarm',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'alarm-list' => {
                'type' => 'alarm-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'alarm-list-info-iter-start' => {
        'category' => 'alarm',
        'family' => [],
        'inputs' => {
            'alarm-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'alarm-modify' => {
        'category' => 'alarm',
        'family' => [],
        'inputs' => {
            'alarm-info' => {
                'type' => 'alarm-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'alarm-test' => {
        'category' => 'alarm',
        'family' => [],
        'inputs' => {
            'alarm-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'api-proxy' => {
        'category' => 'api',
        'family' => [],
        'inputs' => {
            'request' => {
                'type' => 'request',
                'flags' => 1,
                'scope' => [],
            },
            'target' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'response' => {
                'type' => 'response',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'application-policy-copy' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'application-policy-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'application-policy-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'source-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'application-policy-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'application-policy-create' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'application-policy-info' => {
                'type' => 'application-policy-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'application-policy-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'application-policy-destroy' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'application-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'application-policy-edit-begin' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'application-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'application-policy-edit-commit' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'application-policy-edit-rollback' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'application-policy-list-iter-end' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'application-policy-list-iter-next' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'application-policies' => {
                'type' => 'application-policy-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'application-policy-list-iter-start' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'application-policy-type' => {
                'type' => 'application-policy-type',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'application-policy-modify' => {
        'category' => 'application-policy',
        'family' => [],
        'inputs' => {
            'application-policy-info' => {
                'type' => 'application-policy-info',
                'flags' => 1,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'audit-log-add-entry' => {
        'category' => 'audit',
        'family' => [],
        'inputs' => {
            'audit-application-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'audit-interface' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'audit-ip-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'audit-message' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'audit-priority' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'audit-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-domain-list-info-iter-end' => {
        'category' => 'cifs',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'cifs-domain-list-info-iter-next' => {
        'category' => 'cifs',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'cifs-domain-list' => {
                'type' => 'cifs-domain-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-domain-list-info-iter-start' => {
        'category' => 'cifs',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'client-registry-destroy' => {
        'category' => 'client',
        'family' => [],
        'inputs' => {
            'application-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'match' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'option' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'client-registry-get' => {
        'category' => 'client',
        'family' => [],
        'inputs' => {
            'application-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'match' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'option' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'options' => {
                'type' => 'client-option-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'client-registry-set' => {
        'category' => 'client',
        'family' => [],
        'inputs' => {
            'application-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'options' => {
                'type' => 'client-option-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'comment-field-create' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'comment-field-info' => {
                'type' => 'comment-field-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'comment-field-id' => {
                'type' => 'comment-field-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'comment-field-destroy' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'comment-field-name-or-id' => {
                'type' => 'comment-field-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'comment-field-list-info-iter-end' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'comment-field-list-info-iter-next' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'comment-fields' => {
                'type' => 'comment-field-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'comment-field-list-info-iter-start' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'comment-field-name-or-id' => {
                'type' => 'comment-field-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'comment-field-object-types' => {
                'type' => 'comment-field-object-type',
                'flags' => 6,
                'scope' => [],
            },
            'show-system-comments' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'comment-field-modify' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'comment-field-name-or-id' => {
                'type' => 'comment-field-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'comment-field-object-types' => {
                'type' => 'comment-field-object-type',
                'flags' => 6,
                'scope' => [],
            },
            'new-comment-field-name' => {
                'type' => 'comment-field-name',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'comment-field-values-list-info-iter-end' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'comment-field-values-list-info-iter-next' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'comment-field-values' => {
                'type' => 'comment-field-value',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'comment-field-values-list-info-iter-start' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'comment-field-name-or-id' => {
                'type' => 'comment-field-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'comment-field-object-types' => {
                'type' => 'comment-field-object-type',
                'flags' => 6,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'comment-set-object-value' => {
        'category' => 'comment',
        'family' => [],
        'inputs' => {
            'comment-field-name-or-id' => {
                'type' => 'comment-field-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'comment-value' => {
                'type' => 'comment-value',
                'flags' => 0,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-add-member' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-member-parameters' => {
                'type' => 'dataset-member-parameter',
                'flags' => 3,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-existing-member-ok' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-add-member-by-dynamic-reference' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-dynamic-reference-parameters' => {
                'type' => 'dataset-dynamic-reference-parameter',
                'flags' => 3,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-add-resourcepool' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'resourcepool-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-add-to-exclusion-list' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-excluded-member-ok' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'objects-to-be-added' => {
                'type' => 'obj-name-or-id',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-begin-failover' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-begin-failover-script-test' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-change-dr-state' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'allow-internal-transitions' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'dr-state' => {
                'type' => 'dr-state',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-compute-usage-metric' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'compute-io-usage-metric' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'compute-space-usage-metric' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-conform-begin' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'assume-confirmation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-create' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'application-info' => {
                'type' => 'application-info',
                'flags' => 5,
                'scope' => [],
            },
            'application-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-access-details' => {
                'type' => 'dataset-access-details',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-contact' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-metadata' => {
                'type' => 'dfm-metadata-field',
                'flags' => 7,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'is-application-data' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-suspended' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-suspended' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'online-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'primary-volume-name-format' => {
                'type' => 'primary-volume-name-format',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'requires-non-disruptive-restore' => {
                'type' => 'requires-non-disruptive-restore',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-qtree-name-format' => {
                'type' => 'secondary-qtree-name-format',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-volume-name-format' => {
                'type' => 'secondary-volume-name-format',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-name-format' => {
                'type' => 'snapshot-name-format',
                'flags' => 4,
                'scope' => [],
            },
            'timezone-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'volume-qtree-name-prefix' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-destroy' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'cancel-edit-sessions' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-dynamic-reference-list-info-iter-end' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-dynamic-reference-list-info-iter-next' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dataset-dynamic-references' => {
                'type' => 'dataset-dynamic-reference-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-dynamic-reference-list-info-iter-start' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'dynamic-reference-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'storageset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'suppress-status-refresh' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-edit-begin' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-edit-commit' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'assume-confirmation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'include-dry-run-reason-details' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'conformance-alerts' => {
                'type' => 'conformance-alert',
                'flags' => 7,
                'scope' => [],
            },
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
            'is-provisioning-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'job-ids' => {
                'type' => 'job-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'dataset-edit-rollback' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-exclusion-list-info-iter-end' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-exclusion-list-info-iter-next' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'exclusion-list' => {
                'type' => 'excluded-object-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-exclusion-list-info-iter-start' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-io-metric-list-info-iter-end' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-io-metric-list-info-iter-next' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dataset-io-metrics' => {
                'type' => 'dataset-io-metric-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-io-metric-list-info-iter-start' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'day' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'month' => {
                'type' => 'month',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'year' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-list-info-iter-end' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-list-info-iter-next' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'datasets' => {
                'type' => 'dataset-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-list-info-iter-start' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'application-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'application-resource-namespace' => {
                'type' => 'application-resource-namespace',
                'flags' => 4,
                'scope' => [],
            },
            'application-server-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dr-state' => {
                'type' => 'dr-state',
                'flags' => 4,
                'scope' => [],
            },
            'has-application-policy' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'has-protection' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'has-protection-policy' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-can-contain-application-resources-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-can-contain-storage-resources-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-conformance-check-results' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-conformance-run-reason-details' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-export-settings' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-metadata' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-migration-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-protection-status-problems' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-application-data' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dr-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-protected' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'requires-non-disruptive-restore' => {
                'type' => 'requires-non-disruptive-restore',
                'flags' => 4,
                'scope' => [],
            },
            'suppress-status-refresh' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume-qtree-name-prefix' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-member-dedupe-abort' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dataset-member-dedupe-start' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'dedupe-member-request-info' => {
                'type' => 'dedupe-member-request-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-member-delete-snapshots' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'delete-snapshots-request-info' => {
                'type' => 'delete-snapshots-request-info',
                'flags' => 1,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-member-list-info-iter-end' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-member-list-info-iter-next' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dataset-members' => {
                'type' => 'dataset-member-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-member-list-info-iter-start' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-exports-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-indirect' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-space-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'member-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'member-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'member-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storageset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'suppress-status-refresh' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-member-undedupe-start' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'undedupe-member-request-info' => {
                'type' => 'undedupe-member-request-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-missing-member-list-info-iter-end' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-missing-member-list-info-iter-next' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'missing-members' => {
                'type' => 'missing-member-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-missing-member-list-info-iter-start' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-modify' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'application-info' => {
                'type' => 'application-info',
                'flags' => 5,
                'scope' => [],
            },
            'application-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'check-protection-policy-on-commit' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-contact' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-metadata' => {
                'type' => 'dfm-metadata-field',
                'flags' => 7,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-application-data' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-suspended' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-suspended' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'primary-volume-name-format' => {
                'type' => 'primary-volume-name-format',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'requires-non-disruptive-restore' => {
                'type' => 'requires-non-disruptive-restore',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-qtree-name-format' => {
                'type' => 'secondary-qtree-name-format',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-volume-name-format' => {
                'type' => 'secondary-volume-name-format',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-name-format' => {
                'type' => 'snapshot-name-format',
                'flags' => 4,
                'scope' => [],
            },
            'volume-qtree-name-prefix' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-modify-node' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-access-details' => {
                'type' => 'dataset-access-details',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-export-info' => {
                'type' => 'dataset-export-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'online-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'relinquish-vfiler' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'timezone-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-provision-member' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'provision-member-request-info' => {
                'type' => 'provision-member-request-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-remove-from-exclusion-list' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'objects-to-be-removed' => {
                'type' => 'obj-name-or-id',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-remove-member' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-member-parameters' => {
                'type' => 'dataset-member-parameter',
                'flags' => 3,
                'scope' => [],
            },
            'destroy' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-remove-member-by-dynamic-reference' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-dynamic-reference-parameters' => {
                'type' => 'dataset-dynamic-reference-parameter',
                'flags' => 3,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-remove-resourcepool' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'resourcepool-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-replace-primary-members' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'cancel-edit-sessions' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'replace-results' => {
                'type' => 'replace-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'dataset-resize-member' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'resize-member-request-info' => {
                'type' => 'resize-member-request-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-set' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'is-allow-custom-settings' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-enable-write-guarantee-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-none-guaranteed-provision' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-skip-autosize-conformance' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-luns-per-volume' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-qtrees-per-volume' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-set-storageset' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-space-metric-list-info-iter-end' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-space-metric-list-info-iter-next' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dataset-space-metrics' => {
                'type' => 'dataset-space-metric-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-space-metric-list-info-iter-start' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'day' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'month' => {
                'type' => 'month',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'year' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-update-dr-status' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dataset-update-protection-status' => {
        'category' => 'dataset',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-about' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'include-directory-size-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'cpu-count' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dfm-directories' => {
                'type' => 'directory-info',
                'flags' => 3,
                'scope' => [],
            },
            'edition' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'install-dir' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'installed-plugins' => {
                'type' => 'plugin',
                'flags' => 3,
                'scope' => [],
            },
            'licensed-features' => {
                'type' => 'feature',
                'flags' => 3,
                'scope' => [],
            },
            'mode' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'node-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'operating-system' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'prot-mgr-node-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'prov-mgr-node-limit' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'system-memory' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'system-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-backup-schedule-disable' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'dfm-backup-schedule-enable' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'dfm-backup-schedule-get' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'backup-type' => {
                'type' => 'backup-type',
                'flags' => 0,
                'scope' => [],
            },
            'day' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hour' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-schedule-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'minute' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'repeat-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-backup-schedule-set' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'backup-type' => {
                'type' => 'backup-type',
                'flags' => 4,
                'scope' => [],
            },
            'day' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hour' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-schedule-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'minute' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'repeat-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-backup-start' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'backup-type' => {
                'type' => 'backup-type',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-backup-status' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'backup-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-get-api-statistics' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'clear-api-stats' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'api-statistics' => {
                'type' => 'api-stat',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-get-resource-property-values' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'resource-property' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'resource-property-values' => {
                'type' => 'resource-property-values',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-monitor-timestamp-list' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dfm-monitoring-timestamps' => {
                'type' => 'dfm-monitoring-timestamp',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-object-refresh' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'child-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'monitor-names' => {
                'type' => 'monitor-name',
                'flags' => 6,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-objects-get-status' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'objects' => {
                'type' => 'obj-name-or-id',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
            'objects-status' => {
                'type' => 'obj-status-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-related-objects-list-info' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'include-indirect' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'child-count-list' => {
                'type' => 'child-count',
                'flags' => 7,
                'scope' => [],
            },
            'parent-dataset-list' => {
                'type' => 'parent-dataset',
                'flags' => 7,
                'scope' => [],
            },
            'parent-group-list' => {
                'type' => 'parent-group',
                'flags' => 7,
                'scope' => [],
            },
            'parent-object-list' => {
                'type' => 'parent-object',
                'flags' => 7,
                'scope' => [],
            },
            'parent-resourcepool-list' => {
                'type' => 'parent-resourcepool',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'dfm-server-list-diagnostic-info' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'diag-info' => {
                'type' => 'dfm-diag-counter-group',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-snmp-setting-add' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'host-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'network-address' => {
                'type' => 'network-address',
                'flags' => 4,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'prefix-length',
                'flags' => 0,
                'scope' => [],
            },
            'privacy-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'snmp-authentication-login' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-authentication-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'snmp-authentication-protocol' => {
                'type' => 'snmp-authentication-protocol',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-community-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-version' => {
                'type' => 'snmp-version',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'snmp-id' => {
                'type' => 'snmp-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-snmp-setting-delete' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'host-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'network-address' => {
                'type' => 'network-address',
                'flags' => 4,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'prefix-length',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-id' => {
                'type' => 'snmp-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-snmp-setting-modify' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'prefix-length' => {
                'type' => 'prefix-length',
                'flags' => 4,
                'scope' => [],
            },
            'privacy-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'snmp-authentication-login' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-authentication-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'snmp-authentication-protocol' => {
                'type' => 'snmp-authentication-protocol',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-community-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-id' => {
                'type' => 'snmp-id',
                'flags' => 0,
                'scope' => [],
            },
            'snmp-version' => {
                'type' => 'snmp-version',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-snmp-settings-list-info' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
            'host-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'network-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snmp-id' => {
                'type' => 'snmp-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'network-snmp-credentials' => {
                'type' => 'network-snmp-credential-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-user-priv-get' => {
        'category' => 'dfm',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'privilege' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-content-get' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'schedule-content-info' => {
                'type' => 'schedule-content-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-create' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'schedule-content-info' => {
                'type' => 'schedule-content-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'schedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-daily-add' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'daily-content' => {
                'type' => 'daily-info',
                'flags' => 1,
                'scope' => [],
            },
            'daily-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-daily-delete' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-daily-modify' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'daily-content' => {
                'type' => 'daily-info',
                'flags' => 1,
                'scope' => [],
            },
            'daily-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-dependency' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'schedule-assignees' => {
                'type' => 'schedule-assignee',
                'flags' => 3,
                'scope' => [],
            },
            'schedule-in-use' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-destroy' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-hourly-add' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'hourly-content' => {
                'type' => 'hourly-info',
                'flags' => 1,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-hourly-delete' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-hourly-modify' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'hourly-content' => {
                'type' => 'hourly-info',
                'flags' => 1,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-list' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'schedule-list' => {
                'type' => 'schedule-id-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-list-info-iter-end' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-list-info-iter-next' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-content-list' => {
                'type' => 'schedule-content-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-list-info-iter-start' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-modify' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'schedule-content-info' => {
                'type' => 'schedule-content-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-monthly-add' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'monthly-content' => {
                'type' => 'monthly-info',
                'flags' => 1,
                'scope' => [],
            },
            'monthly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-monthly-delete' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'monthly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-monthly-modify' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'monthly-content' => {
                'type' => 'monthly-info',
                'flags' => 1,
                'scope' => [],
            },
            'monthly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-monthly-subschedule-set' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'monthly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'subschedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-monthly-subschedule-unset' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'monthly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-rename' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'new-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-weekly-add' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-content' => {
                'type' => 'weekly-info',
                'flags' => 1,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-weekly-delete' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-weekly-modify' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-content' => {
                'type' => 'weekly-info',
                'flags' => 1,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-weekly-subschedule-add' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'end-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'start-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-schedule-weekly-subschedule-delete' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-schedule-weekly-subschedule-modify' => {
        'category' => 'dfm-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'end-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'start-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-list-info-iter-end' => {
        'category' => 'disk',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'disk-list-info-iter-next' => {
        'category' => 'disk',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'disks' => {
                'type' => 'disk-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'disk-list-info-iter-start' => {
        'category' => 'disk',
        'family' => [],
        'inputs' => {
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-content-list-iter-end' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-backup-content-list-iter-next' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'backup-contents' => {
                'type' => 'dp-backup-content-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-content-list-iter-start' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'primary-snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'root-object-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sub-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'suppress-child-count' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-get-location' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'paths' => {
                'type' => 'dp-backup-path-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
            'backup-locations' => {
                'type' => 'backup-location-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-backup-list-iter-end' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-backup-list-iter-next' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'backups' => {
                'type' => 'dp-backup-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-list-iter-start' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'application-resource-namespace' => {
                'type' => 'application-resource-namespace',
                'flags' => 4,
                'scope' => [],
            },
            'backup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'has-application-resources-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'has-storage-resources-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-backup-graph-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-metadata' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-metadata-host-service' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'is-mounted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-root-object-restorable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'root-object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'search-keys' => {
                'type' => 'search-key',
                'flags' => 6,
                'scope' => [],
            },
            'snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sub-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-mount-start' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'mount-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-start' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'backup-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-destination' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-destination-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-members' => {
                'type' => 'obj-name-or-id',
                'flags' => 6,
                'scope' => [],
            },
            'backup-script' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'hyperv-backup-settings-info' => {
                'type' => 'hyperv-backup-schedule-settings-info',
                'flags' => 5,
                'scope' => [],
            },
            'retention-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 4,
                'scope' => [],
            },
            'vmware-backup-settings-info' => {
                'type' => 'vmware-backup-schedule-settings-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-unmount-start' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'mount-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-version-create' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'backup-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-metadata' => {
                'type' => 'dfm-metadata',
                'flags' => 7,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'is-adding-members' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-complete' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-for-propagation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-native' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storageset-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'version-members' => {
                'type' => 'version-member-info',
                'flags' => 7,
                'scope' => [],
            },
            'version-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-version-delete' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'allow-deferred-delete' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'backup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'delete-multiple-backups' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-backup-version-list-iter-end' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-backup-version-list-iter-next' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'backup-versions' => {
                'type' => 'dp-backup-version-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-version-list-iter-start' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'include-is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-metadata' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'root-object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sub-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-version-modify' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'backup-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'backup-metadata' => {
                'type' => 'dfm-metadata',
                'flags' => 7,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'dp-backup-transfer-info' => {
                'type' => 'dp-backup-transfer-info',
                'flags' => 5,
                'scope' => [],
            },
            'is-adding-members' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-complete' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'version-members' => {
                'type' => 'version-member-info',
                'flags' => 7,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-get-dataset-backup-jobs-data' => {
        'category' => 'dp-backup',
        'family' => [],
        'inputs' => {
            'backup-destination' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'dp-jobs-data' => {
                'type' => 'dp-job-data',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-dashboard-get-dr-dataset-counts' => {
        'category' => 'dp-dashboard',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'dr-state-status-counts' => {
                'type' => 'dr-state-status-count',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-dashboard-get-lagged-datasets' => {
        'category' => 'dp-dashboard',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'max-datasets' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'dp-datasets' => {
                'type' => 'dp-dataset-lag-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-dashboard-get-lagged-relationships' => {
        'category' => 'dp-dashboard',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'is-external-relationship' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-relationships' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'dp-relationships' => {
                'type' => 'dp-relationship-lag-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-dashboard-get-protected-data-counts' => {
        'category' => 'dp-dashboard',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'ignored-dataset-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ignored-ossv-directory-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ignored-qtree-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ignored-volume-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protected-dataset-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protected-ossv-directory-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protected-qtree-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protected-volume-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unprotected-dataset-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unprotected-ossv-directory-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unprotected-qtree-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unprotected-volume-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-dashboard-get-protected-data-counts-2' => {
        'category' => 'dp-dashboard',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'ignored-dataset-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ignored-ossv-directory-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ignored-qtree-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ignored-volume-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protected-dataset-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protected-ossv-directory-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protected-qtree-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protected-volume-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unprotected-application-resources' => {
                'type' => 'application-resource-info',
                'flags' => 7,
                'scope' => [],
            },
            'unprotected-dataset-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unprotected-qtree-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unprotected-volume-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-job-abort' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-job-cleanup' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-job-list-iter-end' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-job-list-iter-next' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'jobs' => {
                'type' => 'dp-job-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-job-list-iter-start' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'job-context-application-resource-namespace' => {
                'type' => 'application-resource-namespace',
                'flags' => 4,
                'scope' => [],
            },
            'job-context-application-resources-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'job-context-obj-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-state' => {
                'type' => 'dp-job-state',
                'flags' => 4,
                'scope' => [],
            },
            'job-type' => {
                'type' => 'dp-job-type',
                'flags' => 4,
                'scope' => [],
            },
            'job-types' => {
                'type' => 'job-type',
                'flags' => 6,
                'scope' => [],
            },
            'max-jobs' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'started-timestamp-from' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'started-timestamp-to' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-job-progress-event-list-iter-end' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-job-progress-event-list-iter-next' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'progress-events' => {
                'type' => 'dp-job-progress-event-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-job-progress-event-list-iter-start' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'connection-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'end-time' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'history' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-type' => {
                'type' => 'dp-job-type',
                'flags' => 4,
                'scope' => [],
            },
            'job-types' => {
                'type' => 'job-type',
                'flags' => 6,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-job-purge' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'completed-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'purge-jobs-completed-with-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-job-schedule-get-last-changed' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'last-changed-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-job-schedule-list-iter-end' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-job-schedule-list-iter-next' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'scheduled-jobs' => {
                'type' => 'dp-scheduled-job',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-job-schedule-list-iter-start' => {
        'category' => 'dp-job',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'from-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'to-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-application-list-info-iter-end' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-ossv-application-list-info-iter-next' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'ossv-application-list' => {
                'type' => 'ossv-application-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-application-list-info-iter-start' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'ossv-application-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ossv-host-name-or-id' => {
                'type' => 'ossv-host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-application-restore-destination-list-info-iter-end' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-ossv-application-restore-destination-list-info-iter-next' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'ossv-application-restore-destination-list' => {
                'type' => 'ossv-application-restore-destination-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-application-restore-destination-list-info-iter-start' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'application-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-directory-add' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'directory-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ossv-host-name-or-id' => {
                'type' => 'ossv-host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'directory-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-directory-browse-iter-end' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-ossv-directory-browse-iter-next' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'subdirectories' => {
                'type' => 'dp-ossv-directory-name',
                'flags' => 2,
                'scope' => [],
            },
        },
    },
    'dp-ossv-directory-browse-iter-start' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'directory-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ossv-host-name-or-id' => {
                'type' => 'ossv-host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-directory-discovered-iter-end' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-ossv-directory-discovered-iter-next' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'directories' => {
                'type' => 'dp-ossv-directory-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-directory-discovered-iter-start' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'include-is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-backup-relationship' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-directory-modify' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'dp-ossv-directory-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-ossv-directory-roots-iter-end' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-ossv-directory-roots-iter-next' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'roots' => {
                'type' => 'dp-ossv-directory-root-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-ossv-directory-roots-iter-start' => {
        'category' => 'dp-ossv-directory',
        'family' => [],
        'inputs' => {
            'fs-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ossv-host-name-or-id' => {
                'type' => 'ossv-host-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-policy-copy' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
            'dp-policy-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dp-policy-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'template-dp-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'template-dp-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'dp-policy-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-policy-destroy' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-policy-edit-begin' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
            'dp-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-policy-edit-commit' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'dp-policy-edit-rollback' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-policy-get-default-property-values' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'backup-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'backup-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'backup-script-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'backup-script-run-as' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'daily-retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'daily-retention-duration' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'failover-script-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'failover-script-run-as' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'hourly-retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'hourly-retention-duration' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-lag-error-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-lag-warning-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'lag-error-threshold' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lag-warning-threshold' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'mirror-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'mirror-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'monthly-retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'monthly-retention-duration' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'throttle-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'throttle-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-retention-duration' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-policy-list-iter-end' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-policy-list-iter-next' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dp-policy-infos' => {
                'type' => 'dp-policy-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-policy-list-iter-start' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
            'dp-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'is-dr-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-policy-modify' => {
        'category' => 'dp-policy',
        'family' => [],
        'inputs' => {
            'dp-policy-content' => {
                'type' => 'dp-policy-content',
                'flags' => 1,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-relationship-list-info-iter-end' => {
        'category' => 'dp-relationship',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-relationship-list-info-iter-next' => {
        'category' => 'dp-relationship',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dp-relationships' => {
                'type' => 'dp-relationship-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-relationship-list-info-iter-start' => {
        'category' => 'dp-relationship',
        'family' => [],
        'inputs' => {
            'connection-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'destination-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'destination-type' => {
                'type' => 'relationship-endpoint-type',
                'flags' => 4,
                'scope' => [],
            },
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-managed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-migration-relationship' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'operational-statuses' => {
                'type' => 'operational-status',
                'flags' => 6,
                'scope' => [],
            },
            'relationship-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'relationship-states' => {
                'type' => 'relationship-state',
                'flags' => 6,
                'scope' => [],
            },
            'relationship-type' => {
                'type' => 'relationship-type',
                'flags' => 4,
                'scope' => [],
            },
            'source-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'source-or-destination-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'source-type' => {
                'type' => 'relationship-endpoint-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-relationship-modify' => {
        'category' => 'dp-relationship',
        'family' => [],
        'inputs' => {
            'is-dp-imported' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-managed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'relationship-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-restore-to-new-path' => {
        'category' => 'dp-restore',
        'family' => [],
        'inputs' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'check-overwrite' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'check-space-status' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'members' => {
                'type' => 'dp-recover-member-info',
                'flags' => 3,
                'scope' => [],
            },
            'migrate-relationship' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'overwrite-results' => {
                'type' => 'overwrite-result',
                'flags' => 7,
                'scope' => [],
            },
            'space-status-results' => {
                'type' => 'space-status-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'dp-restore-to-primary' => {
        'category' => 'dp-restore',
        'family' => [],
        'inputs' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'check-overwrite' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'check-space-status' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'paths' => {
                'type' => 'dp-path-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'overwrite-results' => {
                'type' => 'overwrite-result',
                'flags' => 7,
                'scope' => [],
            },
            'space-status-results' => {
                'type' => 'space-status-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'dp-restore-vi-start' => {
        'category' => 'dp-restore',
        'family' => [],
        'inputs' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dp-vi-restore-objects' => {
                'type' => 'dp-vi-restore-object',
                'flags' => 3,
                'scope' => [],
            },
            'dp-vi-restore-settings' => {
                'type' => 'dp-vi-restore-settings',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-schedule-content-get' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'schedule-content-info' => {
                'type' => 'schedule-content-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'dp-schedule-create' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'schedule-content-info' => {
                'type' => 'schedule-content-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'schedule-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-schedule-daily-add' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'daily-content' => {
                'type' => 'daily-info',
                'flags' => 1,
                'scope' => [],
            },
            'daily-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-schedule-daily-delete' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-daily-modify' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'daily-content' => {
                'type' => 'daily-info',
                'flags' => 1,
                'scope' => [],
            },
            'daily-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-dependency' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'schedule-assignees' => {
                'type' => 'schedule-assignee',
                'flags' => 3,
                'scope' => [],
            },
            'schedule-in-use' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-schedule-destroy' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-hourly-add' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'hourly-content' => {
                'type' => 'hourly-info',
                'flags' => 1,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-schedule-hourly-delete' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-hourly-modify' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'hourly-content' => {
                'type' => 'hourly-info',
                'flags' => 1,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-list' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'schedule-list' => {
                'type' => 'schedule-id-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-schedule-list-info-iter-end' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-list-info-iter-next' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-content-list' => {
                'type' => 'schedule-content-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-schedule-list-info-iter-start' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-schedule-modify' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'schedule-content-info' => {
                'type' => 'schedule-content-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-monthly-add' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'monthly-content' => {
                'type' => 'monthly-info',
                'flags' => 1,
                'scope' => [],
            },
            'monthly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-schedule-monthly-delete' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'monthly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-monthly-modify' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'monthly-content' => {
                'type' => 'monthly-info',
                'flags' => 1,
                'scope' => [],
            },
            'monthly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-monthly-subschedule-set' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'monthly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'subschedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-monthly-subschedule-unset' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'monthly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-rename' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'new-schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-weekly-add' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'weekly-content' => {
                'type' => 'weekly-info',
                'flags' => 1,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-schedule-weekly-delete' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-weekly-modify' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'weekly-content' => {
                'type' => 'weekly-info',
                'flags' => 1,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-weekly-subschedule-add' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'end-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'start-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-schedule-weekly-subschedule-delete' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-schedule-weekly-subschedule-modify' => {
        'category' => 'dp-schedule',
        'family' => [],
        'inputs' => {
            'daily-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'end-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'start-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-schedule-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-throttle-create' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'throttle-content' => {
                'type' => 'throttle-content',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'throttle-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-throttle-dependency' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'throttle-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'throttle-assignees' => {
                'type' => 'throttle-assignee',
                'flags' => 3,
                'scope' => [],
            },
            'throttle-in-use' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-throttle-destroy' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'throttle-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-throttle-item-add' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'throttle-item-content' => {
                'type' => 'throttle-item-info',
                'flags' => 1,
                'scope' => [],
            },
            'throttle-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-throttle-item-delete' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'throttle-item-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'throttle-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-throttle-list-info-iter-end' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-throttle-list-info-iter-next' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'throttle-list' => {
                'type' => 'throttle-content',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-throttle-list-info-iter-start' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'throttle-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-throttle-modify' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'throttle-content' => {
                'type' => 'throttle-content',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dp-throttle-rename' => {
        'category' => 'dp-throttle',
        'family' => [],
        'inputs' => {
            'new-throttle-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'throttle-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'event-acknowledge' => {
        'category' => 'event',
        'family' => [],
        'inputs' => {
            'event-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'event-id-list' => {
                'type' => 'event-id-type',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
            'event-acknowledged' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'events-acknowledged-list' => {
                'type' => 'event-action-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'event-delete' => {
        'category' => 'event',
        'family' => [],
        'inputs' => {
            'event-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'event-id-list' => {
                'type' => 'event-id-type',
                'flags' => 6,
                'scope' => [],
            },
        },
        'outputs' => {
            'event-deleted' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'events-deleted-list' => {
                'type' => 'event-action-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'event-generate' => {
        'category' => 'event',
        'family' => [],
        'inputs' => {
            'event-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'event-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'event-list-iter-end' => {
        'category' => 'event',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'event-list-iter-next' => {
        'category' => 'event',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'events' => {
                'type' => 'event-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'event-list-iter-start' => {
        'category' => 'event',
        'family' => [],
        'inputs' => {
            'event-application-list' => {
                'type' => 'event-application-type',
                'flags' => 6,
                'scope' => [],
            },
            'event-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'event-severities' => {
                'type' => 'obj-status',
                'flags' => 6,
                'scope' => [],
            },
            'event-source-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'event-type-filter-list' => {
                'type' => 'event-type-filter',
                'flags' => 7,
                'scope' => [],
            },
            'greater-than-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'include-dataset-resource-status-events' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-deleted-objects' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-event-arguments' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-related' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-acknowledged' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-history' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-most-severe-first' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-oldest-first' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-events' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'time-range' => {
                'type' => 'event-timestamp-range',
                'flags' => 5,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'event-status-change-list-iter-end' => {
        'category' => 'event',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'event-status-change-list-iter-next' => {
        'category' => 'event',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'events' => {
                'type' => 'event-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'event-status-change-list-iter-start' => {
        'category' => 'event',
        'family' => [],
        'inputs' => {
            'max-events' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-range' => {
                'type' => 'event-timestamp-range',
                'flags' => 1,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'eventclass-add-custom' => {
        'category' => 'eventclass',
        'family' => [],
        'inputs' => {
            'about-message' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-names' => {
                'type' => 'event-name-info',
                'flags' => 3,
                'scope' => [],
            },
            'event-namespace-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-allow-duplicates' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-multi-current' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'event-class-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'eventclass-delete-custom' => {
        'category' => 'eventclass',
        'family' => [],
        'inputs' => {
            'event-class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'eventclass-list' => {
        'category' => 'eventclass',
        'family' => [],
        'inputs' => {
            'event-class-objects' => {
                'type' => 'event-class-object',
                'flags' => 7,
                'scope' => [],
            },
        },
        'outputs' => {
            'event-classes' => {
                'type' => 'event-class-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'eventclass-list-iter-end' => {
        'category' => 'eventclass',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'eventclass-list-iter-next' => {
        'category' => 'eventclass',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'event-classes' => {
                'type' => 'event-class-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'eventclass-list-iter-start' => {
        'category' => 'eventclass',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'fcp-target-list-info-iter-end' => {
        'category' => 'fcp-target',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'fcp-target-list-info-iter-next' => {
        'category' => 'fcp-target',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'targets' => {
                'type' => 'target-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'fcp-target-list-info-iter-start' => {
        'category' => 'fcp-target',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'graph-data-list-info' => {
        'category' => 'graph',
        'family' => [],
        'inputs' => {
            'end-date' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'graph-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'graph-period' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-object' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-object' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'start-date' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'graph-line-values' => {
                'type' => 'graph-line-value-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'graph-list-info-iter-end' => {
        'category' => 'graph',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'graph-list-info-iter-next' => {
        'category' => 'graph',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'graphs' => {
                'type' => 'graph-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'graph-list-info-iter-start' => {
        'category' => 'graph',
        'family' => [],
        'inputs' => {
            'graph-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-add-member' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'member-name-or-id' => {
                'type' => 'object-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-copy' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'new-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'parent-group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-create' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'parent-group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-delete-member' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'member-name-or-id' => {
                'type' => 'object-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-destroy' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-get-options' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'group-option-info' => {
                'type' => 'group-option-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'group-get-status' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'group-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-is-member-of' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'object-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'is-member' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-list-iter-end' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-list-iter-next' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'group-list' => {
                'type' => 'group-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-list-iter-start' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'list-subgroups' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'rbac-operation' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-move' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'new-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'parent-group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-rename' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'new-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-set-options' => {
        'category' => 'group',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'group-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'group-option-info' => {
                'type' => 'group-option-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-member-list-iter-end' => {
        'category' => 'group_member',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'group-member-list-iter-next' => {
        'category' => 'group_member',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'group-member-list' => {
                'type' => 'group-member-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-member-list-iter-start' => {
        'category' => 'group_member',
        'family' => [],
        'inputs' => {
            'groups' => {
                'type' => 'group',
                'flags' => 6,
                'scope' => [],
            },
            'hide-subgroup-members' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-add' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'add-network' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'admin-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'block-cmode' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'host-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'agent-id' => {
                'type' => 'host-id',
                'flags' => 4,
                'scope' => [],
            },
            'appliance-id' => {
                'type' => 'host-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-add-license' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-license' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'suppress-inuse-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-add-ossv' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ndmp-credentials' => {
                'type' => 'full-ndmp-credentials',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ossv-id' => {
                'type' => 'host-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-agent-ossv-service-start' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'agent-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-agent-ossv-service-stop' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'agent-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-capability-list-iter-end' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-capability-list-iter-next' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'capabilities' => {
                'type' => 'capability',
                'flags' => 2,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-capability-list-iter-start' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-create-ndmpuser' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'ndmp-username' => {
                'type' => 'ndmp-username',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-delete' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'ignore-host-in-use' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-domainuser-add' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-domainuser-name-or-id-or-sid' => {
                'type' => 'domainuser-name-or-id-or-sid',
                'flags' => 0,
                'scope' => [],
            },
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-usergroup-names-or-ids' => {
                'type' => 'host-usergroup-name-or-id',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-domainuser-id' => {
                'type' => 'access-object-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-domainuser-list-iter-end' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-domainuser-list-iter-next' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-domainusers' => {
                'type' => 'host-domainuser-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-domainuser-list-iter-start' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-domainuser-name-or-id-or-sid' => {
                'type' => 'domainuser-name-or-id-or-sid',
                'flags' => 4,
                'scope' => [],
            },
            'host-usergroup-name-or-id' => {
                'type' => 'usergroup-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-domainuser-push' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-domainuser-name-or-id-or-sid' => {
                'type' => 'domainuser-name-or-id-or-sid',
                'flags' => 0,
                'scope' => [],
            },
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-domainuser-remove' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-domainuser-name-or-id-or-sid' => {
                'type' => 'domainuser-name-or-id-or-sid',
                'flags' => 0,
                'scope' => [],
            },
            'host-usergroup-names-or-ids' => {
                'type' => 'host-usergroup-name-or-id',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-get-defaults' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'host-defaults' => {
                'type' => 'host-defaults',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'host-list-info-iter-end' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-list-info-iter-next' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'hosts' => {
                'type' => 'host-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-list-info-iter-start' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'expand-filer-to-vfilers' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'host-dp-filter-info' => {
                'type' => 'host-dp-filter-info',
                'flags' => 5,
                'scope' => [],
            },
            'host-types' => {
                'type' => 'host-type',
                'flags' => 6,
                'scope' => [],
            },
            'include-is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-migration-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-perf-space-details' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-direct-member-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'license-filter' => {
                'type' => 'license',
                'flags' => 6,
                'scope' => [],
            },
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'query-host' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-ipspace' => {
                'type' => 'vfiler-ipspace',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-modify' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-modify-info' => {
                'type' => 'host-modify-info',
                'flags' => 1,
                'scope' => [],
            },
            'host-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-modify-agent-credentials' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'agent-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'management-password' => {
                'type' => 'host-password',
                'flags' => 4,
                'scope' => [],
            },
            'os-password' => {
                'type' => 'host-password',
                'flags' => 0,
                'scope' => [],
            },
            'os-username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-role-create' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-role' => {
                'type' => 'host-role-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-role-id' => {
                'type' => 'access-object-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-role-delete' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-role-name-or-id' => {
                'type' => 'access-object-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-role-list-iter-end' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-role-list-iter-next' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-roles' => {
                'type' => 'host-role-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-role-list-iter-start' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-role-name-or-id' => {
                'type' => 'access-object-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-role-modify' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-role' => {
                'type' => 'host-role-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-role-push' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-role-name-or-id' => {
                'type' => 'access-object-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-set-option' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-option-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-user-add' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-user' => {
                'type' => 'host-user-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-user-id' => {
                'type' => 'access-object-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-user-delete' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-user-name-or-id' => {
                'type' => 'access-object-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-user-list-iter-end' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-user-list-iter-next' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-users' => {
                'type' => 'host-user-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-user-list-iter-start' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-user-name-or-id' => {
                'type' => 'access-object-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-usergroup-name-or-id' => {
                'type' => 'usergroup-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-user-modify' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-user' => {
                'type' => 'host-user-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-user-modify-password' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-user-name-or-id' => {
                'type' => 'access-object-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'new-password' => {
                'type' => 'host-user-password',
                'flags' => 0,
                'scope' => [],
            },
            'old-password' => {
                'type' => 'host-user-password',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-user-push' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-user-name-or-id' => {
                'type' => 'access-object-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'password' => {
                'type' => 'host-user-password',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-usergroup-create' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-usergroup' => {
                'type' => 'host-usergroup-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-usergroup-id' => {
                'type' => 'access-object-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-usergroup-delete' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-usergroup-name-or-id' => {
                'type' => 'usergroup-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-usergroup-list-iter-end' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-usergroup-list-iter-next' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-usergroups' => {
                'type' => 'host-usergroup-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-usergroup-list-iter-start' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-usergroup-name-or-id' => {
                'type' => 'usergroup-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-usergroup-modify' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-usergroup' => {
                'type' => 'host-usergroup-info',
                'flags' => 1,
                'scope' => [],
            },
            'new-usergroup-name' => {
                'type' => 'usergroup-name',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-usergroup-push' => {
        'category' => 'host',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-usergroup-name-or-id' => {
                'type' => 'usergroup-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-service-authorize' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'host-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'run-discovery' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-service-configure' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'dfm-server-ip-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'storage-systems-configuration' => {
                'type' => 'storage-system-configuration',
                'flags' => 7,
                'scope' => [],
            },
            'vcenter-ip-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vcenter-password' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vcenter-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-service-discover' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'host-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'resource-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'resource-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'track-progress' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-service-list-info-iter-end' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-service-list-info-iter-next' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-services' => {
                'type' => 'host-service-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-service-list-info-iter-start' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'obj-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-service-modify' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'access-protocol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'admin-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'host-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'mgmt-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'update-service-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-service-package-delete' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'package-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-service-package-list' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'package-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-service-packages' => {
                'type' => 'host-service-package-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'host-service-register' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'admin-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dfm-server-ip-address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'mgmt-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'name-or-ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'suppress-registered-error' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'is-authorized' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-hyperv-cluster-host-service' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-service-storage-system-list-info-iter-end' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'host-service-storage-system-list-info-iter-next' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'storage-systems' => {
                'type' => 'storage-system-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'host-service-storage-system-list-info-iter-start' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'host-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-service-unregister' => {
        'category' => 'host-service',
        'family' => [],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'host-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ifc-list-info-iter-end' => {
        'category' => 'ifc',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ifc-list-info-iter-next' => {
        'category' => 'ifc',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'ifcs' => {
                'type' => 'ifc-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ifc-list-info-iter-start' => {
        'category' => 'ifc',
        'family' => [],
        'inputs' => {
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ldap-server-add' => {
        'category' => 'ldap',
        'family' => [],
        'inputs' => {
            'ldap-server' => {
                'type' => 'ldap-server',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ldap-server-delete' => {
        'category' => 'ldap',
        'family' => [],
        'inputs' => {
            'ldap-server' => {
                'type' => 'ldap-server',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'ldap-server-list-info' => {
        'category' => 'ldap',
        'family' => [],
        'inputs' => {
            'ldap-server' => {
                'type' => 'ldap-server',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'ldap-servers' => {
                'type' => 'ldap-server-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'lun-destroy' => {
        'category' => 'lun',
        'family' => [],
        'inputs' => {
            'lun-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-list-info-iter-end' => {
        'category' => 'lun',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'lun-list-info-iter-next' => {
        'category' => 'lun',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'luns' => {
                'type' => 'lun-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-list-info-iter-start' => {
        'category' => 'lun',
        'family' => [],
        'inputs' => {
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'rbac-operation' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-resize' => {
        'category' => 'lun',
        'family' => [],
        'inputs' => {
            'lun-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'new-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'resize-underlying-volume' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'migrate-cancel' => {
        'category' => 'migrate',
        'family' => [],
        'inputs' => {
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'migrate-change-state' => {
        'category' => 'migrate',
        'family' => [],
        'inputs' => {
            'new-migration-status' => {
                'type' => 'migration-status',
                'flags' => 0,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'migrate-cleanup' => {
        'category' => 'migrate',
        'family' => [],
        'inputs' => {
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'migrate-complete' => {
        'category' => 'migrate',
        'family' => [],
        'inputs' => {
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-cutover-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'migrate-offline' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'persistent-migrated-routes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'route-migration-mode' => {
                'type' => 'route-migration-mode',
                'flags' => 4,
                'scope' => [],
            },
            'run-dedupe-scan' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'script-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'migrate-fix' => {
        'category' => 'migrate',
        'family' => [],
        'inputs' => {
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'migrate-rollback' => {
        'category' => 'migrate',
        'family' => [],
        'inputs' => {
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-cutover-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'migrate-offline' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'persistent-migrated-routes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'route-migration-mode' => {
                'type' => 'route-migration-mode',
                'flags' => 4,
                'scope' => [],
            },
            'run-dedupe-scan' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'script-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'migrate-start' => {
        'category' => 'migrate',
        'family' => [],
        'inputs' => {
            'bandwidth-throttle' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ip-bindings' => {
                'type' => 'ip-binding-info',
                'flags' => 7,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'online-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'perform-cutover' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'persistent-migrated-routes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'resource-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'route-migration-mode' => {
                'type' => 'route-migration-mode',
                'flags' => 4,
                'scope' => [],
            },
            'run-dedupe-scan' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'script-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-aggregate-map' => {
                'type' => 'volume-aggregate-pair',
                'flags' => 7,
                'scope' => [],
            },
        },
        'outputs' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'migrate-update' => {
        'category' => 'migrate',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'migrate-volume' => {
        'category' => 'migrate',
        'family' => [],
        'inputs' => {
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'migration-request-info' => {
                'type' => 'migration-request-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'migration-dry-run-results' => {
                'type' => 'migration-dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
            'migration-jobs' => {
                'type' => 'migration-job-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'netif-ip-interface-list-info' => {
        'category' => 'netif',
        'family' => [],
        'inputs' => {
            'community-string' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hostname' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'interfaces' => {
                'type' => 'netif-ip-interface-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-network-add' => {
        'category' => 'networks',
        'family' => [],
        'inputs' => {
            'network-address' => {
                'type' => 'network-address',
                'flags' => 0,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'prefix-length',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'network-id' => {
                'type' => 'network-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-network-delete' => {
        'category' => 'networks',
        'family' => [],
        'inputs' => {
            'network-address' => {
                'type' => 'network-address',
                'flags' => 4,
                'scope' => [],
            },
            'network-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'dfm-network-list-info' => {
        'category' => 'networks',
        'family' => [],
        'inputs' => {
            'network-id' => {
                'type' => 'network-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'networks' => {
                'type' => 'network-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dfm-network-modify' => {
        'category' => 'networks',
        'family' => [],
        'inputs' => {
            'network-id' => {
                'type' => 'network-id',
                'flags' => 0,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'prefix-length',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-assoc-view-list-iter-end' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-assoc-view-list-iter-next' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'views' => {
                'type' => 'perf-view',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-assoc-view-list-iter-start' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'assoc-obj-type' => {
                'type' => 'perf-assoc-obj-type',
                'flags' => 4,
                'scope' => [],
            },
            'include-empty-views' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'verbose' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'view-type' => {
                'type' => 'view-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-client-stats-list-info-iter-end' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-client-stats-list-info-iter-next' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'hosts-client-stats' => {
                'type' => 'host-client-stats',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-client-stats-list-info-iter-start' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'end-time' => {
                'type' => 'timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'last-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'stat-id' => {
                'type' => 'stat-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-client-stats-purge' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'end-time' => {
                'type' => 'timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'stat-id' => {
                'type' => 'stat-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'deleted-stats-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-collect-client-operation-statistics' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'collection-period' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'errors' => {
                'type' => 'client-stat-error',
                'flags' => 7,
                'scope' => [],
            },
            'stat-id' => {
                'type' => 'stat-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-copy-counter-configuration' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'destination-objects' => {
                'type' => 'obj-name-or-id',
                'flags' => 2,
                'scope' => [],
            },
            'preview' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'source-host-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'src-is-default' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'copy-result' => {
                'type' => 'destination-host-info',
                'flags' => 3,
                'scope' => [],
            },
            'missing-host-object-counters' => {
                'type' => 'perf-missing-host-object-counter',
                'flags' => 7,
                'scope' => [],
            },
            'purged-host-object-counters' => {
                'type' => 'perf-purged-host-object-counter',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'perf-counter-group-create' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'counter-group' => {
                'type' => 'perf-counter-group',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-counter-group-destroy' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-counter-group-get-data' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'data-group' => {
                'type' => 'perf-data-group',
                'flags' => 1,
                'scope' => [],
            },
            'end-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sample-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-consolidation-method' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'counter-data' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-counter-group-get-dynamic-data-sources' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dynamic-data-sources' => {
                'type' => 'perf-dynamic-data-sources',
                'flags' => 1,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'data-sources' => {
                'type' => 'perf-data-source',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-counter-group-list-info' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'consolidate-hosts' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-info-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'custom-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disabled-counter-info-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'include-calculated-stats' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'meta-data-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'counter-groups' => {
                'type' => 'perf-counter-group',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-counter-group-list-iter-end' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-counter-group-list-iter-next' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'counter-groups' => {
                'type' => 'perf-counter-group',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-counter-group-list-iter-start' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'custom-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'meta-data-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-counter-group-modify' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-group' => {
                'type' => 'perf-counter-group',
                'flags' => 1,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-counter-group-start' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-counter-group-stop' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-diag-troubleshoot' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'end-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'categories' => {
                'type' => 'perf-diag-category',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-disable-data-collection' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'is-async' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-persistent' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-disable-object-update' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'perf-enable-data-collection' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'perf-enable-object-update' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
        },
    },
    'perf-get-counter-data' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'direction' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'end-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'instance-counter-info' => {
                'type' => 'instance-counter-info',
                'flags' => 1,
                'scope' => [],
            },
            'number-samples' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'sample-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-consolidation-method' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'time-filter' => {
                'type' => 'time-filter',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'invalid-counter-instances' => {
                'type' => 'invalid-counter-instance',
                'flags' => 7,
                'scope' => [],
            },
            'perf-instances' => {
                'type' => 'perf-instance-counter-data',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'perf-get-counter-dependents' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'counters' => {
                'type' => 'perf-object-counter',
                'flags' => 3,
                'scope' => [],
            },
            'host-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'base-counters' => {
                'type' => 'perf-object-counter',
                'flags' => 7,
                'scope' => [],
            },
            'dependent-counters' => {
                'type' => 'perf-object-counter',
                'flags' => 7,
                'scope' => [],
            },
            'reports' => {
                'type' => 'perf-report',
                'flags' => 7,
                'scope' => [],
            },
            'threshold-templates' => {
                'type' => 'threshold-template',
                'flags' => 7,
                'scope' => [],
            },
            'thresholds' => {
                'type' => 'perf-threshold',
                'flags' => 7,
                'scope' => [],
            },
            'views' => {
                'type' => 'perf-view',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'perf-get-counter-list-not-in-view' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'object-counter-list' => {
                'type' => 'perf-object-counter-info',
                'flags' => 3,
                'scope' => [],
            },
        },
        'outputs' => {
            'orphan-object-counter-list' => {
                'type' => 'perf-object-counter-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-get-default-view' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'view-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-get-server-status' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'perf-server-status' => {
                'type' => 'perf-server-status',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'perf-object-counter-list-info' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'include-calculated-stats' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'counters' => {
                'type' => 'perf-counter',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-object-dependent-counter-list-info' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dependent-counters' => {
                'type' => 'perf-dependent-counter-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-object-instance-list-iter-end' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-object-instance-list-iter-next' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'instances' => {
                'type' => 'perf-instance',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-instance-list-iter-start' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-list-info' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'objects' => {
                'type' => 'perf-object',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-set-default-view' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'view-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-status-get' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'host-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'data-unavailable-reason' => {
                'type' => 'perf-status-error',
                'flags' => 7,
                'scope' => [],
            },
            'is-data-available' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-create' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'threshold-info' => {
                'type' => 'threshold-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'threshold-id' => {
                'type' => 'threshold-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-create2' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'threshold-info2' => {
                'type' => 'threshold-info2',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'threshold-id' => {
                'type' => 'threshold-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-delete' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'threshold-id' => {
                'type' => 'threshold-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-threshold-list-info-iter-end' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-threshold-list-info-iter-next' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'threshold-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-list-info-iter-start' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'query' => {
                'type' => 'threshold-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-list-info2-iter-end' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-threshold-list-info2-iter-next' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'attributes-list' => {
                'type' => 'threshold-info2',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-list-info2-iter-start' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-id' => {
                'type' => 'threshold-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-modify' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'attributes' => {
                'type' => 'threshold-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-threshold-modify2' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'threshold-info2' => {
                'type' => 'threshold-info2',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-threshold-template-attach-objects' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'new-objects' => {
                'type' => 'object-info',
                'flags' => 7,
                'scope' => [],
            },
            'template-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-threshold-template-create' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'member-thresholds' => {
                'type' => 'threshold-info2',
                'flags' => 7,
                'scope' => [],
            },
            'template-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'template-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'template-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-template-delete' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'template-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'template-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'template-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-template-detach-objects' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'objects' => {
                'type' => 'object-info',
                'flags' => 7,
                'scope' => [],
            },
            'template-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-threshold-template-list-info-iter-end' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-threshold-template-list-info-iter-next' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'threshold-templates' => {
                'type' => 'threshold-template-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-threshold-template-list-info-iter-start' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'include-objects' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-thresholds' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'template-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold-template-modify' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'member-thresholds' => {
                'type' => 'threshold-info2',
                'flags' => 7,
                'scope' => [],
            },
            'template-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'template-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'template-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-view-associated-objects-list' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'view-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'objects' => {
                'type' => 'object-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-view-create' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'data-sources' => {
                'type' => 'perf-data-source',
                'flags' => 7,
                'scope' => [],
            },
            'real-time' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'view' => {
                'type' => 'perf-view',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-view-destroy' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-counter-group-also-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'view-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-view-get-data' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'direction' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dynamic-object-info' => {
                'type' => 'perf-dynamic-data-sources',
                'flags' => 5,
                'scope' => [],
            },
            'end-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'instance' => {
                'type' => 'perf-counter-instance',
                'flags' => 5,
                'scope' => [],
            },
            'is-dynamic' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'number-samples' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'sample-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-consolidation-method' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'view-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'counter-data' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dynamic-data' => {
                'type' => 'dynamic-data',
                'flags' => 7,
                'scope' => [],
            },
            'unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-view-list-iter-end' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-view-list-iter-next' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'views' => {
                'type' => 'perf-view',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-view-list-iter-start' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'custom-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'include-empty-views' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'view-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-view-modify' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'view' => {
                'type' => 'perf-view',
                'flags' => 1,
                'scope' => [],
            },
            'view-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-view-object-association-add' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'view-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'perf-view-object-association-delete' => {
        'category' => 'perf',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'view-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'provisioning-policy-copy' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'provisioning-policy-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'source-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'provisioning-policy-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'provisioning-policy-create' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'provisioning-policy-info' => {
                'type' => 'provisioning-policy-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'provisioning-policy-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'provisioning-policy-destroy' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'provisioning-policy-edit-begin' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'provisioning-policy-edit-commit' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'provisioning-policy-edit-rollback' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'provisioning-policy-list-iter-end' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'provisioning-policy-list-iter-next' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'provisioning-policies' => {
                'type' => 'provisioning-policy-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'provisioning-policy-list-iter-start' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'is-policy-readonly' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-type' => {
                'type' => 'provisioning-policy-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'provisioning-policy-modify' => {
        'category' => 'provisioning-policy',
        'family' => [],
        'inputs' => {
            'edit-lock-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'provisioning-policy-info' => {
                'type' => 'provisioning-policy-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-list-info-iter-end' => {
        'category' => 'qtree',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-list-info-iter-next' => {
        'category' => 'qtree',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'qtrees' => {
                'type' => 'qtree-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qtree-list-info-iter-start' => {
        'category' => 'qtree',
        'family' => [],
        'inputs' => {
            'include-is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-direct-member-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-direct-vfiler-child' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapvault-secondary-qtrees' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-unprotected' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'rbac-operation' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sort-results' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qtree-modify' => {
        'category' => 'qtree',
        'family' => [],
        'inputs' => {
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'qtree-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-rename' => {
        'category' => 'qtree',
        'family' => [],
        'inputs' => {
            'qtree-name-new' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qtree-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-start-monitoring' => {
        'category' => 'qtree',
        'family' => [],
        'inputs' => {
            'qtree-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'qtree-stop-monitoring' => {
        'category' => 'qtree',
        'family' => [],
        'inputs' => {
            'qtree-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-access-check' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'admin-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'operation' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'resource' => {
                'type' => 'resource-identifier',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'global-usergroup-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'local-usergroup-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'result' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'rbac-admin-list-info-iter-end' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-admin-list-info-iter-next' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'admins' => {
                'type' => 'admin-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'rbac-admin-list-info-iter-start' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'admin-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'rbac-admin-role-add' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'admin-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'role-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'admin-name-or-id' => {
                'type' => 'rbac-admin-name-or-id',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'rbac-admin-role-info-list' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'role-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'admin-list' => {
                'type' => 'rbac-admin-or-usergroup',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'rbac-admin-role-remove' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'admin-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'delete-all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'role-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-operation-add' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'operation' => {
                'type' => 'rbac-operation',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-operation-delete' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'operation' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-operation-info-list' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'operation' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'operation-list' => {
                'type' => 'rbac-operation',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'rbac-role-add' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'owner-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'role-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'role-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'rbac-role-admin-info-list' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'admin-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'follow-role-inheritance' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'admin-name-or-id' => {
                'type' => 'rbac-admin-name-or-id',
                'flags' => 1,
                'scope' => [],
            },
            'global-usergroup-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'local-usergroup-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'role-list' => {
                'type' => 'rbac-role-resource',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'rbac-role-capability-add' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'operation' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'resource' => {
                'type' => 'resource-identifier',
                'flags' => 1,
                'scope' => [],
            },
            'role-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-role-capability-remove' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'delete-all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'operation' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'resource' => {
                'type' => 'resource-identifier',
                'flags' => 5,
                'scope' => [],
            },
            'role-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-role-delete' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'role-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-role-disinherit' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'disinherit-all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disinherited-role-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'role-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-role-info-list' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'follow-role-inheritance' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'role-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'role-attributes' => {
                'type' => 'role-attributes-identifier',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'rbac-role-inherit' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'inherited-role-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'role-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'rbac-role-modify' => {
        'category' => 'rbac',
        'family' => [],
        'inputs' => {
            'role-description-new' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'role-name-new' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'role-name-or-id-old' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-category-list' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'category-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'category-provenance' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'category-list' => {
                'type' => 'category-list-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'report-designer-list' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'category-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'report-provenance' => {
                'type' => 'report-provenance',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'report-list' => {
                'type' => 'report-list-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'report-designer-schedule-add' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-schedule-info' => {
                'type' => 'report-schedule-info',
                'flags' => 1,
                'scope' => [],
            },
            'schedule-content-info' => {
                'type' => 'schedule-content-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'report-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-designer-schedule-delete' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-designer-schedule-modify' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-schedule-info' => {
                'type' => 'report-schedule-info',
                'flags' => 5,
                'scope' => [],
            },
            'report-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-content-info' => {
                'type' => 'schedule-content-info',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-designer-share' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'email-address-list' => {
                'type' => 'email-address-list',
                'flags' => 0,
                'scope' => [],
            },
            'output-format' => {
                'type' => 'report-output-format',
                'flags' => 4,
                'scope' => [],
            },
            'report-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'subject-field' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'target-object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-graph-list-info-iter-end' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-graph-list-info-iter-next' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'graph-list' => {
                'type' => 'graph-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-graph-list-info-iter-start' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-application' => {
                'type' => 'report-application',
                'flags' => 4,
                'scope' => [],
            },
            'report-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-list-info-iter-end' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-list-info-iter-next' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'report-list' => {
                'type' => 'report-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'report-list-info-iter-start' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-application' => {
                'type' => 'report-application',
                'flags' => 4,
                'scope' => [],
            },
            'report-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'report-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-output-delete' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-output-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-output-list-info-iter-end' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-output-list-info-iter-next' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'report-output-list' => {
                'type' => 'report-output-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'report-output-list-info-iter-start' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'is-successful' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'report-application' => {
                'type' => 'report-application',
                'flags' => 4,
                'scope' => [],
            },
            'report-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'report-output-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'report-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'target-object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-output-read' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'offset' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'report-output-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'file-data' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'output-format' => {
                'type' => 'report-output-format',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-schedule-add' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-schedule-info' => {
                'type' => 'report-schedule-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'report-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-schedule-delete' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-schedule-disable' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-schedule-enable' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-schedule-list-info-iter-end' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-schedule-list-info-iter-next' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'report-schedule-list' => {
                'type' => 'report-schedule-content-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'report-schedule-list-info-iter-start' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'report-application' => {
                'type' => 'report-application',
                'flags' => 4,
                'scope' => [],
            },
            'report-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'report-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'target-object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-schedule-modify' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-schedule-info' => {
                'type' => 'report-schedule-info',
                'flags' => 1,
                'scope' => [],
            },
            'report-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'report-schedule-run' => {
        'category' => 'report',
        'family' => [],
        'inputs' => {
            'report-schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'report-output-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'resourcepool-add-member' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'member-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'move-if-exists' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'resource-tag' => {
                'type' => 'resource-tag',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'resourcepool-create' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'resourcepool' => {
                'type' => 'resourcepool-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'resourcepool-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'resourcepool-destroy' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'resourcepool-get-defaults' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'resourcepool-defaults' => {
                'type' => 'resourcepool-defaults',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'resourcepool-list-info-iter-end' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'resourcepool-list-info-iter-next' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'resourcepools' => {
                'type' => 'resourcepool-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'resourcepool-list-info-iter-start' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'check-licenses' => {
                'type' => 'license',
                'flags' => 6,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'include-free-space' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'resource-tag' => {
                'type' => 'resource-tag',
                'flags' => 4,
                'scope' => [],
            },
            'storage-reliability' => {
                'type' => 'storage-reliability',
                'flags' => 5,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'resourcepool-member-list-info-iter-end' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'resourcepool-member-list-info-iter-next' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'resourcepool-members' => {
                'type' => 'resourcepool-member-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'resourcepool-member-list-info-iter-start' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'include-dataset-space-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-indirect' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'member-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'provision-member-request-info' => {
                'type' => 'provision-member-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'provisioning-policy-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-member-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'run-provisioning-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'resourcepool-modify' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'resourcepool' => {
                'type' => 'resourcepool-info',
                'flags' => 1,
                'scope' => [],
            },
            'resourcepool-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'resourcepool-modify-member' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'member-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'resource-tag' => {
                'type' => 'resource-tag',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'resourcepool-remove-member' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'member-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'resourcepool-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'resourcepool-update-free-space-status' => {
        'category' => 'resourcepool',
        'family' => [],
        'inputs' => {
            'resourcepool-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-get-reclaimable-info' => {
        'category' => 'snapshot',
        'family' => [],
        'inputs' => {
            'snapshots' => {
                'type' => 'snapshot',
                'flags' => 3,
                'scope' => [],
            },
            'volume-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'reclaimable-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-shared-data' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot-list-info-iter-end' => {
        'category' => 'snapshot',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'snapshot-list-info-iter-next' => {
        'category' => 'snapshot',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshots' => {
                'type' => 'snapshot-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'snapshot-list-info-iter-start' => {
        'category' => 'snapshot',
        'family' => [],
        'inputs' => {
            'include-backup-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'srm-file-type-add' => {
        'category' => 'srm',
        'family' => [],
        'inputs' => {
            'srm-file-type-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'srm-file-type-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'srm-file-type-delete' => {
        'category' => 'srm',
        'family' => [],
        'inputs' => {
            'srm-file-type-name-or-id-list' => {
                'type' => 'object-name-or-id',
                'flags' => 2,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'srm-file-type-list-info' => {
        'category' => 'srm',
        'family' => [],
        'inputs' => {
            'srm-file-type-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'srm-file-types' => {
                'type' => 'srm-file-type-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-service-create' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'group-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-contact' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-node-list' => {
                'type' => 'storage-service-node-attributes',
                'flags' => 3,
                'scope' => [],
            },
            'storage-service-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'storage-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-service-dataset-list-iter-end' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'storage-service-dataset-list-iter-next' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-datasets-info' => {
                'type' => 'storage-service-dataset-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-service-dataset-list-iter-start' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-service-dataset-modify' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'assume-confirmation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-dry-run-reason-details' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'operation-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-node-list' => {
                'type' => 'storage-service-node-attributes',
                'flags' => 7,
                'scope' => [],
            },
        },
        'outputs' => {
            'conformance-alerts' => {
                'type' => 'conformance-alert',
                'flags' => 7,
                'scope' => [],
            },
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'storage-service-dataset-provision' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'application-info' => {
                'type' => 'application-info',
                'flags' => 5,
                'scope' => [],
            },
            'assume-confirmation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-contact' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-metadata' => {
                'type' => 'dfm-metadata-field',
                'flags' => 7,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'include-dry-run-reason-details' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-application-data' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-suspended' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'online-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'provision-member' => {
                'type' => 'provision-member-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'requires-non-disruptive-restore' => {
                'type' => 'requires-non-disruptive-restore',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'storage-set-details' => {
                'type' => 'storage-set-info',
                'flags' => 7,
                'scope' => [],
            },
            'volume-qtree-name-prefix' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'conformance-alerts' => {
                'type' => 'conformance-alert',
                'flags' => 7,
                'scope' => [],
            },
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'storage-service-destroy' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'force' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'storage-service-list-info-iter-end' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'storage-service-list-info-iter-next' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'storage-services' => {
                'type' => 'storage-service-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'storage-service-list-info-iter-start' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'is-dr-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-service-modify' => {
        'category' => 'storage-service',
        'family' => [],
        'inputs' => {
            'assume-confirmation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-dry-run-reason-details' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-contact' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-node-list' => {
                'type' => 'storage-service-node-attributes',
                'flags' => 7,
                'scope' => [],
            },
            'storage-service-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'conformance-alerts' => {
                'type' => 'conformance-alert',
                'flags' => 7,
                'scope' => [],
            },
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'timezone-get-defaults' => {
        'category' => 'timezone',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'timezone-defaults' => {
                'type' => 'timezone-defaults',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'timezone-list-info-iter-end' => {
        'category' => 'timezone',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'timezone-list-info-iter-next' => {
        'category' => 'timezone',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'timezones' => {
                'type' => 'timezone-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'timezone-list-info-iter-start' => {
        'category' => 'timezone',
        'family' => [],
        'inputs' => {
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'timezone-validate' => {
        'category' => 'timezone',
        'family' => [],
        'inputs' => {
            'timezone' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'utc-offset' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'user-favorite-report-delete' => {
        'category' => 'user_report_profile',
        'family' => [],
        'inputs' => {
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'user-favorite-report-list-info-iter-end' => {
        'category' => 'user_report_profile',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'user-favorite-report-list-info-iter-next' => {
        'category' => 'user_report_profile',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'favorites' => {
                'type' => 'user-report-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'user-favorite-report-list-info-iter-start' => {
        'category' => 'user_report_profile',
        'family' => [],
        'inputs' => {
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'user-recent-report-delete' => {
        'category' => 'user_report_profile',
        'family' => [],
        'inputs' => {
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'user-recent-report-list-info-iter-end' => {
        'category' => 'user_report_profile',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'user-recent-report-list-info-iter-next' => {
        'category' => 'user_report_profile',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'recent-viewed' => {
                'type' => 'user-report-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'user-recent-report-list-info-iter-start' => {
        'category' => 'user_report_profile',
        'family' => [],
        'inputs' => {
            'user-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vfiler-create' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'allowed-protocols' => {
                'type' => 'protocol',
                'flags' => 6,
                'scope' => [],
            },
            'dry-run' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'resource-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'filer-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'filer-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'root-volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'root-volume-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'vfiler-destroy' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-setup' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'allowed-protocols' => {
                'type' => 'protocol',
                'flags' => 6,
                'scope' => [],
            },
            'cifs-domain-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'cifs-domain-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cifs-workgroup-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ip-bindings' => {
                'type' => 'ip-binding-info',
                'flags' => 7,
                'scope' => [],
            },
            'root-password' => {
                'type' => 'string',
                'flags' => 12,
                'scope' => [],
            },
            'run-cifs-setup' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'script-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler-template-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-template-copy' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler-template-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler-template-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'vfiler-template-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vfiler-template-create' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler-template' => {
                'type' => 'vfiler-template-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
            'vfiler-template-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vfiler-template-delete' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler-template-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-template-list-info-iter-end' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vfiler-template-list-info-iter-next' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler-templates' => {
                'type' => 'vfiler-template-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vfiler-template-list-info-iter-start' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler-template-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vfiler-template-modify' => {
        'category' => 'vfiler',
        'family' => [],
        'inputs' => {
            'vfiler-template' => {
                'type' => 'vfiler-template-info',
                'flags' => 1,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vi-datacenter-list-info-iter-end' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vi-datacenter-list-info-iter-next' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'datacenters' => {
                'type' => 'datacenter',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vi-datacenter-list-info-iter-start' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-unprotected' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'obj-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vi-datastore-list-info-iter-end' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vi-datastore-list-info-iter-next' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'datastores' => {
                'type' => 'datastore',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vi-datastore-list-info-iter-start' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-unprotected' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'obj-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vi-hypervisor-list-info-iter-end' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vi-hypervisor-list-info-iter-next' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'hypervisors' => {
                'type' => 'hypervisor-info',
                'flags' => 3,
                'scope' => [],
            },
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vi-hypervisor-list-info-iter-start' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'obj-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'virtual-infrastructure-type' => {
                'type' => 'virtual-infrastructure-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vi-virtual-center-list-info-iter-end' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vi-virtual-center-list-info-iter-next' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-centers' => {
                'type' => 'virtual-center',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vi-virtual-center-list-info-iter-start' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'obj-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vi-virtual-disk-list-info-iter-end' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vi-virtual-disk-list-info-iter-next' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-disks' => {
                'type' => 'virtual-disk',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vi-virtual-disk-list-info-iter-start' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'obj-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vi-virtual-machine-list-info-iter-end' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'vi-virtual-machine-list-info-iter-next' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-machines' => {
                'type' => 'virtual-machine',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vi-virtual-machine-list-info-iter-start' => {
        'category' => 'virtual-infrastructure',
        'family' => [],
        'inputs' => {
            'include-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-unprotected' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'obj-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'virtual-infrastructure-type' => {
                'type' => 'virtual-infrastructure-type',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-dedupe' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'dedupe-request-info' => {
                'type' => 'dedupe-request-info',
                'flags' => 1,
                'scope' => [],
            },
            'volume-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-destroy' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'volume-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-list-info-iter-end' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-list-info-iter-next' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'maximum' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volumes' => {
                'type' => 'volume-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'volume-list-info-iter-start' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'block-type' => {
                'type' => 'file-system-block-type',
                'flags' => 4,
                'scope' => [],
            },
            'include-is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-migration-info' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'include-next-scheduled-backup-time' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-direct-member-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-sis-volume' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapmirror-primary-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapmirror-secondary-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapvault-primary-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapvault-secondary-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-unprotected' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-management-filter' => {
                'type' => 'object-management-interface',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'rbac-operation' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snapvault-secondary-schedule-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
        'outputs' => {
            'records' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'tag' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-modify' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name-or-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
        },
    },
    'volume-resize' => {
        'category' => 'volume',
        'family' => [],
        'inputs' => {
            'resize-volume-request-info' => {
                'type' => 'resize-volume-request-info',
                'flags' => 1,
                'scope' => [],
            },
            'volume-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
        'outputs' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
};

my $TYPEDEFS = {
    'aggregate-info' => {
        'category' => 'aggregate',
        'fields' => {
            'aggregate-full-threshold' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-nearly-full-threshold' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-nearly-overcommitted-threshold' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-overcommitted-threshold' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-perf-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'aggregate-size' => {
                'type' => 'aggregate-size',
                'flags' => 1,
                'scope' => [],
            },
            'aggregate-space-status' => {
                'type' => 'object-space-status',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'aggregate-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'block-type' => {
                'type' => 'file-system-block-type',
                'flags' => 0,
                'scope' => [],
            },
            'datasets' => {
                'type' => 'dataset-reference',
                'flags' => 3,
                'scope' => [],
            },
            'datasets-space-info' => {
                'type' => 'dataset-space-info',
                'flags' => 7,
                'scope' => [],
            },
            'filer-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'filer-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-flash-pool-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'resourcepool-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'time-to-full' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'aggregate-size' => {
        'category' => 'aggregate',
        'fields' => {
            'size-available' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-total' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'size-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'space-total-committed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'aggregate-space-info' => {
        'category' => 'aggregate',
        'fields' => {
            'aggregate-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'committed-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'used-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'backup-deletion-request-info' => {
        'category' => 'aggregate',
        'fields' => {
            'backup-ids' => {
                'type' => 'backup-id',
                'flags' => 2,
                'scope' => [],
            },
        },
    },
    'backup-id' => {
        'category' => 'aggregate',
        'fields' => {
        },
    },
    'cleanup-stale-storage' => {
        'category' => 'aggregate',
        'fields' => {
        },
    },
    'dedupe-request-info' => {
        'category' => 'aggregate',
        'fields' => {
            'full-volume-dedupe' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'object-management-interface' => {
        'category' => 'aggregate',
        'fields' => {
        },
    },
    'resize-volume-request-info' => {
        'category' => 'aggregate',
        'fields' => {
            'maximum-capacity' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'new-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snap-reserve' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapshot-deletion-request-info' => {
        'category' => 'aggregate',
        'fields' => {
            'snapshots' => {
                'type' => 'snapshot',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'space-management-op-type' => {
        'category' => 'aggregate',
        'fields' => {
        },
    },
    'space-management-operation-info' => {
        'category' => 'aggregate',
        'fields' => {
            'backup-deletion-request-info' => {
                'type' => 'backup-deletion-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'dedupe-request-info' => {
                'type' => 'dedupe-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'resize-volume-request-info' => {
                'type' => 'resize-volume-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'snapshot-deletion-request-info' => {
                'type' => 'snapshot-deletion-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'space-management-op-type' => {
                'type' => 'space-management-op-type',
                'flags' => 0,
                'scope' => [],
            },
            'volume-migration-request-info' => {
                'type' => 'volume-migration-request-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'space-management-result-info' => {
        'category' => 'aggregate',
        'fields' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 7,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'object-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'space-management-op-type' => {
                'type' => 'space-management-op-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-migration-request-info' => {
        'category' => 'aggregate',
        'fields' => {
            'cleanup-stale-storage' => {
                'type' => 'cleanup-stale-storage',
                'flags' => 4,
                'scope' => [],
            },
            'destination-aggregate-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 4,
                'scope' => [],
            },
            'run-dedupe-scan' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'run-on-demand-update' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'admin-name' => {
        'category' => 'alarm',
        'fields' => {
        },
    },
    'alarm-defaults' => {
        'category' => 'alarm',
        'fields' => {
            'group-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-disabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-repeat-notify' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'repeat-interval' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'trap-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'alarm-info' => {
        'category' => 'alarm',
        'fields' => {
            'admin-login-names' => {
                'type' => 'admin-name',
                'flags' => 6,
                'scope' => [],
            },
            'alarm-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'alarm-script' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'alarm-script-runas' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'email-addresses' => {
                'type' => 'email-address',
                'flags' => 6,
                'scope' => [],
            },
            'event-class' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'event-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'event-severity' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'group-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-disabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-repeat-notify' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'pager-admin-login-names' => {
                'type' => 'admin-name',
                'flags' => 6,
                'scope' => [],
            },
            'pager-email-addresses' => {
                'type' => 'email-address',
                'flags' => 6,
                'scope' => [],
            },
            'repeat-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-from' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'time-to' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'trap-destinations' => {
                'type' => 'trap-destination',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'email-address' => {
        'category' => 'alarm',
        'fields' => {
        },
    },
    'trap-destination' => {
        'category' => 'alarm',
        'fields' => {
            'trap-community' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'trap-host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'trap-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'request' => {
        'category' => 'api',
        'fields' => {
            'args' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'response' => {
        'category' => 'api',
        'fields' => {
            'errno' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'results' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'application-backup-operation-info' => {
        'category' => 'application-policy',
        'fields' => {
            'backup-schedules' => {
                'type' => 'application-backup-schedule-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'application-backup-schedule-info' => {
        'category' => 'application-policy',
        'fields' => {
            'hyperv-backup-schedule-settings-info' => {
                'type' => 'hyperv-backup-schedule-settings-info',
                'flags' => 5,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'simple-schedule-info' => {
                'type' => 'simple-schedule-info',
                'flags' => 1,
                'scope' => [],
            },
            'start-remote-backup-after-local-backup' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'vmware-backup-schedule-settings-info' => {
                'type' => 'vmware-backup-schedule-settings-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'application-policy-info' => {
        'category' => 'application-policy',
        'fields' => {
            'application-backup-operation-info' => {
                'type' => 'application-backup-operation-info',
                'flags' => 1,
                'scope' => [],
            },
            'application-policy-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'application-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'application-policy-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'application-policy-settings-info' => {
                'type' => 'application-policy-settings-info',
                'flags' => 1,
                'scope' => [],
            },
            'application-policy-type' => {
                'type' => 'application-policy-type',
                'flags' => 0,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'application-policy-settings-info' => {
        'category' => 'application-policy',
        'fields' => {
            'backup-script' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'daily-retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'daily-retention-duration' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'hourly-retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'hourly-retention-duration' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-lag-error-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-lag-warning-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'lag-error-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lag-warning-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'monthly-retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'monthly-retention-duration' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-retention-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-retention-duration' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'application-policy-type' => {
        'category' => 'application-policy',
        'fields' => {
        },
    },
    'day-of-month' => {
        'category' => 'application-policy',
        'fields' => {
        },
    },
    'day-of-week' => {
        'category' => 'application-policy',
        'fields' => {
        },
    },
    'hyperv-backup-schedule-settings-info' => {
        'category' => 'application-policy',
        'fields' => {
            'allow-saved-state-backup' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'simple-schedule-info' => {
        'category' => 'application-policy',
        'fields' => {
            'days-of-month' => {
                'type' => 'day-of-month',
                'flags' => 6,
                'scope' => [],
            },
            'days-of-week' => {
                'type' => 'day-of-week',
                'flags' => 6,
                'scope' => [],
            },
            'times-of-day-info' => {
                'type' => 'times-of-day-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'time-of-day-info' => {
        'category' => 'application-policy',
        'fields' => {
            'hour' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'minute' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'times-of-day-info' => {
        'category' => 'application-policy',
        'fields' => {
            'end-time' => {
                'type' => 'time-of-day-info',
                'flags' => 5,
                'scope' => [],
            },
            'frequency' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'time-of-day-info',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'vmware-backup-schedule-settings-info' => {
        'category' => 'application-policy',
        'fields' => {
            'create-vmware-snapshot' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'include-independent-disks' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-domain-info' => {
        'category' => 'cifs',
        'fields' => {
            'cifs-dns-domain-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'cifs-domain-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'cifs-domain-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'client-option-info' => {
        'category' => 'client',
        'fields' => {
            'option' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'comment-field-id' => {
        'category' => 'comment',
        'fields' => {
        },
    },
    'comment-field-info' => {
        'category' => 'comment',
        'fields' => {
            'comment-field-id' => {
                'type' => 'comment-field-id',
                'flags' => 4,
                'scope' => [],
            },
            'comment-field-name' => {
                'type' => 'comment-field-name',
                'flags' => 0,
                'scope' => [],
            },
            'comment-field-object-types' => {
                'type' => 'comment-field-object-type',
                'flags' => 6,
                'scope' => [],
            },
            'is-system-comment' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'comment-field-name' => {
        'category' => 'comment',
        'fields' => {
        },
    },
    'comment-field-name-or-id' => {
        'category' => 'comment',
        'fields' => {
        },
    },
    'comment-field-object-type' => {
        'category' => 'comment',
        'fields' => {
        },
    },
    'comment-field-value' => {
        'category' => 'comment',
        'fields' => {
            'comment-field-id' => {
                'type' => 'comment-field-id',
                'flags' => 0,
                'scope' => [],
            },
            'comment-field-name' => {
                'type' => 'comment-field-name',
                'flags' => 0,
                'scope' => [],
            },
            'comment-value' => {
                'type' => 'comment-value',
                'flags' => 0,
                'scope' => [],
            },
            'object-full-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'object-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'object-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'comment-value' => {
        'category' => 'comment',
        'fields' => {
        },
    },
    'application-info' => {
        'category' => 'dataset',
        'fields' => {
            'application-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'application-server-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'application-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'carry-primary-backup-retention' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-application-managing-primary-backup-retention' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-application-responsible-for-primary-backup' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'application-resource-namespace' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'cifs-permission' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'cifs-share-info' => {
        'category' => 'dataset',
        'fields' => {
            'cifs-share-name' => {
                'type' => 'cifs-share-name',
                'flags' => 0,
                'scope' => [],
            },
            'cifs-share-permissions' => {
                'type' => 'cifs-share-permission',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'cifs-share-name' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'cifs-share-permission' => {
        'category' => 'dataset',
        'fields' => {
            'cifs-username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'permission' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'conformance-alert' => {
        'category' => 'dataset',
        'fields' => {
            'conformance-alert-effect' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'conformance-alert-reason' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'conformance-alert-severity' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'conformance-alert-suggestion' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'conformance-alert-type' => {
                'type' => 'conformance-alert-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'conformance-alert-type' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'conformance-run-result' => {
        'category' => 'dataset',
        'fields' => {
            'conformance-job-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'conformance-run-action' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'conformance-run-effect' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'conformance-run-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'conformance-run-reason-details' => {
                'type' => 'result-detail',
                'flags' => 7,
                'scope' => [],
            },
            'conformance-run-severity' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'conformance-run-suggestion' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dataset-access-details' => {
        'category' => 'dataset',
        'fields' => {
            'ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'netmask' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-cifs-export-setting' => {
        'category' => 'dataset',
        'fields' => {
            'cifs-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-cifs-share-permissions' => {
                'type' => 'dataset-cifs-share-permission',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'dataset-cifs-share-permission' => {
        'category' => 'dataset',
        'fields' => {
            'cifs-username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'permission' => {
                'type' => 'cifs-permission',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-dynamic-reference-info' => {
        'category' => 'dataset',
        'fields' => {
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'dynamic-reference-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dynamic-reference-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'dynamic-reference-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'dynamic-reference-subtype' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dynamic-reference-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'storageset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'storageset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-dynamic-reference-parameter' => {
        'category' => 'dataset',
        'fields' => {
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-export-info' => {
        'category' => 'dataset',
        'fields' => {
            'dataset-cifs-export-setting' => {
                'type' => 'dataset-cifs-export-setting',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-export-protocol' => {
                'type' => 'dataset-export-protocol',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-lun-mapping-info' => {
                'type' => 'dataset-lun-mapping-info',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-nfs-export-setting' => {
                'type' => 'dataset-nfs-export-setting',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'dataset-export-protocol' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'dataset-info' => {
        'category' => 'dataset',
        'fields' => {
            'application-info' => {
                'type' => 'application-info',
                'flags' => 5,
                'scope' => [],
            },
            'application-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'application-policy-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'application-resource-namespaces' => {
                'type' => 'application-resource-namespace',
                'flags' => 6,
                'scope' => [],
            },
            'can-contain-application-resources' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'can-contain-storage-resources' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-access-details' => {
                'type' => 'dataset-access-details',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-contact' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-export-info' => {
                'type' => 'dataset-export-info',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-map' => {
                'type' => 'dataset-map-entry',
                'flags' => 7,
                'scope' => [],
            },
            'dataset-metadata' => {
                'type' => 'dfm-metadata-field',
                'flags' => 7,
                'scope' => [],
            },
            'dataset-migration-info' => {
                'type' => 'dataset-migration-info',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-status' => {
                'type' => 'dataset-status',
                'flags' => 1,
                'scope' => [],
            },
            'dr-state' => {
                'type' => 'dr-state',
                'flags' => 4,
                'scope' => [],
            },
            'dynamic-reference-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'has-protection' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'has-protection-policy' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-allow-custom-settings' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-application-data' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-suspended' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-dr-capable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-enable-write-guarantee-checks' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-none-guaranteed-provision' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-protected' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-skip-autosize-conformance' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-suspended' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-vfiler-created-for-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-luns-per-volume' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-qtrees-per-volume' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'member-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'online-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'primary-volume-name-format' => {
                'type' => 'primary-volume-name-format',
                'flags' => 0,
                'scope' => [],
            },
            'protection-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'requires-non-disruptive-restore' => {
                'type' => 'requires-non-disruptive-restore',
                'flags' => 0,
                'scope' => [],
            },
            'resourcepool-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepools' => {
                'type' => 'dataset-resourcepool-info',
                'flags' => 7,
                'scope' => [],
            },
            'secondary-qtree-name-format' => {
                'type' => 'secondary-qtree-name-format',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-volume-name-format' => {
                'type' => 'secondary-volume-name-format',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-name-format' => {
                'type' => 'snapshot-name-format',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'storageset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'storageset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'storageset-timezone' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'volume-qtree-name-prefix' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-io-metric-info' => {
        'category' => 'dataset',
        'fields' => {
            'dataset-node' => {
                'type' => 'metric-dataset-node-info',
                'flags' => 1,
                'scope' => [],
            },
            'io-measurement' => {
                'type' => 'io-measurement',
                'flags' => 1,
                'scope' => [],
            },
            'is-io-data-partial' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-overcharge' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-lun-mapping-info' => {
        'category' => 'dataset',
        'fields' => {
            'igroup-os-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-mapping-initiators' => {
                'type' => 'lun-mapping-initiator',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dataset-map-entry' => {
        'category' => 'dataset',
        'fields' => {
            'dataset-access-details' => {
                'type' => 'dataset-access-details',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-export-info' => {
                'type' => 'dataset-export-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-node-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 0,
                'scope' => [],
            },
            'is-dr-capable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-vfiler-created-for-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepools' => {
                'type' => 'dataset-resourcepool-info',
                'flags' => 7,
                'scope' => [],
            },
            'storageset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'storageset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'storageset-timezone' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dataset-member-info' => {
        'category' => 'dataset',
        'fields' => {
            'cifs-share-names' => {
                'type' => 'cifs-share-name',
                'flags' => 6,
                'scope' => [],
            },
            'cifs-shares-info' => {
                'type' => 'cifs-share-info',
                'flags' => 3,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-deleted' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'lun-igroups-info' => {
                'type' => 'lun-igroup-info',
                'flags' => 7,
                'scope' => [],
            },
            'member-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'member-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'member-perf-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'member-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'member-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nfs-export-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nfs-export-rules' => {
                'type' => 'nfs-export-rules',
                'flags' => 1,
                'scope' => [],
            },
            'space-info' => {
                'type' => 'space-info',
                'flags' => 5,
                'scope' => [],
            },
            'storageset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'storageset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-member-parameter' => {
        'category' => 'dataset',
        'fields' => {
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-migration-info' => {
        'category' => 'dataset',
        'fields' => {
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-filer-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'destination-filer-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'destination-vfiler-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'destination-vfiler-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'migration-status' => {
                'type' => 'migration-status',
                'flags' => 0,
                'scope' => [],
            },
            'provisioning-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'source-filer-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'source-filer-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'source-vfiler-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'source-vfiler-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-nfs-export-setting' => {
        'category' => 'dataset',
        'fields' => {
            'anonymous-access-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disable-setuid' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-readonly-for-all-hosts' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-readwrite-for-all-hosts' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'nfs-export-ro-hosts' => {
                'type' => 'nfs-export-host',
                'flags' => 7,
                'scope' => [],
            },
            'nfs-export-root-hosts' => {
                'type' => 'nfs-export-host',
                'flags' => 7,
                'scope' => [],
            },
            'nfs-export-rw-hosts' => {
                'type' => 'nfs-export-host',
                'flags' => 7,
                'scope' => [],
            },
            'nfs-protocol-version' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nfs-security-flavors' => {
                'type' => 'nfs-security-flavor',
                'flags' => 6,
                'scope' => [],
            },
        },
    },
    'dataset-node-info' => {
        'category' => 'dataset',
        'fields' => {
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'dp-node-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-node-effective-primary' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-resourcepool-info' => {
        'category' => 'dataset',
        'fields' => {
            'resourcepool-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'resourcepool-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-space-metric-info' => {
        'category' => 'dataset',
        'fields' => {
            'avg-space-measurement' => {
                'type' => 'space-measurement',
                'flags' => 1,
                'scope' => [],
            },
            'dataset-node' => {
                'type' => 'metric-dataset-node-info',
                'flags' => 1,
                'scope' => [],
            },
            'is-overcharge' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-space-data-partial' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'max-space-measurement' => {
                'type' => 'space-measurement',
                'flags' => 1,
                'scope' => [],
            },
            'timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-status' => {
        'category' => 'dataset',
        'fields' => {
            'conformance-check-results' => {
                'type' => 'conformance-run-result',
                'flags' => 7,
                'scope' => [],
            },
            'conformance-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dr-protection-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dr-status' => {
                'type' => 'dr-status',
                'flags' => 4,
                'scope' => [],
            },
            'dr-status-problems' => {
                'type' => 'dr-status-problem',
                'flags' => 7,
                'scope' => [],
            },
            'performance-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'protection-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'protection-status-problems' => {
                'type' => 'protection-status-problem',
                'flags' => 7,
                'scope' => [],
            },
            'resource-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'space-status' => {
                'type' => 'space-status',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dedupe-member-request-info' => {
        'category' => 'dataset',
        'fields' => {
            'full-volume-dedupe' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'delete-snapshots-request-info' => {
        'category' => 'dataset',
        'fields' => {
            'snapshots' => {
                'type' => 'snapshot',
                'flags' => 3,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dfm-metadata-field' => {
        'category' => 'dataset',
        'fields' => {
            'field-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'field-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dr-state' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'dr-status' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'dr-status-problem' => {
        'category' => 'dataset',
        'fields' => {
            'dr-status-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dr-status-severity' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dry-run-result' => {
        'category' => 'dataset',
        'fields' => {
            'dry-run-action' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dry-run-effect' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dry-run-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dry-run-reason-details' => {
                'type' => 'result-detail',
                'flags' => 7,
                'scope' => [],
            },
            'dry-run-severity' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'dry-run-suggestion' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'excluded-object-info' => {
        'category' => 'dataset',
        'fields' => {
            'object-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'object-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'initiator-id' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'io-measurement' => {
        'category' => 'dataset',
        'fields' => {
            'data-read' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'data-written' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-info' => {
        'category' => 'dataset',
        'fields' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-igroup-info' => {
        'category' => 'dataset',
        'fields' => {
            'igroup-initiators' => {
                'type' => 'lun-mapping-initiator',
                'flags' => 7,
                'scope' => [],
            },
            'igroup-lun-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'igroup-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'igroup-os-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'igroup-protocol' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-mapping-initiator' => {
        'category' => 'dataset',
        'fields' => {
            'hostname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'initiator-id' => {
                'type' => 'initiator-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'metric-dataset-node-info' => {
        'category' => 'dataset',
        'fields' => {
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'migration-status' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'missing-member-info' => {
        'category' => 'dataset',
        'fields' => {
            'aggregate-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'cifs-share-names' => {
                'type' => 'cifs-share-name',
                'flags' => 6,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'hostname' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'member-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'member-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'member-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nfs-export-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'quota-hard-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'quota-soft-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'space-guarantee' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'total-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'nfs-export-host' => {
        'category' => 'dataset',
        'fields' => {
            'hostname' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-an-exception' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'nfs-export-rules' => {
        'category' => 'dataset',
        'fields' => {
            'anonymous-access-user' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'disable-setuid' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-readonly-for-all-hosts' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-readwrite-for-all-hosts' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'nfs-export-ro-hosts' => {
                'type' => 'nfs-export-host',
                'flags' => 7,
                'scope' => [],
            },
            'nfs-export-root-hosts' => {
                'type' => 'nfs-export-host',
                'flags' => 7,
                'scope' => [],
            },
            'nfs-export-rw-hosts' => {
                'type' => 'nfs-export-host',
                'flags' => 7,
                'scope' => [],
            },
            'nfs-security-flavors' => {
                'type' => 'nfs-security-flavor',
                'flags' => 6,
                'scope' => [],
            },
        },
    },
    'nfs-security-flavor' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'primary-volume-name-format' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'protection-status-job-detail' => {
        'category' => 'dataset',
        'fields' => {
            'protection-status-job-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'protection-status-job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protection-status-job-status' => {
                'type' => 'dp-job-overall-status',
                'flags' => 0,
                'scope' => [],
            },
            'protection-status-job-type' => {
                'type' => 'dp-job-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'protection-status-problem' => {
        'category' => 'dataset',
        'fields' => {
            'protection-status-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'protection-status-job-details' => {
                'type' => 'protection-status-job-detail',
                'flags' => 7,
                'scope' => [],
            },
            'protection-status-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'provision-member-comment' => {
        'category' => 'dataset',
        'fields' => {
            'comment-field-name-or-id' => {
                'type' => 'comment-field-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'comment-value' => {
                'type' => 'comment-value',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'provision-member-request-info' => {
        'category' => 'dataset',
        'fields' => {
            'comments' => {
                'type' => 'provision-member-comment',
                'flags' => 7,
                'scope' => [],
            },
            'create-new-vfiler' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-export-info' => {
                'type' => 'dataset-export-info',
                'flags' => 5,
                'scope' => [],
            },
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'initial-snapshot-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-data-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'maximum-snapshot-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'online-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'resource-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'replace-result' => {
        'category' => 'dataset',
        'fields' => {
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'member-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'new-primary-member-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'new-primary-member-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'old-primary-member-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'old-primary-member-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'replace-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-member-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'secondary-member-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'requires-non-disruptive-restore' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'resize-member-request-info' => {
        'category' => 'dataset',
        'fields' => {
            'maximum-capacity' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'member-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'member-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'new-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snap-reserve' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'result-detail' => {
        'category' => 'dataset',
        'fields' => {
            'action' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'effect' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'severity' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'suggestion' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'secondary-qtree-name-format' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'secondary-volume-name-format' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'snapshot-name-format' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'space-condition' => {
        'category' => 'dataset',
        'fields' => {
            'condition' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'severity' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'suggestion' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'space-info' => {
        'category' => 'dataset',
        'fields' => {
            'available-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'space-conditions' => {
                'type' => 'space-condition',
                'flags' => 7,
                'scope' => [],
            },
            'space-status' => {
                'type' => 'space-status',
                'flags' => 4,
                'scope' => [],
            },
            'total-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'used-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'space-measurement' => {
        'category' => 'dataset',
        'fields' => {
            'effective-used-data-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'guaranteed-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'physical-used-data-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-reserve' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'total-data-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'total-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'used-snapshot-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'space-status' => {
        'category' => 'dataset',
        'fields' => {
        },
    },
    'undedupe-member-request-info' => {
        'category' => 'dataset',
        'fields' => {
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'api-stat' => {
        'category' => 'dfm',
        'fields' => {
            'api-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'call-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'cpu-max-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'cpu-mean-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'cpu-min-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'db-max-calls' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'db-max-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'db-mean-calls' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'db-mean-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'db-min-calls' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'db-min-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'max-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'mean-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'min-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'backup-type' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'child-count' => {
        'category' => 'dfm',
        'fields' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-diag-counter-group' => {
        'category' => 'dfm',
        'fields' => {
            'group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'histogram' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'last-updated' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dfm-monitoring-timestamp' => {
        'category' => 'dfm',
        'fields' => {
            'last-monitoring-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'monitor-name' => {
                'type' => 'monitor-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'directory-info' => {
        'category' => 'dfm',
        'fields' => {
            'disk-free-space' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'disk-free-space-percent' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'file-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'email-address-list' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'feature' => {
        'category' => 'dfm',
        'fields' => {
            'is-license-expired' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'summary' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'file-system-block-type' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'host-service-unique-id' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'ip-address' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'key-value-pair' => {
        'category' => 'dfm',
        'fields' => {
            'key' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'monitor-name' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'network-address' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'network-snmp-credential-info' => {
        'category' => 'dfm',
        'fields' => {
            'host-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-snmp-privacy-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'network-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snmp-authentication-login' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snmp-authentication-protocol' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snmp-community-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snmp-id' => {
                'type' => 'snmp-id',
                'flags' => 0,
                'scope' => [],
            },
            'snmp-version' => {
                'type' => 'snmp-version',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'obj-full-name' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'obj-id' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'obj-name' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'obj-name-or-id' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'obj-status' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'obj-status-info' => {
        'category' => 'dfm',
        'fields' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'object-perf-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'object-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'parent-dataset' => {
        'category' => 'dfm',
        'fields' => {
            'id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'parent-group' => {
        'category' => 'dfm',
        'fields' => {
            'full-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'parent-object' => {
        'category' => 'dfm',
        'fields' => {
            'full-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'parent-resourcepool' => {
        'category' => 'dfm',
        'fields' => {
            'id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'plugin' => {
        'category' => 'dfm',
        'fields' => {
            'plugin-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'product-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'special-build' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'prefix-length' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'resource-property-values' => {
        'category' => 'dfm',
        'fields' => {
            'resource-property' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'values' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snmp-authentication-protocol' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'snmp-id' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'snmp-version' => {
        'category' => 'dfm',
        'fields' => {
        },
    },
    'daily-info' => {
        'category' => 'dfm-schedule',
        'fields' => {
            'item-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-hour' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'start-minute' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'hourly-info' => {
        'category' => 'dfm-schedule',
        'fields' => {
            'end-hour' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'end-minute' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'frequency' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-hour' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'start-minute' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'monthly-info' => {
        'category' => 'dfm-schedule',
        'fields' => {
            'day-of-month' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'day-of-week' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-hour' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'start-minute' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'week-of-month' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'monthly-subschedule-info' => {
        'category' => 'dfm-schedule',
        'fields' => {
            'subschedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'subschedule-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'schedule-assignee' => {
        'category' => 'dfm-schedule',
        'fields' => {
            'assignee-full-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'assignee-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'assignee-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'schedule-content-info' => {
        'category' => 'dfm-schedule',
        'fields' => {
            'daily-list' => {
                'type' => 'daily-info',
                'flags' => 7,
                'scope' => [],
            },
            'hourly-list' => {
                'type' => 'hourly-info',
                'flags' => 7,
                'scope' => [],
            },
            'is-modifiable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'monthly-list' => {
                'type' => 'monthly-info',
                'flags' => 7,
                'scope' => [],
            },
            'monthly-subschedule-list' => {
                'type' => 'monthly-subschedule-info',
                'flags' => 7,
                'scope' => [],
            },
            'schedule-category' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'weekly-list' => {
                'type' => 'weekly-info',
                'flags' => 7,
                'scope' => [],
            },
            'weekly-subschedule-list' => {
                'type' => 'weekly-subschedule-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'schedule-id-info' => {
        'category' => 'dfm-schedule',
        'fields' => {
            'id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'weekly-info' => {
        'category' => 'dfm-schedule',
        'fields' => {
            'day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-hour' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'start-minute' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'weekly-subschedule-info' => {
        'category' => 'dfm-schedule',
        'fields' => {
            'end-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-day-of-week' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'subschedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'subschedule-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'disk-info' => {
        'category' => 'disk',
        'fields' => {
            'aggregate-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'aggregate-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'disk-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'disk-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'disk-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'disk-uid-or-wwn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'plex-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'raidgroup-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'application-backup-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'application-backup-properties' => {
                'type' => 'property-info',
                'flags' => 3,
                'scope' => [],
            },
            'application-resource-namespace' => {
                'type' => 'application-resource-namespace',
                'flags' => 0,
                'scope' => [],
            },
            'backup-graph-info' => {
                'type' => 'backup-graph-info',
                'flags' => 5,
                'scope' => [],
            },
            'host-service-backup-id' => {
                'type' => 'host-service-unique-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'application-object-type' => {
        'category' => 'dp-backup',
        'fields' => {
        },
    },
    'backup-graph-edge-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'from-resource-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'to-resource-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'backup-graph-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'graph-edges' => {
                'type' => 'backup-graph-edge-info',
                'flags' => 3,
                'scope' => [],
            },
            'graph-resources' => {
                'type' => 'backup-graph-resource-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'backup-graph-resource-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'application-resource-properties' => {
                'type' => 'property-info',
                'flags' => 3,
                'scope' => [],
            },
            'host-service-object-id' => {
                'type' => 'host-service-unique-id',
                'flags' => 0,
                'scope' => [],
            },
            'is-restorable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'object-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'object-name-when-backed-up' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'resource-type' => {
                'type' => 'application-object-type',
                'flags' => 0,
                'scope' => [],
            },
            'snapshots' => {
                'type' => 'snapshot-member-info',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'backup-location-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'member-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'member-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'path-found' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'primary-snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-qtree-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-qtree-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-system-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'storage-system-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'backup-mount-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'mount-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'mount-job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'mount-state' => {
                'type' => 'mount-state',
                'flags' => 0,
                'scope' => [],
            },
            'mounted-by' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unmount-job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dfm-metadata' => {
        'category' => 'dp-backup',
        'fields' => {
            'field-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'field-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-backup-content-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'dp-file-info' => {
                'type' => 'dp-file-info',
                'flags' => 5,
                'scope' => [],
            },
            'primary-snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'root-object-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'root-object-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'root-object-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-backup-id-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'backup-metadata' => {
                'type' => 'dfm-metadata',
                'flags' => 7,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'node-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-backup-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'application-backup-infos' => {
                'type' => 'application-backup-info',
                'flags' => 7,
                'scope' => [],
            },
            'backup-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'backup-metadata' => {
                'type' => 'dfm-metadata',
                'flags' => 7,
                'scope' => [],
            },
            'backup-mount-infos' => {
                'type' => 'backup-mount-info',
                'flags' => 7,
                'scope' => [],
            },
            'backup-transfer-infos' => {
                'type' => 'dp-backup-transfer-info',
                'flags' => 3,
                'scope' => [],
            },
            'backup-transfer-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'is-adding-members' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-backup-destination-node' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-for-propagation' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-mirror-destination-node' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'retention-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 0,
                'scope' => [],
            },
            'supports-non-disruptive-restore' => {
                'type' => 'requires-non-disruptive-restore',
                'flags' => 0,
                'scope' => [],
            },
            'version-members' => {
                'type' => 'version-member-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-backup-path-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'member-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'member-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-backup-retention-type' => {
        'category' => 'dp-backup',
        'fields' => {
        },
    },
    'dp-backup-transfer-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'backup-transfer-needed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'backup-transfer-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'connection-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-backup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'destination-node-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'destination-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-storageset-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-backup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-node-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'source-storageset-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-backup-version-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'backup-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-id-infos' => {
                'type' => 'dp-backup-id-info',
                'flags' => 3,
                'scope' => [],
            },
            'backup-transfer-infos' => {
                'type' => 'dp-backup-transfer-info',
                'flags' => 3,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'is-fully-propagated' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 0,
                'scope' => [],
            },
            'version-members' => {
                'type' => 'version-member-info',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'dp-file-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'child-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'file-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'file-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'file-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-empty' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'last-modified-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-job-data' => {
        'category' => 'dp-backup',
        'fields' => {
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dp-job-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dp-local-snapshot-job-data' => {
                'type' => 'dp-local-snapshot-job-data',
                'flags' => 5,
                'scope' => [],
            },
            'dp-snapmirror-transfer-job-data' => {
                'type' => 'dp-snapmirror-transfer-job-data',
                'flags' => 5,
                'scope' => [],
            },
            'dp-snapvault-transfer-job-data' => {
                'type' => 'dp-snapvault-transfer-job-data',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'mount-state' => {
        'category' => 'dp-backup',
        'fields' => {
        },
    },
    'property-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'property-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'property-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'search-key' => {
        'category' => 'dp-backup',
        'fields' => {
        },
    },
    'snapshot-member-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'primary-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'primary-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-host-service-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-qtree-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-qtree-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'secondary-qtree-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'version-member-info' => {
        'category' => 'dp-backup',
        'fields' => {
            'host-address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'host-fqdn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-contents' => {
                'type' => 'snapshot-member-info',
                'flags' => 3,
                'scope' => [],
            },
            'snapshot-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'application-resource-info' => {
        'category' => 'dp-dashboard',
        'fields' => {
            'application-object-type' => {
                'type' => 'application-object-type',
                'flags' => 0,
                'scope' => [],
            },
            'application-resource-namespace' => {
                'type' => 'application-resource-namespace',
                'flags' => 0,
                'scope' => [],
            },
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-dataset-lag-info' => {
        'category' => 'dp-dashboard',
        'fields' => {
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'lag-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'worst-lag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-relationship-lag-info' => {
        'category' => 'dp-dashboard',
        'fields' => {
            'lag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'relationship-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'relationship-source' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'relationship-state' => {
                'type' => 'relationship-state',
                'flags' => 0,
                'scope' => [],
            },
            'relationship-type' => {
                'type' => 'relationship-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dr-state-status-count' => {
        'category' => 'dp-dashboard',
        'fields' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dr-state' => {
                'type' => 'dr-state',
                'flags' => 0,
                'scope' => [],
            },
            'dr-status' => {
                'type' => 'dr-status',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-acl' => {
        'category' => 'dp-job',
        'fields' => {
            'access-rights' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'destroy-member-request-info' => {
        'category' => 'dp-job',
        'fields' => {
            'member-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'member-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'member-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-job-info' => {
        'category' => 'dp-job',
        'fields' => {
            'abort-requested-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'bytes-transferred' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'completed-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-node-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'destination-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'job-context-application-resource-namespaces' => {
                'type' => 'application-resource-namespace',
                'flags' => 6,
                'scope' => [],
            },
            'job-context-obj-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'job-context-obj-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'job-context-obj-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'job-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'job-overall-status' => {
                'type' => 'dp-job-overall-status',
                'flags' => 0,
                'scope' => [],
            },
            'job-progress' => {
                'type' => 'dp-job-progress',
                'flags' => 0,
                'scope' => [],
            },
            'job-state' => {
                'type' => 'dp-job-state',
                'flags' => 0,
                'scope' => [],
            },
            'job-type' => {
                'type' => 'dp-job-type',
                'flags' => 0,
                'scope' => [],
            },
            'object-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'object-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'policy-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'provision-request-info' => {
                'type' => 'provision-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'source-node-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'source-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'started-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'submitted-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-job-overall-status' => {
        'category' => 'dp-job',
        'fields' => {
        },
    },
    'dp-job-progress' => {
        'category' => 'dp-job',
        'fields' => {
        },
    },
    'dp-job-progress-event-info' => {
        'category' => 'dp-job',
        'fields' => {
            'dp-progress-backup-info' => {
                'type' => 'dp-progress-backup-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-progress-failover-info' => {
                'type' => 'dp-progress-failover-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-progress-job-abort-info' => {
                'type' => 'dp-progress-job-abort-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-progress-relationship-info' => {
                'type' => 'dp-progress-relationship-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-progress-restore-info' => {
                'type' => 'dp-progress-restore-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-progress-snapmirror-info' => {
                'type' => 'dp-progress-snapmirror-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-progress-snapshot-info' => {
                'type' => 'dp-progress-snapshot-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-progress-snapvault-info' => {
                'type' => 'dp-progress-snapvault-info',
                'flags' => 5,
                'scope' => [],
            },
            'error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'event-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'event-message' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'event-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'event-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'job-type' => {
                'type' => 'dp-job-type',
                'flags' => 0,
                'scope' => [],
            },
            'progress-aggregate-info' => {
                'type' => 'progress-aggregate-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-cifs-share-info' => {
                'type' => 'progress-cifs-share-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-host-service-info' => {
                'type' => 'progress-host-service-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-igroup-config-info' => {
                'type' => 'progress-igroup-config-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-igroup-info' => {
                'type' => 'progress-igroup-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-lun-info' => {
                'type' => 'progress-lun-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-lun-map-info' => {
                'type' => 'progress-lun-map-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-nfsexport-info' => {
                'type' => 'progress-nfsexport-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-qtree-info' => {
                'type' => 'progress-qtree-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-quota-info' => {
                'type' => 'progress-quota-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-resource-pool-info' => {
                'type' => 'progress-resource-pool-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-script-run-info' => {
                'type' => 'progress-script-run-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-storage-service-info' => {
                'type' => 'progress-storage-service-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-storage-system-info' => {
                'type' => 'progress-storage-system-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-vfiler-info' => {
                'type' => 'progress-vfiler-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-vfiler-storage-info' => {
                'type' => 'progress-vfiler-storage-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-volume-dedupe-info' => {
                'type' => 'progress-volume-dedupe-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-volume-info' => {
                'type' => 'progress-volume-info',
                'flags' => 5,
                'scope' => [],
            },
            'progress-volume-option-info' => {
                'type' => 'progress-volume-option-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'dp-job-state' => {
        'category' => 'dp-job',
        'fields' => {
        },
    },
    'dp-job-type' => {
        'category' => 'dp-job',
        'fields' => {
        },
    },
    'dp-local-snapshot-job-data' => {
        'category' => 'dp-job',
        'fields' => {
            'is-confirmation-data' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'node-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-progress-backup-info' => {
        'category' => 'dp-job',
        'fields' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'retention' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-progress-failover-info' => {
        'category' => 'dp-job',
        'fields' => {
            'destination-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'environment-variable-list' => {
                'type' => 'environment-variable-info',
                'flags' => 7,
                'scope' => [],
            },
            'relationship-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'script-exit-status' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'script-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'script-run-as' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'script-summary' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-progress-job-abort-info' => {
        'category' => 'dp-job',
        'fields' => {
            'aborted-by' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-progress-relationship-info' => {
        'category' => 'dp-job',
        'fields' => {
            'bytes-transferred' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'destination-volume-or-qtree-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'destination-volume-or-qtree-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'relationship-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-volume-or-qtree-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'source-volume-or-qtree-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-progress-restore-info' => {
        'category' => 'dp-job',
        'fields' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'bytes-transferred' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'destination-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'member-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'member-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-progress-snapmirror-info' => {
        'category' => 'dp-job',
        'fields' => {
            'bytes-transferred' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'destination-volume-or-qtree-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'destination-volume-or-qtree-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-volume-or-qtree-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'source-volume-or-qtree-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-progress-snapshot-info' => {
        'category' => 'dp-job',
        'fields' => {
            'snapshot-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-progress-snapvault-info' => {
        'category' => 'dp-job',
        'fields' => {
            'bytes-transferred' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'destination-qtree-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'destination-qtree-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'source-qtree-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'source-qtree-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-scheduled-job' => {
        'category' => 'dp-job',
        'fields' => {
            'dataset-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dp-local-snapshot-job-data' => {
                'type' => 'dp-local-snapshot-job-data',
                'flags' => 5,
                'scope' => [],
            },
            'dp-snapmirror-transfer-job-data' => {
                'type' => 'dp-snapmirror-transfer-job-data',
                'flags' => 5,
                'scope' => [],
            },
            'dp-snapvault-transfer-job-data' => {
                'type' => 'dp-snapvault-transfer-job-data',
                'flags' => 5,
                'scope' => [],
            },
            'scheduled-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-snapmirror-transfer-job-data' => {
        'category' => 'dp-job',
        'fields' => {
            'connection-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-snapvault-transfer-job-data' => {
        'category' => 'dp-job',
        'fields' => {
            'connection-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-timestamp' => {
        'category' => 'dp-job',
        'fields' => {
        },
    },
    'environment-variable-info' => {
        'category' => 'dp-job',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'job-type' => {
        'category' => 'dp-job',
        'fields' => {
        },
    },
    'progress-aggregate-info' => {
        'category' => 'dp-job',
        'fields' => {
            'aggregate-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-cifs-share-info' => {
        'category' => 'dp-job',
        'fields' => {
            'cifs-acl-list' => {
                'type' => 'cifs-acl',
                'flags' => 7,
                'scope' => [],
            },
            'cifs-share-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vol-or-qtree-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'vol-or-qtree-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-host-service-info' => {
        'category' => 'dp-job',
        'fields' => {
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-service-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'operation-id' => {
                'type' => 'host-service-unique-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-igroup-config-info' => {
        'category' => 'dp-job',
        'fields' => {
            'igroup-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'igroup-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'initiators' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-igroup-info' => {
        'category' => 'dp-job',
        'fields' => {
            'igroup-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'igroup-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-lun-info' => {
        'category' => 'dp-job',
        'fields' => {
            'lun-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'lun-path-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-lun-map-info' => {
        'category' => 'dp-job',
        'fields' => {
            'igroup-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'igroup-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'lun-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'lun-path-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-nfsexport-info' => {
        'category' => 'dp-job',
        'fields' => {
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qtree-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'qtree-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-qtree-info' => {
        'category' => 'dp-job',
        'fields' => {
            'qtree-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'qtree-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-quota-info' => {
        'category' => 'dp-job',
        'fields' => {
            'default-group-quota' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'default-user-quota' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'qtree-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'qtree-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'tree-quota' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'progress-resource-pool-info' => {
        'category' => 'dp-job',
        'fields' => {
            'resource-pool-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'resource-pool-members' => {
                'type' => 'resource-pool-member',
                'flags' => 3,
                'scope' => [],
            },
            'resource-pool-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-script-run-info' => {
        'category' => 'dp-job',
        'fields' => {
            'script-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-storage-service-info' => {
        'category' => 'dp-job',
        'fields' => {
            'storage-service-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-storage-system-info' => {
        'category' => 'dp-job',
        'fields' => {
            'storage-system-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'storage-system-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-vfiler-info' => {
        'category' => 'dp-job',
        'fields' => {
            'filer-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'filer-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'ipaddress' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-vfiler-storage-info' => {
        'category' => 'dp-job',
        'fields' => {
            'vfiler-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'vfiler-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-volume-dedupe-info' => {
        'category' => 'dp-job',
        'fields' => {
            'dedupe-progress' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dedupe-schedule' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dedupe-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-volume-info' => {
        'category' => 'dp-job',
        'fields' => {
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'progress-volume-option-info' => {
        'category' => 'dp-job',
        'fields' => {
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'volume-options' => {
                'type' => 'volume-option',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'provision-request-info' => {
        'category' => 'dp-job',
        'fields' => {
            'dedupe-member-request-info' => {
                'type' => 'dedupe-member-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'delete-snapshots-request-info' => {
                'type' => 'delete-snapshots-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'destroy-member-request-info' => {
                'type' => 'destroy-member-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'provision-member-request-info' => {
                'type' => 'provision-member-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'resize-member-request-info' => {
                'type' => 'resize-member-request-info',
                'flags' => 5,
                'scope' => [],
            },
            'undedupe-member-request-info' => {
                'type' => 'undedupe-member-request-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'resource-pool-member' => {
        'category' => 'dp-job',
        'fields' => {
            'resource-pool-member-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'resource-pool-member-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-option' => {
        'category' => 'dp-job',
        'fields' => {
            'option-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dataset-reference' => {
        'category' => 'dp-ossv-directory',
        'fields' => {
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-directory-info' => {
        'category' => 'dp-ossv-directory',
        'fields' => {
            'dataset-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'datasets' => {
                'type' => 'dataset-reference',
                'flags' => 3,
                'scope' => [],
            },
            'dir-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-browsable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-in-backup-relationship' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-ossv-directory-name' => {
        'category' => 'dp-ossv-directory',
        'fields' => {
        },
    },
    'dp-ossv-directory-root-info' => {
        'category' => 'dp-ossv-directory',
        'fields' => {
            'filesystem-device' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'filesystem-state' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'filesystem-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'root-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ossv-application-info' => {
        'category' => 'dp-ossv-directory',
        'fields' => {
            'can-backup' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-leaf' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'ossv-application-restore-destination-info' => {
        'category' => 'dp-ossv-directory',
        'fields' => {
            'host-full-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ossv-host-name-or-id' => {
        'category' => 'dp-ossv-directory',
        'fields' => {
        },
    },
    'dp-policy-connection-info' => {
        'category' => 'dp-policy',
        'fields' => {
            'backup-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'backup-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'from-node-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'from-node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-dr-capable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-lag-error-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-lag-warning-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'lag-error-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lag-warning-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'mirror-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'throttle-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'throttle-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'to-node-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'to-node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-policy-content' => {
        'category' => 'dp-policy',
        'fields' => {
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dp-policy-connections' => {
                'type' => 'dp-policy-connection-info',
                'flags' => 7,
                'scope' => [],
            },
            'dp-policy-nodes' => {
                'type' => 'dp-policy-node-info',
                'flags' => 3,
                'scope' => [],
            },
            'name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-policy-info' => {
        'category' => 'dp-policy',
        'fields' => {
            'dp-policy-content' => {
                'type' => 'dp-policy-content',
                'flags' => 1,
                'scope' => [],
            },
            'id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'is-application-compatible' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-modifiable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-non-disruptive-restore-compatible' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-policy-node-info' => {
        'category' => 'dp-policy',
        'fields' => {
            'backup-script-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'backup-script-run-as' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'daily-retention-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'daily-retention-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'failover-script-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'failover-script-run-as' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'hourly-retention-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hourly-retention-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'is-lag-error-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-lag-warning-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'lag-error-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lag-warning-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'monthly-retention-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'monthly-retention-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'weekly-retention-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'weekly-retention-duration' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-policy-node-name' => {
        'category' => 'dp-policy',
        'fields' => {
        },
    },
    'dp-relationship-info' => {
        'category' => 'dp-relationship',
        'fields' => {
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'deleted-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'destination-aggregate-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'destination-full-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'destination-host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'destination-host-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'destination-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'destination-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'destination-storageset-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'destination-type' => {
                'type' => 'relationship-endpoint-type',
                'flags' => 0,
                'scope' => [],
            },
            'destination-volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'discovered-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-imported' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-managed' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-orphan' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-redundant' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'lag' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lag-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'operational-status' => {
                'type' => 'operational-status',
                'flags' => 0,
                'scope' => [],
            },
            'relationship-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'relationship-state' => {
                'type' => 'relationship-state',
                'flags' => 0,
                'scope' => [],
            },
            'relationship-type' => {
                'type' => 'relationship-type',
                'flags' => 0,
                'scope' => [],
            },
            'source-aggregate-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'source-full-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'source-host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'source-host-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'source-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'source-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'source-storageset-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'source-type' => {
                'type' => 'relationship-endpoint-type',
                'flags' => 0,
                'scope' => [],
            },
            'source-volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'operational-status' => {
        'category' => 'dp-relationship',
        'fields' => {
        },
    },
    'relationship-endpoint-type' => {
        'category' => 'dp-relationship',
        'fields' => {
        },
    },
    'relationship-state' => {
        'category' => 'dp-relationship',
        'fields' => {
        },
    },
    'relationship-type' => {
        'category' => 'dp-relationship',
        'fields' => {
        },
    },
    'dp-path-info' => {
        'category' => 'dp-restore',
        'fields' => {
            'member-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'primary-snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'restore-configuration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-recover-member-info' => {
        'category' => 'dp-restore',
        'fields' => {
            'destination-host' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'destination-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'destination-path-skip-extra-directory' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'member-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'primary-snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'primary-snapshot-unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'restore-configuration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-vi-hyperv-restore-settings' => {
        'category' => 'dp-restore',
        'fields' => {
            'start-vm-after-restore' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-vi-object-restore-settings' => {
        'category' => 'dp-restore',
        'fields' => {
            'dp-vi-vmware-object-restore-settings' => {
                'type' => 'dp-vi-vmware-object-restore-settings',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'dp-vi-restore-object' => {
        'category' => 'dp-restore',
        'fields' => {
            'dp-vi-object-restore-settings' => {
                'type' => 'dp-vi-object-restore-settings',
                'flags' => 5,
                'scope' => [],
            },
            'restore-object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dp-vi-restore-settings' => {
        'category' => 'dp-restore',
        'fields' => {
            'dp-vi-hyperv-restore-settings' => {
                'type' => 'dp-vi-hyperv-restore-settings',
                'flags' => 5,
                'scope' => [],
            },
            'dp-vi-vmware-restore-settings' => {
                'type' => 'dp-vi-vmware-restore-settings',
                'flags' => 5,
                'scope' => [],
            },
            'restore-script' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-vi-vmware-object-restore-settings' => {
        'category' => 'dp-restore',
        'fields' => {
            'destination-datastore-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dp-vi-vmware-restore-settings' => {
        'category' => 'dp-restore',
        'fields' => {
            'esx-server-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'start-vm-after-restore' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'overwrite-result' => {
        'category' => 'dp-restore',
        'fields' => {
            'dest-host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'file-path' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'overwrite-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'space-status-result' => {
        'category' => 'dp-restore',
        'fields' => {
            'avail-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dest-host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dest-vol' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'req-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'day-info' => {
        'category' => 'dp-throttle',
        'fields' => {
            'day' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'throttle-assignee' => {
        'category' => 'dp-throttle',
        'fields' => {
            'assignee-full-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'assignee-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'throttle-content' => {
        'category' => 'dp-throttle',
        'fields' => {
            'is-modifiable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'throttle-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'throttle-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'throttle-item-list' => {
                'type' => 'throttle-item-info',
                'flags' => 7,
                'scope' => [],
            },
            'throttle-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'throttle-item-info' => {
        'category' => 'dp-throttle',
        'fields' => {
            'day-list' => {
                'type' => 'day-info',
                'flags' => 7,
                'scope' => [],
            },
            'end-hour' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'end-minute' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'item-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-hour' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'start-minute' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'throughput' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'event-action-info' => {
        'category' => 'event',
        'fields' => {
            'error-code' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'error-message' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'event-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'event-application-type' => {
        'category' => 'event',
        'fields' => {
        },
    },
    'event-id-type' => {
        'category' => 'event',
        'fields' => {
        },
    },
    'event-info' => {
        'category' => 'event',
        'fields' => {
            'event-about' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-acknowledged' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'event-acknowledged-user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-arguments' => {
                'type' => 'key-value-pair',
                'flags' => 7,
                'scope' => [],
            },
            'event-condition' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-deleted' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'event-deleted-user' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'event-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-originating-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'event-severity' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'event-source-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'event-source-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-source-node-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'event-source-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'event-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-deleted' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'event-timestamp-range' => {
        'category' => 'event',
        'fields' => {
            'end-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'event-type-filter' => {
        'category' => 'event',
        'fields' => {
            'event-filter' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'event-class-info' => {
        'category' => 'eventclass',
        'fields' => {
            'about-message' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-class-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'event-class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-names' => {
                'type' => 'event-name-info',
                'flags' => 3,
                'scope' => [],
            },
            'is-allow-duplicates' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-multi-current' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'event-class-object' => {
        'category' => 'eventclass',
        'fields' => {
            'event-class-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'event-name-info' => {
        'category' => 'eventclass',
        'fields' => {
            'event-name-pretty' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'event-name-short' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'severity' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'target-info' => {
        'category' => 'fcp-target',
        'fields' => {
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'target-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'target-port-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'graph-line-value-info' => {
        'category' => 'graph',
        'fields' => {
            'sample-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'sample-values' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-info' => {
        'category' => 'group',
        'fields' => {
            'group-perf-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'group-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'has-privilege' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'parent-group-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'short-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'subgroup-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'group-name-or-id' => {
        'category' => 'group',
        'fields' => {
        },
    },
    'group-option-info' => {
        'category' => 'group',
        'fields' => {
            'chargeback-rate' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-contact' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'group-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'srm-max-large-files' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'srm-max-new-mtime-files' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'srm-max-old-atime-files' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'srm-max-old-mtime-files' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'object-name-or-id' => {
        'category' => 'group',
        'fields' => {
        },
    },
    'group' => {
        'category' => 'group_member',
        'fields' => {
        },
    },
    'group-member-attribute' => {
        'category' => 'group_member',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'group-member-info' => {
        'category' => 'group_member',
        'fields' => {
            'group-member-attributes' => {
                'type' => 'group-member-attribute',
                'flags' => 7,
                'scope' => [],
            },
            'id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'perf-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'sub-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'access-object-description' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'access-object-id' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'access-object-name' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'access-object-name-or-id' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'capability' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'domainuser-name' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'domainuser-name-or-id-or-sid' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'full-ndmp-credentials' => {
        'category' => 'host',
        'fields' => {
            'ndmp-password' => {
                'type' => 'host-password',
                'flags' => 0,
                'scope' => [],
            },
            'ndmp-port' => {
                'type' => 'ip-port-number',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-username' => {
                'type' => 'ndmp-username',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-defaults' => {
        'category' => 'host',
        'fields' => {
            'admin-port-agent' => {
                'type' => 'ip-port-number',
                'flags' => 0,
                'scope' => [],
            },
            'admin-port-cache-http' => {
                'type' => 'ip-port-number',
                'flags' => 0,
                'scope' => [],
            },
            'admin-port-cache-https' => {
                'type' => 'ip-port-number',
                'flags' => 0,
                'scope' => [],
            },
            'admin-port-host' => {
                'type' => 'ip-port-number',
                'flags' => 0,
                'scope' => [],
            },
            'admin-port-host-http' => {
                'type' => 'ip-port-number',
                'flags' => 0,
                'scope' => [],
            },
            'admin-port-host-https' => {
                'type' => 'ip-port-number',
                'flags' => 0,
                'scope' => [],
            },
            'admin-transport-agent' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'admin-transport-cache' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'admin-transport-host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ndmp-port' => {
                'type' => 'ip-port-number',
                'flags' => 0,
                'scope' => [],
            },
            'perf-advisor-transport-host' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapvault-max-backup-threads' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'timeout' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'use-hosts-equiv' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-domainuser-info' => {
        'category' => 'host',
        'fields' => {
            'SID' => {
                'type' => 'sid',
                'flags' => 4,
                'scope' => [],
            },
            'capabilities' => {
                'type' => 'capability',
                'flags' => 6,
                'scope' => [],
            },
            'host-domainuser-id' => {
                'type' => 'access-object-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-domainuser-name' => {
                'type' => 'domainuser-name',
                'flags' => 0,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'host-role-ids' => {
                'type' => 'host-role-id',
                'flags' => 6,
                'scope' => [],
            },
            'host-role-names' => {
                'type' => 'host-role-name',
                'flags' => 6,
                'scope' => [],
            },
            'host-usergroup-ids' => {
                'type' => 'host-usergroup-id',
                'flags' => 6,
                'scope' => [],
            },
            'host-usergroup-names' => {
                'type' => 'host-usergroup-name',
                'flags' => 6,
                'scope' => [],
            },
        },
    },
    'host-dp-filter-info' => {
        'category' => 'host',
        'fields' => {
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-resourcepool' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapmirrored-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapvault-primary-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapvault-secondary-only' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-unprotected' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-dp-info' => {
        'category' => 'host',
        'fields' => {
            'datasets' => {
                'type' => 'dataset-reference',
                'flags' => 3,
                'scope' => [],
            },
            'host-dataset' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'host-resourcepool' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'is-agent-ossv-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-linux-primary' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-ndmp-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-nearstore' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapmirror-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapmirror-host' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapvault-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-snapvault-primary' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapvault-secondary' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-unix-primary' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-windows-ofm-primary' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-windows-primary' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-access-specifier' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'snapmirror-access-specifier' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapvault-access-specifier' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'snapvault-max-backup-threads' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-dp-modify-info' => {
        'category' => 'host',
        'fields' => {
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'snapvault-max-backup-threads' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-id' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'host-info' => {
        'category' => 'host',
        'fields' => {
            'admin-port' => {
                'type' => 'ip-port-number',
                'flags' => 0,
                'scope' => [],
            },
            'admin-transport' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'cifs-domain-info' => {
                'type' => 'cifs-domain-info',
                'flags' => 5,
                'scope' => [],
            },
            'host-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-communication-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-credentials-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-dp-info' => {
                'type' => 'host-dp-info',
                'flags' => 5,
                'scope' => [],
            },
            'host-fqdn' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'host-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-model' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-obj-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'host-os' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-perf-info' => {
                'type' => 'host-perf-info',
                'flags' => 5,
                'scope' => [],
            },
            'host-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-type' => {
                'type' => 'host-type',
                'flags' => 0,
                'scope' => [],
            },
            'host-username' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'licenses' => {
                'type' => 'license',
                'flags' => 2,
                'scope' => [],
            },
            'ndmp-agent-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-communication-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-communication-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-credentials' => {
                'type' => 'ndmp-credentials',
                'flags' => 5,
                'scope' => [],
            },
            'ndmp-credentials-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-timestamp' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'other-host-id' => {
                'type' => 'host-id',
                'flags' => 4,
                'scope' => [],
            },
            'partner-storage-system-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'partner-storage-system-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'perf-advisor-transport' => {
                'type' => 'perf-advisor-transport',
                'flags' => 4,
                'scope' => [],
            },
            'service-statuses' => {
                'type' => 'service-status',
                'flags' => 3,
                'scope' => [],
            },
            'use-hosts-equiv' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-info' => {
                'type' => 'vfiler-info',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'host-modify-info' => {
        'category' => 'host',
        'fields' => {
            'admin-port' => {
                'type' => 'ip-port-number',
                'flags' => 4,
                'scope' => [],
            },
            'admin-transport' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-dp-modify-info' => {
                'type' => 'host-dp-modify-info',
                'flags' => 5,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'host-password' => {
                'type' => 'host-password',
                'flags' => 4,
                'scope' => [],
            },
            'host-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-credentials' => {
                'type' => 'ndmp-credentials',
                'flags' => 5,
                'scope' => [],
            },
            'perf-advisor-transport' => {
                'type' => 'perf-advisor-transport',
                'flags' => 4,
                'scope' => [],
            },
            'use-hosts-equiv' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-name-or-id' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'host-password' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'host-perf-info' => {
        'category' => 'host',
        'fields' => {
            'data-unavailable-reason' => {
                'type' => 'perf-status-error',
                'flags' => 7,
                'scope' => [],
            },
            'host-perf-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'is-cluster-config-shared' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-data-available' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'last-client-stats-collection-time' => {
                'type' => 'timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'percentage-space-consumed' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'space-consumed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'space-projected' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-role-id' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'host-role-info' => {
        'category' => 'host',
        'fields' => {
            'capabilities' => {
                'type' => 'capability',
                'flags' => 6,
                'scope' => [],
            },
            'description' => {
                'type' => 'access-object-description',
                'flags' => 4,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'host-role-id' => {
                'type' => 'access-object-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-role-name' => {
                'type' => 'access-object-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-role-name' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'host-type' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'host-user-info' => {
        'category' => 'host',
        'fields' => {
            'capabilities' => {
                'type' => 'capability',
                'flags' => 6,
                'scope' => [],
            },
            'description' => {
                'type' => 'access-object-description',
                'flags' => 4,
                'scope' => [],
            },
            'full-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'host-role-ids' => {
                'type' => 'host-role-id',
                'flags' => 6,
                'scope' => [],
            },
            'host-role-names' => {
                'type' => 'host-role-name',
                'flags' => 6,
                'scope' => [],
            },
            'host-user-id' => {
                'type' => 'access-object-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-user-name' => {
                'type' => 'access-object-name',
                'flags' => 4,
                'scope' => [],
            },
            'host-usergroup-ids' => {
                'type' => 'host-usergroup-id',
                'flags' => 6,
                'scope' => [],
            },
            'host-usergroup-names' => {
                'type' => 'host-usergroup-name',
                'flags' => 6,
                'scope' => [],
            },
            'maximum-password-age' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'minimum-password-age' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'password' => {
                'type' => 'host-user-password',
                'flags' => 4,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-user-password' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'host-usergroup-id' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'host-usergroup-info' => {
        'category' => 'host',
        'fields' => {
            'capabilities' => {
                'type' => 'capability',
                'flags' => 6,
                'scope' => [],
            },
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'host-role-ids' => {
                'type' => 'host-role-id',
                'flags' => 6,
                'scope' => [],
            },
            'host-role-names' => {
                'type' => 'host-role-name',
                'flags' => 6,
                'scope' => [],
            },
            'host-usergroup-id' => {
                'type' => 'access-object-id',
                'flags' => 4,
                'scope' => [],
            },
            'host-usergroup-name' => {
                'type' => 'usergroup-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-usergroup-name' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'host-usergroup-name-or-id' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'ip-port-number' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'license' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'ndmp-credentials' => {
        'category' => 'host',
        'fields' => {
            'ndmp-password' => {
                'type' => 'host-password',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-port' => {
                'type' => 'ip-port-number',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-username' => {
                'type' => 'ndmp-username',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'ndmp-username' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'perf-advisor-transport' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'service-status' => {
        'category' => 'host',
        'fields' => {
            'service' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'sid' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'usergroup-name' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'usergroup-name-or-id' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'vfiler-info' => {
        'category' => 'host',
        'fields' => {
            'hosting-filer-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'hosting-filer-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-allowed-protocols' => {
                'type' => 'protocol',
                'flags' => 6,
                'scope' => [],
            },
            'vfiler-ipspace' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-migration-info' => {
                'type' => 'vfiler-migration-info',
                'flags' => 1,
                'scope' => [],
            },
            'vfiler-network-resources' => {
                'type' => 'vfiler-network-resource',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'vfiler-ipspace' => {
        'category' => 'host',
        'fields' => {
        },
    },
    'vfiler-migration-info' => {
        'category' => 'host',
        'fields' => {
            'destination-filer-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'destination-filer-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'destination-vfiler-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'destination-vfiler-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'migration-status' => {
                'type' => 'migration-status',
                'flags' => 0,
                'scope' => [],
            },
            'source-filer-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'source-filer-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'source-vfiler-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'source-vfiler-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'vfiler-network-resource' => {
        'category' => 'host',
        'fields' => {
            'interface-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'interface-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'mtu-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-service-info' => {
        'category' => 'host-service',
        'fields' => {
            'admin-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'deleted-by' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-service-ip-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-service-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-service-plugins' => {
                'type' => 'host-service-plugin-info',
                'flags' => 3,
                'scope' => [],
            },
            'host-service-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-service-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-authorized' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'last-discovery-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'mgmt-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'needs-upgrade' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'timezone-info' => {
                'type' => 'timezone-info',
                'flags' => 1,
                'scope' => [],
            },
            'update-service-port' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'update-service-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-service-package-info' => {
        'category' => 'host-service',
        'fields' => {
            'package-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'package-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'package-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-service-plugin-info' => {
        'category' => 'host-service',
        'fields' => {
            'plugin-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'plugin-version' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-system-configuration' => {
        'category' => 'host-service',
        'fields' => {
            'login-protocol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'push-credentials' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'storage-system-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-system-info' => {
        'category' => 'host-service',
        'fields' => {
            'access-protocol' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'login-status-from-dfm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'login-status-from-hs' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-cred-status-from-dfm' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ndmp-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-system-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'storage-system-ip-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-system-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'storage-system-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-system-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'storage-system-username' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'ifc-info' => {
        'category' => 'ifc',
        'fields' => {
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ifc-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'ifc-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'ip-address-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'ipspace' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-vlan-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'mtu-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'netmask' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-interface-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'partner-interface-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ldap-server' => {
        'category' => 'ldap',
        'fields' => {
            'ldap-server-addr' => {
                'type' => 'network-address',
                'flags' => 0,
                'scope' => [],
            },
            'ldap-server-port' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'ldap-server-info' => {
        'category' => 'ldap',
        'fields' => {
            'last-failed-time' => {
                'type' => 'timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'last-used-time' => {
                'type' => 'timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'ldap-server' => {
                'type' => 'ldap-server',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'igroup-reference' => {
        'category' => 'lun',
        'fields' => {
            'igroup-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'igroup-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'lun-info' => {
        'category' => 'lun',
        'fields' => {
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'igroups' => {
                'type' => 'igroup-reference',
                'flags' => 7,
                'scope' => [],
            },
            'is-lun-space-reserved' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'lun-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'lun-path' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'lun-serial-number' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'lun-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'lun-used-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'object-perf-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'object-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'qtree-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'qtree-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'migration-dry-run-result' => {
        'category' => 'migrate',
        'fields' => {
            'dry-run-results' => {
                'type' => 'dry-run-result',
                'flags' => 3,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'migration-job-info' => {
        'category' => 'migrate',
        'fields' => {
            'job-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'migration-request-info' => {
        'category' => 'migrate',
        'fields' => {
            'cleanup-stale-storage' => {
                'type' => 'cleanup-stale-storage',
                'flags' => 4,
                'scope' => [],
            },
            'destination-aggregate-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'retention-type' => {
                'type' => 'dp-backup-retention-type',
                'flags' => 4,
                'scope' => [],
            },
            'run-dedupe-scan' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'run-on-demand-update' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'volumes' => {
                'type' => 'obj-name-or-id',
                'flags' => 2,
                'scope' => [],
            },
        },
    },
    'route-migration-mode' => {
        'category' => 'migrate',
        'fields' => {
        },
    },
    'volume-aggregate-pair' => {
        'category' => 'migrate',
        'fields' => {
            'aggregate' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'netif-ip-interface-info' => {
        'category' => 'netif',
        'fields' => {
            'administrative-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'bytes-in' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'bytes-out' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'discards-in' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'discards-out' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'errors-in' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'errors-out' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'ip-addresses' => {
                'type' => 'string',
                'flags' => 2,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'operational-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'packets-in' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'packets-out' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'physical-address' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'speed' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'network-id' => {
        'category' => 'networks',
        'fields' => {
        },
    },
    'network-info' => {
        'category' => 'networks',
        'fields' => {
            'hop-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'last-searched-time' => {
                'type' => 'timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'network-address' => {
                'type' => 'network-address',
                'flags' => 0,
                'scope' => [],
            },
            'network-id' => {
                'type' => 'network-id',
                'flags' => 0,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'prefix-length',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'cifs-op-stats' => {
        'category' => 'perf',
        'fields' => {
            'other-operations' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'read-operations' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'write-operations' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'client-stat-error' => {
        'category' => 'perf',
        'fields' => {
            'cifs-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nfs-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'client-stats' => {
        'category' => 'perf',
        'fields' => {
            'cifs-op-stats' => {
                'type' => 'cifs-op-stats',
                'flags' => 5,
                'scope' => [],
            },
            'client-name-or-ip' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'nfs-op-stats' => {
                'type' => 'nfs-op-stats',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'counter-threshold-info' => {
        'category' => 'perf',
        'fields' => {
            'perf-object-counter' => {
                'type' => 'perf-object-counter',
                'flags' => 1,
                'scope' => [],
            },
            'threshold-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-unit' => {
                'type' => 'counter-unit',
                'flags' => 0,
                'scope' => [],
            },
            'threshold-value' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'counter-unit' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'day' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'destination-host-info' => {
        'category' => 'perf',
        'fields' => {
            'error-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'dynamic-data' => {
        'category' => 'perf',
        'fields' => {
            'hostname' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'perf-instance',
                'flags' => 5,
                'scope' => [],
            },
            'obj-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'host-client-stats' => {
        'category' => 'perf',
        'fields' => {
            'collection-period' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'object-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'stat-id' => {
                'type' => 'stat-id',
                'flags' => 0,
                'scope' => [],
            },
            'stats' => {
                'type' => 'client-stats',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'instance-counter-info' => {
        'category' => 'perf',
        'fields' => {
            'counter-info' => {
                'type' => 'perf-object-counter',
                'flags' => 3,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'invalid-counter-instance' => {
        'category' => 'perf',
        'fields' => {
            'counter-info' => {
                'type' => 'perf-object-counter',
                'flags' => 1,
                'scope' => [],
            },
            'err-code' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'err-reason' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'metric' => {
        'category' => 'perf',
        'fields' => {
            'id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'metric-result' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'period' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'slide' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'month' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'nfs-op-stats' => {
        'category' => 'perf',
        'fields' => {
            'other-operations' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'read-operations' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'write-operations' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'object-info' => {
        'category' => 'perf',
        'fields' => {
            'object-full-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'object-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'object-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-assoc-obj-type' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'perf-chart' => {
        'category' => 'perf',
        'fields' => {
            'chart-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'dynamic-data-sources' => {
                'type' => 'perf-dynamic-data-sources',
                'flags' => 5,
                'scope' => [],
            },
            'lines' => {
                'type' => 'perf-line',
                'flags' => 7,
                'scope' => [],
            },
            'maximum-y' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-counter' => {
        'category' => 'perf',
        'fields' => {
            'base-counter' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'desc' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-display' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'labels' => {
                'type' => 'perf-label',
                'flags' => 7,
                'scope' => [],
            },
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'privilege-level' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'properties' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-counter-data' => {
        'category' => 'perf',
        'fields' => {
            'counter-data' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'counter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'label-names' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'metrics' => {
                'type' => 'metric',
                'flags' => 7,
                'scope' => [],
            },
            'object-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-counter-group' => {
        'category' => 'perf',
        'fields' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'counter-info' => {
                'type' => 'perf-object-counter',
                'flags' => 7,
                'scope' => [],
            },
            'data-sources' => {
                'type' => 'perf-data-source',
                'flags' => 7,
                'scope' => [],
            },
            'data-sources-to-be-disabled' => {
                'type' => 'perf-data-source',
                'flags' => 7,
                'scope' => [],
            },
            'end-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-default' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-disable-all' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-stopped' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'number-records' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'perf-file-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'real-time' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'sample-buffer' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'sample-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'space-consumed' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'space-projected' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'start-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-counter-instance' => {
        'category' => 'perf',
        'fields' => {
            'counter-info' => {
                'type' => 'perf-object-counter',
                'flags' => 1,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-data-group' => {
        'category' => 'perf',
        'fields' => {
            'data-group-method' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'data-sources' => {
                'type' => 'perf-data-source',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-data-source' => {
        'category' => 'perf',
        'fields' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'label-names' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'object-full-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'object-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-dependent-counter-info' => {
        'category' => 'perf',
        'fields' => {
            'counter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'object-counters' => {
                'type' => 'perf-object-counter',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'perf-diag-category' => {
        'category' => 'perf',
        'fields' => {
            'category-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'category-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'health-checks' => {
                'type' => 'perf-health-check',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-dynamic-data-sources' => {
        'category' => 'perf',
        'fields' => {
            'color' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'data-source' => {
                'type' => 'perf-data-source',
                'flags' => 5,
                'scope' => [],
            },
            'maximum-instances' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'select-all-instances' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'sort-order' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'time-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-health-check' => {
        'category' => 'perf',
        'fields' => {
            'health-check-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'health-check-status' => {
                'type' => 'obj-status',
                'flags' => 0,
                'scope' => [],
            },
            'observation' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'recommendation' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-instance' => {
        'category' => 'perf',
        'fields' => {
            'instance-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-instance-counter-data' => {
        'category' => 'perf',
        'fields' => {
            'counters' => {
                'type' => 'perf-counter-data',
                'flags' => 3,
                'scope' => [],
            },
            'instance-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'object-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-label' => {
        'category' => 'perf',
        'fields' => {
            'label-names' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-line' => {
        'category' => 'perf',
        'fields' => {
            'color' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'data-group' => {
                'type' => 'perf-data-group',
                'flags' => 1,
                'scope' => [],
            },
            'line-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-missing-host-object-counter' => {
        'category' => 'perf',
        'fields' => {
            'host-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'missing-object-counters' => {
                'type' => 'perf-object-counter',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-object' => {
        'category' => 'perf',
        'fields' => {
            'assoc-obj-type' => {
                'type' => 'perf-assoc-obj-type',
                'flags' => 0,
                'scope' => [],
            },
            'object-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-object-counter' => {
        'category' => 'perf',
        'fields' => {
            'counter-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'counter-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-calculated-stats' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'label-names' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'metrics' => {
                'type' => 'metric',
                'flags' => 7,
                'scope' => [],
            },
            'object-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'perf-labels' => {
                'type' => 'perf-label',
                'flags' => 7,
                'scope' => [],
            },
            'time-consolidation-method' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'perf-object-counter-info' => {
        'category' => 'perf',
        'fields' => {
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'perf-object-counter' => {
                'type' => 'perf-object-counter',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'perf-purged-host-object-counter' => {
        'category' => 'perf',
        'fields' => {
            'host-name-or-id' => {
                'type' => 'host-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'purged-object-counters-details' => {
                'type' => 'perf-purged-object-counters-details',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-purged-object-counters-details' => {
        'category' => 'perf',
        'fields' => {
            'current-retention-period' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'new-retention-period' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'purged-object-counters' => {
                'type' => 'perf-object-counter',
                'flags' => 3,
                'scope' => [],
            },
        },
    },
    'perf-report' => {
        'category' => 'perf',
        'fields' => {
            'report-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-server-status' => {
        'category' => 'perf',
        'fields' => {
            'data-collection-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'object-update-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'server-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-status-error' => {
        'category' => 'perf',
        'fields' => {
            'error' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-threshold' => {
        'category' => 'perf',
        'fields' => {
            'perf-threshold-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'perf-view' => {
        'category' => 'perf',
        'fields' => {
            'appliance-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'are-events-shown' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'assoc-obj-type' => {
                'type' => 'perf-assoc-obj-type',
                'flags' => 6,
                'scope' => [],
            },
            'charts' => {
                'type' => 'perf-chart',
                'flags' => 7,
                'scope' => [],
            },
            'counter-group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'group-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-default' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-stopped' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'sample-buffer' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'sample-rate' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'view-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'view-type' => {
                'type' => 'view-type',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'resource-property-condition' => {
        'category' => 'perf',
        'fields' => {
            'name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'stat-id' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'threshold-id' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'threshold-info' => {
        'category' => 'perf',
        'fields' => {
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'object-full-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
            'object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'perf-object-counter' => {
                'type' => 'perf-object-counter',
                'flags' => 5,
                'scope' => [],
            },
            'threshold-id' => {
                'type' => 'threshold-id',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-interval' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-unit' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-value' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'threshold-info2' => {
        'category' => 'perf',
        'fields' => {
            'counter-thresholds' => {
                'type' => 'counter-threshold-info',
                'flags' => 3,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-indirect' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'objects-info' => {
                'type' => 'object-info',
                'flags' => 7,
                'scope' => [],
            },
            'resource-property-conditions' => {
                'type' => 'resource-property-condition',
                'flags' => 7,
                'scope' => [],
            },
            'template-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'template-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-event-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'threshold-id' => {
                'type' => 'threshold-id',
                'flags' => 4,
                'scope' => [],
            },
            'threshold-interval' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'threshold-template' => {
        'category' => 'perf',
        'fields' => {
            'template-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'threshold-template-info' => {
        'category' => 'perf',
        'fields' => {
            'applied-objects' => {
                'type' => 'object-info',
                'flags' => 3,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'member-thresholds' => {
                'type' => 'threshold-info2',
                'flags' => 7,
                'scope' => [],
            },
            'template-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'template-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'template-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'time-filter' => {
        'category' => 'perf',
        'fields' => {
            'days' => {
                'type' => 'day',
                'flags' => 6,
                'scope' => [],
            },
            'months' => {
                'type' => 'month',
                'flags' => 6,
                'scope' => [],
            },
            'time-ranges' => {
                'type' => 'time-range',
                'flags' => 7,
                'scope' => [],
            },
        },
    },
    'time-range' => {
        'category' => 'perf',
        'fields' => {
            'from' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'to' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'view-type' => {
        'category' => 'perf',
        'fields' => {
        },
    },
    'advanced-option-info' => {
        'category' => 'provisioning-policy',
        'fields' => {
            'option-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'option-value' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'custom-provisioning-script-settings' => {
        'category' => 'provisioning-policy',
        'fields' => {
            'script-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dataset-member-used-space-thresholds' => {
        'category' => 'provisioning-policy',
        'fields' => {
            'full-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'nearly-full-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'nas-container-settings' => {
        'category' => 'provisioning-policy',
        'fields' => {
            'auto-delete-snapshots' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'auto-grow-capacity' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'default-group-quota' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'default-user-quota' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-reserve' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'space-on-demand' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'storage-container-type' => {
                'type' => 'storage-container-type',
                'flags' => 4,
                'scope' => [],
            },
            'thin-provision' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'provisioning-policy-info' => {
        'category' => 'provisioning-policy',
        'fields' => {
            'advanced-options' => {
                'type' => 'advanced-option-info',
                'flags' => 7,
                'scope' => [],
            },
            'custom-provisioning-script-settings' => {
                'type' => 'custom-provisioning-script-settings',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-member-used-space-thresholds' => {
                'type' => 'dataset-member-used-space-thresholds',
                'flags' => 5,
                'scope' => [],
            },
            'dedupe-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'dedupe-schedule' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-policy-readonly' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'nas-container-settings' => {
                'type' => 'nas-container-settings',
                'flags' => 5,
                'scope' => [],
            },
            'provisioning-policy-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'provisioning-policy-type' => {
                'type' => 'provisioning-policy-type',
                'flags' => 4,
                'scope' => [],
            },
            'resource-tag' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'san-container-settings' => {
                'type' => 'san-container-settings',
                'flags' => 5,
                'scope' => [],
            },
            'storage-reliability' => {
                'type' => 'storage-reliability',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'provisioning-policy-type' => {
        'category' => 'provisioning-policy',
        'fields' => {
        },
    },
    'san-container-settings' => {
        'category' => 'provisioning-policy',
        'fields' => {
            'guarantee-writes' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'storage-container-type' => {
                'type' => 'storage-container-type',
                'flags' => 4,
                'scope' => [],
            },
            'thin-provision' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'thin-provisioning-configuration' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'storage-container-type' => {
        'category' => 'provisioning-policy',
        'fields' => {
        },
    },
    'storage-reliability' => {
        'category' => 'provisioning-policy',
        'fields' => {
            'controller-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'disk-failure' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'sub-system-failure' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'qtree-info' => {
        'category' => 'qtree',
        'fields' => {
            'dataset-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'datasets' => {
                'type' => 'dataset-reference',
                'flags' => 3,
                'scope' => [],
            },
            'filer-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'filer-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-direct-vfiler-child' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapvault-secondary-qtree' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'qtree-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'qtree-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'qtree-size' => {
                'type' => 'qtree-size-info',
                'flags' => 1,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'qtree-size-info' => {
        'category' => 'qtree',
        'fields' => {
            'files-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'files-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'hard-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'qtree-perf-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'qtree-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'soft-limit' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'space-used' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'admin-info' => {
        'category' => 'rbac',
        'fields' => {
            'admin-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'admin-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'email-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'pager-address' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'aggregate-name-or-id' => {
        'category' => 'rbac',
        'fields' => {
            'aggregate-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'aggregate-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'aggregate-resource' => {
        'category' => 'rbac',
        'fields' => {
            'aggregate-resource-name-or-id' => {
                'type' => 'aggregate-name-or-id',
                'flags' => 1,
                'scope' => [],
            },
            'filer-identifier' => {
                'type' => 'filer-resource',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'dataset-resource' => {
        'category' => 'rbac',
        'fields' => {
            'dataset-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'filer-resource' => {
        'category' => 'rbac',
        'fields' => {
            'filer-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'filer-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'group-resource' => {
        'category' => 'rbac',
        'fields' => {
            'group-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'group-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'host-resource' => {
        'category' => 'rbac',
        'fields' => {
            'host-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'lun-name-or-id' => {
        'category' => 'rbac',
        'fields' => {
            'lun-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'lun-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'lun-resource' => {
        'category' => 'rbac',
        'fields' => {
            'host-identifier' => {
                'type' => 'host-resource',
                'flags' => 5,
                'scope' => [],
            },
            'lun-identifier-name-or-id' => {
                'type' => 'lun-name-or-id',
                'flags' => 1,
                'scope' => [],
            },
            'volume-identifier' => {
                'type' => 'volume-resource',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'policy-resource' => {
        'category' => 'rbac',
        'fields' => {
            'policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'policy-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'qtree-name-or-id' => {
        'category' => 'rbac',
        'fields' => {
            'qtree-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'qtree-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'qtree-resource' => {
        'category' => 'rbac',
        'fields' => {
            'host-identifier' => {
                'type' => 'host-resource',
                'flags' => 5,
                'scope' => [],
            },
            'qtree-identifier-name-or-id' => {
                'type' => 'qtree-name-or-id',
                'flags' => 1,
                'scope' => [],
            },
            'volume-identifier' => {
                'type' => 'volume-resource',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'rbac-admin-name-or-id' => {
        'category' => 'rbac',
        'fields' => {
            'admin-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'admin-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'rbac-admin-or-usergroup' => {
        'category' => 'rbac',
        'fields' => {
            'admin-or-usergroup-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'admin-or-usergroup-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'rbac-operation' => {
        'category' => 'rbac',
        'fields' => {
            'operation-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'operation-name-details' => {
                'type' => 'rbac-operation-name-details',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'rbac-operation-name-details' => {
        'category' => 'rbac',
        'fields' => {
            'operation-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'operation-synopsis' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'resource-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'rbac-resource-operation' => {
        'category' => 'rbac',
        'fields' => {
            'operation' => {
                'type' => 'rbac-operation',
                'flags' => 1,
                'scope' => [],
            },
            'resource' => {
                'type' => 'resource-identifier',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'rbac-role-resource' => {
        'category' => 'rbac',
        'fields' => {
            'rbac-role-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'rbac-role-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'resource-identifier' => {
        'category' => 'rbac',
        'fields' => {
            'aggregate' => {
                'type' => 'aggregate-resource',
                'flags' => 5,
                'scope' => [],
            },
            'dataset' => {
                'type' => 'dataset-resource',
                'flags' => 5,
                'scope' => [],
            },
            'filer' => {
                'type' => 'filer-resource',
                'flags' => 5,
                'scope' => [],
            },
            'group' => {
                'type' => 'group-resource',
                'flags' => 5,
                'scope' => [],
            },
            'host' => {
                'type' => 'host-resource',
                'flags' => 5,
                'scope' => [],
            },
            'lun' => {
                'type' => 'lun-resource',
                'flags' => 5,
                'scope' => [],
            },
            'policy' => {
                'type' => 'policy-resource',
                'flags' => 5,
                'scope' => [],
            },
            'qtree' => {
                'type' => 'qtree-resource',
                'flags' => 5,
                'scope' => [],
            },
            'rbac-role' => {
                'type' => 'rbac-role-resource',
                'flags' => 5,
                'scope' => [],
            },
            'resource-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resource-pool' => {
                'type' => 'resource-pool-resource',
                'flags' => 5,
                'scope' => [],
            },
            'storage-service' => {
                'type' => 'storage-service-resource',
                'flags' => 5,
                'scope' => [],
            },
            'vfiler' => {
                'type' => 'vfiler-resource',
                'flags' => 5,
                'scope' => [],
            },
            'vfiler-template' => {
                'type' => 'vfiler-template-resource',
                'flags' => 5,
                'scope' => [],
            },
            'volume' => {
                'type' => 'volume-resource',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'resource-pool-resource' => {
        'category' => 'rbac',
        'fields' => {
            'resource-pool-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resource-pool-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'role-attributes-identifier' => {
        'category' => 'rbac',
        'fields' => {
            'capabilities' => {
                'type' => 'rbac-resource-operation',
                'flags' => 3,
                'scope' => [],
            },
            'description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'inherited-roles' => {
                'type' => 'rbac-role-resource',
                'flags' => 3,
                'scope' => [],
            },
            'role-name-and-id' => {
                'type' => 'rbac-role-resource',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'storage-service-resource' => {
        'category' => 'rbac',
        'fields' => {
            'storage-service-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'vfiler-resource' => {
        'category' => 'rbac',
        'fields' => {
            'vfiler-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-name-or-uuid' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'vfiler-template-resource' => {
        'category' => 'rbac',
        'fields' => {
            'vfiler-template-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-template-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'volume-name-or-id' => {
        'category' => 'rbac',
        'fields' => {
            'volume-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'volume-resource' => {
        'category' => 'rbac',
        'fields' => {
            'aggregate-identifier' => {
                'type' => 'aggregate-resource',
                'flags' => 5,
                'scope' => [],
            },
            'host-identifier' => {
                'type' => 'host-resource',
                'flags' => 5,
                'scope' => [],
            },
            'vfiler-identifier' => {
                'type' => 'vfiler-resource',
                'flags' => 5,
                'scope' => [],
            },
            'volume-identifier-name-or-id' => {
                'type' => 'volume-name-or-id',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'category-list-info' => {
        'category' => 'report',
        'fields' => {
            'category-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'category-list' => {
                'type' => 'category-list-info',
                'flags' => 7,
                'scope' => [],
            },
            'category-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-category-custom' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'graph-info' => {
        'category' => 'report',
        'fields' => {
            'deprecated-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'graph-lines' => {
                'type' => 'graph-line-info',
                'flags' => 7,
                'scope' => [],
            },
            'graph-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'graph-pretty-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-default' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-deprecated' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'graph-line-info' => {
        'category' => 'report',
        'fields' => {
            'sample-format' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'sample-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'sample-pretty-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'sample-suffix' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-application' => {
        'category' => 'report',
        'fields' => {
        },
    },
    'report-info' => {
        'category' => 'report',
        'fields' => {
            'deprecated-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'display-tab' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-deprecated' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'output-format-list' => {
                'type' => 'report-output-format',
                'flags' => 2,
                'scope' => [],
            },
            'rbac-operation' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'report-application' => {
                'type' => 'report-application',
                'flags' => 0,
                'scope' => [],
            },
            'report-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'report-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'report-pretty-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'report-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-list-info' => {
        'category' => 'report',
        'fields' => {
            'category-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-interval-allowed' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'report-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'report-design-file-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'report-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'report-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'report-pretty-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'report-provenance' => {
                'type' => 'report-provenance',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-output-format' => {
        'category' => 'report',
        'fields' => {
        },
    },
    'report-output-info' => {
        'category' => 'report',
        'fields' => {
            'failure-reason' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'graph-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'report-application' => {
                'type' => 'report-application',
                'flags' => 0,
                'scope' => [],
            },
            'report-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'report-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'report-output-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'report-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'report-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'run-by' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'run-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'run-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'target-object-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-object-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-provenance' => {
        'category' => 'report',
        'fields' => {
        },
    },
    'report-schedule-content-info' => {
        'category' => 'report',
        'fields' => {
            'archival-format' => {
                'type' => 'report-output-format',
                'flags' => 0,
                'scope' => [],
            },
            'email-address-list' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'graph-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'include-deleted-objects' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-enabled' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-successful' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'last-run-time' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'report-application' => {
                'type' => 'report-application',
                'flags' => 0,
                'scope' => [],
            },
            'report-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'report-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'report-schedule-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'report-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'save-all-fields' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'schedule-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'target-object-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'target-object-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'report-schedule-info' => {
        'category' => 'report',
        'fields' => {
            'archival-format' => {
                'type' => 'report-output-format',
                'flags' => 4,
                'scope' => [],
            },
            'email-address-list' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'graph-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'include-deleted-objects' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'report-application' => {
                'type' => 'report-application',
                'flags' => 4,
                'scope' => [],
            },
            'report-name-or-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'report-schedule-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'save-all-fields' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'schedule-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'target-object-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'dataset-space-info' => {
        'category' => 'resourcepool',
        'fields' => {
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'dp-node-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-capable-of-migration' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-dp-node-effective-primary' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'used-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'resource-tag' => {
        'category' => 'resourcepool',
        'fields' => {
        },
    },
    'resourcepool-defaults' => {
        'category' => 'resourcepool',
        'fields' => {
            'resourcepool-full-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-nearly-full-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'resourcepool-info' => {
        'category' => 'resourcepool',
        'fields' => {
            'aggregate-nearly-overcommitted-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'aggregate-overcommitted-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resource-tag' => {
                'type' => 'resource-tag',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-contact' => {
                'type' => 'email-address-list',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-free-vfilers' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-full-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-is-provisionable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-kbytes-available' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-kbytes-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-kbytes-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-member-count' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-nearly-full-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-owner' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-perf-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-space-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepool-timezone' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'resourcepool-member-info' => {
        'category' => 'resourcepool',
        'fields' => {
            'datasets-space-info' => {
                'type' => 'dataset-space-info',
                'flags' => 7,
                'scope' => [],
            },
            'member-committed-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'member-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'member-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'member-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'member-space-status' => {
                'type' => 'object-space-status',
                'flags' => 4,
                'scope' => [],
            },
            'member-status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'member-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'member-used-space' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'provisioning-checks-passed' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'resource-tag' => {
                'type' => 'resource-tag',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'backup-info' => {
        'category' => 'snapshot',
        'fields' => {
            'backup-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'backup-version' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'dp-backup-expiry-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'dp-node-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-application-backup' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'snapshot' => {
        'category' => 'snapshot',
        'fields' => {
            'snapshot-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'unique-id' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'snapshot-dependency' => {
        'category' => 'snapshot',
        'fields' => {
        },
    },
    'snapshot-info' => {
        'category' => 'snapshot',
        'fields' => {
            'backups' => {
                'type' => 'backup-info',
                'flags' => 7,
                'scope' => [],
            },
            'creation-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 0,
                'scope' => [],
            },
            'cumulative-percentage-of-total-blocks' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'dependencies' => {
                'type' => 'snapshot-dependency',
                'flags' => 6,
                'scope' => [],
            },
            'is-busy' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-part-of-backup-version' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'percentage-of-total-blocks' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'snapshot-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'unique-id' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'obj-full-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'srm-file-type-info' => {
        'category' => 'srm',
        'fields' => {
            'srm-file-type-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'srm-file-type-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'resourcepool-name-or-id' => {
        'category' => 'storage-service',
        'fields' => {
        },
    },
    'storage-service-dataset-info' => {
        'category' => 'storage-service',
        'fields' => {
            'dataset-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'storage-service-info' => {
        'category' => 'storage-service',
        'fields' => {
            'datasets' => {
                'type' => 'dataset-reference',
                'flags' => 7,
                'scope' => [],
            },
            'is-dr-capable' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'protection-policy-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'storage-service-contact' => {
                'type' => 'email-address-list',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'storage-service-nodes' => {
                'type' => 'storage-service-node-info',
                'flags' => 3,
                'scope' => [],
            },
            'storage-service-owner' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'storage-service-node-attributes' => {
        'category' => 'storage-service',
        'fields' => {
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'old-dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepools' => {
                'type' => 'resourcepool-name-or-id',
                'flags' => 6,
                'scope' => [],
            },
            'vfiler-template-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'storage-service-node-info' => {
        'category' => 'storage-service',
        'fields' => {
            'dp-node-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'provisioning-policy-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'provisioning-policy-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'resourcepools' => {
                'type' => 'resourcepool-info',
                'flags' => 7,
                'scope' => [],
            },
            'vfiler-template-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-template-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'storage-set-info' => {
        'category' => 'storage-service',
        'fields' => {
            'dataset-access-details' => {
                'type' => 'dataset-access-details',
                'flags' => 5,
                'scope' => [],
            },
            'dataset-export-info' => {
                'type' => 'dataset-export-info',
                'flags' => 5,
                'scope' => [],
            },
            'dp-node-name' => {
                'type' => 'dp-policy-node-name',
                'flags' => 4,
                'scope' => [],
            },
            'server-name-or-id' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'timezone-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'timezone-defaults' => {
        'category' => 'timezone',
        'fields' => {
            'default-timezone' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'server-timezone-description' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'timezone-info' => {
        'category' => 'timezone',
        'fields' => {
            'timezone-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'user-report-info' => {
        'category' => 'user_report_profile',
        'fields' => {
            'count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'user-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'ip-binding-info' => {
        'category' => 'vfiler',
        'fields' => {
            'interface' => {
                'type' => 'obj-name-or-id',
                'flags' => 0,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'mtu-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'netmask' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'partner-interface' => {
                'type' => 'obj-name-or-id',
                'flags' => 4,
                'scope' => [],
            },
            'prefix-length' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'vlan-identifier' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'protocol' => {
        'category' => 'vfiler',
        'fields' => {
        },
    },
    'vfiler-template-info' => {
        'category' => 'vfiler',
        'fields' => {
            'administrative-host-ip-address' => {
                'type' => 'ip-address',
                'flags' => 4,
                'scope' => [],
            },
            'cifs-auth-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cifs-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'cifs-security-style' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'description' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dns-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dns-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'nis-domain' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'nis-servers' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'vfiler-template-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'vfiler-template-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'datacenter' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'datacenter-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'datacenter-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'datasets' => {
                'type' => 'dataset-reference',
                'flags' => 3,
                'scope' => [],
            },
            'deleted-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'is-protected' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-center-reference' => {
                'type' => 'virtual-center-reference',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'datacenter-reference' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'datacenter-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'datacenter-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'datastore' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'allocated-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'datacenter-reference' => {
                'type' => 'datacenter-reference',
                'flags' => 1,
                'scope' => [],
            },
            'datasets' => {
                'type' => 'dataset-reference',
                'flags' => 3,
                'scope' => [],
            },
            'datastore-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'datastore-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'datastore-on-ontap' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'datastore-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'deleted-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'is-protected' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'nfs-export-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'used-capacity' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-center-reference' => {
                'type' => 'virtual-center-reference',
                'flags' => 1,
                'scope' => [],
            },
        },
    },
    'datastore-reference' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'datastore-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'datastore-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'hypervisor-info' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'datacenter-reference' => {
                'type' => 'datacenter-reference',
                'flags' => 5,
                'scope' => [],
            },
            'deleted-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'domain-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'hypervisor-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'hypervisor-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'ip-address' => {
                'type' => 'ip-address',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-center-reference' => {
                'type' => 'virtual-center-reference',
                'flags' => 5,
                'scope' => [],
            },
            'virtual-infrastructure-type' => {
                'type' => 'virtual-infrastructure-type',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'hypervisor-reference' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'hypervisor-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'hypervisor-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'virtual-center' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'deleted-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-center-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-center-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'virtual-center-reference' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'virtual-center-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-center-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'virtual-disk' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'datastore-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'datastore-name' => {
                'type' => 'obj-name',
                'flags' => 4,
                'scope' => [],
            },
            'datastore-reference' => {
                'type' => 'datastore-reference',
                'flags' => 5,
                'scope' => [],
            },
            'deleted-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'vhd-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'virtual-disk-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-disk-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-infrastructure-type' => {
                'type' => 'virtual-infrastructure-type',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-machine-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-machine-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-machine-reference' => {
                'type' => 'virtual-machine-reference',
                'flags' => 5,
                'scope' => [],
            },
        },
    },
    'virtual-infrastructure-type' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
        },
    },
    'virtual-machine' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'datacenter-reference' => {
                'type' => 'datacenter-reference',
                'flags' => 5,
                'scope' => [],
            },
            'datasets' => {
                'type' => 'dataset-reference',
                'flags' => 3,
                'scope' => [],
            },
            'deleted-by' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'deleted-timestamp' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'dns-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'guest-os-type' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'host-service-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'hypervisor-reference' => {
                'type' => 'hypervisor-reference',
                'flags' => 1,
                'scope' => [],
            },
            'ip-address-list' => {
                'type' => 'ip-address',
                'flags' => 6,
                'scope' => [],
            },
            'is-protected' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'status' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-center-reference' => {
                'type' => 'virtual-center-reference',
                'flags' => 5,
                'scope' => [],
            },
            'virtual-infrastructure-type' => {
                'type' => 'virtual-infrastructure-type',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-machine-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-machine-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'virtual-machine-reference' => {
        'category' => 'virtual-infrastructure',
        'fields' => {
            'virtual-machine-id' => {
                'type' => 'obj-id',
                'flags' => 0,
                'scope' => [],
            },
            'virtual-machine-name' => {
                'type' => 'obj-name',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'migration-incompatibility-reason' => {
        'category' => 'volume',
        'fields' => {
        },
    },
    'object-space-status' => {
        'category' => 'volume',
        'fields' => {
        },
    },
    'timestamp' => {
        'category' => 'volume',
        'fields' => {
        },
    },
    'volume-dedupe-info' => {
        'category' => 'volume',
        'fields' => {
            'dedupe-progress' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'dedupe-space-savings' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dedupe-space-savings-percentage' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dedupe-status' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'is-dedupe-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'last-dedupe-begin-timestamp' => {
                'type' => 'timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'last-dedupe-end-timestamp' => {
                'type' => 'timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'last-dedupe-error' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'last-dedupe-scanned-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
    'volume-info' => {
        'category' => 'volume',
        'fields' => {
            'aggregate-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'aggregate-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'block-type' => {
                'type' => 'file-system-block-type',
                'flags' => 0,
                'scope' => [],
            },
            'dataset-id' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'dataset-nodes' => {
                'type' => 'dataset-node-info',
                'flags' => 7,
                'scope' => [],
            },
            'datasets' => {
                'type' => 'dataset-reference',
                'flags' => 3,
                'scope' => [],
            },
            'host-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'host-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'is-available' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-capable-of-migration' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-dp-ignored' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'is-in-dataset' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-readonly-volume' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapmirror-primary-capable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapmirror-primary-volume' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapmirror-secondary-capable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapmirror-secondary-volume' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapvault-primary-capable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapvault-primary-volume' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapvault-secondary-capable' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-snapvault-secondary-volume' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'is-vsm-secondary-volume' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'junction-path' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'junction-path-active' => {
                'type' => 'boolean',
                'flags' => 4,
                'scope' => [],
            },
            'migration-incompatibility-reasons' => {
                'type' => 'migration-incompatibility-reason',
                'flags' => 6,
                'scope' => [],
            },
            'next-scheduled-backup-time' => {
                'type' => 'dp-timestamp',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-volume-id' => {
                'type' => 'obj-id',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-volume-name' => {
                'type' => 'obj-full-name',
                'flags' => 4,
                'scope' => [],
            },
            'snapvault-lag-warning-threshold' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapvault-secondary-schedule-name' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'space-guarantee' => {
                'type' => 'string',
                'flags' => 4,
                'scope' => [],
            },
            'volume-dedupe-info' => {
                'type' => 'volume-dedupe-info',
                'flags' => 5,
                'scope' => [],
            },
            'volume-full-threshold' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-id' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-name' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-nearly-full-threshold' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'volume-perf-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'volume-qtree' => {
                'type' => 'volume-qtree',
                'flags' => 5,
                'scope' => [],
            },
            'volume-size' => {
                'type' => 'volume-size',
                'flags' => 1,
                'scope' => [],
            },
            'volume-space-status' => {
                'type' => 'object-space-status',
                'flags' => 0,
                'scope' => [],
            },
            'volume-state' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
            'volume-status' => {
                'type' => 'obj-status',
                'flags' => 4,
                'scope' => [],
            },
            'volume-type' => {
                'type' => 'string',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-qtree' => {
        'category' => 'volume',
        'fields' => {
            'protected-data-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'protected-qtree-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total-qtree-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unprotected-data-size' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'unprotected-qtree-count' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
        },
    },
    'volume-size' => {
        'category' => 'volume',
        'fields' => {
            'actual-volume-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'afs-avail' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'afs-data' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'afs-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'afs-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'afs-used-per-day' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'hole-reserve' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'is-autosize-enabled' => {
                'type' => 'boolean',
                'flags' => 0,
                'scope' => [],
            },
            'maximum-size' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'overwrite-reserve-avail' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'overwrite-reserve-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'overwrite-reserve-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-reserve-avail' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-reserve-total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'snapshot-reserve-used' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
            'space-allocated-from-aggr' => {
                'type' => 'integer',
                'flags' => 0,
                'scope' => [],
            },
            'total' => {
                'type' => 'integer',
                'flags' => 4,
                'scope' => [],
            },
        },
    },
};

sub new {
    my $self = {'apis' => $APIS, 'typedefs' => $TYPEDEFS};
    bless $self;
    return $self;
}
sub GetApi {
    my ($self, $name) = @_;
    my $type = ref($self) || die "$self is not an object";
    my $api = $self->{apis}->{$name} || die "No definition for API $name found";
    return $api;
}
sub GetTypedef {
    my ($self, $name) = @_;
    my $type = ref($self) || die "$self is not an object";
    my $api = $self->{typedefs}->{$name} || die "No definition for typedef $name found";
    return $api;
}
sub IsTypedefFlag {
    my ($self, $flag) = @_;
    return ($flag & FIELD_TYPEDEF) == FIELD_TYPEDEF;
}

sub IsArrayFlag {
    my ($self, $flag) = @_;
    return ($flag & FIELD_ARRAY) == FIELD_ARRAY;
}

sub IsEncryptedFlag {
    my ($self, $flag) = @_;
    return ($flag & FIELD_ENCRYPTED) == FIELD_ENCRYPTED;
}

1;


__END__

=head1 NAME

OCUMClassicAPI - Contains the definitions and description of API Bindings for OnCommand Unified Manager server 5.2 or earlier

=head1 SYNOPSIS

	 my $s = NaServer->new($server, 1, 0); # create NaServer (server context)
	 $s->set_admin_user('admin', 'password'); # provide username and password
	 $s->set_server_type('DFM'); # set the server type to DFM for OnCommand Unified Manager 5.2 or earlier

	 eval{ 
		 my $output = $s->dfm_about(); # use binding for dfm-about API
		 print "OCUM server version is: $output->{version}\n"; # extract the required parameter from output

	 };
	 if($@) { # check for any exception
		 my ($error_reason, $error_code) = $@ =~ /(.+)\s\((\d+)\)/;  # parse out error reason and error code
		 print "Error Reason: $error_reason  Code: $error_code\n"
	 }

=head1 DESCRIPTION

NetApp Manageability SDK 5.3.1 provides support for Perl API bindings for both Data ONTAP APIs and OnCommand Unified Manager APIs.
The Perl API bindings libraries contain interfaces to establish a connection with either the Data ONTAP server or the OnCommand Unified Manager server.
By using these libraries, you can create Perl applications to access and manage the Data ONTAP server or OnCommand Unified Manager server.

NetApp Manageability SDK 5.3.1 Perl API bindings provide a runtime library NaServer.pm, which is available at <installation_folder>/lib/perl/NetApp.
This library file enables you to establish a server connection, send requests and receive responses, and interpret error messages.
Each binding can be called as a subroutine of NaServer module which in turn invokes the corresponding Data ONTAP or OnCommand Unified Manager API.



=head1 API BINDINGS



=head2 aggregate_list_info_iter_end



=begin html

The aggregate-list-info-iter-* set of APIs are used to retrieve the list of aggregates. aggregate-list-info-iter-end is used to tell the DFM station that the temporary store used by DFM to support the aggregate-list-info-iter-next API for the particular tag is no longer necessary.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An internal opaque handle used by the DFM station

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggregate_list_info_iter_next



=begin html

For more documentation please check aggregate-list-info-iter-start. The aggregate-list-info-iter-next API is used to iterate over the members of the aggregates stored in the temporary store created by the aggregate-list-info-iter-start API.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous aggregate-list-info-iter-start. It's an opaque handle used by the DFM station to identify the temporary store created by aggregate-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<aggregates>  =>   B<L<"aggregate-info">[]>

=begin html

<br>List of aggregates.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned. Range: [1..2^31-1]

=end html

=back



=head2 aggregate_list_info_iter_start



=begin html

The aggregate-list-info-iter-* set of APIs are used to retrieve the list of aggregates in DFM. The aggregate-list-info-iter-start API is used to load the list of aggregates into a temporary store. The API returns a tag that identifies that temporary store so that subsequent APIs can be used to iterate over the aggregates in the temporary store. If aggregate-list-info-iter-start is invoked twice, then two distinct temporary stores are created. If neither aggregate-name-or-id or aggr-group-name-or-id are provided, all aggregates will be listed. If either, but not both are provided, the aggregate or all aggregates in the group will be listed respectively. If aggregate-name-or-id and aggr-group-name-or-id are provided, the aggregate will be listed only if it is under the specified group.

=end html



B<Inputs>

=over 2

=item * I<aggregate-type>  =>   B<string, optional>

=begin html

<br>Filter by type of aggregate. Possible values are: <ul> <li> traditional <li> aggregate <li> striped </ul> If no aggregate-type input is supplied, all types of aggregates will be listed.

=end html

=back



=over 2

=item * I<block-type>  =>   B<file-system-block-type, optional>

=begin html

<br>Filter by file system block type of the aggregate. If no block-type input is supplied, all types of aggregates will be listed.

=end html

=back



=over 2

=item * I<include-dataset-space-info>  =>   B<boolean, optional>

=begin html

<br>If true, a list of datasets that consume space from this aggregate and the actual space consumed is returned in datasets-space-info. Default value: false.

=end html

=back



=over 2

=item * I<include-is-available>  =>   B<boolean, optional>

=begin html

<br>If true, the is-available status is calculated for each aggregate which may make the call to this zapi take much longer. Default is false.

=end html

=back



=over 2

=item * I<is-direct-member-only>  =>   B<boolean, optional>

=begin html

<br>If true, only return the aggregates that are direct members of the specified resource group. Default value is false. This field is meaningful only if a resource group name or id is given for the object-name-or-id field.

=end html

=back



=over 2

=item * I<is-dp-ignored>  =>   B<boolean, optional>

=begin html

<br>If true, only list aggregates that have been set to be ignored for purposes of data protection. If false, only list aggregates that have not been set to be ignored for purposes of data protection. If not specified, list all aggregates without taking into account whether they have been ignored or not.

=end html

=back



=over 2

=item * I<is-in-dataset>  =>   B<boolean, optional>

=begin html

<br>If true, only list aggregates which only contain data which is protected by a dataset. If false, only list aggregates containing data which is not protected by a dataset. If not specified, list all aggregates whether they are in a dataset or not.

=end html

=back



=over 2

=item * I<is-unprotected>  =>   B<boolean, optional>

=begin html

<br>If true, only list aggregates that are not protected, which means the aggregate is: <ul> <li> 1. not in any resource pool. <li> 2. not a child of a host that is a member of any resource pool. <li> and 3. not a member of a node in a dataset with protection policy assigned. </ul> If false or not set, list all aggregates.

=end html

=back



=over 2

=item * I<object-management-filter>  =>   B<object-management-interface, optional>

=begin html

<br>Filter the object based on the Data ONTAP interface that provides complete management for the object i.e. ONTAP CLIs, SNMP, ONTAPI etc. If no filter is supplied, all objects will be considered.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<string, optional>

=begin html

<br>Name or identifier of an object to list aggregates for. The allowed object types for this argument are: <ul> <li> Resource Group <li> Resource Pool <li> Dataset <li> Storage Set <li> Host <li> Aggregate <li> Volume <li> Qtree <li> GenericAppObject </ul> If object-name-or-id identifies an aggregate, that single aggregate will be returned. If object-name-or-id resolves to more than one aggregate, all of them will be returned. If no object-name-or-id is provided, all aggregates will be listed.

=end html

=back



=over 2

=item * I<rbac-operation>  =>   B<string, optional>

=begin html

<br>Name of an RBAC operation. If specified, only return aggregates for which authenticated admin has the required capability. A capability is an operation/resource pair. The resource is the volume where the aggregate lives. The possible values that can be specified for operation can be obtained by calling rbac-operation-info-list. If operation is not specified, then it defaults to DFM.Database.Read. For more information about operations, capabilities and user roles, see the RBAC APIs.

=end html

=back



=over 2

=item * I<resourcepool-filter>  =>   B<string, optional>

=begin html

<br>Possible Value: 'in_rpool', 'not_in_rpool', 'all'. If set to 'in_rpool', only list aggregates that are in a resource pool. If set to 'not_in_rpool', only list aggregates that are not in a resource pool. If set to 'all', then list all aggregates. If a value is not specified, then 'all' will be the default. An aggregate is said to be in a resource pool if either the aggregate or the storage system containing the aggregate is a member of a resource pool.

=end html

=back



=over 2

=item * I<volumes-to-migrate>  =>   B<object-name-or-id[], optional>

=begin html

<br>This is a filter to return a list of candidate destination aggregates where the volumes in volumes-to-migrate can be migrated to. An ordered list of candidate aggregates are returned based on free space. Each object-name-or-id in volumes-to-migrate input should be the identifier or full name of a volume and they should all belong to the same source aggregate. Returning the list of candidate aggregates for migration can potentially take some time to compute.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with aggregate-list-info-iter-next. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to aggregate-list-info-iter-next. It is an opaque handle used by the DFM station to identify a temporary store.

=end html

=back



=head2 aggregate_modify



=begin html

Modify an aggregate's information. If modifying of one property fails, nothing will be changed. <br> Error Conditions: <ul> <li> EACCESSDENIED - When the user does not have DFM.Database.Write capability on the specified aggregate. <li> EINVALIDINPUT - When invalid input specified. <li> EOBJECTNOTFOUND - When the aggregate-name-or-id does not correspond to an aggregate. <li> EDATABASEERROR - On database error. </ul>

=end html



B<Inputs>

=over 2

=item * I<aggregate-name-or-id>  =>   B<string>

=begin html

<br>Name or identifier of the aggregate to modify.

=end html

=back



=over 2

=item * I<is-dp-ignored>  =>   B<boolean, optional>

=begin html

<br>True if an administrator has chosen to ignore this object for purposes of data protection.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 aggregate_space_management_add_operation



=begin html

Add a space management operation as part of this space management session. The actual operation is not carried out unless aggregate-space-management-commit is called. If this operation cannot be carried out, then ESPACEMGMTCONFLICTOP will be returned The following rules apply when adding an operation to the session. <ul> <li> A session cannot have 2 operations of same type for a give volume. For example two volume resize operations cannot be added for the same volume to a session. If this check fails the api will return ESPACEMGMTCONFLICTOP error. <li> If a volume migration operation is added to a session then other session management operations cannot be added to the session. Similarly a volume migration cannot be added to a session if other type of operation is already added to session. If this check fails the api will return ESPACEMGMTCONFLICTOP error. </ul> If this operation leads to errors in dry-run-results that are returned, then this operation is not added to the session.

=end html



B<Inputs>

=over 2

=item * I<space-management-operation-info>  =>   B<L<"space-management-operation-info">>

=begin html

<br>Details of a space management operation to be added to the session.

=end html

=back



=over 2

=item * I<space-management-session-id>  =>   B<integer>

=begin html

<br>Identifier of the space management session on an aggregate to which this space management operation has to be added. Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * I<aggregate-diff-space-infos>  =>   B<L<"aggregate-space-info">[]>

=begin html

<br>Returns the difference in aggregate space consumption (i.e used space and committed space) due to this space management operation only on the session aggregate as well as other aggregates affected by this operation (for example volume migration affects both session aggregate and destination aggregate.) The values returned in aggregate-space-info can be positive or negetive depending on whether the operation consumes or frees up space on the aggregates. For example volume migration frees up space on the source aggregate and consumes space on the destination aggregate.

=end html

=back



=over 2

=item * I<dry-run-results>  =>   B<L<"dry-run-result">[], optional>

=begin html

<br>Results of a dry run. Each result describes one action the system would take and the predicted effects of that action.

=end html

=back



=head2 aggregate_space_management_begin



=begin html

Open a space management session to run space management operations on an aggregate.<P> This allows adding a set of space management operations in a session, getting the difference in space consumption due to these set of operations and then committing all the operations. A space management session must be started before invoking the following ZAPIs: <UL> <LI>aggregate-space-management-add-operation <LI>aggregate-space-management-remove-operation <LI>aggregate-space-management-commit <LI>aggregate-space-management-rollback </UL> Use aggregate-space-management-commit to commit the changes and to start jobs which will carry out the space management operations. <P> Use aggregate-space-management-rollback to rollback the session. This will not submit any jobs for space management operations. <P> After 24 hours, a session can be opened on the same aggregate by another client without the force option. This will cause any space management operations that were part of the session to be discarded.

=end html



B<Inputs>

=over 2

=item * I<aggregate-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of the aggregate on which to open the space management session.

=end html

=back



=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>By default, force is false. If true, and a space management session is already in progress on the specified aggregate the previous space management session is rolled back and a new edit session is begun.

=end html

=back



B<Outputs>

=over 2

=item * I<space-management-session-id>  =>   B<integer>

=begin html

<br>Identifier of the space management session. Range: [1..2^31-1]

=end html

=back



=head2 aggregate_space_management_commit



=begin html

Commit the space management operations added as part of this space management session. <P> The session that was opened on the aggregate will be released once all the space management jobs that were part of the session are queued to be executed eventually.<P> This will not wait for the jobs to be executed.<P> Use the <b>dry-run</b> option to test the commit. It returns a set of dry-run results for each space management operation that was added as part of this session. <p> dry-run-results is a set of steps that the server will take to carry out the space management operation <p>When dry-run is true, it also returns the projected used and committed space of the aggregate on which the space management session was opened and other dependent aggregates in case of migration operations. <p> If <b>dry-run</b> is false, then before the call returns, the system submits jobs to the provisioning engine to execute.

=end html



B<Inputs>

=over 2

=item * I<dry-run>  =>   B<boolean, optional>

=begin html

<br>If true, return the dry-run-results list for each space management operation and aggregate-space-infos which gives the projected used and committed space of the aggregate(s) as a result of space management operations added to the session. <p> The dry-run-results list contains actions that would be taken should the changes be committed without actually committing the changes. <p> The session is not released after a dry run. By default, dry-run is false.

=end html

=back



=over 2

=item * I<space-management-session-id>  =>   B<integer>

=begin html

<br>Identifier of the space management session on an aggregate Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * I<aggregate-space-infos>  =>   B<L<"aggregate-space-info">[], optional>

=begin html

<br>Returns overall effect of space management operations added to the session on the used and committed space of all affected aggregates (i.e aggregate on which the space management session is started and the aggregates affected by space management operations added to the session. For example migration effects two aggregates, session aggregate and destination aggregate). <P> The space effect is calculated by obtaining the space freed or consumed by each operation and by adding or subtracting it from the current used and committed space of the aggregate. <P> Returned only if dry-run is true.

=end html

=back



=over 2

=item * I<space-management-results>  =>   B<L<"space-management-result-info">[]>

=begin html

<br>Results of a commit operation for each space management operation that was added in this session.

=end html

=back



=head2 aggregate_space_management_remove_operation



=begin html

Remove a space management operation that was added as part of this space management session.

=end html



B<Inputs>

=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Object whose space management operation has to be removed from this session.

=end html

=back



=over 2

=item * I<space-management-op-type>  =>   B<space-management-op-type>

=begin html

<br>Type of space management operation to be removed for the object from this session.

=end html

=back



=over 2

=item * I<space-management-session-id>  =>   B<integer>

=begin html

<br>Identifier of the space management session on an aggregate from which this space management operation has to be removed. Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * I<aggregate-diff-space-infos>  =>   B<L<"aggregate-space-info">[]>

=begin html

<br>Returns difference in aggregate space consumption (i.e used space and committed space) caused by removing this space magagement operation from the session. The values returned here are same as the values returned by aggregate-space-management-add-operation zapi (called when adding this operation to the session) but with the signs reversed.

=end html

=back



=head2 aggregate_space_management_rollback



=begin html

Release the session opened for space management on an aggregate. All the space management operations that were submitted as part of the space management session would be discarded.

=end html



B<Inputs>

=over 2

=item * I<space-management-session-id>  =>   B<integer>

=begin html

<br>Identifier of the space management session on an aggregate to be rolled back. Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 alarm_create



=begin html

Create a DFM alarm. The alarm-info element specifies all the parameters of the new alarm. <P> Note that it is possible to specify a combination of the event-name, event-severity and event-class such that this alarm will never be triggered. It is the user's responsibility to verify these settings are useful. <P> Error Conditions: <ul> <li> EINVALIDEMAILADDR - If the email address has spaces, semi-colons or unprintable characters. <li> EINVALIDEVENTSEVERITY - If the event-severity specified is not one of 'normal', 'information', 'unknown', 'warning', 'error', 'critical', 'emergency'. <li> EINVALIDEVENTCLASSEXP - If the regular expression specified for the event-class is not a valid POSIX.1 regular expression. <li> EINVALIDALARMTIME - If the time-specified for time-from or time-to is greater than 86399 ((24 * 60 * 60) - 1) seconds or if only one of time-from and time-to values are specified. <li> EINVALIDTRAPADDR - If the trap host specified is not reachable or when the port is greater than 65535 (2^15 - 1) <li> ENOSUCHEVENT - If the event name specified is not a valid event-name of DFM. <li> EGROUPDOESNOTEXIST - If the group specified in the alarm parameters is not a DFM resource group. <li> ENOTFOUNDUSER - If the administrator name specified in the alarm parameters is not a DFM administrator. <li> ERUNASUNSUPPORTED - If script-runas parameter is specified on a Windows DFM platform. <li> EINVALIDINPUT - If the event-severity value is less than the severity of the event-name event. <li> EDATABASEERROR - A database error occured during processing. <li> EACCESSDENIED - When the user does not have DFM.Event.Write capability on the resource group on which the alarm is being configured. It is also set when the user sets script-runas parameter for the alarm and he does not have global DFM.Database.Write capability. </ul>

=end html



B<Inputs>

=over 2

=item * I<alarm-info>  =>   B<L<"alarm-info">>

=begin html

<br>Parameters of the new alarm.

=end html

=back



B<Outputs>

=over 2

=item * I<alarm-id>  =>   B<integer>

=begin html

<br>ID of newly created alarm. Range: [1..2^15-1]

=end html

=back



=head2 alarm_destroy



=begin html

Delete an alarm. <P> Error Conditions: <ul> <li> EALARMDOESNOTEXIST - If an alarm by the specified id does not exist. <li> EDATABASEERROR - A database error occured during processing. <li> EACCESSDENIED - When the user does not have DFM.Event.Write capability on the resource group on which the alarm being destroyed is configured. </ul>

=end html



B<Inputs>

=over 2

=item * I<alarm-id>  =>   B<integer>

=begin html

<br>Identifier of the alarm. Range: [1..2^15-1]

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 alarm_get_defaults



=begin html

Get the default values of attributes defined by this ZAPI set.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<alarm-defaults>  =>   B<L<"alarm-defaults">>

=begin html

<br>The default values of the attributes defined by this ZAPI.

=end html

=back



=head2 alarm_list_info_iter_end



=begin html

Ends listing of alarms.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag returned from alarm-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 alarm_list_info_iter_next



=begin html

Returns items from list generated by alarm-list-info-iter-start.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>The tag returned in alarm-list-info-iter-start call.

=end html

=back



B<Outputs>

=over 2

=item * I<alarm-list>  =>   B<L<"alarm-info">[]>

=begin html

<br>Array of alarm information.

=end html

=back



=over 2

=item * I<records>  =>   B<integer, optional>

=begin html

<br>The number of records actually returned. Range: [1..2^31-1].

=end html

=back



=head2 alarm_list_info_iter_start



=begin html

List all configured alarms.

=end html



B<Inputs>

=over 2

=item * I<alarm-id>  =>   B<integer, optional>

=begin html

<br>Identifier of the alarm to list. Range: [1..2^15-1]. If alarm-id is not specified, list all alarms.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number indicating how many items are available for future retrieval with alarm-list-info-iter-next.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to alarm-list-info-iter-next or alarm-list-info-iter-end.

=end html

=back



=head2 alarm_modify



=begin html

Modify settings of a DFM alarm. <P> Error Conditions: <ul> <li> EALARMDOESNOTEXIST - If an alarm by the specified id does not exist. <li> EINVALIDEMAILADDR - If the email address has spaces, semi-colons or unprintable characters. <li> EINVALIDEVENTSEVERITY - If the event-severity specified is not one of 'normal', 'information', 'unknown', 'warning', 'error', 'critical', 'emergency'. <li> EINVALIDEVENTCLASSEXP - If the regular expression specified for the event-class is not a valid POSIX.1 regular expression. <li> EINVALIDALARMTIME - If the time-specified for time-from or time-to is greater than 86399 ((24 * 60 * 60) - 1) seconds or if only one of time-from and time-to values are specified. <li> EINVALIDTRAPADDR - If the trap host specified is not reachable or when the port is greater than 65535 (2^15 - 1) <li> ENOSUCHEVENT - If the event name specified is not a valid event-name of DFM. <li> EGROUPDOESNOTEXIST - If the group specified in the alarm parameters is not a DFM resource group. <li> ENOTFOUNDUSER - If the administrator name specified in the alarm parameters is not a DFM administrator. <li> ERUNASUNSUPPORTED - If script-runas parameter is specified on a Windows DFM platform. <li> EINVALIDINPUT - If the event-severity value is less than the severity of the event-name event. <li> EDATABASEERROR - A database error occured during processing. <li> EACCESSDENIED - When the user does not have DFM.Event.Write capability on the resource group on which the alarm is being configured. It is also set when the user sets script-runas parameter for the alarm and he does not have DFM.Database.Write capability at global level. </ul>

=end html



B<Inputs>

=over 2

=item * I<alarm-info>  =>   B<L<"alarm-info">>

=begin html

<br>Parameters to be modfied for the alarm. Any value specified in alarm-info replaces values configured for the alarm. Specifying any optional attributes with a blank value removes that setting from the alarm. Specifying an empty array for attributes that take an array will remove all the entries. Specifying an array element with values replaces the existing values. If an array element is not specified, then no change happens. If none of the optional parameters are specified, then this API does nothing. <P> Note that it is possible to specify a combination of the event-name, event-severity and event-class such that this alarm will never be triggered. It is the user's responsibility to verify these settings are useful.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 alarm_test



=begin html

Test an alarm by performing it's trigger actions. The test will be performed irrespective of whether the alarm is enabled or disabled. <P> Error Conditions: <ul> <li> EALARMDOESNOTEXIST - If an alarm by the specified id does not exist. <li> EALARMTESTFAILED - If there is an error sending the test alarm event to DataFabric Manager Event service. <li> EDATABASEERROR - A database error occured during processing. <li> EACCESSDENIED - When the user does not have DFM.Event.Write capability on the resource group on which the alarm is configured. </ul>

=end html



B<Inputs>

=over 2

=item * I<alarm-id>  =>   B<integer>

=begin html

<br>Identifier of the alarm. Range: [1..2^15-1]

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 api_proxy



=begin html

Proxy an API request to a third party and return the API response.

=end html



B<Inputs>

=over 2

=item * I<request>  =>   B<L<"request">>

=begin html

<br>The request to be forwarded to another server.

=end html

=back



=over 2

=item * I<target>  =>   B<string>

=begin html

<br>The target host. May be a hostname (qualified or unqualified), a vfiler name or a host agent. If the target is not resolved during a capability check, EOBJECTAMBIGUOUS or EOBJECTNOTFOUND is returned.

=end html

=back



=over 2

=item * I<timeout>  =>   B<integer, optional>

=begin html

<br>Number of seconds that the proxy server should wait for a response before giving up.

=end html

=back



=over 2

=item * I<username>  =>   B<string, optional>

=begin html

<br>User account to use for executing the API. If none is specified, the highest privilege available will be attempted. The proxy server may have a security policy that restricts the accepted values for this field. Invalid values will cause EACCESSDENIED.

=end html

=back



B<Outputs>

=over 2

=item * I<response>  =>   B<L<"response">>

=begin html

<br>The response from the other server.

=end html

=back



=head2 application_policy_copy



=begin html

Create a new application policy by making a copy of an existing policy. The new policy created using this ZAPI has the same set of properties as the existing policy. <HR> Error conditions: <UL> <LI> EACCESSDENIED - User does not have privileges to read the existing policy from the database, or create a new policy, or both. <LI> EOBJECTNOTFOUND - No existing policy was found that has the given name or ID. <LI> EOBJECTAMBIGUOUS - Multiple objects with the given name present in database. <LI> EPOLICYEXISTS - A policy with the given application-policy-name already exists. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> EINVALIDINPUTERROR - Invalid input was provided. </UL>

=end html



B<Inputs>

=over 2

=item * I<application-policy-description>  =>   B<string, optional>

=begin html

<br>Description of the new policy. It may contain from 0 to 255 characters. If the length is greater than 255 characters, the ZAPI fails with error code EINVALIDINPUTERROR. The default value is the empty string "".

=end html

=back



=over 2

=item * I<application-policy-name>  =>   B<obj-name>

=begin html

<br>Name of the new policy. It must be unique across all application,provisioning and data protection policies.

=end html

=back



=over 2

=item * I<group-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Resource group to which the newly created application policy should be added to. User should have DFM.ApplicationPolicy.Write capability on the specified group. Default value: Global group.

=end html

=back



=over 2

=item * I<source-policy-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>The name or ID of an existing policy that is copied to create the new policy.

=end html

=back



B<Outputs>

=over 2

=item * I<application-policy-id>  =>   B<obj-id>

=begin html

<br>An object ID for the newly created policy.

=end html

=back



=head2 application_policy_create



=begin html

This API creates a new application policy. Error conditions: <UL> <LI> EACCESSDENIED - User does not have privileges to create policies. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> EINVALIDINPUTERROR - Invalid input was provided. <LI> EPOLICYEXISTS - An application policy with given name already exists. </UL>

=end html



B<Inputs>

=over 2

=item * I<application-policy-info>  =>   B<L<"application-policy-info">>

=begin html

<br>Details of the new policy to be created.

=end html

=back



B<Outputs>

=over 2

=item * I<application-policy-id>  =>   B<obj-id>

=begin html

<br>Object ID of the newly created policy.

=end html

=back



=head2 application_policy_destroy



=begin html

Destroy a application policy. This removes it from the database. <P> If the policy has been applied to any dataset nodes, then the destroy operation fails; it must first be disassociated from all the dataset nodes to which it has been associated and then destroyed. Error conditions: <UL> <LI> EACCESSDENIED - User does not have DFM.Policy.Delete on the policy being destroyed. <LI> EOBJECTNOTFOUND - The specified application policy does not exist in the database. <LI> EAPPPOLICYINUSE - The policy is assigned to one or more datasets. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> EOBJECTAMBIGUOUS - Multiple objects with the given name present in database. <LI> EEDITSESSIONINPROGRESS - The application policy being destroyed locked in an edit session. </UL>

=end html



B<Inputs>

=over 2

=item * I<application-policy-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or id of the application policy being destroyed.

=end html

=back



=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>force delete even if there is an edit session in progress on the application policy.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 application_policy_edit_begin



=begin html

Create an edit session and obtain an edit lock on an application policy to begin modifying the policy. <P> An edit lock must be obtained before invoking application-policy-modify. <P> Use application-policy-edit-commit to end the edit session and commit the changes to the database. <P> Use application-policy-edit-rollback to end the edit session and discard any changes made to the policy. <P> 24 hours after an edit session on a policy begins, any subsequent call to application-policy-edit-begin for that same policy automatically rolls back the existing edit session and begins a new edit session, just as if the call had used the force option. If there is no such call, the existing edit session simply continues and retains the edit lock. <HR> Error conditions: <UL> <LI> EEDITINPROGRESS - Another edit session already has an edit lock on the specified application policy. <LI> EOBJECTNOTFOUND - No application policy was found that has the given name or ID. <LI> EACCESSDENIED - User does not have DFM.Policy.Write privilege on the policy. modify the application policy. <LI> EDATABASEERROR - A database error occurred while processing the request. </UL>

=end html



B<Inputs>

=over 2

=item * I<application-policy-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of an application policy.

=end html

=back



=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>If true, and an edit session is already in progress on the specified policy, then the previous edit is rolled back and a new edit is begun. If false, and an edit is already in progress, then the call fails with error code EEDITINPROGRESS. Default value is false.

=end html

=back



B<Outputs>

=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock on the policy. Range: [0..(2^31)-1]

=end html

=back



=head2 application_policy_edit_commit



=begin html

Commit changes made to an application policy during an edit session into the database.<P> If all the changes to the policy are performed successfully, the entire edit is committed and the edit lock on the policy is released.<P> If any of the changes to the policy are not performed successfully, then the edit is rolled back (none of the changes are committed) and the edit lock on the policy is released.<P> Use the dry-run option to test the commit. Using this option, the changes to the policy are not committed to the database. <HR> Error conditions: <UL> <LI> EEDITSESSIONNOTFOUND - No edit lock was found that has the given ID. <LI> EACCESSDENIED - User does not have DFM.Policy.Write on the policy. <LI> EPOLICYEXISTS - The policy's name is being changed, and a policy with the new name already exists. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> EAPPPOLICYNOTFOUND - An application policy was not found. </UL>

=end html



B<Inputs>

=over 2

=item * I<dry-run>  =>   B<boolean, optional>

=begin html

<br>If true, return a list of the actions the system would take after committing the changes to the policy, but without actually committing the changes. In addition, the edit lock is not released. By default, dry-run is false.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock on the policy. The value must be an edit lock ID that was previously returned by application-policy-edit-begin ZAPI.

=end html

=back



B<Outputs>

=over 2

=item * I<dry-run-results>  =>   B<L<"dry-run-result">[], optional>

=begin html

<br>Results of a dry run. Only returned if dry-run is true.

=end html

=back



=head2 application_policy_edit_rollback



=begin html

Roll back changes made to an application policy. The edit lock on the policy will be released after the rollback. <HR> Error conditions: <UL> <LI> EEDITSESSIONNOTFOUND - No edit lock was found that has the given ID. <LI> EACCESSDENIED - User does not have privileges to modify the policy. </UL>

=end html



B<Inputs>

=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock on the policy. The value must be an edit lock ID that was previously returned by application-policy-edit-begin ZAPI.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 application_policy_list_iter_end



=begin html

Terminate a list iteration that had been started by a call to application-policy-list-iter-start. This informs the server that it may now release any resources associated with the temporary store for the list iteration. <HR> Error conditions: <UL> <LI> EINVALIDTAG - The specified tag does not exist. </UL>

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>The opaque handle returned by the prior call to application-policy-list-iter-start that started this list iteration.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 application_policy_list_iter_next



=begin html

Retrieve the next series of policies that are present in a list iteration created by a call to application-policy-list-iter-start. The server maintains an internal cursor pointing to the last record returned. Subsequent calls to application-policy-list-iter-next return the next maximum records after the cursor, or all the remaining records, whichever is fewer. <HR> Error conditions: <UL> <LI> EINVALIDTAG - The specified tag does not exist. </UL>

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of policies to return. Range: [1..2^31-1].

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>The opaque handle returned by the prior call to application-policy-list-iter-start that started this list iteration.

=end html

=back



B<Outputs>

=over 2

=item * I<application-policies>  =>   B<L<"application-policy-info">[]>

=begin html

<br>List of information about multiple application policies.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of records actually returned in the output. Range:[0..2^31-1]

=end html

=back



=head2 application_policy_list_iter_start



=begin html

Begin a list iteration over application policies. <p> After calling application-policy-list-iter-start, you continue the iteration by calling application-policy-list-iter-next zero or more times, followed by a call to application-policy-list-iter-end to terminate the iteration. <HR> Error conditions: <UL> <LI> EACCESSDENIED - User does not have privileges to read the specified policy. <LI> EOBJECTNOTFOUND - No policy or resource group was found that has the given name or ID. <LI> EDATABASEERROR - A database error occurred while processing the request. </UL>

=end html



B<Inputs>

=over 2

=item * I<application-policy-type>  =>   B<application-policy-type, optional>

=begin html

<br>Filter application policies by type.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of a application policy or resource group. If a resource group is specified, only the application policies which are members of the group are returned. If application policy name or ID is specified, then application-policy-type filter is ignored.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of items present in the list iteration. Range:[0..2^31-1].

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An opaque handle used to identify the list iteration. The list content resides in a temporary store in the server.

=end html

=back



=head2 application_policy_modify



=begin html

This ZAPI modifies the application policy settings of an existing policy in the database with the new values specified in the input. Note: type of application policy cannot be modified after creation. Before modifying the policy, an edit lock has to be obtained on the policy object. <HR> Error conditions: <UL> <LI> EEDITSESSIONNOTFOUND - No edit lock was found that has the given ID. <LI> EEDITSESSIONCONFLICTINGOP - current modification made conflicts with previous change in the edit session. <LI> EACCESSDENIED - User does not have privileges to modify the policy. <LI> EOBJECTNOTFOUND - The policy was already destroyed during this edit session. <LI> EOBJECTAMBIGUOUS - Multiple objects with the given name present in database. <LI> EINVALIDINPUT - The requested modification is not applicable to the policy being modified. <LI> EDATABASEERROR - A database error occurred while processing the request. </UL>

=end html



B<Inputs>

=over 2

=item * I<application-policy-info>  =>   B<L<"application-policy-info">>

=begin html

<br>New values for application policy attributes. All the policy attributes are replaced by the new values. If an optional element is absent, then it gets replaced by its default value.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock on the policy. The value must be an edit lock ID that was previously returned by application-policy-edit-begin.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 audit_log_add_entry



=begin html

Log an entry in the audit log file of DataFabric Manager

=end html



B<Inputs>

=over 2

=item * I<audit-application-name>  =>   B<string>

=begin html

<br>Name of the application which wants to log an entry in the audit log file.

=end html

=back



=over 2

=item * I<audit-interface>  =>   B<string, optional>

=begin html

<br>Specifies the interface of the event being logged. Possible values: web, command and log. Default value is log.

=end html

=back



=over 2

=item * I<audit-ip-address>  =>   B<string, optional>

=begin html

<br>Specifies the IP Address of the machine from which the operation is invoked.

=end html

=back



=over 2

=item * I<audit-message>  =>   B<string>

=begin html

<br>Application specific message for audit logging.

=end html

=back



=over 2

=item * I<audit-priority>  =>   B<string>

=begin html

<br>Specifies the priority of the audit log entry. Possible values: emergency, critical, error, warning and information

=end html

=back



=over 2

=item * I<audit-type>  =>   B<string>

=begin html

<br>Specifies the type of the event being logged. Possible values: input, error, action and output

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_domain_list_info_iter_end



=begin html

Terminate a view list iteration and clean up any saved info.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An opaque handle used by the DFM station to identify a temporary store.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 cifs_domain_list_info_iter_next



=begin html

Returns items from a previous call to cifs-domain-list-info-iter-start

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve. Range: [1..(2^31)-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An opaque handle used by the DFM station to identify a temporary store.

=end html

=back



B<Outputs>

=over 2

=item * I<cifs-domain-list>  =>   B<L<"cifs-domain-info">[]>

=begin html

<br>A list of cifs domains.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned.

=end html

=back



=head2 cifs_domain_list_info_iter_start



=begin html

Initiates a query for a list of cifs domains on hosts discovered by DFM.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number indicating how many items are available for future retrieval with cifs-domain-list-info-iter-next. Range: [1..(2^31)-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An opaque handle used by the DFM station to identify a temporary store. Used in subsequent calls to cifs-domain-list-info-iter-next. or cifs-domain-list-info-iter-end.

=end html

=back



=head2 client_registry_destroy



=begin html

Remove one or all name/value pairs from the persistent store.

=end html



B<Inputs>

=over 2

=item * I<application-name>  =>   B<string>

=begin html

<br>Unique name identifying the application requesting the data.

=end html

=back



=over 2

=item * I<match>  =>   B<string, optional>

=begin html

<br>Specify how the API should determine which name/value pairs to remove. Use "exact", the default, to specify that the option name must exactly match "option". The API returns ENAMENOTFOUND if an option by that name does not exist. Use "all" to indicate that the API should ignore the option name and return all name/value pairs. Use "regexp" to indicate that the API should interpret the option as an extended regular expression, and return all name/value pairs where the option name matches the pattern specified in "option". The API returns EINVALIDINPUTERROR if the "option" is not a valid regular expression.

=end html

=back



=over 2

=item * I<option>  =>   B<string, optional>

=begin html

<br>Name of the key to remove. See the description of the "match" parameter for more information.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 client_registry_get



=begin html

Retrieve one or all name/value string pairs.

=end html



B<Inputs>

=over 2

=item * I<application-name>  =>   B<string>

=begin html

<br>Unique name identifying the application requesting the data.

=end html

=back



=over 2

=item * I<match>  =>   B<string, optional>

=begin html

<br>Indicate how the API should find matching options. Use "exact", the default, to specify that the option name must exactly match "option". The API returns ENAMENOTFOUND if no option with that name exists for this application. Use "all" to indicate that the API should ignore the option name and return all name/value pairs. Use "regexp" to indicate that the API should interpret the option as an extended regular expression, and return all name/value pairs where the option name matches the pattern specified in "option". In the case of "regexp", the API returns EINVALIDINPUTERROR if the "option" is not a valid regular expression.

=end html

=back



=over 2

=item * I<option>  =>   B<string, optional>

=begin html

<br>Name of the registry key to fetch. See the description of the "match" parameter for more information.

=end html

=back



B<Outputs>

=over 2

=item * I<options>  =>   B<L<"client-option-info">[]>

=begin html

<br>An array of name/value pair objects.

=end html

=back



=head2 client_registry_set



=begin html

Store one or more name/value string pairs.

=end html



B<Inputs>

=over 2

=item * I<application-name>  =>   B<string>

=begin html

<br>Unique name identifying the application requesting storage.

=end html

=back



=over 2

=item * I<options>  =>   B<L<"client-option-info">[]>

=begin html

<br>An array of name/value pair objects.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 comment_field_create



=begin html

Create a comment field. <HR> Error conditions: <UL> <LI> ECOMMENTFIELDALREADYEXISTS - A comment field by the same name already exists. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> EINVALIDINPUT - Invalid input was provided. </UL>

=end html



B<Inputs>

=over 2

=item * I<comment-field-info>  =>   B<L<"comment-field-info">>

=begin html

<br>Information about the comment field.

=end html

=back



B<Outputs>

=over 2

=item * I<comment-field-id>  =>   B<comment-field-id>

=begin html

<br>Identifier of the newly created comment field.

=end html

=back



=head2 comment_field_destroy



=begin html

Destroy a comment field. <HR> Error conditions: <UL> <LI> ECOMMENTFIELDDOESNOTEXIST - A comment field by the specified id does not exist. <LI> ESYSTEMCOMMENTFIELD - An attempt was made to destroy a system comment field. <LI> EDATABASEERROR - A database error occured while processing the request. </UL>

=end html



B<Inputs>

=over 2

=item * I<comment-field-name-or-id>  =>   B<comment-field-name-or-id>

=begin html

<br>Comment field to be destroyed.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 comment_field_list_info_iter_end



=begin html

Terminate a list iteration that had been started by a call to comment-field-list-info-iter-start. This informs the server that it may now release any resources associated with the temporary store for the list iteration. <HR> Error conditions: <ul> <li> EINVALIDTAG - The specified tag does not exist. </ul>

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>The opaque handle returned by the prior call to comment-field-list-info-iter-start that started this list iteration.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 comment_field_list_info_iter_next



=begin html

Get the next set of comment fields in the iteration started by comment-field-list-info-iter-start. <HR> Error conditions: <UL> <LI> EINVALIDTAG - The specified tag does not exist. <LI> EDATABASEERROR - A database error occurred while processing the request. </UL>

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of comment fields to return. Range: [1..2^31-1].

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>The opaque handle returned by the prior call to comment-field-list-info-iter-start that started this list iteration.

=end html

=back



B<Outputs>

=over 2

=item * I<comment-fields>  =>   B<L<"comment-field-info">[]>

=begin html

<br>List of comment fields.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned.

=end html

=back



=head2 comment_field_list_info_iter_start



=begin html

Starts iteration to list all comment fields. <HR> Error conditions: <UL> <LI> ECOMMENTFIELDDOESNOTEXIST - A comment field by the specified id or name does not exist. <LI> EDATABASEERROR - A database error occured while processing the request. </UL>

=end html



B<Inputs>

=over 2

=item * I<comment-field-name-or-id>  =>   B<comment-field-name-or-id, optional>

=begin html

<br>If specified, only the specified comment field is returned. Otherwise information about all comment fields are returned.

=end html

=back



=over 2

=item * I<comment-field-object-types>  =>   B<comment-field-object-type[], optional>

=begin html

<br>If specified, only the specified comment field with specified object type is returned. If not specified, then all comment fields will be returned.

=end html

=back



=over 2

=item * I<show-system-comments>  =>   B<boolean, optional>

=begin html

<br>Indicates whether system comment fields are returned. Default is true.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of items present in the list iteration. Range: [0..2^31-1].

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An opaque handle used to identify the list iteration. The list content resides in a temporary store in the server.

=end html

=back



=head2 comment_field_modify



=begin html

Modify a comment field. Currently only the name of the comment field can be modified. <HR> Error conditions: <UL> <LI> ECOMMENTFIELDDOESNOTEXIST - A comment field by the specified id does not exist. <LI> ECOMMENTFIELDALREADYEXISTS - A comment field by the same name already exists. <LI> ESYSTEMCOMMENTFIELD - An attempt was made to modify a system comment field. <LI> EDATABASEERROR - A database error occured while processing the request. <LI> EINVALIDINPUT - Invalid input was provided. </UL>

=end html



B<Inputs>

=over 2

=item * I<comment-field-name-or-id>  =>   B<comment-field-name-or-id>

=begin html

<br>Name or identifier of the comment field which has to be modified.

=end html

=back



=over 2

=item * I<comment-field-object-types>  =>   B<comment-field-object-type[], optional>

=begin html

<br>Object type(s) of the comment field to be modified. If an object type of the comment field does not exist, then the new object type will be associated with the comment field. Any existing object type of the comment field that is not specified in this input will be disassociated. If the input is empty, then all object types of the comment field will be disassociated.

=end html

=back



=over 2

=item * I<new-comment-field-name>  =>   B<comment-field-name, optional>

=begin html

<br>New name of the comment field. May be omitted if only changing the comment field object types.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 comment_field_values_list_info_iter_end



=begin html

Terminate a list iteration that had been started by a call to comment-field-values-list-info-iter-start. This informs the server that it may now release any resources associated with the temporary store for the list iteration. <HR> Error conditions: <ul> <li> EINVALIDTAG - The specified tag does not exist. </ul>

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>The opaque handle returned by the prior call to comment-field-values-list-iter-start that started this list iteration.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 comment_field_values_list_info_iter_next



=begin html

Get the next set of comment field values in the iteration started by comment-field-values-list-iter-start <HR> Error conditions: <UL> <LI> EINVALIDTAG - The specified tag does not exist. <LI> EDATABASEERROR - A database error occurred while processing the request. </UL>

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of comment field values to return. Range: [1..2^31-1].

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>The opaque handle returned by the prior call to comment-field-values-list-iter-start that started this list iteration.

=end html

=back



B<Outputs>

=over 2

=item * I<comment-field-values>  =>   B<L<"comment-field-value">[]>

=begin html

<br>Comment field values.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned.

=end html

=back



=head2 comment_field_values_list_info_iter_start



=begin html

Start iteration on listing comment field values for objects. <HR> Error conditions: <ul> <li> ECOMMENTFIELDDOESNOTEXIST - A comment field by the specified id or name does not exist. <li> EDATABASEERROR - A database error occured while processing the request. <li> EACCESSDENIED - The user does not have DFM.Database.Read capability on the specified object. If the object is a dataset, then the user does not have DFM.Dataset.Read on the dataset. <li> EOBJECTNOTFOUND - The specified object was not found. <li> EOBJECTAMBIGUOUS - The specified object name could refer to more than a single object. Use object identifiers to disambiguate. </ul>

=end html



B<Inputs>

=over 2

=item * I<comment-field-name-or-id>  =>   B<comment-field-name-or-id, optional>

=begin html

<br>If specified, the values set for various objects for the specified comment field is returned. Otherwise, list the comment field values for all comment fields.

=end html

=back



=over 2

=item * I<comment-field-object-types>  =>   B<comment-field-object-type[], optional>

=begin html

<br>Object type(s) of the comment field to be returned.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of the managed object. If specified all comment field values set for that object is returned. Otherwise list the comment field values for all objects.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of items present in the list iteration. Range: [0..2^31-1].

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An opaque handle used to identify the list iteration. The list content resides in a temporary store in the server.

=end html

=back



=head2 comment_set_object_value



=begin html

Set the value of a comment field for a specified managed object. <HR> Error conditions: <ul> <li> ECOMMENTFIELDDOESNOTEXIST - A comment field by the specified id or name does not exist. <li> EDATABASEERROR - A database error occured while processing the request. <li> EACCESSDENIED - The user does not have DFM.Database.Write capability on the specified object. <li> EINVALIDINPUT - The specified comment value is invalid. <li> EOBJECTNOTFOUND - The specified object was not found or the managed object was not a supported type for setting comments. <li> EOBJECTAMBIGUOUS - The specified object name could refer to more than a single object. Use object identifiers to disambiguate. </ul>

=end html



B<Inputs>

=over 2

=item * I<comment-field-name-or-id>  =>   B<comment-field-name-or-id>

=begin html

<br>Name or identifier of the comment field.

=end html

=back



=over 2

=item * I<comment-value>  =>   B<comment-value>

=begin html

<br>Value of the comment field. An empty string can be used to unset the value of the comment field for this object.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of the managed object for which the value of the comment has to be set. The supported object types for which a comment value can be set are: <ul> <li>dataset <li>host <li>volume <li>qtree <li>lun_path <li>quota_user <li>resource_group <li>aggregate <li>srm_path <li>resource_pool <li>dp_policy <li>dp_schedule <li>dp_throttle <li>prov_policy <li>ossv_directory </ul>

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_add_member



=begin html

Add members to an existing dataset.<P> This API is for adding direct member objects to one or more storage sets in the dataset. Each storage set is identified by the data protection policy node associated with it. <P>The types of storage objects allowed to be added vary: <UL> <LI> Volumes, qtrees and OSSV directories are allowed in the storage set attached to a primary policy node. </LI> <LI> Only volumes are allowed in a storage sets attached to secondary/destination nodes. </LI> </UL> It is legal to add storage objects to multiple storage sets in a single call.

=end html



B<Inputs>

=over 2

=item * I<dataset-member-parameters>  =>   B<L<"dataset-member-parameter">[]>

=begin html

<br>List of members to add to the dataset.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<is-existing-member-ok>  =>   B<boolean, optional>

=begin html

<br>If specified, the call will not return an error if one or more objects being added is already a member of the specified node. If an ancestor or child of an object is already a member, an error will still be returned. By default, is-existing-member-ok is false.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_add_member_by_dynamic_reference



=begin html

Add dynamic reference to an existing dataset.<P> By adding a dynamic reference, the volumes, qtrees and ossv directories referred to by the dynamic reference become implicit (indirect) members of the dataset. A dynamic reference can be added to a particular storage set in the dataset by specifying the data protection policy node associated with it. If necessary a new storage set is first created automatically before adding storage objects to it.<P> The types of storage objects allowed to be added vary: <UL> <LI> Storage systems, vFiler units, aggregates, OSSV hosts, virtualization objects can be attached to a primary node. </LI> <LI> Storage systems, vFiler units and aggregates are allowed in storage sets attached to secondary/destination nodes. </LI> </UL> It is legal to add storage objects to multiple storage sets in a single call.

=end html



B<Inputs>

=over 2

=item * I<dataset-dynamic-reference-parameters>  =>   B<L<"dataset-dynamic-reference-parameter">[]>

=begin html

<br>List of dynamic-references to add to the dataset.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_add_resourcepool



=begin html

Add resource pool to a single storage set that is part of a dataset. The storage set is specified implicitly by the name of the policy node that maps to it.<P> Within the same edit session in which you call <b>dataset-add-resourcepool</b>, you may also add or remove members or dynamic references, or change the dataset's name, description, <b>is-dp-ignored</b>, <b>is-dp-suspended</b>, or <b>is-suspended</b>. You may not change the data set's protection policy or storage sets within the same edit session. <HR> Error conditions: <UL> <LI> EEDITSESSIONNOTFOUND - No edit lock was found that has the given identifier. <LI> EACCESSDENIED - User does not have permission to modify the storage set or does not have DFM.ResourcePool.Provision on the specified resource pool. <LI> EOBJECTAMBIGUOUS - The name given for the storage set or resource pool matches multiple storage sets or resource pools. <LI> EOBJECTNOTFOUND - No storage set or resource pool was found that has the given name or identifier. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> ESTORAGESETNOTINDATASET - The specified storage set is not a part of the dataset being edited. <LI> EDPPOLICYNODENOTFOUND - No DP policy node was found that has the given name. <LI> EEDITSESSIONCONFLICTINGOP - The requested modification conflicts with other changes performed during the edit session. <LI> EDSCONFLICTALREADYINDATASET - Object, its ancestor or descendent is already in dataset. <LI> EDSCONFLICTSRCDESTINSAMEAGGR - Source data and destination data are in the same aggregate. <LI> EDSCONFLICTALREADYINRESPOOL - Object, its ancestor or descendent is already in resource pool. </UL>

=end html



B<Inputs>

=over 2

=item * I<dp-node-name>  =>   B<dp-policy-node-name, optional>

=begin html

<br>Name of the node in the data protection policy that maps to the storage set. <b>dp-node-name</b> must match exactly the name of one of the nodes in the data protection policy that is currently assigned to the data set.<P> If <b>dp-node-name</b> is not specified, then the storage set associated with the root node is modified.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset that was obtained by an earlier call to <b>dataset-edit-begin</b>. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<resourcepool-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or object identifier of a resource pool to add to the storage set.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_add_to_exclusion_list



=begin html

Add datastore objects to a dataset's exclusion list.<P> This API is for adding datastore objects to a dataset's exclusion list.<BR><BR> Users may want to exclude a datastore when adding a virtual machine to the dataset. Virtual Machine may be on multiple datastores and one of the datastores will contain swap files which don't need to be backed up. If a datastore is excluded, relationships and backups for that datastore will not be created. If a relationship already exists, it will be left alone and only the backups will stop. There is no impact on suspend/resume.

=end html



B<Inputs>

=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<is-excluded-member-ok>  =>   B<boolean, optional>

=begin html

<br>If specified, the call will not return an error if one or more objects being added is already on the exclusion list. By default, is-excluded-member-ok is false.

=end html

=back



=over 2

=item * I<objects-to-be-added>  =>   B<obj-name-or-id[]>

=begin html

<br>List of datastore object names or IDs to be added to the exclusion list.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_begin_failover



=begin html

Begin failover of a dataset. <P>This API begins the process of failing over a dataset to its disaster recovery storage. The failover process will break any mirror relationships between the primary and DR storage objects and make the secondary storage available for use. <P>This API may only be invoked if the DR state of the data set is "ready". <P>Specifically, when the ZAPI runs, the following actions will take place: <ol> <li>The DR state of the dataset will immediately change to "failing_over". <li>Any pending conformance tasks will be cancelled. <li>Any jobs running against this dataset will be aborted. <li>A failover job will be started to break any mirrors between the primary storage set and the DR storage set <li>Finally, the DR state of the dataset will be updated to either "failed_over" or "failover_error" based on whether the failover job succeeded or not. </ol>

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<string>

=begin html

<br>Name or ID of dataset.

=end html

=back



B<Outputs>

=over 2

=item * I<job-id>  =>   B<integer>

=begin html

<br>Identifier of the failover job that is failing the dataset over to its DR secondary. If there was an error, the job id will be 0. Range: [1..2^31-1]

=end html

=back



=head2 dataset_begin_failover_script_test



=begin html

Begin test failover of a dataset that only runs the the failover scripts and does not dequeue tasks, abort jobs or change the dr-state.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<string>

=begin html

<br>Name or ID of dataset.

=end html

=back



B<Outputs>

=over 2

=item * I<job-id>  =>   B<integer>

=begin html

<br>Identifier of the failover job that is just running the DR scripts for the dataset. If there was an error, the job id will be 0. Range: [1..2^31-1]

=end html

=back



=head2 dataset_change_dr_state



=begin html

Change the disaster recovery state of a dataset. <P>This API sets the DR state of a dataset to a new value. Users may perform the following DR state transitions using this ZAPI: <ul> <li> From "failover_error" to "failed_over". <li> From "failover_error" to "ready". <li> From "failed_over" to "ready". </ul> <P>If the "allow-internal-transitions" element is present and true, the caller may make additional state transitions: <ul> <li> From "ready" to "failing_over" <li> From "failing_over" to "failed_over" <li> From "failing_over" to "failover_error" </ul> These state transitions are intended to be used by Protection Manager server processes as part of a failover or failback sequence. Any attempt to perform other state transition will fail with an error code of EDATASETWRONGDRSTATE. <P>The DR state of a dataset will also change in one special case: <ul> <li>The dataset is in a "failed_over" DR state <li>The caller changes the data protection policy <li>The caller maps the storage set for the DR node of the old policy to the root node of the new policy (using dataset-set-storageset) </ul> When the edit session with these modifications is committed, the DR state will be set back to "ready".

=end html



B<Inputs>

=over 2

=item * I<allow-internal-transitions>  =>   B<boolean, optional>

=begin html

<br>If present and true, allow server-only state transitions (e.g. from "failing_over" to "failed_over"). If not present or false, only allow user-initiated state transitions.

=end html

=back



=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of dataset.

=end html

=back



=over 2

=item * I<dr-state>  =>   B<dr-state>

=begin html

<br>Desired DR state of dataset.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_compute_usage_metric



=begin html

This API computes space and/or IO usage metrics for a dataset. dataset-space-metric-list-info-iter-* set of APIs can be used to retrieve the computed space metrics and dataset-io-metric-list-info-iter-* set of APIs can be used to retrieve the computed IO metrics.

=end html



B<Inputs>

=over 2

=item * I<compute-io-usage-metric>  =>   B<boolean, optional>

=begin html

<br>If true, IO usage metric for the dataset will be computed. If not specified in input, it defaults to false.

=end html

=back



=over 2

=item * I<compute-space-usage-metric>  =>   B<boolean, optional>

=begin html

<br>If true, space usage metric for the dataset will be computed. If not specified in input, it defaults to false.

=end html

=back



=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of a dataset for which the usage metric has to be computed.

=end html

=back



=over 2

=item * I<timestamp>  =>   B<dp-timestamp>

=begin html

<br>Time upto which usage metrics for the dataset needs to be computed. The timestamp value should not be in future. Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_conform_begin



=begin html

Begin a conformance run on a dataset, to attempt to bring it into conformance with its data protection policy and provisioning policy. A conformance run consists of two main steps: <UL> <LI> Perform a <b>conformance check</b> to determine both the dataset's current conformance status, and the set of actions needed to bring the dataset into conformance. <LI> Perform the <b>conformance actions</b> needed to bring the dataset into conformance. </UL> In addition, the dataset's conformance status is updated at various points during the conformance run. Whenever the conformance status is updated, an event of type "dataset.conformance" is generated. <P> Successful completion of this ZAPI indicates that: the conformance check has completed successfully, the dataset's conformance status has been updated based on the results of the conformance check, and the system has begun to take any needed conformance actions. <P> After the ZAPI returns, the system continues to perform conformance actions in the background, until all actions complete. Once all actions have completed, the dataset's conformance status is again updated. Note that at present, there is no ZAPI interface for determining when all actions have completed. <P> If no policy has been assigned to the dataset, the conformance run completes immediately and performs no conformance actions. <HR> Error conditions: <UL> <LI> EACCESSDENIED - User does not have privileges to access the dataset. <LI> EOBJECTNOTFOUND - No dataset was found that has the given name or ID. <LI> EDATABASEERROR - A database error occurred while processing the request. </UL>

=end html



B<Inputs>

=over 2

=item * I<assume-confirmation>  =>   B<boolean, optional>

=begin html

<br>Value determining whether confirmation is given for all resolvable conformance actions that require user confirmation. One key and sometimes undesirable resolvable conformance action is the possible re-baseline of one or more relationships. If the value is true, all conformance actions which require user confirmation will be executed as if confirmation is already granted. If the value is false, all conformance actions which require user confirmation will not be executed. Default value is false.

=end html

=back



=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or object ID for the dataset.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_create



=begin html

Create a new, empty dataset.

=end html



B<Inputs>

=over 2

=item * I<application-info>  =>   B<L<"application-info">, optional>

=begin html

<br>If is-application-data is true, then this element will contain information about the application which manages this dataset.

=end html

=back



=over 2

=item * I<application-policy-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of the application policy to associate with this dataset.<BR> An application policy can only be attached to an empty dataset or a dataset containing only virtualization objects.<BR> Once an application policy is attached to a dataset, user can no longer assign volumes or qtrees to the root node of that dataset. <BR> Depending on the application policy type, 'vmware' or 'hyperv', only virtualization objects of that type can be added to the dataset. Vmware objects and Hyper-V objects can not be mixed in a single dataset.

=end html

=back



=over 2

=item * I<dataset-access-details>  =>   B<L<"dataset-access-details">, optional>

=begin html

<br>Data access details for a dataset that needs to be configured and provisioned in a way that it is capable of transparent migration. This enables all the storage in the primary node of the dataset to be migrated to a different physical resource without having to reconfigure the clients accessing this storage.<BR> This value will be ignored if application-policy-name-or-id is specified.

=end html

=back



=over 2

=item * I<dataset-contact>  =>   B<email-address-list, optional>

=begin html

<br>Contact for the dataset, such as the owner's e-mail address.

=end html

=back



=over 2

=item * I<dataset-description>  =>   B<string, optional>

=begin html

<br>Description of the new dataset, up to 255 characters long.

=end html

=back



=over 2

=item * I<dataset-metadata>  =>   B<L<"dfm-metadata-field">[], optional>

=begin html

<br>Opaque metadata for dataset. Metadata is usually set and interpreted by an application that is using the dataset. DFM does not look into the contents of the metadata.

=end html

=back



=over 2

=item * I<dataset-name>  =>   B<obj-name>

=begin html

<br>Name of the new dataset. It cannot be all numeric. The allowed characters are a to z A to Z 0 to 9 ' ' (space) . (period) _ (underscore) - (hyphen) If any other characters are included, an error is returned.

=end html

=back



=over 2

=item * I<dataset-owner>  =>   B<string, optional>

=begin html

<br>Name of the owner of the dataset, up to 255 characters long.

=end html

=back



=over 2

=item * I<group-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Resource group to which the newly created dataset should be added to. User should have DFM.Dataset.Write capability on the specified group. Default value: Global group.

=end html

=back



=over 2

=item * I<is-application-data>  =>   B<boolean, optional>

=begin html

<br>If true, the dataset is an application dataset managed by an external application. The default value is false.

=end html

=back



=over 2

=item * I<is-dp-suspended>  =>   B<boolean, optional>

=begin html

<br>Flag indicating whether or not the dataset should be protected. This also indicates whether conformance checking of the dataset is to be done or not. Default is False. <P> Deprecated field. Retained for backward compatibility. This field is deprecated in favour of is-suspended, which suspends the dataset for all automated actions (data protection and conformance check of the dataset).

=end html

=back



=over 2

=item * I<is-suspended>  =>   B<boolean, optional>

=begin html

<br>True if an administrator has chosen to suspend this dataset for all automated actions (data protection and conformance check of the dataset). Default is False. If present, this field takes precedence over is-dp-suspended.

=end html

=back



=over 2

=item * I<online-migration>  =>   B<boolean, optional>

=begin html

<br>Indicates, that the dataset will be capable of non-disruptive migration. By default the migration will be disruptive. Default: false.

=end html

=back



=over 2

=item * I<primary-volume-name-format>  =>   B<primary-volume-name-format, optional>

=begin html

<br>Name format string for the primary volumes created by Provisioning Manager. This element is optional. If the value of this element is empty string "", then the global naming option will be used to create names for the primary volumes. Volume name can only be 60 characters long. Name would be truncated if it exceeds that limit. For name collisions, numeric suffix would be added at the end of the volume name. Volume name can have ASCII alphabets, ASCII numbers and underscore '_'. Volume name cannot start with a number. All other characters will be converted to character 'x'. By default, the value of the option would be empty string.

=end html

=back



=over 2

=item * I<protection-policy-id>  =>   B<obj-id, optional>

=begin html

<br>Identifier of the protection policy to associate with this dataset. This legacy parameter is only used if protection-policy-name-or-id is not supplied. The dataprotection license is required for this input.

=end html

=back



=over 2

=item * I<protection-policy-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of the protection policy to associate with this dataset. This input is preferred over protection-policy-id and if supplied then do not supply protection-policy-id because protection-policy-id will be ignored. The dataprotection license is required for this input.

=end html

=back



=over 2

=item * I<provisioning-policy-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of the provisioning policy to be associated with the primary node of the dataset. The members of the primary node are provisioned based on this policy. Once the provisioning policy is associated with the dataset node, the storage in the node is periodically monitored for conformance with the policy.

=end html

=back



=over 2

=item * I<requires-non-disruptive-restore>  =>   B<requires-non-disruptive-restore, optional>

=begin html

<br>Specifies whether the dataset should be configured to enable non-disruptive restores from backup destinations.<BR> This value will be ignored if application-policy-name-or-id is specified. Non-disruptive-restore is not supported for datasets containing virtualization objects (virtual machines and datastores). <BR> Default value is false.

=end html

=back



=over 2

=item * I<secondary-qtree-name-format>  =>   B<secondary-qtree-name-format, optional>

=begin html

<br>Name format for the secondary qtrees created by Protection Manager. This element is optional. If the value of this element is empty string "", then the global naming option will be used to create names for qtrees Qtree name can only be 60 characters long. Name would be truncated if it exceeds that limit. For name collisions, numeric suffix would be added at the end of the qtree name. Qtree name can have ASCII alphabets, ASCII numbers, hypen '-', dot '.' and underscore '_'. All other characters will be converted to character 'x'. By default, the value of the option would be empty string. This option does not apply to names of primary qtrees..

=end html

=back



=over 2

=item * I<secondary-volume-name-format>  =>   B<secondary-volume-name-format, optional>

=begin html

<br>Naming format string for the secondary volumes created by Protection Manager. This element is optional. If the value of this element is empty string "", then the global naming option will be used to create names for the secondary volumes. Volume name can only be 60 characters long. Name would be truncated if it exceeds that limit. For name collisions, numeric suffix would be added at the end of the volume name. Volume name can have ASCII alphabets, ASCII numbers and underscore '_'. Volume name cannot start with a number. All other characters will be converted to character 'x'. By default, the value of the option would be empty string.

=end html

=back



=over 2

=item * I<snapshot-name-format>  =>   B<snapshot-name-format, optional>

=begin html

<br>Name format string for snapshots created by Protection Manager and Host Service's plug-ins. This element is optional. If the value of this element is empty string "", then the global naming option will be used to created names for snapshot. If %A is not specified as one of the substitution tokens in the format, plug-ins creating snapshots for application datasets will implicitly add %A at the end of the format string and the snapshot name will have application fields in them. Snapshot name length can only be 124 characters long. Name would be truncated if it exceeds that limit. For name collisions, numeric suffix would be added at the end of the snapshots. Snapshot name can have ASCII alphabets, ASCII numbers, underscore '_', hyphen '-', plus sign '+' and a dot '.'. All other characters will be converted to character 'x'. By default, the value of the option is an empty string.

=end html

=back



=over 2

=item * I<timezone-name>  =>   B<string, optional>

=begin html

<br>Timezone to assign to the root node. If specified, the value must be a timezone-name returned by timezone-list-info-iter-next. If no timezone is assigned, then the default system timezone will be used.

=end html

=back



=over 2

=item * I<vfiler-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of the vFiler unit to be attached to the primary node of the dataset. If a vFiler unit is attached, then all members provisioned into this node will be exported over this vFiler unit. If an application policy is assigned to this dataset, this parameter will be ignored.<BR> This value will be ignored if application-policy-name-or-id is specified.

=end html

=back



=over 2

=item * I<volume-qtree-name-prefix>  =>   B<string, optional>

=begin html

<br>Prefix for volume and qtree names, up to 60 characters long. The allowed characters are a to z A to Z 0 to 9 ' ' (space) . (period) _ (underscore) - (hyphen) If any other characters are included, an error is returned

=end html

=back



B<Outputs>

=over 2

=item * I<dataset-id>  =>   B<obj-id>

=begin html

<br>Identifier of the new dataset.

=end html

=back



=head2 dataset_destroy



=begin html

Destroy a dataset. The dataset must be empty unless the "force" option is used.

=end html



B<Inputs>

=over 2

=item * I<cancel-edit-sessions>  =>   B<boolean, optional>

=begin html

<br>Specifies if edit operations in progress on the dataset should be cancelled. <P> If true, any edit operations in progress on the dataset are rolled back before destroying the dataset. <P> If cancel-edit-sessions is false, dataset with pending edit operations cannot be destroyed. <P> Default is false.

=end html

=back



=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of the dataset to destroy.

=end html

=back



=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>If true, allows destroying a dataset that has members or dynamic references. By default, only empty datasets can be destroyed.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_dynamic_reference_list_info_iter_end



=begin html

Ends iteration of the dynamic references in the dataset.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-dynamic-reference-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_dynamic_reference_list_info_iter_next



=begin html

Get next records in the iteration started by dataset-dynamic-reference-list-info-iter-start

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of records to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-dynamic-reference-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<dataset-dynamic-references>  =>   B<L<"dataset-dynamic-reference-info">[]>

=begin html

<br>List of the dynamic references in the dataset.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned.

=end html

=back



=head2 dataset_dynamic_reference_list_info_iter_start



=begin html

Starts iteration to list the dynamic references in the dataset. Volumes are not considered dynamic references because they are members. (even though they can contain qtrees)

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of dataset whose dynamic references will be listed.

=end html

=back



=over 2

=item * I<dp-node-name>  =>   B<dp-policy-node-name, optional>

=begin html

<br>List only the members in this policy node. If none is specified, then list members in all policy nodes. If both dp-node-name and storageset-name-or-id are specified, then the value of dp-node-name is ignored.

=end html

=back



=over 2

=item * I<dynamic-reference-type>  =>   B<string, optional>

=begin html

<br>Type of dynamic reference. Possible values are 'filer', 'vfiler', 'aggregate', 'ossv_host' or 'app_object'. If present, only dynamic references of the specified type are returned.

=end html

=back



=over 2

=item * I<include-deleted>  =>   B<boolean, optional>

=begin html

<br>If present and true, dynamic references which are marked as deleted in the database are also returned. Otherwise, deleted dynamic references are not returned.

=end html

=back



=over 2

=item * I<include-is-available>  =>   B<boolean, optional>

=begin html

<br>If true, the is-available status is calculated for each member which may make the call to this zapi take much longer. Default is false.

=end html

=back



=over 2

=item * I<storageset-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>List only the members in this storage set. If none is specified, then list members in all storagesets mapped to this dataset's nodes. If both dp-node-name and storageset-name-or-id are specified, then the value of dp-node-name is ignored.

=end html

=back



=over 2

=item * I<suppress-status-refresh>  =>   B<boolean, optional>

=begin html

<br>If true, do not refresh the dynamic_reference status. If false or omitted, the status of all dynamic references will be refreshed before being returned.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of items that have been saved for future retrieval with dataset-dynamic-reference-list-info-iter-next.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to dataset-dynamic-reference-list-info-iter-next.

=end html

=back



=head2 dataset_edit_begin



=begin html

Obtain an edit lock to start modifying a dataset. <P>Besides locking the dataset itself, all storage sets in the dataset are locked, as well as the data protection policy if one is assigned. <P>An edit lock must be obtained before invoking the following ZAPIs: <UL> <LI>dataset-add-member <LI>dataset-remove-member <LI>dataset-add-member-by-dynamic-reference <LI>dataset-remove-member-by-dynamic-reference <LI>dataset-set-storageset <LI>dataset-modify <LI>dataset-modify-node <LI>dataset-add-resourcepool <LI>dataset-remove-resourcepool <LI>dataset-provision-member <LI>dataset-resize-member <LI>dataset-member-delete-snapshots <LI>dataset-add-to-exclusion-list <LI>dataset-remove-from-exclusion-list </UL> Use dataset-edit-commit to commit the changes to the database. <P>Use dataset-edit-rollback to undo the changes made to the dataset. <P>After 24 hours, the lock can be taken by another client without the force option. This will cause any edits pending on the aborted session to be lost.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of the dataset to edit.

=end html

=back



=over 2

=item * I<force>  =>   B<boolean, optional>

=begin html

<br>By default, force is false. If true, and an edit is already in progress on the specified dataset or an object the dataset is dependent on (such as a data protection policy), the previous edit session is rolled back and a new edit session is begun.

=end html

=back



B<Outputs>

=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock on the dataset. Range: [1..2^31-1]

=end html

=back



=head2 dataset_edit_commit



=begin html

Commit changes made to a dataset into the database.<P> The edit lock on the dataset will be released after the changes have been successfully committed.<P> Use the <b>dry-run</b> option to test the commit. It invokes the conformance checker to return a list of actions that would be taken should the changes be actually committed. The <b>dry-run</b> option also returns a list of high level alerts to notify the user of rebaseline operations or system level issues related to successful conformance. <P> If <b>dry-run</b> is false, then before the call returns, the system begins a <b>conformance run</b> on the dataset. (See <b>dataset-conform-begin</b> for a description of conformance runs.) If the system is to perform a <b>conformance run</b> on the dataset it will be done with the current dataset edit session value for assume-confirmation. The default value for assume-confirmation is initially true when the edit session begins, but may be altered by certain changes to the dataset made through the use of <b>dataset-modify</b>. The optional <b>assume-confirmation</b> option may be used to specify if user confirmation is to be assumed or not for this <b>dataset-edit-commit</b>. One key, and sometimes undesirable, resolvable action that requires user confirmation is the possible re-baseline of a relationship.

=end html



B<Inputs>

=over 2

=item * I<assume-confirmation>  =>   B<boolean, optional>

=begin html

<br>Value determining whether confirmation is given for all resolvable conformance actions that require user confirmation. If the value is true, all conformance actions which require user confirmation will be executed as if confirmation is already granted. If the value is false, all conformance actions which require user confirmation will not be executed. The default value is initially true when the edit session begins, but may be altered by certain changes to the dataset made through the use of <b>dataset-modify</b>. One key, and sometimes undesirable, resolvable action that requires user confirmation is the possible re-baseline of a relationship.

=end html

=back



=over 2

=item * I<dry-run>  =>   B<boolean, optional>

=begin html

<br>If true, return the dry-run-results list as well as the conformance-alerts list. The dry-run-results list contains actions that would be taken should the changes be committed without actually committing the changes. The conformance-alerts list contains high level alerts to notify a user of conditions that will impact any attempt to commit the changes. A conformance alert may warn that if the changes are committed, one or more rebaseline operations may be done. The conformance alerts may also warn of conditions that exist that may prevent the succesful conformance of datasets. The edit lock is not released after a dry run. By default, dry-run is false.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock on the dataset. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<include-dry-run-reason-details>  =>   B<boolean, optional>

=begin html

<br>If true or omitted, then include any possible <b>dry-run-reason-details</b> along with the associated <b>dry-run-result</b> element. Default value is true. If false, the <b>dry-run-reason-details</b> will not be returned.

=end html

=back



B<Outputs>

=over 2

=item * I<conformance-alerts>  =>   B<L<"conformance-alert">[], optional>

=begin html

<br>Alerts that apply to the conformance check. Each alert describes one type of condition that a user should be aware of before attempting to conform any more datasets. Only returned if dry-run is true.

=end html

=back



=over 2

=item * I<dry-run-results>  =>   B<L<"dry-run-result">[], optional>

=begin html

<br>Results of a dry run. Each result describes one action the system would take and the predicted effects of that action. Only returned if dry-run is true.

=end html

=back



=over 2

=item * I<is-provisioning-failure>  =>   B<boolean, optional>

=begin html

<br>This element is returned only if dry-run is true and only when there was a provisioning request issued in the edit session. If the dry run shows errors for the provisioning request its value is TRUE, else FALSE. This element can be used by clients to distinguish the case where provisioning job will succeed, but the dry run contains dataset conformance related errors.

=end html

=back



=over 2

=item * I<job-ids>  =>   B<L<"job-info">[], optional>

=begin html

<br>Job identifiers of provisioning requests or dataset reexport jobs. This output element is present only if <ul> <li>1. There were any provisioning requests issued in the edit session. <li>2. The dataset is reexported due to change in provisioning policy. </ul> This is returned only if dry-run is false.

=end html

=back



=head2 dataset_edit_rollback



=begin html

Roll back changes made to a dataset. The edit lock on the dataset will be released after the rollback.

=end html



B<Inputs>

=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock on the dataset. Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_exclusion_list_info_iter_end



=begin html

Ends iteration of dataset exclusion list.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-exclusion-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_exclusion_list_info_iter_next



=begin html

Get next records in the iteration started by dataset-exclusion-list-info-iter-start

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of records to retrieve. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-exclusion-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<exclusion-list>  =>   B<L<"excluded-object-info">[]>

=begin html

<br>List of the objects in the dataset to exclude from being backed up.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned. Range: [1..2^31-1]

=end html

=back



=head2 dataset_exclusion_list_info_iter_start



=begin html

Starts iteration to retrieve the backup exclusion list of the dataset.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of the dataset whose members will be listed.

=end html

=back



=over 2

=item * I<include-deleted>  =>   B<boolean, optional>

=begin html

<br>If present and true, members which are marked as deleted in the database are also returned. Otherwise, deleted members are not returned.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or id in the DFM database, of a specific member of the dataset's exclusion list. If specified, details of only this object will be returned.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of records that have been saved for future retieval with dataset-exclusion-list-info-iter-next. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to dataset-exclusion-list-info-iter-next.

=end html

=back



=head2 dataset_io_metric_list_info_iter_end



=begin html

Ends iteration to list dataset I/O usage metric.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-io-metric-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_io_metric_list_info_iter_next



=begin html

Get next few records in the iteration started by dataset-io-metric-list-info-iter-start.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-io-metric-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<dataset-io-metrics>  =>   B<L<"dataset-io-metric-info">[]>

=begin html

<br>List of I/O usage measurement information of datasets.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned. Range: [0..2^31-1]

=end html

=back



=head2 dataset_io_metric_list_info_iter_start



=begin html

Starts iteration to list dataset's I/O usage measurements.

=end html



B<Inputs>

=over 2

=item * I<day>  =>   B<integer, optional>

=begin html

<br>The day for which the usage metric is required. The month element is required along with this input. When present, the usage metrics for the day is returned. Range: [1..31]

=end html

=back



=over 2

=item * I<month>  =>   B<month, optional>

=begin html

<br>The month for which the usage metric is required. If month is not specified, it defaults to the current month. If month element is provided without the day element in input, then the usage metrics available for the month is returned. If month and year element is not provided in input, then the usage measurements for the current month is returned. The start of the current month is determined by the <b>chargebackDayOfMonth</b> global option. Range: [1..12]

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of a dataset or resource group or storage service. If a resource group is given, usage measurement of the datasets which are direct members of the group are returned. If a storage service is given, usage measurement of datasets associated with the storage service is returned. If input is not given, usage measurement of all the datasets is returned.

=end html

=back



=over 2

=item * I<year>  =>   B<integer, optional>

=begin html

<br>The year for which the usage metric is required. If year element is not provided in input, then the current year is selected. Range: [1900..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of records that have been saved for future retrieval with dataset-io-metric-list-info-iter-next. Range: [0..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to dataset-io-metric-list-info-iter-next.

=end html

=back



=head2 dataset_list_info_iter_end



=begin html

Ends iteration to list datasets.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_list_info_iter_next



=begin html

Get next few records in the iteration started by dataset-list-info-iter-start. <p> If a dataset has a data protection policy assigned to it, the has-protection-policy field will be true. If the client has suspended the dataset, has-protection-policy is still true, but is-dp-suspended and is-suspended fields are also set to true to reflect this. When the client sets is-dp-ignored to true, nothing changes, except that, when the client requests the list of datasets which are not ignored, the ignored datasets will not be returned.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<datasets>  =>   B<L<"dataset-info">[]>

=begin html

<br>List of datasets.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned.

=end html

=back



=head2 dataset_list_info_iter_start



=begin html

Starts iteration to list datasets.

=end html



B<Inputs>

=over 2

=item * I<application-name>  =>   B<string, optional>

=begin html

<br>Return only application datasets managed by a particular type of application. Up to 255 characters long.

=end html

=back



=over 2

=item * I<application-resource-namespace>  =>   B<application-resource-namespace, optional>

=begin html

<br>Namespace of the application resources in the dataset. If specified, then only datasets containing application resources, which belong to this namespace, are returned. Ignored, if include-can-contain-application-resources-only is false. If not specified, when include-can-contain-application-resources-only is true, then all datasets which can contain application resources, are returned.

=end html

=back



=over 2

=item * I<application-server-name>  =>   B<string, optional>

=begin html

<br>Return only application datasets managed by an application running on a particular server. Up to 255 characters long.

=end html

=back



=over 2

=item * I<dr-state>  =>   B<dr-state, optional>

=begin html

<br>Filter by dr-state value. If no dr-state input is supplied, all datasets will be listed.

=end html

=back



=over 2

=item * I<has-application-policy>  =>   B<boolean, optional>

=begin html

<br>If true, only list datasets which have an application policy assigned to them. If false, only list datasets which do not have any application policy assigned. If not set, list all datasets.

=end html

=back



=over 2

=item * I<has-protection>  =>   B<boolean, optional>

=begin html

<br>If true, only list datasets which have a data protection policy and at least 1 relationship associated with them or the policy has only 1 node. If false, only list datasets which do not have any associated policy or datasets which have policy with more than 1 node but do not have any associated relationship. If not set, list all datasets.

=end html

=back



=over 2

=item * I<has-protection-policy>  =>   B<boolean, optional>

=begin html

<br>If true, only list datasets which have a data protection policy assigned to them. If false, only list datasets which do not have any data protection policy assigned. If not set, list all datasets.

=end html

=back



=over 2

=item * I<include-can-contain-application-resources-only>  =>   B<boolean, optional>

=begin html

<br>If true, restricts returned datasets to only those to which application resources can be added. If false or not specified, this restriction is not applied. Default is false.

=end html

=back



=over 2

=item * I<include-can-contain-storage-resources-only>  =>   B<boolean, optional>

=begin html

<br>If true, restricts returned datasets to only those to which storage resources can be added. If false or not specified, this restriction is not applied. Default is false.

=end html

=back



=over 2

=item * I<include-conformance-check-results>  =>   B<boolean, optional>

=begin html

<br>If true, return the detailed conformance check results. If false or omitted, the conformance check results, which are expensive to retrieve, will not be returned.

=end html

=back



=over 2

=item * I<include-conformance-run-reason-details>  =>   B<boolean, optional>

=begin html

<br>If true or omitted and <b>include-conformance-check-results</b> is also true, then include any possible <b>conformance-run-reason-details</b> along with the associated <b>conformance-run-result</b> element. Default value is true. If false, the <b>conformance-run-reason-details</b>, will not be returned.

=end html

=back



=over 2

=item * I<include-export-settings>  =>   B<boolean, optional>

=begin html

<br>If true, the export settings for the dataset nodes will be present in the output of dataset-list-info-iter-next. Default value is false.

=end html

=back



=over 2

=item * I<include-metadata>  =>   B<boolean, optional>

=begin html

<br>If true, returns dataset's metadata. If false, metadata, which can be large in size, is not returned. Default is false.

=end html

=back



=over 2

=item * I<include-migration-info>  =>   B<boolean, optional>

=begin html

<br>If true, the migration information for the dataset is returned in dataset-list-info-iter-next. Default is false.

=end html

=back



=over 2

=item * I<include-protection-status-problems>  =>   B<boolean, optional>

=begin html

<br>If true, return the detailed protection-status-problems if the dataset does not have protection status as "protected". Setting include-protection-status-problems to true will generate an error unless only one dataset is specified from the other input parameters. If false or omitted, protection-status-problems, which can be expensive to retrieve, will not be returned.

=end html

=back



=over 2

=item * I<is-application-data>  =>   B<boolean, optional>

=begin html

<br>If true, return only datasets managed by an application. If false, return only datasets which are not managed by an application. By default, return all datasets.

=end html

=back



=over 2

=item * I<is-dp-ignored>  =>   B<boolean, optional>

=begin html

<br>If true, only list datasets that have been set to be ignored for purposes of data protection. If false, only list datasets that have been not set to be ignored for purposes of data protection. If not specified, list all datasets without taking into account whether they have been ignored or not.

=end html

=back



=over 2

=item * I<is-dr-capable>  =>   B<boolean, optional>

=begin html

<br>If true, return only datasets with dp policies that are disaster recovery capable. If false, return only datasets with policies that are not disaster recovery capable. By default, return all datasets.

=end html

=back



=over 2

=item * I<is-protected>  =>   B<boolean, optional>

=begin html

<br>If true, only list datasets which have a data protection policy assigned to them. If false, only list datasets which do not have any data protection policy assigned. If not set, list all datasets. <P> Deprecated field. Retained for backward compatibility. This field is deprecated and to be replaced by has-protection-policy.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of a dataset or resource group or provisioning policy or storage service. If a resource group is given, only the datasets which are direct members of the group are returned. If a provisioning policy is given, only those datasets where one or more of its nodes is associated with the provisioning policy are returned. If storage service is given, only those datasets which are associated with the storage service are are returned.

=end html

=back



=over 2

=item * I<requires-non-disruptive-restore>  =>   B<requires-non-disruptive-restore, optional>

=begin html

<br>If true, return only datasets requiring non-disruptive restore. If false, return only datasets which do not require non-disruptive restore. By default, return all datasets.

=end html

=back



=over 2

=item * I<suppress-status-refresh>  =>   B<boolean, optional>

=begin html

<br>If true, do not refresh the dataset status. If false or omitted, the status of all queried datasets will be re-calculated before being returned.

=end html

=back



=over 2

=item * I<volume-qtree-name-prefix>  =>   B<string, optional>

=begin html

<br>Return only datasets with a particular type of custom name prefix. Up to 60 characters long.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of records that have been saved for future retrieval with dataset-list-info-iter-next.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to dataset-list-info-iter-next.

=end html

=back



=head2 dataset_member_dedupe_abort



=begin html

Abort in-progress dedupe operation on the given volume member of the dataset.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of dataset.

=end html

=back



=over 2

=item * I<volume-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of a volume member of the dataset.

=end html

=back



B<Outputs>

=over 2

=item * I<job-id>  =>   B<integer, optional>

=begin html

<br>Id of the job that handles the deduplication operation. This is returned only if there is an on-demand deduplication job running and will not be present if the deduplication operation was triggered by the storage system. <BR> Range: [1..2^31-1]

=end html

=back



=head2 dataset_member_dedupe_start



=begin html

Start deduplication operation on specified volume member of the given dataset.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or Identifier of the dataset.

=end html

=back



=over 2

=item * I<dedupe-member-request-info>  =>   B<L<"dedupe-member-request-info">>

=begin html

<br>Details on member to be deduplicated.

=end html

=back



B<Outputs>

=over 2

=item * I<job-id>  =>   B<integer>

=begin html

<br>Id of the job that handles the deduplication operation. <BR> Range: [1..2^31-1]

=end html

=back



=head2 dataset_member_delete_snapshots



=begin html

Delete Snapshot copies of a volume which is a member of the effective primary node of the dataset. <P>The effective primary node for a non disaster recovery capable dataset or a disaster recovery capable dataset not in the DR state of "failed_over" is the root node of the dataset. The effective primary of a disaster recovery dataset in the DR state of "failed_over" is the disaster recovery capable node of the dataset. <P>The deletion of Snapshot copies happens in the background. <P>A provisioning job id is returned in dataset-edit-commit zapi that represents the job which will delete the specified Snapshot copies. The status of the job can be checked using dp-job-list-iter ZAPIs with the given job-id. Error conditions: <UL> <LI> EACCESSDENIED - User does not have privileges to delete Snapshot copies of the member. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> EOBJECTNOTFOUND - No volume by the given name or identifier was found. <LI> ENOTINDATASET - Member is not in the primary node of the specified dataset. <LI> EOBJECTAMBIGUOUS - The specified member name could refer to two or more objects. Try again with the object identifier or object full name. <LI> EINVALIDINPUT - No Snapshot copies are specified for deletion or both volume-id and volume-name are not given in input or at least one of the Snapshot copies specified for deletion is marked busy. <LI> ESNAPSHOTNOTFOUND - At least one of the Snapshot copy specified is not found on the volume. <LI> EEDITSESSIONNOTFOUND - If the edit session specified in input is not found <LI> EEDITSESSIONOBJECTALREADYLOCKED - If the object being tried to lock in this operation is already locked by some other edit session <LI> EEDITSESSIONCONFLICTINGOP - If this snapshot deletion operation is conflicting with some other edit operation in the same edit session <LI> EDATASETNOTINSTABLEDRSTATE - The dataset is not in a stable disaster recovery state. </UL>

=end html



B<Inputs>

=over 2

=item * I<delete-snapshots-request-info>  =>   B<L<"delete-snapshots-request-info">>

=begin html

<br>Details on the volume and Snapshot copies to be deleted.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_member_list_info_iter_end



=begin html

Ends iteration of dataset members.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-member-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_member_list_info_iter_next



=begin html

Get next records in the iteration started by dataset-member-list-info-iter-start

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of records to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-member-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<dataset-members>  =>   B<L<"dataset-member-info">[]>

=begin html

<br>List of the members of the dataset.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned.

=end html

=back



=head2 dataset_member_list_info_iter_start



=begin html

Starts iteration to list members of the dataset. Dynamic references are not returned by this API, nor are objects only associated with the dataset by their inclusion in a dynamic reference.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of the dataset whose members will be listed.

=end html

=back



=over 2

=item * I<dp-node-name>  =>   B<dp-policy-node-name, optional>

=begin html

<br>List only the members in this policy node. If none is specified, then list members in all policy nodes. If both dp-node-name and storageset-name-or-id are specified, then the value of dp-node-name is ignored.

=end html

=back



=over 2

=item * I<include-deleted>  =>   B<boolean, optional>

=begin html

<br>If present and true, members which are marked as deleted in the database are also returned. Otherwise, deleted members are not returned.

=end html

=back



=over 2

=item * I<include-exports-info>  =>   B<boolean, optional>

=begin html

<br>If true, the export information of members is included in output. If the member is exported over NFS, the NFS export name is retuned in nfs-export-name element in dataset-member-info. If the member is exported over CIFS, the share names are returned in cifs-share-names array in dataset-member-info. In case the members are accessed using both NFS and CIFS (i.e Mixed mode) then both NFS export name and CIFS share names are returned. Default value is false.

=end html

=back



=over 2

=item * I<include-indirect>  =>   B<boolean, optional>

=begin html

<br>If true, indirect members are included. By default they are not included. An example of an indirect member is a qtree in a volume which is a direct member of the dataset.

=end html

=back



=over 2

=item * I<include-is-available>  =>   B<boolean, optional>

=begin html

<br>If true, the is-available status is calculated for each member which may make the call to this zapi take much longer. Default is false.

=end html

=back



=over 2

=item * I<include-space-info>  =>   B<boolean, optional>

=begin html

<br>If true, the space status is computed for all members, the space status and detailed space conditions of every data set member is returned if the space status of the member is "warning" or "error". Default value is false.

=end html

=back



=over 2

=item * I<member-id>  =>   B<obj-id, optional>

=begin html

<br>Id, in the DFM database, of a specific member of the dataset. If specified, details of only this object will be returned.

=end html

=back



=over 2

=item * I<member-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or id in the DFM database, of a specific member of the dataset. If specified, details of only this object will be returned. If both member-id and member-name-or-id is specified, then member-id will take precedence over member-name-or-id.

=end html

=back



=over 2

=item * I<member-type>  =>   B<string, optional>

=begin html

<br>Type of the member. Possible values for direct members are: "volume", "qtree" or "ossv_directory". When include-exports-info is true in dataset-member-list-info-iter-start, this can also be "lun_path". If present, only members of the specified type are returned.

=end html

=back



=over 2

=item * I<storageset-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>List only the members in this storage set. If none is specified, then list members in all storagesets mapped to this dataset's nodes. If both dp-node-name and storageset-name-or-id are specified, then the value of dp-node-name is ignored.

=end html

=back



=over 2

=item * I<suppress-status-refresh>  =>   B<boolean, optional>

=begin html

<br>If true, do not refresh the member status. If false or omitted, the status of all members will be refreshed before being returned.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of records that have been saved for future retieval with dataset-member-list-info-iter-next.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to dataset-member-list-info-iter-next.

=end html

=back



=head2 dataset_member_undedupe_start



=begin html

Start undeduplication operation on specified volume member of the given dataset.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or Identifier of the dataset.

=end html

=back



=over 2

=item * I<undedupe-member-request-info>  =>   B<L<"undedupe-member-request-info">>

=begin html

<br>Details on member to be undeduplicated.

=end html

=back



B<Outputs>

=over 2

=item * I<job-id>  =>   B<integer>

=begin html

<br>Id of the job that handles the undeduplication operation. <BR> Range: [1..2^31-1]

=end html

=back



=head2 dataset_missing_member_list_info_iter_end



=begin html

Ends iteration of missing dataset members.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-missing-member-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_missing_member_list_info_iter_next



=begin html

Get next records in the iteration started by dataset-member-list-info-iter-start

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of records to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-member-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<missing-members>  =>   B<L<"missing-member-info">[]>

=begin html

<br>List of the missing members of the dataset.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned.

=end html

=back



=head2 dataset_missing_member_list_info_iter_start



=begin html

Starts iteration to list members of the dataset that have gone missing. The way the server determines if an object was not intentionally removed from the dataset is: <ol> <li>The object is still a dataset member. <li>The object's objDeleted flag is set. </ol>

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of the dataset whose members will be listed.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of records that have been saved for future retieval with dataset-member-list-info-iter-next.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to dataset-member-list-info-iter-next.

=end html

=back



=head2 dataset_modify



=begin html

Modify attributes for a dataset.

=end html



B<Inputs>

=over 2

=item * I<application-info>  =>   B<L<"application-info">, optional>

=begin html

<br>This input is used only if is-application-data is true. It contains information about the application which manages this dataset.

=end html

=back



=over 2

=item * I<application-policy-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of the application policy to associate with this dataset.<BR> An application policy can only be attached to an empty dataset or a dataset containing only virtualization objects.<BR> Once an application policy is attached to a dataset, user can no longer assign volumes or qtrees to the root node of that dataset. <BR> Depending on the application policy type, 'vmware' or 'hyperv', only virtualization objects of that type can be added to the dataset. Vmware objects and Hyper-V objects can not be mixed in a single dataset.

=end html

=back



=over 2

=item * I<check-protection-policy-on-commit>  =>   B<boolean, optional>

=begin html

<br>In the default case for a protection policy change, we immediately check the dataset's membership configuration. However, in the case where we are changing the policy and the storage set assignments in the same edit session, the caller can set this flag to true to request that the server postpone the check of the protection policy configuration and root node membership until the call to edit-commit. Default value is false.

=end html

=back



=over 2

=item * I<dataset-contact>  =>   B<email-address-list, optional>

=begin html

<br>Contact for the dataset, such as the owner's e-mail address.

=end html

=back



=over 2

=item * I<dataset-description>  =>   B<string, optional>

=begin html

<br>Description of the dataset, up to 255 character long.

=end html

=back



=over 2

=item * I<dataset-metadata>  =>   B<L<"dfm-metadata-field">[], optional>

=begin html

<br>Opaque metadata for dataset. Metadata is usually set and interpreted by an application that is using the dataset. DFM does not look into the contents of the metadata.

=end html

=back



=over 2

=item * I<dataset-name>  =>   B<obj-name, optional>

=begin html

<br>Name of the dataset. It cannot be all numeric. The allowed characters are a to z A to Z 0 to 9 ' ' (space) . (period) _ (underscore) - (hyphen) If any other characters are included, an error is returned.

=end html

=back



=over 2

=item * I<dataset-owner>  =>   B<string, optional>

=begin html

<br>Name of the owner of the dataset, up to 255 characters long.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<is-application-data>  =>   B<boolean, optional>

=begin html

<br>If true, the dataset is an application dataset managed by an external application. Conversion of a non-application dataset to an application dataset is not allowed. The default value is false.

=end html

=back



=over 2

=item * I<is-dp-ignored>  =>   B<boolean, optional>

=begin html

<br>True if an administrator has chosen to ignore this dataset for purposes of data protection. Data sets with this attribute set to true are not returned when the client requests datasets which are not ignored. This attribute has no other significance to the system.

=end html

=back



=over 2

=item * I<is-dp-suspended>  =>   B<boolean, optional>

=begin html

<br>Flag indicating whether or not the dataset should be protected. This also indicates whether conformance checking of the dataset is to be done or not. Default is False. <P> Should is-dp-suspended go from TRUE to FALSE the edit session assume-confirmation default setting will be be set to FALSE for this dataset. (See <b>dataset-edit-commit</b> for details) <P> Deprecated field. Retained for backward compatibility. This field is deprecated in favour of is-suspended, which suspends the dataset for all automated actions (data protection and conformance check of the dataset).

=end html

=back



=over 2

=item * I<is-suspended>  =>   B<boolean, optional>

=begin html

<br>True if an administrator has chosen to suspend this dataset for all automated actions (data protection and conformance check of the dataset). Default is False. If present, this field takes precedence over is-dp-suspended. <P> Should is-suspended go from TRUE to FALSE the edit session assume-confirmation default setting will be be set to FALSE for this dataset. (See <b>dataset-edit-commit</b> for details)

=end html

=back



=over 2

=item * I<primary-volume-name-format>  =>   B<primary-volume-name-format, optional>

=begin html

<br>Name format string for the primary volumes created by Provisioning Manager. This element is optional. If the value of this element is empty string "", then the global naming option will be used to create names for the primary volumes. Volume name can only be 60 characters long. Name would be truncated if it exceeds that limit. For name collisions, numeric suffix would be added at the end of the volume name. Volume name can have ASCII alphabets, ASCII numbers and underscore '_'. Volume name cannot start with a number. All other characters will be converted to character 'x'. By default, the value of the option would be empty string.

=end html

=back



=over 2

=item * I<protection-policy-id>  =>   B<obj-id, optional>

=begin html

<br>Identifier of the protection policy to associate with this dataset. This legacy parameter is only used if protection-policy-name-or-id is not supplied. The dataprotection license is required for this input.

=end html

=back



=over 2

=item * I<protection-policy-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of the protection policy to associate with this dataset. This input is preferred over protection-policy-id and if supplied then do not supply protection-policy-id because protection-policy-id will be ignored. The dataprotection license is required for this input.

=end html

=back



=over 2

=item * I<requires-non-disruptive-restore>  =>   B<requires-non-disruptive-restore, optional>

=begin html

<br>Specifies whether the dataset requires a non-disruptive restore of LUNs so that the host need not get detached from the LUN.<BR> This value will be ignored if application-policy-name-or-id is specified. Non-disruptive-restore is not supported for datasets containing virtualization objects.<BR> Default value is false.

=end html

=back



=over 2

=item * I<secondary-qtree-name-format>  =>   B<secondary-qtree-name-format, optional>

=begin html

<br>Name format for the secondary qtrees created by Protection Manager. This element is optional. If the value of this element is empty string "", then the global naming option will be used to create names for qtree Qtree name can only be 60 characters long. Name would be truncated if it exceeds that limit. For name collisions, numeric suffix would be added at the end of the qtree name. Qtree name can have ASCII alphabets, ASCII numbers, hypen '-', dot '.' and underscore '_'. All other characters will be converted to character 'x'. By default, the value of the option would be empty string. This option does not apply to names of primary qtrees.

=end html

=back



=over 2

=item * I<secondary-volume-name-format>  =>   B<secondary-volume-name-format, optional>

=begin html

<br>Naming format string for the secondary volumes created by Protection Manager. This element is optional. If the value of this element is empty string "", then the global naming option will be used to create names for the secondary volumes. Volume name can only be 60 characters long. Name would be truncated if it exceeds that limit. For name collisions, numeric suffix would be added at the end of the volume name. Volume name can have ASCII alphabets, ASCII numbers and underscore '_'. Volume name cannot start with a number. All other characters will be converted to character 'x'. By default, the value of the option would be empty string.

=end html

=back



=over 2

=item * I<snapshot-name-format>  =>   B<snapshot-name-format, optional>

=begin html

<br>Name format string for snapshots created by Protection Manager and Host Service's plug-ins. This element is optional. If the value of this element is empty string "", then the global naming option will be used to created names for snapshot. If %A is not specified as one of the substitution tokens in the format, plug-ins creating snapshots for application datasets will implicitly add %A at the end of the format string and the snapshot name will have application fields in them. Snapshot name length can only be 124 characters long. Name would be truncated if it exceeds that limit. For name collisions, numeric suffix would be added at the end of the snapshots. Snapshot name can have ASCII alphabets, ASCII numbers, underscore '_', hyphen '-', plus sign '+' and a dot '.'. All other characters will be converted to character 'x'. By default, the value of the option is an empty string.

=end html

=back



=over 2

=item * I<volume-qtree-name-prefix>  =>   B<string, optional>

=begin html

<br>Prefix for volume and qtree names, up to 60 character long. The allowed characters are a to z A to Z 0 to 9 ' ' (space) . (period) _ (underscore) - (hyphen) If any other characters are included, an error is returned.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_modify_node



=begin html

Modify attributes of a single storage set that is part of a dataset. The storage set is specified implicitly by the name of the data protection policy node that maps to it. You may change the storage set's resource pool and timezone using this call, but not its name or description.<P> Within the same edit session in which you call <b>dataset-modify-node</b>, you may also add or remove members or dynamic references, or change the dataset's name, description, <b>is-dp-ignored</b>, <b>is-dp-suspended</b>, or <b>is-suspended</b>. You may not change the data set's policy or storage sets within the same edit session. <HR> Error conditions: <UL> <LI> EEDITSESSIONNOTFOUND - No edit lock was foundthat has the given identifier. <LI> EACCESSDENIED - User does not have permission to modify the storage set. <LI> EOBJECTAMBIGUOUS - The name given for the storage set or resource pool matches multiple storage sets or resource pools. <LI> EOBJECTNOTFOUND - No storage set or resource pool was found that has the given name or identifier. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> ESTORAGESETNOTINDATASET - The specified storage set is not a part of the dataset being edited. <LI> EDPPOLICYNODENOTFOUND - No DP policy node was found that has the given name. <LI> EEDITSESSIONCONFLICTINGOP - The requested modification conflicts with other changes performed during the edit session. <LI> EINVALIDTIMEZONE - The given timezone name is not valid. <LI> EDSCONFLICTALREADYINDATASET - Object, its ancestor or descendent is already in dataset. <LI> EDSCONFLICTSRCDESTINSAMEAGGR - Source data and destination data are in the same aggregate. <LI> EDSCONFLICTALREADYINRESPOOL - Object, its ancestor or descendent is already in resource pool. <LI> EDSCONFLICTCANTMIRROROSSV - OSSV is not allowed in mirror source node. <LI> EDSCONFLICTCANTSNAPSHOTOSSV - Cannot apply snapshot schedule to OSSV. <LI> EDSCONFLICTINCOMPATIBLEPOLICY - Policy is not compatible with application dataset. <LI> EDSCONFLICTOSSVNOTALLOWED - OSSV is not allowed in the dataset. <LI> EDSCONFLICTNOSMLICENSE - There is no SnapMirror license installed. <LI> EDSCONFLICTNOSMSVLICENSE - There is no SnapMirror or SnapVault license installed. Need to have at least one of them installed. <LI> EDSCONFLICTROOTNODE - Operation cannot be performed on root node of dataset. <LI> EDSCONFLICTNOTROOTNODE - Operation cannot be performed on non-root node of dataset. <LI> EDSCONFLICTNOTLEAFNODE - Operation cannot be performed on non-leaf node of dataset. <LI> EDSCONFLICTINVALIDVFILER - Dataset node has members that do not belong to the vFiler being attached. <LI>EDSCONFLICTDEDUPLICATION - A deduplication schedule enabled provisioning policy cannot be associated with SnapVault destinations. </UL>

=end html



B<Inputs>

=over 2

=item * I<dataset-access-details>  =>   B<L<"dataset-access-details">, optional>

=begin html

<br>Data access details for a dataset that needs to be configured and provisioned in a way that it is capable of transparent migration. This enables all the storage in the primary node of the dataset to be migrated to a different physical resource without having to reconfigure the clients accessing this storage. This input is valid only when: - There are no members in the dataset. - There is no vFiler unit attached to the dataset. - The node being edited is the primary node of the dataset.

=end html

=back



=over 2

=item * I<dataset-export-info>  =>   B<L<"dataset-export-info">, optional>

=begin html

<br>Specifies the NAS or SAN export settings for members provisioned in this node of the dataset.

=end html

=back



=over 2

=item * I<dp-node-name>  =>   B<dp-policy-node-name, optional>

=begin html

<br>Name of the node in the data protection policy that maps to the storage set. <b>dp-node-name</b> must match exactly the name of one of the nodes in the data protection policy that is currently assigned to the data set.<P> If <b>dp-node-name</b> is not specified, then the storage set associated with the root node is modified.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset that was obtained by an earlier call to <b>dataset-edit-begin</b>.

=end html

=back



=over 2

=item * I<online-migration>  =>   B<boolean, optional>

=begin html

<br>Indicates, that this dataset is capable of non-disruptive migration. This field is valid only when either dataset-access-details or vfiler-id is not empty. By default the migration will be assumed to be disruptive. Default: false.

=end html

=back



=over 2

=item * I<provisioning-policy-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or object identifier of the provisioning policy to be attached to the node. The implications of this are: <ul> <li> Members of the storage set associated with node are checked for conformance with the provisioning policy. <li> Any new members provisioned into the storage set will be based on this provisioning policy. </ul>

=end html

=back



=over 2

=item * I<relinquish-vfiler>  =>   B<boolean, optional>

=begin html

<br>If true, relinquish the vFiler unit associated with the dataset. This will destroy the vFiler unit, move all the storage owned by the vFiler unit to the hosting storage system and re-export the dataset over the storage system. This option can be specified only when: <ul> <li> The vFiler unit associated with the node of the dataset has been created by Provisioning Manager. In this case is-vfiler-created-for-migration will be true in dataset-info returned by dataset-list-info-iter APIs. <li>All storage of the vFiler unit belongs to the node of the dataset, except for the root storage. </ul> Default value is false.

=end html

=back



=over 2

=item * I<resourcepool-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or object identifier of a resource pool to assign to the storage set. If other resource pool(s) are already assigned to the storage set, then this one will replace it. This will delete all the attached resource pools and add the new one. If the input value is the empty string "", then no resource pool will be assigned to the storage set i.e. all the attached resource pools will be removed. If this parameter is not supplied, then the storage set's resource pool assignment will not be changed. <P> This is a legacy parameter. dataset-add-resourcepool and dataset-remove-resourcepool are preferred APIs for adding and removing resource pools to/from dataset nodes.

=end html

=back



=over 2

=item * I<timezone-name>  =>   B<string, optional>

=begin html

<br>Timezone to assign to the storage set. The value must be either a <b>timezone-name</b> returned by <b>timezone-list-info-iter-next</b>, or the empty string "". If the value is "", no timezone is assigned to the storage set. Storage sets with no timezone assignment use the timezone of the resource pool assigned to them, or the system default if no timezone is assigned to the resource pool.

=end html

=back



=over 2

=item * I<vfiler-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or object identifier of the vFiler unit to be attached to the node. If there are any members currently in the node, they should belong to this vFiler unit. Any new member provisioned for this node, will be exported over this vFiler unit.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_provision_member



=begin html

Provision a new member into the effective primary node of a dataset. <P>The effective primary node for a non disaster recovery capable dataset or a disaster recovery capable dataset not in the DR state of "failed_over" is the dataset root node. The effective primary node of a disaster recovery dataset in the DR state of "failed_over" is the disaster recovery capable node of the dataset. <P>Error conditions: <ul> <LI> EINVALIDINPUT - If the inputs specified are not valid. <LI> EEDITSESSIONNOTFOUND - No edit lock was found that has the given identifier. <LI> EACCESSDENIED - User does not have permission to provision a member. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> EEDITSESSIONCONFLICTINGOP - The requested modification conflicts with other changes performed during the edit session. <LI> EDATASETNOTINSTABLEDRSTATE - The dataset is not in a stable disaster recovery state. </ul>

=end html



B<Inputs>

=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset that was obtained by an earlier call to <b>dataset-edit-begin</b>. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<provision-member-request-info>  =>   B<L<"provision-member-request-info">>

=begin html

<br>Information of the provisioning request.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_remove_from_exclusion_list



=begin html

Remove datastore objects from a dataset's exclusion list.<P> This API is for removing datastore objects from a dataset's exclusion list.

=end html



B<Inputs>

=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<objects-to-be-removed>  =>   B<obj-name-or-id[]>

=begin html

<br>List of datastore object names or IDs to be removed from the exclusion list.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_remove_member



=begin html

Remove member from a dataset. Only members explicitly added to the dataset (direct members) can be removed. <P> If "destroy" is true, even indirect members can be destroyed on the storage system and removed from the dataset. <P> If "destroy" is true, then it is applicable only on members of the effective primary node of the dataset. <P>The effective primary node for a non disaster recovery capable dataset or a disaster recovery capable dataset not in the DR state of "failed_over" is the dataset root node. The effective primary node of a disaster recovery dataset in the DR state of "failed_over" is the disaster recovery capable node of the dataset. <P>The destroy operation happens in the background. <P>A provisioning job id is returned in dataset-edit-commit api that represents the job which will resize the member as specified. The status of the job can be checked using dp-job-list-iter ZAPIs with the given job-id.

=end html



B<Inputs>

=over 2

=item * I<dataset-member-parameters>  =>   B<L<"dataset-member-parameter">[]>

=begin html

<br>List of members to remove from the dataset.

=end html

=back



=over 2

=item * I<destroy>  =>   B<boolean, optional>

=begin html

<br>Specifies whether the member should be destroyed on the filer. If not specified or false, the member will not be destroyed on the filer. "destroy" flag can be true, only when the members given in input are of type volume, qtree or lun. Also, when "destroy" is true, the volume, qtree or lun given can be indirect members of the dataset.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_remove_member_by_dynamic_reference



=begin html

Remove dynamic references from a dataset. Only dynamic_references explicitly added to the dataset can be removed.<P>

=end html



B<Inputs>

=over 2

=item * I<dataset-dynamic-reference-parameters>  =>   B<L<"dataset-dynamic-reference-parameter">[]>

=begin html

<br>List of dynamic-references to remove from the dataset.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_remove_resourcepool



=begin html

Remove resource pool from a single storage set that is part of a dataset. The storage set is specified implicitly by the name of the policy node that maps to it.<P> Within the same edit session in which you call <b>dataset-remove-resourcepool</b>, you may also add or remove members or dynamic references, or change the dataset's name, description, <b>is-dp-ignored</b>, <b>is-dp-suspended</b>, or <b>is-suspended</b>. You may not change the data set's protection policy or storage sets within the same edit session. <HR> Error conditions: <UL> <LI> EEDITSESSIONNOTFOUND - No edit lock was found that has the given identifier. <LI> EACCESSDENIED - User does not have permission to modify the storage set. <LI> EOBJECTAMBIGUOUS - The name given for the storage set or resource pool matches multiple storage sets or resource pools. <LI> EOBJECTNOTFOUND - No storage set or resource pool was found that has the given name or identifier. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> ESTORAGESETNOTINDATASET - The specified storage set is not a part of the dataset being edited. <LI> EDPPOLICYNODENOTFOUND - No DP policy node was found that has the given name. <LI> EEDITSESSIONCONFLICTINGOP - The requested modification conflicts with other changes performed during the edit session. <LI> EDSCONFLICTALREADYINDATASET - Object, its ancestor or descendent is already in dataset. <LI> EDSCONFLICTSRCDESTINSAMEAGGR - Source data and destination data are in the same aggregate. <LI> EDSCONFLICTALREADYINRESPOOL - Object, its ancestor or descendent is already in resource pool. </UL>

=end html



B<Inputs>

=over 2

=item * I<dp-node-name>  =>   B<dp-policy-node-name, optional>

=begin html

<br>Name of the node in the data protection policy that maps to the storage set. <b>dp-node-name</b> must match exactly the name of one of the nodes in the data protection policy that is currently assigned to the data set.<P> If <b>dp-node-name</b> is not specified, then the storage set associated with the root node is modified.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset that was obtained by an earlier call to <b>dataset-edit-begin</b>. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<resourcepool-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or object identifier of a resource pool to remove from the storage set.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_replace_primary_members



=begin html

Replace primary members and relationships after a failover. <P>If a secondary volume or qtree is specified, it replaces the primary member for just that secondary volume or qtree. If neither are specified, it replaces all primary members that need to be replaced. <P>If dry-run is specified, it returns the results of the operation that would be taken should the operation be committed.

=end html



B<Inputs>

=over 2

=item * I<cancel-edit-sessions>  =>   B<boolean, optional>

=begin html

<br>If true, any edit operations in progress on the data set are rolled back before replacing any primary members. If it is false and there are edit operations in progress on the dataset, EEDITSESSIONINPROGRESS is returned and no primary members will be replaced. By default, cancel-edit-sessions is false. If dry-run is true, canel-edit-sessions is ignored.

=end html

=back



=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of the dataset whose primary members need to be replaced.

=end html

=back



=over 2

=item * I<dry-run>  =>   B<boolean, optional>

=begin html

<br>If true, return a list of actions that would be taken should the operation be committed without actually committing them. Dry run does not affect any edit session in progress. By default, dry-run is false.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of the secondary volume or qtree whose primary needs to be replaced. If object-name-or-id is not specified, it replaces all primary members in the dataset that need to be replaced.

=end html

=back



B<Outputs>

=over 2

=item * I<replace-results>  =>   B<L<"replace-result">[], optional>

=begin html

<br>Results of the replace operation. Each result describes one action that was taken. If dry-run is true, it describes one action that would be taken should the operation be committed.

=end html

=back



=head2 dataset_resize_member



=begin html

Resize, change maximum capacity and change snap reserve for a dataset member on the effective primary node of the dataset. <P>The effective primary node for a non disaster recovery capable dataset or a disaster recovery capable dataset not in the DR state of "failed_over" is the dataset root node. The effective primary of a disaster recovery data set in the DR state of "failed_over" is the disaster recovery capable node of the dataset. <P>The resize operation happens in the background. <P>A provisioning job id is returned in dataset-edit-commit zapi that represents the job which will resize the member as specified. The status of the job can be checked using dp-job-list-iter ZAPIs with the given job-id. Error conditions: <UL> <LI> EACCESSDENIED - User does not have the capability DFM.ResourcePool.Provision on the containing resource pool for a volume that is being resized. <LI> EDATABASEERROR - A database error occurred while processing the request. <LI> EOBJECTNOTFOUND - No volume or qtree member by the given name or identifier was found. <LI> ENOTINDATASET - Member is not in the primary node of the specified dataset. <LI> EOBJECTAMBIGUOUS - The specified member name could refer to two or more objects. Try again with the object identifier or object full name. <LI> EINVALIDINPUT - Both member-id and member-name are not specified, inputs other than new-size are specified for a qtree member, size parameters are being changed for traditional volumes. <LI> EEDITSESSIONNOTFOUND - If the edit session specified in input is not found <LI> EEDITSESSIONOBJECTALREADYLOCKED - If the object being tried to lock in this operation is already locked by some other edit session <LI> EEDITSESSIONCONFLICTINGOP - If this resize operation is conflicting with some other edit operation in the same edit session <LI> EDATASETNOTINSTABLEDRSTATE - The dataset is not in a stable disaster recovery state. </UL>

=end html



B<Inputs>

=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<resize-member-request-info>  =>   B<L<"resize-member-request-info">>

=begin html

<br>Details on member to be resized.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_set



=begin html

Set dataset options.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or object identifier for the dataset whose options need to be set.

=end html

=back



=over 2

=item * I<is-allow-custom-settings>  =>   B<boolean, optional>

=begin html

<br>If true, conformance check of some volume options is disabled for the dataset. These volume options include, fractional-reserve, autodelete commitment and autodelete trigger attributes only. This option is applicable only for datasets which have san thin provisioning policy associated. For other datasets the option is ignored. default value is false.

=end html

=back



=over 2

=item * I<is-enable-write-guarantee-checks>  =>   B<boolean, optional>

=begin html

<br>If true, periodic write guarantee checks are enabled for the dataset. This option is applicable only for datasets which have SAN thin provisioning policy associated. Presence of lun-clones, flex-clones, SFSR operations in the volume may effect write guarantees in SAN thin provisioning configurations. Periodic write guarantee checks detect such condition and generate alerts. For other datasets the option is ignored. default value is true.

=end html

=back



=over 2

=item * I<is-none-guaranteed-provision>  =>   B<boolean, optional>

=begin html

<br>If true, the volume provisioned for this dataset will be created with none guarantee, and it will override the default behavior that is provided by a NAS provisioning policy. This option is applicable only for datasets which have NAS thin provisioning policy associated. default value is false.

=end html

=back



=over 2

=item * I<is-skip-autosize-conformance>  =>   B<boolean, optional>

=begin html

<br>If true, conformance check of autosize volume options is disabled for the dataset. This option is applicable only for datasets which have thin provisioning policy associated. For other datasets the option is ignored. default value is false.

=end html

=back



=over 2

=item * I<maximum-luns-per-volume>  =>   B<integer, optional>

=begin html

<br>Maximum luns to be provisioned from a volume in this dataset. If the value is empty, then the dataset level value of the global option maxLUNsPerVolume is applicable for the dataset.

=end html

=back



=over 2

=item * I<maximum-qtrees-per-volume>  =>   B<integer, optional>

=begin html

<br>Maximum qtrees to be provisioned from a volume in this dataset. If the value is empty, then the dataset level value of the global option maxQtreesPerVolume is applicable for the dataset.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_set_storageset



=begin html

Change the storage sets associated with policy nodes. It is legal to change many storage set/node mappings in an edit session.

=end html



B<Inputs>

=over 2

=item * I<dp-node-name>  =>   B<dp-policy-node-name, optional>

=begin html

<br>Name of the data protection policy node to associate the storage set to. If this input is not present the root node is used as the default. <P>If dp-node-name is the root node, <ul> <li>dataset must have a disaster recovery capable protection policy <li>dataset must be in a "failed_over" DR state <li>object-name-or-id specified must be the storage set mapped to the DR-capable node of the old protection policy. </ul> Mapping the DR storage set to the root node of a new protection policy will have the side effect of changing the DR state to "ready" when the edit session is committed.

=end html

=back



=over 2

=item * I<edit-lock-id>  =>   B<integer>

=begin html

<br>Identifier of the edit lock for a dataset obtained by calling dataset-edit-begin. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of the storage set to add.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_space_metric_list_info_iter_end



=begin html

Ends iteration to list dataset space metric.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-space-metric-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_space_metric_list_info_iter_next



=begin html

Get next few records in the iteration started by dataset-space-metric-list-info-iter-start.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dataset-space-metric-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<dataset-space-metrics>  =>   B<L<"dataset-space-metric-info">[]>

=begin html

<br>List of space usage measurement of dataset.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned. Range: [0..2^31-1]

=end html

=back



=head2 dataset_space_metric_list_info_iter_start



=begin html

Starts iteration to list dataset's space usage measurements.

=end html



B<Inputs>

=over 2

=item * I<day>  =>   B<integer, optional>

=begin html

<br>The day for which the usage metric is required. The month element is required along with this input. When present, the usage metrics for the day is returned. Range: [1..31]

=end html

=back



=over 2

=item * I<month>  =>   B<month, optional>

=begin html

<br>The month for which the usage metric is required. If month is not specified, it defaults to the current month. If month element is provided without the day element in input, then the usage metrics available for the month is returned. If month and year element is not provided in input, then the usage measurements for the current month is returned. The start of the current month is determined by the <b>chargebackDayOfMonth</b> global option. Range: [1..12]

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of a dataset or resource group or storage service. If a resource group is given, usage measurement of the datasets which are direct members of the group are returned. If a storage service is given, usage measurement of datasets associated with the storage service is returned. If this input is not given, usage measurements of all the datasets are returned.

=end html

=back



=over 2

=item * I<year>  =>   B<integer, optional>

=begin html

<br>The year for which the usage metric is required. If year element is not provided in input, then the current year is selected. Range: [1900..2^31-1]

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of records that have been saved for future retrieval with dataset-space-metric-list-info-iter-next. Range: [0..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to dataset-space-metric-list-info-iter-next.

=end html

=back



=head2 dataset_update_dr_status



=begin html

Update disaster recovery status for a dataset.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or object identifier for the dataset.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dataset_update_protection_status



=begin html

Update protection status for a dataset.

=end html



B<Inputs>

=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or object identifier for the dataset.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_about



=begin html

Retrieve information currently provided by the 'dfm about' command.

=end html



B<Inputs>

=over 2

=item * I<include-directory-size-info>  =>   B<boolean, optional>

=begin html

<br>If true, then size and file count information of the DFM directories is returned. Default value is false i.e. only names of the DFM directories are returned.

=end html

=back



B<Outputs>

=over 2

=item * I<cpu-count>  =>   B<string>

=begin html

<br>CPU count.

=end html

=back



=over 2

=item * I<dfm-directories>  =>   B<L<"directory-info">[]>

=begin html

<br>null

=end html

=back



=over 2

=item * I<edition>  =>   B<string>

=begin html

<br>Edition of this product. Possible Values are 'Express edition' and 'Standard edition' with product name appened.

=end html

=back



=over 2

=item * I<host-name>  =>   B<string>

=begin html

<br>Host name.

=end html

=back



=over 2

=item * I<install-dir>  =>   B<string>

=begin html

<br>Installation directory.

=end html

=back



=over 2

=item * I<installed-plugins>  =>   B<L<"plugin">[]>

=begin html

<br>null

=end html

=back



=over 2

=item * I<licensed-features>  =>   B<L<"feature">[]>

=begin html

<br>null

=end html

=back



=over 2

=item * I<mode>  =>   B<string>

=begin html

<br>DFM operating mode. <P> Possible values are <ul> <li><b>7_mode</b>: DFM Operating for Data ONTAP 7-Mode storage systems only. <li><b>cluster_mode</b>: DFM Operating for Data ONTAP C-Mode storage systems only. </ul> <P>

=end html

=back



=over 2

=item * I<node-limit>  =>   B<string>

=begin html

<br>Operations Manager Node limit.

=end html

=back



=over 2

=item * I<operating-system>  =>   B<string>

=begin html

<br>Operating system.

=end html

=back



=over 2

=item * I<prot-mgr-node-limit>  =>   B<string>

=begin html

<br>Protection Manager Node limit.

=end html

=back



=over 2

=item * I<prov-mgr-node-limit>  =>   B<string>

=begin html

<br>Provisioning Manager Node limit.

=end html

=back



=over 2

=item * I<serial-number>  =>   B<string>

=begin html

<br>serial number of this product.

=end html

=back



=over 2

=item * I<system-memory>  =>   B<string>

=begin html

<br>System memory.

=end html

=back



=over 2

=item * I<system-time>  =>   B<integer>

=begin html

<br>System time in seconds since 00:00:00 Jan 1, 1970, UTC.

=end html

=back



=over 2

=item * I<version>  =>   B<string>

=begin html

<br>A string that adheres to the following regular expression: [1-9][0-9]+\.[1-9][0-9]+.* The first number is the DFM major version. The second number is the DFM minor version. DFM APIs don't change if the major.minor doesn't change. Example: 3.5.0.4726

=end html

=back



=head2 dfm_backup_schedule_disable



=begin html

Disable an existing backup schedule.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_backup_schedule_enable



=begin html

Enable an existing backup schedule.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_backup_schedule_get



=begin html

Get the information about a DFM database backup schedule.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<backup-type>  =>   B<backup-type>

=begin html

<br>Scheduled DFM database backup type.

=end html

=back



=over 2

=item * I<day>  =>   B<integer, optional>

=begin html

<br>The day of the week on which the backup schedule has to run at the specified hour:minute time. This is optional when the schedule-type is 'weekly'. The day starts with Sunday. The days are enumerated with Sunday=0, Monday=1 and so on. Range: [0..6]

=end html

=back



=over 2

=item * I<hour>  =>   B<integer, optional>

=begin html

<br>The hour of a day at which the backup schedule runs. This is optional only for the 'snapshot' type backups set at 'hourly' period. Range: [0..23]

=end html

=back



=over 2

=item * I<is-schedule-enabled>  =>   B<boolean>

=begin html

<br>true if the backup schedule is enabled, false otherwise.

=end html

=back



=over 2

=item * I<minute>  =>   B<integer>

=begin html

<br>The minute of an hour at which the backup schedule runs. Range: [0..59]

=end html

=back



=over 2

=item * I<repeat-interval>  =>   B<integer, optional>

=begin html

<br>The hourly interval at which 'snapshot' based backups recur. This is applicable for 'snapshot' type backups having 'daily' schedule-type. Range: [1..24]

=end html

=back



=over 2

=item * I<schedule-type>  =>   B<string>

=begin html

<br>The period at which the backup schedule has runs. Possible values are 'hourly', 'daily' or 'weekly'.

=end html

=back



=head2 dfm_backup_schedule_set



=begin html

API to configure DFM database backup schedules. A schedule can be of 'snapshot' or 'archive' type backup. Archive backups can be scheduled at 'daily' or 'weekly' period. Snapshot backups can be scheduled at 'hourly', 'daily' or 'weekly' period or everyday at regular intervals starting from a specified time. Hourly backups require the 'minute' at which the backup schedule is to run every hour. Daily backup schedule requires 'hour' and 'minute' at which the backup schedule is to run. Weekly backup schedule requires the day of the week and time (hh:mm) at which the backup schedule is to run. A backup schedule can also be set to run every day at regular hourly repeat intervals starting from a specified hour:minute. Only one schedule can be set for creating DFM backups.

=end html



B<Inputs>

=over 2

=item * I<backup-type>  =>   B<backup-type, optional>

=begin html

<br>Default backup type is 'archive'.

=end html

=back



=over 2

=item * I<day>  =>   B<integer, optional>

=begin html

<br>The day of the week on which the backup schedule has to run at the specified hour:minute time. Required for weekly schedule type. Not allowed for hourly and daily schedule type. The day starts with Sunday. The days are enumerated with Sunday=0, Monday=1 and so on. Range: [0..6]

=end html

=back



=over 2

=item * I<hour>  =>   B<integer, optional>

=begin html

<br>The hour of a day at which the backup schedule has to run. Required for daily or weekly schedule type. Not allowed for hourly schedule type. Range: [0..23]

=end html

=back



=over 2

=item * I<is-schedule-enabled>  =>   B<boolean, optional>

=begin html

<br>Indicates whether the backup schedule has to be enabled or disabled after setting. Default value is true.

=end html

=back



=over 2

=item * I<minute>  =>   B<integer, optional>

=begin html

<br>The minute of an hour at which the backup schedule has to run. Default value is 0. Range: [0..59]

=end html

=back



=over 2

=item * I<repeat-interval>  =>   B<integer, optional>

=begin html

<br>The hourly interval at which 'snapshot' based backups have to recur starting at hour:minute. This is applicable only for 'snapshot' type backups. Range: [1..24]

=end html

=back



=over 2

=item * I<schedule-type>  =>   B<string>

=begin html

<br>The period at which the backup schedule has to run. Possible values are 'hourly', 'daily', 'weekly'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_backup_start



=begin html

API to start a database backup immediately.

=end html



B<Inputs>

=over 2

=item * I<backup-type>  =>   B<backup-type>

=begin html

<br>Type of DFM database backup to initiate a backup.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_backup_status



=begin html

Get information about a DFM database backup.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<backup-status>  =>   B<string>

=begin html

<br>Status of the database backup. Possible values are: 'running': when backup job is running; applicable for both immediate and scheduled backups. 'pending': when backup job is scheduled, but yet to start; applicable only for immediate backup started with dfm-backup-start. 'schedule_active': backup schedule is set and enabled; applicable for scheduled backup only. 'schedule_inactive': backup schedule is set and disabled; applicable for scheduled backup only. 'not_scheduled': when a schedule is not set; applicable for scheduled backup only.

=end html

=back



=head2 dfm_get_api_statistics



=begin html

Retrieve information about the API call frequencies on the DFM server

=end html



B<Inputs>

=over 2

=item * I<clear-api-stats>  =>   B<boolean, optional>

=begin html

<br>If present and true, reset all the API statistics. Default value is false.

=end html

=back



B<Outputs>

=over 2

=item * I<api-statistics>  =>   B<L<"api-stat">[]>

=begin html

<br>Lists the statistics about the API call frequencies on the DFM server.

=end html

=back



=head2 dfm_get_resource_property_values



=begin html

Gets the list of resource properties and the values that can be set as filters for thresholds. The list of resource properties are pre-defined, but the values are obtained from the current set of values in the database

=end html



B<Inputs>

=over 2

=item * I<resource-property>  =>   B<string, optional>

=begin html

<br>Specifies the property for which the values are to be returned If not present, then resource values for all properties are returned Maximum length of 255 characters

=end html

=back



B<Outputs>

=over 2

=item * I<resource-property-values>  =>   B<L<"resource-property-values">[]>

=begin html

<br>The values for the resource properties

=end html

=back



=head2 dfm_monitor_timestamp_list



=begin html

Returns the monitoring timestamps of a host.

=end html



B<Inputs>

=over 2

=item * I<host-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>The name or id of the host for which monitoring timestamp is required. It should be name or id of a Host Agent, vFiler Unit, Storage System, Cluster or OSSV Host.

=end html

=back



B<Outputs>

=over 2

=item * I<dfm-monitoring-timestamps>  =>   B<L<"dfm-monitoring-timestamp">[]>

=begin html

<br>List of all applicable monitoring timestamps.

=end html

=back



=head2 dfm_object_refresh



=begin html

Request monitors be scheduled to run to refresh the information of the object specified. The monitors to be scheduled to run can be specified implicitly using child-type or explicitly by providing monitor-names. If both child-type and monitor-names are specified, it will be treated as an error.

=end html



B<Inputs>

=over 2

=item * I<child-type>  =>   B<string, optional>

=begin html

<br>If specified, schedule only those monitors affecting the specified type. Otherwise, all monitors affecting the object-name-or-id will be scheduled. Valid only if object-name-or-id points to a Storage System or a vFiler unit. Possible values: "aggregate", "volume", "qtree" and "lun_path".

=end html

=back



=over 2

=item * I<monitor-names>  =>   B<monitor-name[], optional>

=begin html

<br>Specifies one or more monitors to be scheduled to run. If this input is not provided, all monitors will be scheduled. Valid only if object-name-or-id points to a Host Agent, Storage System, vFiler unit, OSSV Host or a NetCache.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>The name or id of the object to be refreshed. Should be name or id of a Host Agent, Storage System, vFiler unit, OSSV Host, Aggregate, Volume, Qtree, LUN or a NetCache. If child-type is specified, this should be name or id of a Storage System or a vFiler unit. If monitor-names are specified, this should be name or id of a Host Agent, Storage System, vFiler unit, OSSV Host or a NetCache.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_objects_get_status



=begin html

Get status for DFM objects This api always returns true. It returns the status for all the objects that are passed in. A object-name-or-id of "0" indicates the "global group" Privelege required is read

=end html



B<Inputs>

=over 2

=item * I<objects>  =>   B<obj-name-or-id[]>

=begin html

<br>The objects for which status is to be retrieved

=end html

=back



B<Outputs>

=over 2

=item * I<objects-status>  =>   B<L<"obj-status-info">[]>

=begin html

<br>Status of the passed in input objects.

=end html

=back



=head2 dfm_related_objects_list_info



=begin html

Retrieve information about objects related to a DFM object. This api takes an object as input and returns the information about parent objects of that object, resource groups, datasets and resource pools the object belongs to and objects that belong to the specified object. Privilege required is DFM.Database.Read on the specified object. Parent output objects are returned only if the authenticated user has DFM.Database.Read privilege on that parent object. For e.g. group to which an object belongs is returned only if the authenticated user has DFM.Database.Read privilege on that group.

=end html



B<Inputs>

=over 2

=item * I<include-indirect>  =>   B<boolean, optional>

=begin html

<br>If true, resource groups, datasets and resource pools in which the input object is an indirect member will also be returned. Default value is false, i.e only direct memberships are returned.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of an object to list related objects for. The allowed object types for this argument are: <ul> <li> Host <li> Aggregate <li> Volume <li> Qtree <li> Lun </ul>

=end html

=back



B<Outputs>

=over 2

=item * I<child-count-list>  =>   B<L<"child-count">[], optional>

=begin html

<br>Count of children for the specified object. Present in the output if the object has at least one child.

=end html

=back



=over 2

=item * I<parent-dataset-list>  =>   B<L<"parent-dataset">[], optional>

=begin html

<br>Datasets the specified object belongs to. Present in the output if the object belongs to at least one dataset.

=end html

=back



=over 2

=item * I<parent-group-list>  =>   B<L<"parent-group">[], optional>

=begin html

<br>Resource groups the specified object belongs to. Present in the output if the object belongs to at least one group.

=end html

=back



=over 2

=item * I<parent-object-list>  =>   B<L<"parent-object">[], optional>

=begin html

<br>Parents of the specified object. Present in the output if there is at least one parent object.

=end html

=back



=over 2

=item * I<parent-resourcepool-list>  =>   B<L<"parent-resourcepool">[], optional>

=begin html

<br>Resource Pools the specified object belongs to. Present in the output if the object belongs to at least one resource pool.

=end html

=back



=head2 dfm_server_list_diagnostic_info



=begin html

Retrieve server diagnostic information

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<diag-info>  =>   B<L<"dfm-diag-counter-group">[]>

=begin html

<br>Diagnostic information collected from the dfm server.

=end html

=back



=head2 dfm_snmp_setting_add



=begin html

Add a SNMP credential setttings for a host or network in dfm. This credential will be used when discovering networks in dfm.

=end html



B<Inputs>

=over 2

=item * I<host-name>  =>   B<string, optional>

=begin html

<br>The name of the host. This could be either short or fully qualified host name. Either this attribute or network-address must be provided. Error is returned if both are provided.

=end html

=back



=over 2

=item * I<network-address>  =>   B<network-address, optional>

=begin html

<br>Ip address of the network or host

=end html

=back



=over 2

=item * I<prefix-length>  =>   B<prefix-length>

=begin html

<br>It represents prefix length. Useful for subnet mask calculation. This should be 32 for IPv4 and 128 for IPv6 if the network-address is a host address.

=end html

=back



=over 2

=item * I<privacy-password>  =>   B<string, optional, encrypted>

=begin html

<br>Privacy password used for encrypting SNMPv3 communication. This element is optional for the SNMP versions other than snmp_v3.

=end html

=back



=over 2

=item * I<snmp-authentication-login>  =>   B<string, optional>

=begin html

<br>The name of the user to be used for SNMPv3 discovery and monitoring. This element is optional for the SNMP versions other than snmp_v3.

=end html

=back



=over 2

=item * I<snmp-authentication-password>  =>   B<string, optional, encrypted>

=begin html

<br>The authentication password to be used for SNMPv3 communication. Value must be a string greater than or equal to 8 characters. This element is optional for the SNMP versions other than snmp_v3.

=end html

=back



=over 2

=item * I<snmp-authentication-protocol>  =>   B<snmp-authentication-protocol, optional>

=begin html

<br>Authentication protocol for use with SNMPv3. This element is optional for the SNMP versions other than snmp_v3.

=end html

=back



=over 2

=item * I<snmp-community-name>  =>   B<string, optional>

=begin html

<br>Name of the snmp community used for snmpv1 communication. This element is optional for the SNMP versions other than snmp_v1.

=end html

=back



=over 2

=item * I<snmp-version>  =>   B<snmp-version, optional>

=begin html

<br>Represents snmp version that will be used for discovering network.

=end html

=back



B<Outputs>

=over 2

=item * I<snmp-id>  =>   B<snmp-id>

=begin html

<br>A unique-id for this snmp credential setting will be returned.

=end html

=back



=head2 dfm_snmp_setting_delete



=begin html

Delete networks from dfm so that discovery should not happen. Either snmp-id or both network-address and prefix-length has to be provided. If the user provides both or does not provide any, it will be considered as invalid input.

=end html



B<Inputs>

=over 2

=item * I<host-name>  =>   B<string, optional>

=begin html

<br>Name of the host. It could be either short or fully qualified host name.

=end html

=back



=over 2

=item * I<network-address>  =>   B<network-address, optional>

=begin html

<br>IP address of the network or host.

=end html

=back



=over 2

=item * I<prefix-length>  =>   B<prefix-length, optional>

=begin html

<br>Prefix length of the network or host. This should be 32 for IPv4 and 128 for IPv6 if the network-address is a host address.

=end html

=back



=over 2

=item * I<snmp-id>  =>   B<snmp-id, optional>

=begin html

<br>Unique indentifier of the SNMP credential setting in dfm. This id will be generated when SNMP credential setting was added.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_snmp_setting_modify



=begin html

Modify SNMP credential in dfm so that network discovery should happen using new SNMP credential.

=end html



B<Inputs>

=over 2

=item * I<prefix-length>  =>   B<prefix-length, optional>

=begin html

<br>It is prefix length of network or host, useful for subnet mask calculation. This cannot be modified for hosts.

=end html

=back



=over 2

=item * I<privacy-password>  =>   B<string, optional, encrypted>

=begin html

<br>Privacy password used for encrypting SNMPv3 communication. This element is optional for the SNMP versions other than snmp_v3.

=end html

=back



=over 2

=item * I<snmp-authentication-login>  =>   B<string, optional>

=begin html

<br>The name of the user to be used for SNMPv3 discovery and monitoring. This element is optional for the SNMP versions other than snmp_v3.

=end html

=back



=over 2

=item * I<snmp-authentication-password>  =>   B<string, optional, encrypted>

=begin html

<br>The authentication password to be used for SNMPv3 communication. Value must be a string greater than or equal to 8 characters. This element is optional for the SNMP versions other than snmp_v3.

=end html

=back



=over 2

=item * I<snmp-authentication-protocol>  =>   B<snmp-authentication-protocol, optional>

=begin html

<br>Authentication protocol for use with SNMPv3. This element is optional for the SNMP versions other than snmp_v3.

=end html

=back



=over 2

=item * I<snmp-community-name>  =>   B<string, optional>

=begin html

<br>Name of the snmp community used for snmpv1 communication. This element is optional for the SNMP versions other than snmp_v1.

=end html

=back



=over 2

=item * I<snmp-id>  =>   B<snmp-id>

=begin html

<br>Unique indentifier of the SNMP credential setting in dfm.

=end html

=back



=over 2

=item * I<snmp-version>  =>   B<snmp-version, optional>

=begin html

<br>Represents snmp version that will be used for discovering network.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_snmp_settings_list_info



=begin html

Returns list of SNMP credential settings available in the dfm database Either snmp-id or both network-address and prefix-length has to be provided. If user provides both, it will be considered as invalid input. If user does not provide any, then all the snmp credentials will be returned.

=end html



B<Inputs>

=over 2

=item * I<host-name>  =>   B<string, optional>

=begin html

<br>The name of the host. This could be either short or fully qualified host name. This attribute and network-address must not be provided simultaneously. Error is returned if both are provided.

=end html

=back



=over 2

=item * I<network-address>  =>   B<string, optional>

=begin html

<br>Ip address of the network or host.

=end html

=back



=over 2

=item * I<prefix-length>  =>   B<integer, optional>

=begin html

<br>It represents prefix length. Useful for subnet mask calculation. This should be 32 for IPv4 and 128 for IPv6 if the network-address is a host address.

=end html

=back



=over 2

=item * I<snmp-id>  =>   B<snmp-id, optional>

=begin html

<br>A unique id representing the SNMP credential setting.

=end html

=back



B<Outputs>

=over 2

=item * I<network-snmp-credentials>  =>   B<L<"network-snmp-credential-info">[]>

=begin html

<br>The list of SNMP credential settings.

=end html

=back



=head2 dfm_user_priv_get



=begin html

Retrieve current user's global privilege. This api is no longer the preferred way to getting user privileges. Use rbac-access-check.

=end html



B<Inputs>

=over 2

=item * None

=back



B<Outputs>

=over 2

=item * I<privilege>  =>   B<string>

=begin html

<br>User's privilege(s), comma separated if there are multiple. Possible privileges are: FULL, DELETE, WRITE, READ, BACKUP, RESTORE, SAN, SRM, MIRROR.

=end html

=back



=head2 dfm_schedule_content_get



=begin html

Get the content of a given schedule.

=end html



B<Inputs>

=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of the schedule

=end html

=back



B<Outputs>

=over 2

=item * I<schedule-content-info>  =>   B<L<"schedule-content-info">>

=begin html

<br>Details of a schedule

=end html

=back



=head2 dfm_schedule_create



=begin html

Create a new schedule with the given name. The schedule type may be daily, weekly, or monthly.

=end html



B<Inputs>

=over 2

=item * I<schedule-content-info>  =>   B<L<"schedule-content-info">>

=begin html

<br>Details of a schedule

=end html

=back



B<Outputs>

=over 2

=item * I<schedule-id>  =>   B<obj-id>

=begin html

<br>A unique ID of the schedule

=end html

=back



=head2 dfm_schedule_daily_add



=begin html

Create a single schedule within a daily schedule.

=end html



B<Inputs>

=over 2

=item * I<daily-content>  =>   B<L<"daily-info">>

=begin html

<br>Content of the daily schedule.

=end html

=back



=over 2

=item * I<daily-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a daily schedule

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the daily item within the schedule

=end html

=back



=head2 dfm_schedule_daily_delete



=begin html

Delete a single schedule within a daily schedule.

=end html



B<Inputs>

=over 2

=item * I<daily-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a daily schedule

=end html

=back



=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the daily item within the schedule. Range: [1..(2^31)-1]

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_daily_modify



=begin html

Modify a single schedule within a daily schedule. Sample schedules cannot be modified.

=end html



B<Inputs>

=over 2

=item * I<daily-content>  =>   B<L<"daily-info">>

=begin html

<br>Content of the daily schedule.

=end html

=back



=over 2

=item * I<daily-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a daily schedule

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_dependency



=begin html

Return a list of other DP policies, report schedule and schedules using the specified schedule.

=end html



B<Inputs>

=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or identifier of a schedule.

=end html

=back



B<Outputs>

=over 2

=item * I<schedule-assignees>  =>   B<L<"schedule-assignee">[]>

=begin html

<br>List of other DP policies, report schedules and schedules using the specified schedule. The list returned will depend on the schedule category. For schedule catedory 'dfm_schedule' only report schedules and the DFM schedules using this schedule will be returned. For schedule category 'dp_schedule' only DP policies and the DP schedules using this schedule will be returned. The list excludes DP policies, report schedules or schedules that the caller has no permissions to read.

=end html

=back



=over 2

=item * I<schedule-in-use>  =>   B<boolean>

=begin html

<br>For schedule category 'dfm_schedule' this is true if its used by report schedules or DFM schedules. For schedule category 'dp_schedule' this is true if its used by DP policies or DP schedules.

=end html

=back



=head2 dfm_schedule_destroy



=begin html

Delete a schedule with the given name or ID. A schedule that is used by another schedule(s) may not be deleted and an error will be returned. Sample schedules cannot be destroyed.

=end html



B<Inputs>

=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of the schedule

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_hourly_add



=begin html

Create an hourly schedule within a daily schedule. An hourly schedule specifies the frequency of schedules to be run within the start time and end time.

=end html



B<Inputs>

=over 2

=item * I<daily-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a daily schedule

=end html

=back



=over 2

=item * I<hourly-content>  =>   B<L<"hourly-info">>

=begin html

<br>Content of the hourly schedule.

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the hourly item within the schedule

=end html

=back



=head2 dfm_schedule_hourly_delete



=begin html

Delete an hourly schedule within a daily schedule.

=end html



B<Inputs>

=over 2

=item * I<daily-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a daily schedule

=end html

=back



=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the hourly item within the schedule. Range: [1..(2^31)-1]

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_hourly_modify



=begin html

Modify an hourly schedule within a daily schedule. Sample schedules cannot be modified.

=end html



B<Inputs>

=over 2

=item * I<daily-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a daily schedule

=end html

=back



=over 2

=item * I<hourly-content>  =>   B<L<"hourly-info">>

=begin html

<br>Content of the hourly schedule.

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_list



=begin html

List all existing schedule IDs and types.

=end html



B<Inputs>

=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * I<schedule-list>  =>   B<L<"schedule-id-info">[]>

=begin html

<br>List of schedule IDs

=end html

=back



=head2 dfm_schedule_list_info_iter_end



=begin html

Tell the DFM station that the temporary store associated with the specified tag is no longer necessary

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An opaque handle used by the DFM station to identify a temporary store.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_list_info_iter_next



=begin html

Iterate over the list of schedules stored in the temporary store. The DFM internally maintains a cursor pointing to the last record returned. Subsequent calls to this API will return the records after the cursor up to the specified "maximum" or number of actual records left.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>Maximum number of schedules to retrieve

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An opaque handle used by the DFM station to identify a temporary store.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned.

=end html

=back



=over 2

=item * I<schedule-content-list>  =>   B<L<"schedule-content-info">[]>

=begin html

<br>List of detailed schedule contents

=end html

=back



=head2 dfm_schedule_list_info_iter_start



=begin html

The dfm-schedule-list-info-iter-* set of APIs are used to retrieve a list of schedule contents

=end html



B<Inputs>

=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<schedule-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or ID of the schedule. If specified, only this schedule is listed.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number of items saved for future retrieval

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An opaque handle used by the DFM station to identify a temporary store.

=end html

=back



=head2 dfm_schedule_modify



=begin html

Modify a schedule's details in the database. When the zapi is called, all details within the schedule will be removed and replace by the new details specified in schedule-content. Sample schedules cannot be modified. schedule-id and schedule-type cannot be modified.

=end html



B<Inputs>

=over 2

=item * I<schedule-content-info>  =>   B<L<"schedule-content-info">>

=begin html

<br>Details of a schedule

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_monthly_add



=begin html

Specify a single schedule within a monthly schedule. Either day-of-month, or both week-of-month and day-of-week must be specified.

=end html



B<Inputs>

=over 2

=item * I<monthly-content>  =>   B<L<"monthly-info">>

=begin html

<br>Content of the monthly schedule.

=end html

=back



=over 2

=item * I<monthly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a weekly schedule

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the monthly item within the schedule

=end html

=back



=head2 dfm_schedule_monthly_delete



=begin html

Delete a single schedule within a monthly schedule

=end html



B<Inputs>

=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the monthly item within the schedule. Range: [1..(2^31)-1]

=end html

=back



=over 2

=item * I<monthly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a weekly schedule

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_monthly_modify



=begin html

Modify a single schedule within a monthly schedule. Sample schedules cannot be modified.

=end html



B<Inputs>

=over 2

=item * I<monthly-content>  =>   B<L<"monthly-info">>

=begin html

<br>Content of the monthly schedule.

=end html

=back



=over 2

=item * I<monthly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a monthly schedule

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_monthly_subschedule_set



=begin html

Specify a sub-schedule to be used by a monthly schedule. On top of the individual monthly events, a monthly schedule may only have 1 daily subschedule OR 1 weekly schedule. If this monthly schedule already has a daily or weekly schedule, this command replaces the old one.

=end html



B<Inputs>

=over 2

=item * I<monthly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of the monthly schedule

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<subschedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of the schedule to be used by the monthly schedule

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_monthly_subschedule_unset



=begin html

Unset a sub-schedule used by a monthly schedule.

=end html



B<Inputs>

=over 2

=item * I<monthly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of the monthly schedule

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_rename



=begin html

Rename a schedule. Sample schedules cannot be renamed.

=end html



B<Inputs>

=over 2

=item * I<new-schedule-name>  =>   B<string>

=begin html

<br>A new unique name of the schedule

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of the schedule

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_weekly_add



=begin html

Specify a single schedule within a weekly schedule.

=end html



B<Inputs>

=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<weekly-content>  =>   B<L<"weekly-info">>

=begin html

<br>Content of the weekly schedule.

=end html

=back



=over 2

=item * I<weekly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a weekly schedule

=end html

=back



B<Outputs>

=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the weekly item within the schedule

=end html

=back



=head2 dfm_schedule_weekly_delete



=begin html

Delete a single schedule within a weekly schedule.

=end html



B<Inputs>

=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the weekly item within the schedule. Range: [1..(2^31)-1]

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<weekly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a weekly schedule

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_weekly_modify



=begin html

Modify a single schedule within a weekly schedule. Sample schedules canot be modified.

=end html



B<Inputs>

=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<weekly-content>  =>   B<L<"weekly-info">>

=begin html

<br>Content of the weekly schedule.

=end html

=back



=over 2

=item * I<weekly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a weekly schedule

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_weekly_subschedule_add



=begin html

Specify which daily schedule will be used on a certain range of days within a weekly schedule

=end html



B<Inputs>

=over 2

=item * I<daily-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a daily schedule

=end html

=back



=over 2

=item * I<end-day-of-week>  =>   B<integer>

=begin html

<br>Day of week for the schedule. Range: [0..6] (0 = "Sun")

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<start-day-of-week>  =>   B<integer>

=begin html

<br>Day of week for the schedule. Range: [0..6] (0 = "Sun")

=end html

=back



=over 2

=item * I<weekly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a weekly schedule

=end html

=back



B<Outputs>

=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the weekly use item within the schedule. Range: [1..(2^31)-1]

=end html

=back



=head2 dfm_schedule_weekly_subschedule_delete



=begin html

Specify which daily schedule to be deleted within a weekly schedule

=end html



B<Inputs>

=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the weekly use item within the schedule. Range: [1..(2^31)-1]

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<weekly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a weekly schedule

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dfm_schedule_weekly_subschedule_modify



=begin html

Specify which daily schedule will be used on a certain range of days within a weekly schedule. Permenent of sample schedules cannot be modified.

=end html



B<Inputs>

=over 2

=item * I<daily-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a weekly schedule

=end html

=back



=over 2

=item * I<end-day-of-week>  =>   B<integer>

=begin html

<br>Day of week for the schedule. Range: [0..6] (0 = "Sun")

=end html

=back



=over 2

=item * I<item-id>  =>   B<integer>

=begin html

<br>An ID of the weekly use item within the schedule. Range: [1..(2^31)-1]

=end html

=back



=over 2

=item * I<schedule-category>  =>   B<string>

=begin html

<br>Specifies the category of the schedule. Possible values are: 'dfm_schedule', 'dp_schedule'.

=end html

=back



=over 2

=item * I<start-day-of-week>  =>   B<integer>

=begin html

<br>Day of week for the schedule. Range: [0..6] (0 = "Sun")

=end html

=back



=over 2

=item * I<weekly-schedule-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or ID of a weekly schedule

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 disk_list_info_iter_end



=begin html

The disk-list-info-iter-* set of APIs are used to retrieve the list of disks. disk-list-info-iter-end is used to tell the DFM station that the temporary store used by DFM to support the disk-list-info-iter-next API for the particular tag is no longer necessary.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>An internal opaque handle used by the DFM station

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 disk_list_info_iter_next



=begin html

For more documentation please check disk-list-info-iter-start. The disk-list-info-iter-next API is used to iterate over the members of the disks stored in the temporary store created by the disk-list-info-iter-start API.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous disk-list-info-iter-start. It's an opaque handle used by the DFM station to identify the temporary store created by disk-list-info-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<disks>  =>   B<L<"disk-info">[]>

=begin html

<br>List of disks.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned. Range: [1..2^31-1]

=end html

=back



=head2 disk_list_info_iter_start



=begin html

The disk-list-info-iter-* set of APIs are used to retrieve the list of disks in DFM. disk-list-info-iter-start returns the disk belonging to objects specified. It loads the list of disks into a temporary store. The API returns a tag that identifies that temporary store so that subsequent APIs can be used to iterate over the disks in the temporary store. If disk-list-info-iter-start is invoked twice, then two distinct temporary stores are created.

=end html



B<Inputs>

=over 2

=item * I<object-management-filter>  =>   B<object-management-interface, optional>

=begin html

<br>Filter the object based on the Data ONTAP interface that provides complete management for the object i.e. ONTAP CLIs, SNMP, ONTAPI etc. If no filter is supplied, all objects will be considered.

=end html

=back



=over 2

=item * I<object-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or identifier of an object to list disks for. The allowed object types for this argument are: <ul> <li> Resource Group <li> Host <li> Aggregate </ul> Disks are not objects in DFM. So, a single disk cannot be listed. If object-name-or-id is specified, all disks that belong to the object specified will be listed. If no object-name-or-id is provided, all disks will be listed.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with disk-list-info-iter-next. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to disk-list-info-iter-next. It is an opaque handle used by the DFM station to identify a temporary store.

=end html

=back



=head2 dp_backup_content_list_iter_end



=begin html

Ends iteration to list file contents of a backup.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dp-backup-content-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dp_backup_content_list_iter_next



=begin html

Get next few records in the iteration started by dp-backup-content-list-iter-start.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve. Range: [1..2^31-1].

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dp-backup-content-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<backup-contents>  =>   B<L<"dp-backup-content-info">[]>

=begin html

<br>List of files and directories in backup.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned. Range: [0..2^31-1].

=end html

=back



=head2 dp_backup_content_list_iter_start



=begin html

Starts iteration to list contents of a backup. Files and directories directly under specified path are listed. In order to list all files recursively, multiple invocations of this API are necessary.

=end html



B<Inputs>

=over 2

=item * I<backup-id>  =>   B<integer>

=begin html

<br>Id of backup instance whose file contents are to be listed. Use dp-backup-list-iter-start to retrieve valid backup ids. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<primary-snapshot-name>  =>   B<string, optional>

=begin html

<br>Name of the Snapshot copy on the primary where the data originated. This field is ignored if the root-object-name-or-id is omitted. It is also ignored, if primary-snapshot-unique-id is specified.

=end html

=back



=over 2

=item * I<primary-snapshot-unique-id>  =>   B<string, optional>

=begin html

<br>Unique id of the Snapshot copy on the primary where the data originated. Currently, this is the Snapshot copy's creation time. This field is ignored if the root-object-name-or-id is omitted.

=end html

=back



=over 2

=item * I<root-object-name-or-id>  =>   B<string, optional>

=begin html

<br>Name or id of a dataset member that is at the root of the file tree. This may be qtree, ossv directory or volume that is the source of the physical data protection relationship. Indirect members may also be specified. If the sub path input is given, then this input is required. If specified, backup contents of this object are listed. Otherwise, backup contents directly under the dataset are listed.

=end html

=back



=over 2

=item * I<sub-path>  =>   B<string, optional>

=begin html

<br>Local subpath within the dataset with regard to root-object-name-or-id. If specified, backup contents directly under this sub path are listed. Otherwise, backup contents directly under the specified root-object are listed. Ignored if root-object-name-or-id input is not present If the root-object-name-or-id is a volume, qtree or ossv unix directory then this sub-path is a unix-like path, ex: 'dir1/dir2/'. If the root-object-name-or-id is ossv windows directory then this sub-path is a windows path, ex : 'dir1\\dir2\\'. Maximum length of sub-path is 32767 characters.

=end html

=back



=over 2

=item * I<suppress-child-count>  =>   B<boolean, optional>

=begin html

<br>This flag is set to FALSE by default. When TRUE, the child count for a file will not be calculated and a zero will be returned in its place in the file_info structer.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with dp-backup-content-list-iter-next. Range: [0..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to dp-backup-content-list-iter-next.

=end html

=back



=head2 dp_backup_get_location



=begin html

Given a backup-id or the backup-version and a list of member-ids or member-names, returns the snapshot name, volume that it exists on as well as the secondary qtree associated with the member id. If more than one snapshots match the backup-d or backup-version, only one, the first item in the resulting list, is returned. Multiple matches occur when the same backup version exists on multiple nodes. In case of mutiple matches which snapshot gets picked is unspecified.

=end html



B<Inputs>

=over 2

=item * I<backup-id>  =>   B<integer, optional>

=begin html

<br>Identifier of the backup instance. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<backup-version>  =>   B<dp-timestamp, optional>

=begin html

<br>Timestamp of the backup version.

=end html

=back



=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or ID of the dataset to which this backup version belongs to. This parameter is ignored in case of backup-id parameter in the input.

=end html

=back



=over 2

=item * I<paths>  =>   B<L<"dp-backup-path-info">[]>

=begin html

<br>Path information about backup

=end html

=back



B<Outputs>

=over 2

=item * I<backup-locations>  =>   B<L<"backup-location-info">[]>

=begin html

<br>Location information for the backup.

=end html

=back



=head2 dp_backup_list_iter_end



=begin html

Ends iteration to list backups.

=end html



B<Inputs>

=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dp-backup-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * None

=back



=head2 dp_backup_list_iter_next



=begin html

Get next few records in the iteration started by dp-backup-list-iter-start.

=end html



B<Inputs>

=over 2

=item * I<maximum>  =>   B<integer>

=begin html

<br>The maximum number of entries to retrieve.

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag from a previous dp-backup-list-iter-start.

=end html

=back



B<Outputs>

=over 2

=item * I<backups>  =>   B<L<"dp-backup-info">[]>

=begin html

<br>List of backups.

=end html

=back



=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>The number of records actually returned. Range: [0..2^31-1]

=end html

=back



=head2 dp_backup_list_iter_start



=begin html

Starts iteration to list backups of a dataset or a path within dataset.

=end html



B<Inputs>

=over 2

=item * I<application-resource-namespace>  =>   B<application-resource-namespace, optional>

=begin html

<br>Name of the application resource namespace. If has-application-resources-only is true, then (has-application-resources-only, application-resource-namespace) is used to load backups, specific to a resource namespace. Ignored if has-application-resources-only is false. If not specified, when has-application-resource-namespace is true, then all backups containing application resources are returned.

=end html

=back



=over 2

=item * I<backup-id>  =>   B<integer, optional>

=begin html

<br>Id of backup instance whose information is to be listed. If this parameter is specified backup-version, volume-id, snapshot-unique-id, root-object-name-or-id, sub-path, application-resource-namespace and search-keys parameters are ignored. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<backup-version>  =>   B<dp-timestamp, optional>

=begin html

<br>Timestamp when the backup was taken. Backups of the dataset that were taken at this time is listed. If this parameter is specified, volume-id, snapshot-unique-id, root-object-name-or-id, sub-path, application-resource-namespace and search-keys are ignored.

=end html

=back



=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or id of dataset. Backups for this dataset are listed. If this is not given, then all backups for all datasets will be returned, the backup-id, backup-version, volume-id fields are ignored.

=end html

=back



=over 2

=item * I<has-application-resources-only>  =>   B<boolean, optional>

=begin html

<br>If true, returns backups containing only application resources from host services and plugins. Can be true, only if has-storage-resources-only is false. Default is false.

=end html

=back



=over 2

=item * I<has-storage-resources-only>  =>   B<boolean, optional>

=begin html

<br>If true, returns backups containing only storage entities. Can be true, only if has-application-resources-only is false. Default is false.

=end html

=back



=over 2

=item * I<include-backup-graph-info>  =>   B<boolean, optional>

=begin html

<br>If true, the backup-graph-info is returned in the output. Otherwise, backup-graph-info is omitted to improve performance. Default is true.

=end html

=back



=over 2

=item * I<include-is-available>  =>   B<boolean, optional>

=begin html

<br>If true, the is-available status is calculated for each member which may make the call to this zapi take much longer. Default is false.

=end html

=back



=over 2

=item * I<include-metadata>  =>   B<boolean, optional>

=begin html

<br>If true, returns metadata for the backup. If false, metadata, which can be large in size, is not returned. Default is false. Ignored if include-metadata-host-service is specified.

=end html

=back



=over 2

=item * I<include-metadata-host-service>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or object identifier of the Host Service for the backup metadata. If specified, only the backup metadata of the given Host Service are listed, and include-metadata is ignored.

=end html

=back



=over 2

=item * I<is-mounted>  =>   B<boolean, optional>

=begin html

<br>If true, return backups that are either mounted, being mounted or being unmounted. If false, this input will not be used as filtering criterion while listing backups. Ignored if either backup-id, backup-version, or search-keys are specified. Default is false.

=end html

=back



=over 2

=item * I<is-root-object-restorable>  =>   B<boolean, optional>

=begin html

<br>If root-object-name-or-id is given, and this is TRUE, only the backups from which the root-object is restorable will be returned. Default is FALSE. This is ignored if root-object-name-or-id is not given.

=end html

=back



=over 2

=item * I<root-object-name-or-id>  =>   B<obj-name-or-id, optional>

=begin html

<br>Name or id of a dataset member. This may be either be an application object such as VM or a datastore or it can be a qtree, ossv directory or volume. If sub path input is given then this input is required. However, sub path input cannot be specified if this input represents an application object. If specified, backups containing this object are listed. Otherwise, all backups of this dataset are listed. If dataset-name-or-id is not specified, all backups containing this root object across all datasets will be listed.

=end html

=back



=over 2

=item * I<search-keys>  =>   B<search-key[], optional>

=begin html

<br>Keys to search the backups by. If any of the given search keys matchs a backup, the backup will be returned. If backup-id, backup-version, volume-id, snapshot-unique-id, root-object-name-or-id, or sub-path is specified, this field is ignored. If dataset-name-or-id is not specified, backups are searched across all the datasets, otherwise search is limited to only the specified dataset.

=end html

=back



=over 2

=item * I<snapshot-unique-id>  =>   B<string, optional>

=begin html

<br>Unique id of a snapshot. If volume-id is present, then this input must be given. Ignored if volume-id is not present.

=end html

=back



=over 2

=item * I<sub-path>  =>   B<string, optional>

=begin html

<br>Local subpath within the dataset with regard to root-object-name-or-id. If specified, backups containing this sub path are listed. Ignored if root-object-name-or-id input is not present or if root-object-name-or-id represents an application object such as a VM or a datastore. If the root-object-name-or-id is a volume, qtree or ossv unix directory then this sub-path is a unix-like path, ex: 'dir1/dir2/'. If the root-object-name-or-id is ossv windows directory then this sub-path is a windows path, ex : 'dir1\dir2\'. Maximum length of sub-path is 32767 characters.

=end html

=back



=over 2

=item * I<volume-id>  =>   B<obj-id, optional>

=begin html

<br>Id of volume that is member of a dataset node. If this input is present then snapshot-unique-id must be present. backup-version containing this (volume-id, snapshot-unique-id) is returned. If this parameter is specified, root-object-name-or-id, sub-path, application-resource-namespace and search-keys are ignored.

=end html

=back



B<Outputs>

=over 2

=item * I<records>  =>   B<integer>

=begin html

<br>Number which tells you how many items have been saved for future retrieval with dp-backup-list-iter-next. Range: [0..2^31-1]

=end html

=back



=over 2

=item * I<tag>  =>   B<string>

=begin html

<br>Tag to be used in subsequent calls to dp-backup-list-iter-next.

=end html

=back



=head2 dp_backup_mount_start



=begin html

Mount a backup containing virtual infrastructure objects such as VMs or datastores. A background job will be started for this operation.

=end html



B<Inputs>

=over 2

=item * I<backup-id>  =>   B<integer>

=begin html

<br>Identifier of the backup that is to be mounted. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<host-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name of the host on which the backup is mounted.

=end html

=back



B<Outputs>

=over 2

=item * I<job-id>  =>   B<integer>

=begin html

<br>Id of the job that handles the mounting operation. All host services progress/status information will be logged in this job. Range: [1..2^31-1]

=end html

=back



=over 2

=item * I<mount-id>  =>   B<integer>

=begin html

<br>Id of the mount session. This can be used to unmount the backup. Range: [1..2^31-1]

=end html

=back



=head2 dp_backup_start



=begin html

Start an unscheduled backup of a dataset. All members or a subset of the dataset will be backed up. A background job will be spawned to backup the dataset.

=end html



B<Inputs>

=over 2

=item * I<backup-description>  =>   B<string, optional>

=begin html

<br>Description for the backup. Can be arbitrary string meaningful to the user. If provided, the job spawned will have this description. The length of this string cannot be more than 255 characters.

=end html

=back



=over 2

=item * I<backup-destination>  =>   B<string, optional>

=begin html

<br>This field is deprecated in favor of backup-destination-name-or-id. Destination node name of the backup. This legacy parameter is ignored if backup-destination-name-or-id is supplied. Please see input backup-destination-name-or-id for the description of how this node name will be used.

=end html

=back



=over 2

=item * I<backup-destination-name-or-id>  =>   B<string, optional>

=begin html

<br>Destination of the backup. <P> For a dataset with an associated data protection policy, this may be the name or id of one of the nodes in the data protection policy associated with the dataset directly or through the storage service. <p> If the name or id of the primary node is specified, the management station takes local snapshot only. Otherwise, the management station transfers the backup over intervening policy nodes until it reaches the destination with this node name or id. <P> If no node name or id is provided, and there is an associated data protection policy for the dataset, the management station takes local snapshots on the primary node as well as backups on all connections in the policy. <P> A value of 1 is used for the root node of the dataset. <P> If both backup-destination and backup-destination-name-or-id are specified, then backup-destination-name-or-id will take precedence over backup-destination.

=end html

=back



=over 2

=item * I<backup-members>  =>   B<obj-name-or-id[], optional>

=begin html

<br>One or more dataset member Ids which should be included in the backup. Only the member Id should be specified. If member path is specified, backup will fail. If this input is not supplied, all members of the dataset will be backed up. This input is valid only for the datasets containing application objects such as Hyper-V VMs or VMware VMs. If supplied for a dataset not containing application objects, EUNUSEDAPPLICATIONOBJECTSETTING is returned. <P> Specification of a member that is not part of the dataset generates an error of type ENOTINDATASET.

=end html

=back



=over 2

=item * I<backup-script>  =>   B<string, optional>

=begin html

<br>Name of the script to invoke on the Host Services station both before and after the backup. This script is only used for datasets containing application objects such as Hyper-V VMs or VMware VMs and if supplied on other datasets will generate an error of EUNUSEDAPPLICATIONOBJECTSETTING. <p> The backup-script consists of 0 to 255 characters. An empty string value "" indicates no script is invoked. The default value of this property is the empty string "". <p> The system does not check whether a non-empty path string actually refers to an executable script prior to attempting to run the script. The default value of this property is the empty string "". For example, possible values are %env%\scripts\backup.ps1 OR c:\program..\HS\scripts\backup.ps1 OR k:\program..\HS\scripts\backup.ps1 [k is a network share] OR UNC path \\SCRIPTSSVR\SHARE\SCRIPTS\BACKUP.PS

=end html

=back



=over 2

=item * I<dataset-name-or-id>  =>   B<obj-name-or-id>

=begin html

<br>Name or id of the dataset to backup.

=end html

=back



=over 2

=item * I<hyperv-backup-settings-info>  =>   B<L<"hyperv-backup-schedule-settings-info">, optional>

=begin html

<br>Hyper-V specific settings for the backup operation. These settings apply to this backup only. When backing up Hyper-V objects, this input can be used to specify the Hyper-V plugin settings.

=end html

=back



=over 2

=item * I<retention-duration>  =>   B<integer, optional>

=begin html

<br>The age, in seconds, after which this backup expires. <P> When this input is not present for datasets that are associated with a data protection policy, the retention-duration for this one backup will be determined by the data protection policy. <P> When retention-type is omitted the the value of retention-duration will determine the retention-type as shown below. <UL> <LI> 'hourly' if less than 24 hours <LI> 'daily' if 1 day up to and not including 1 week <LI> 'weekly' if 1 week up to and not including 31 days <LI> 'monthly' if 31 days or longer. </UL> <P> At least one of retention-type or retention-duration is required unless the dataset is an application dataset with is-application-responsible-for-primary-backup set to true. In the latter case, both can be omitted. <P> If present, it should be a non-zero value. Range: [1..2^31 - 1].

=end html

=back



=over 2

=item * I<retention-type>  =>   B<dp-backup-retention-type, optional>

=begin html

<br>Retention type to which the backup version should be archived. <P> At least one of retention-type or retention-duration is required unless the dataset is an application dataset with is-application-responsible-for-primary-backup set to true. In the latter case, both can be omitted. <P> If this input is specified, the specified retention type will be assigned to the backups created by this operation. This applies to all types of datasets including the application datasets with is-application-responsible-for-primary-backup set to true. <P> If this input is omitted for an application dataset and if is-application-responsible-for-primary-backup is true, the retention type of the primary backup is assigned to the replicated backups. <P> If this input is omitted in any of the other cases, retention type will be determined from retention-duration as specified in the retention-duration definition that follows.

=end html

=back



=over 2

=item * I<vmware-backup-settings-info>  =>   B<L<"vmware-backup-schedule-settings-info">, optional>

=begin html

<br>VMware specific settings for the backup operation. These settings apply to this backup only. When backing up VMware objects, this input can be used to specify the VMware plugin settings.

=end html

=back



B<Outputs>

=over 2

=item * I<job-id>  =>   B<integer>

=begin html

<br>Id of the job that handles the unscheduled backup of the dat