/*
 * Decompiled with CFR 0.152.
 */
package zexplore.toolbar;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import netapp.manage.NaElement;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.Server;
import zexplore.View;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteAndDisplayWorker;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.menubar.preferences.PreferencesMenu;

public class ExecuteButton
extends JButton {
    private static final long serialVersionUID = 6227100095517530379L;
    private static Map<ExecuteTabPanel, Queue<NaElement>> queueMap = new HashMap<ExecuteTabPanel, Queue<NaElement>>();
    private static Map<ExecuteTabPanel, Integer> totalApiCountMap = new HashMap<ExecuteTabPanel, Integer>();
    private static Map<ExecuteTabPanel, String> xmlOutputMap = new HashMap<ExecuteTabPanel, String>();
    private static Map<ExecuteTabPanel, Long> executionTimeMap = new HashMap<ExecuteTabPanel, Long>();
    private static boolean stopExecution = false;
    private static final ImageIcon executeIcon = new IconMap().getIcon("execute");
    private static final ImageIcon stopIcon = new IconMap().getIcon("stop");

    public ExecuteButton() {
        super(executeIcon);
        String string = "Execute Selected Workflow on a Connected Server.";
        this.setToolTipText(string);
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ExecuteButton.this.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ExecuteButton.this.setContentAreaFilled(false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ExecuteButton.this.executeApi();
            }
        });
        this.addKeyListener(new KeyOperationsListener());
    }

    public void executeApi() {
        int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
        String string = executeTabPanel.inputPanel.input.getText();
        if (string.trim().equals("")) {
            return;
        }
        Server server = executeTabPanel.getServer();
        if (server == null) {
            int n2 = JOptionPane.showConfirmDialog(View.frame, "Not connected to a server. \nDo you want to connect to a server?", "Not Connected", 0, 2);
            if (n2 == 0) {
                PreferencesMenu.connectItem.connect();
                server = executeTabPanel.getServer();
                if (server == null) {
                    return;
                }
            } else {
                return;
            }
        }
        NaElement naElement = server.getApiElement(string);
        Queue<NaElement> queue = new LinkedList<NaElement>();
        List list = naElement.getChildren();
        int n3 = 0;
        if (PreferencesMenu.optionsItem.getCurrentExecuteMultipleAPIs()) {
            if (string.contains("-iter-start") && PreferencesMenu.optionsItem.getCurrentEnableIteratorComprehension()) {
                NaElement naElement2 = new NaElement("netapp");
                for (NaElement naElement3 : list) {
                    ++n3;
                    if (naElement3.getName().contains("-iter-start")) {
                        if (naElement2.hasChildren()) {
                            queue.add(naElement2);
                            naElement2 = new NaElement("netapp");
                        }
                        queue.add(naElement3);
                        queue = this.addIteratorElements(naElement3.getName(), queue);
                        n3 += 2;
                        continue;
                    }
                    naElement2.addChildElem(naElement3);
                }
                if (naElement2.hasChildren()) {
                    queue.add(naElement2);
                }
            } else {
                queue.add(naElement);
                n3 = list.size();
            }
        } else {
            for (NaElement naElement4 : list) {
                queue.add(naElement4);
                ++n3;
                if (!naElement4.getName().contains("-iter-start") || !PreferencesMenu.optionsItem.getCurrentEnableIteratorComprehension()) continue;
                queue = this.addIteratorElements(naElement4.getName(), queue);
                n3 += 2;
            }
        }
        queueMap.put(executeTabPanel, queue);
        totalApiCountMap.put(executeTabPanel, n3);
        executeTabPanel.outputTabbedPane.xmlOutputPanel.output.setText("");
        executeTabPanel.outputTabbedPane.treeOutputPanel.outputTree.setModel(null);
        View.statusBar.setExecutionProgress("");
        View.statusBar.setExecutionTime(-1L);
        if (!PreferencesMenu.optionsItem.getCurrentExecuteMultipleAPIs()) {
            if (this.getIcon().equals(executeIcon)) {
                this.setIcon(stopIcon);
                stopExecution = false;
            } else {
                this.setIcon(executeIcon);
                stopExecution = true;
                return;
            }
        }
        this.executeAndDisplay(executeTabPanel);
    }

    public void executeAndDisplay(ExecuteTabPanel executeTabPanel) {
        Queue<NaElement> queue = queueMap.get(executeTabPanel);
        if (queue.isEmpty() || stopExecution) {
            if (queue.isEmpty()) {
                int n = totalApiCountMap.get(executeTabPanel);
                View.statusBar.setExecutionProgress(null, n, n);
            }
            totalApiCountMap.put(executeTabPanel, 0);
            xmlOutputMap.put(executeTabPanel, "");
            executionTimeMap.put(executeTabPanel, -1L);
            this.setIcon(executeIcon);
            stopExecution = false;
            return;
        }
        NaElement naElement = queue.remove();
        ExecuteAndDisplayWorker executeAndDisplayWorker = new ExecuteAndDisplayWorker();
        executeAndDisplayWorker.setApiInput(naElement);
        executeAndDisplayWorker.setExecuteTabPanel(executeTabPanel);
        int n = totalApiCountMap.get(executeTabPanel);
        executeAndDisplayWorker.setTotalApiCount(n);
        executeAndDisplayWorker.setCompletedApiCount(n - queue.size());
        executeAndDisplayWorker.execute();
        while (!executeAndDisplayWorker.isDone()) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void addQueueTopElement(ExecuteTabPanel executeTabPanel, String string, String string2) {
        NaElement naElement;
        Queue<NaElement> queue = queueMap.get(executeTabPanel);
        LinkedList<NaElement> linkedList = new LinkedList<NaElement>();
        String string3 = queue.remove().getName();
        int n = totalApiCountMap.get(executeTabPanel);
        totalApiCountMap.put(executeTabPanel, n - 1);
        long l = PreferencesMenu.optionsItem.getCurrentIteratorFetchSize();
        long l2 = Long.parseLong(string2);
        for (long i = 0L; i < l2; i += l) {
            naElement = new NaElement(string3);
            naElement.addNewChild("tag", string);
            naElement.addNewChild("maximum", String.valueOf(l));
            linkedList.add(naElement);
            n = totalApiCountMap.get(executeTabPanel);
            totalApiCountMap.put(executeTabPanel, n + 1);
        }
        naElement = queue.remove();
        n = totalApiCountMap.get(executeTabPanel);
        totalApiCountMap.put(executeTabPanel, n - 1);
        if (string != null) {
            naElement.addNewChild("tag", string);
            linkedList.add(naElement);
            n = totalApiCountMap.get(executeTabPanel);
            totalApiCountMap.put(executeTabPanel, n + 1);
        }
        linkedList.addAll(queue);
        queueMap.put(executeTabPanel, linkedList);
    }

    public void setXMLOutput(ExecuteTabPanel executeTabPanel, String string) {
        xmlOutputMap.put(executeTabPanel, string);
    }

    public String getXMLOutput(ExecuteTabPanel executeTabPanel) {
        return xmlOutputMap.get(executeTabPanel);
    }

    public void setExecutionTime(ExecuteTabPanel executeTabPanel, long l) {
        executionTimeMap.put(executeTabPanel, l);
    }

    public long getExecutionTime(ExecuteTabPanel executeTabPanel) {
        return executionTimeMap.get(executeTabPanel);
    }

    public boolean shouldStopExecution() {
        return stopExecution;
    }

    private Queue<NaElement> addIteratorElements(String string, Queue<NaElement> queue) {
        String string2 = string.replace("-iter-start", "-iter-next");
        NaElement naElement = new NaElement(string2);
        queue.add(naElement);
        String string3 = string.replace("-iter-start", "-iter-end");
        NaElement naElement2 = new NaElement(string3);
        queue.add(naElement2);
        return queue;
    }
}

