/*
 * Decompiled with CFR 0.152.
 */
package zexplore.menubar.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import zexplore.menubar.preferences.Connection;

public class ConnectionList {
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private static final String PREF_NODE_CONNECTION_COUNT = "CONNECTION_COUNT";
    private static final String PREF_NODE_CONNECTION_ENTRY_PREFIX = "CONN";
    private static List<Connection> connectionList = new ArrayList<Connection>();

    public List<Connection> getConnectionList() {
        return connectionList;
    }

    public Connection getConnection(String string) {
        for (Connection connection : connectionList) {
            if (!connection.getConnectionName().endsWith(string)) continue;
            return connection;
        }
        return null;
    }

    public boolean addConnection(Connection connection) {
        String string = connection.getConnectionName();
        for (Connection connection2 : connectionList) {
            if (!connection2.getConnectionName().equals(string)) continue;
            return false;
        }
        connectionList.add(connection);
        return true;
    }

    public void overwriteConnection(Connection connection) {
        String string = connection.getConnectionName();
        for (Connection connection2 : connectionList) {
            if (!connection2.getConnectionName().equals(string)) continue;
            int n = connectionList.indexOf(connection2);
            connectionList.set(n, connection);
            return;
        }
    }

    public boolean removeConnection(Connection connection) {
        String string = connection.getConnectionName();
        for (Connection connection2 : connectionList) {
            if (!connection2.getConnectionName().endsWith(string)) continue;
            connectionList.remove(connection);
            return true;
        }
        return false;
    }

    public void loadSavedConnections() {
        int n = this.prefs.getInt(PREF_NODE_CONNECTION_COUNT, 0);
        for (int i = 0; i < n; ++i) {
            String string = PREF_NODE_CONNECTION_ENTRY_PREFIX + i;
            String string2 = this.prefs.get(string, null);
            if (string2 == null) continue;
            connectionList.add(this.getConnectionFromEntry(string2));
        }
    }

    public void putSavedConnections() {
        this.clearPreferences();
        int n = 0;
        for (Connection connection : connectionList) {
            String string = PREF_NODE_CONNECTION_ENTRY_PREFIX + n;
            ++n;
            this.prefs.put(string, this.getEntryFromConnection(connection));
        }
        this.prefs.putInt(PREF_NODE_CONNECTION_COUNT, n);
    }

    public void clearPreferences() {
        try {
            this.prefs.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public Connection getConnectionFromEntry(String string) {
        String[] stringArray = string.split("#");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Connection.ServerType serverType = Connection.ServerType.ONTAP;
        if (!string3.equalsIgnoreCase("Ontap")) {
            serverType = Connection.ServerType.DFM;
        }
        String string4 = stringArray[2];
        String string5 = stringArray[3];
        String string6 = stringArray[4];
        Connection.Transport transport = Connection.Transport.HTTPS;
        if (string6.equalsIgnoreCase("http")) {
            transport = Connection.Transport.HTTP;
        }
        String string7 = stringArray[5];
        boolean bl = Boolean.parseBoolean(stringArray[6]);
        String string8 = stringArray[7];
        boolean bl2 = Boolean.parseBoolean(stringArray[8]);
        String string9 = "";
        if (stringArray.length > 9) {
            string9 = stringArray[9];
        }
        return new Connection(string2, serverType, string4, string5, transport, string7, bl, string8, bl2, string9);
    }

    public String getEntryFromConnection(Connection connection) {
        String string = connection.getConnectionName();
        String string2 = "Ontap";
        if (connection.getServerType() == Connection.ServerType.DFM) {
            string2 = "DFM";
        }
        String string3 = connection.getServerName();
        String string4 = connection.getUserName();
        String string5 = "HTTPS";
        if (connection.getTransportType() == Connection.Transport.HTTP) {
            string5 = "HTTP";
        }
        String string6 = connection.getPort();
        String string7 = String.valueOf(connection.isTimeoutChecked());
        String string8 = connection.getTimeout();
        String string9 = String.valueOf(connection.isVfilerTunnelChecked());
        String string10 = connection.getVfilerUnitName();
        String string11 = string + "#" + string2 + "#" + string3 + "#" + string4 + "#" + string5 + "#" + string6 + "#" + string7 + "#" + string8 + "#" + string9 + "#" + string10;
        return string11;
    }
}

