/*
 * Decompiled with CFR 0.152.
 */
package zexplore.menubar.file;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import zexplore.IconMap;
import zexplore.View;
import zexplore.addedapisworkflows.workflows.LoadedWorkflowList;
import zexplore.addedapisworkflows.workflows.WorkflowsTreePanel;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.menubar.file.CustomFileFilter;

public class ImportItem
extends JMenuItem {
    private static final long serialVersionUID = 8599915878204039887L;
    private static JFileChooser fileChooser = new JFileChooser();
    private static CustomFileFilter filter = new CustomFileFilter("xml");

    public ImportItem() {
        this.setText("Import                                      Ctrl+I");
        this.setMnemonic(73);
        this.setIcon(new IconMap().getIcon("import"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportItem.this.importWorkflow();
            }
        });
    }

    public void importWorkflow() {
        fileChooser.setFileFilter(filter);
        fileChooser.setDialogTitle("Import Workflow");
        int n = fileChooser.showOpenDialog(View.frame);
        if (n == 0) {
            File file = fileChooser.getSelectedFile();
            this.readFileSetContent(file, true);
        }
    }

    public void readFileSetContent(File file, boolean bl) {
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
            }
            bufferedReader.close();
            dataInputStream.close();
            fileInputStream.close();
            String string2 = LoadedWorkflowList.sanitizeFilePath(file.getAbsolutePath());
            if (LoadedWorkflowList.getLoadedWorkflowList().contains(string2)) {
                int n = JOptionPane.showConfirmDialog(View.frame, "Workflow already imported:\n" + string2 + "\n\nDo you want to view the previously imported workflow?", "Duplicate Import", 0, 2);
                if (n == 0) {
                    ExecuteTabPanel executeTabPanel = LoadedWorkflowList.getExecuteTabPanel(string2);
                    ExecuteDevelopPane.executeTabbedPane.setSelectedComponent(executeTabPanel);
                }
                return;
            }
            String string3 = LoadedWorkflowList.getWorkflowName(file.getAbsolutePath());
            ExecuteDevelopPane.executeTabbedPane.addImportTab(string3);
            ExecuteDevelopPane.developTabbedPane.addImportTab(string3);
            int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
            ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
            executeTabPanel.inputPanel.input.setText(stringBuffer.toString());
            executeTabPanel.inputPanel.importPath = file;
            LoadedWorkflowList.addLoadedWorkflow(string2, true);
            LoadedWorkflowList.setNewWorkflow(string2, false);
            LoadedWorkflowList.setExecuteTabPanel(string2, executeTabPanel);
            int n2 = WorkflowsTreePanel.tree.addUserDefinedWorkflow(stringBuffer.toString(), string3, -1, bl);
            executeTabPanel.setWorkflowNodeIndex(n2);
            WorkflowsTreePanel.tree.setExecuteTabPanelIndex(n2, n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            int n = JOptionPane.showConfirmDialog(View.frame, "Failed to load workflow from\n" + LoadedWorkflowList.sanitizeFilePath(file.getAbsolutePath()) + "\n\nDo you want to browse the file to import?", "File Not Found", 0, 2);
            if (n == 0) {
                this.importWorkflow();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

