/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.tabpopupmenu;

import java.io.File;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import zexplore.addedapisworkflows.workflows.LoadedWorkflowList;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;

public class WorkflowFileListTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8670739948947598868L;
    private String[] columnNames = new String[]{"Save", "Workflow"};
    private Object[][] data;

    public WorkflowFileListTableModel(FileType fileType) {
        int n;
        Vector<String> vector = null;
        ExecuteTabPanel executeTabPanel = null;
        if (fileType == FileType.SAVED) {
            vector = LoadedWorkflowList.getSavedWorkflowList();
            this.data = new Object[vector.size()][2];
        } else if (fileType == FileType.UNSAVED) {
            vector = LoadedWorkflowList.getUnsavedWorkflowList(true);
            this.data = new Object[vector.size()][2];
        } else {
            vector = LoadedWorkflowList.getUnsavedWorkflowList(true);
            n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
            executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
            File file = executeTabPanel.inputPanel.importPath;
            this.data = !LoadedWorkflowList.isSaved(file.getAbsolutePath()) ? new Object[vector.size() - 1][2] : new Object[vector.size()][2];
        }
        n = 0;
        for (String string : vector) {
            if (executeTabPanel != null && LoadedWorkflowList.getExecuteTabPanel(string).equals(executeTabPanel)) continue;
            this.data[n][0] = new Boolean(true);
            this.data[n][1] = LoadedWorkflowList.getWorkflowName(string) + " [" + string + "]";
            ++n;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.data.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.data[n][n2];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.data[n][n2] = object;
        this.fireTableCellUpdated(n, n2);
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public static enum FileType {
        SAVED,
        UNSAVED,
        UNSAVED_EXCLUDE_SELECTED;

    }
}

