/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.tabpopupmenu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import zexplore.View;
import zexplore.addedapisworkflows.workflows.LoadedWorkflowList;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.executedevelop.tabpopupmenu.WorkflowFileListTableModel;
import zexplore.menubar.file.FileMenu;

public class SaveUnsavedWorkflowsDialog
extends JDialog {
    private static final long serialVersionUID = 2201481656376513905L;
    private JFrame frame = View.frame;
    private JPanel mainPanel;
    private JTable unsavedWorkflowsTable;
    private JScrollPane scrollPane;
    private JPanel buttonsPanel;
    private JToggleButton selectButton;
    private JButton saveSelectedButton;
    private JButton saveNoneButton;
    private JButton cancelButton;
    private boolean closeTabs = false;
    private SaveUnsavedWorkflowsDialog dialog = this;

    public SaveUnsavedWorkflowsDialog(WorkflowFileListTableModel.FileType fileType) {
        super(View.frame, "Save Unsaved Workflows", true);
        this.dialog.setPreferredSize(new Dimension(500, 300));
        this.mainPanel = new JPanel(new BorderLayout());
        this.createTable(fileType);
        this.scrollPane = new JScrollPane(this.unsavedWorkflowsTable);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.createButtonPanel();
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.dialog.getContentPane().add(this.mainPanel);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
    }

    private void createTable(WorkflowFileListTableModel.FileType fileType) {
        this.unsavedWorkflowsTable = new JTable(new WorkflowFileListTableModel(fileType));
        this.unsavedWorkflowsTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.unsavedWorkflowsTable.setFillsViewportHeight(true);
        this.unsavedWorkflowsTable.setShowGrid(false);
        this.unsavedWorkflowsTable.setTableHeader(null);
        this.unsavedWorkflowsTable.setRowHeight(30);
        this.unsavedWorkflowsTable.setRowMargin(10);
        TableColumn tableColumn = this.unsavedWorkflowsTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(50);
        this.unsavedWorkflowsTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                WorkflowFileListTableModel workflowFileListTableModel = (WorkflowFileListTableModel)SaveUnsavedWorkflowsDialog.this.unsavedWorkflowsTable.getModel();
                int n = workflowFileListTableModel.getRowCount();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Boolean bl = (Boolean)workflowFileListTableModel.getValueAt(i, 0);
                    if (!bl.booleanValue()) continue;
                    SaveUnsavedWorkflowsDialog.this.saveSelectedButton.setEnabled(true);
                    ++n2;
                }
                if (n2 == 0) {
                    SaveUnsavedWorkflowsDialog.this.saveSelectedButton.setEnabled(false);
                    SaveUnsavedWorkflowsDialog.this.selectButton.setSelected(true);
                    SaveUnsavedWorkflowsDialog.this.selectButton.setText("Select All");
                } else if (n2 == n) {
                    SaveUnsavedWorkflowsDialog.this.selectButton.setSelected(false);
                    SaveUnsavedWorkflowsDialog.this.selectButton.setText("Deselect All");
                }
            }
        });
    }

    private void createButtonPanel() {
        this.buttonsPanel = new JPanel(new GridLayout(1, 4, 10, 0));
        this.createSelectToggleButton();
        this.createSaveSelectedButton();
        this.createSaveNoneButton();
        this.createCancelButton();
        this.buttonsPanel.add(this.selectButton);
        this.buttonsPanel.add(this.saveSelectedButton);
        this.buttonsPanel.add(this.saveNoneButton);
        this.buttonsPanel.add(this.cancelButton);
    }

    private void createSelectToggleButton() {
        this.selectButton = new JToggleButton("Deselect All");
        this.selectButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SaveUnsavedWorkflowsDialog.this.selectAll(false);
                    SaveUnsavedWorkflowsDialog.this.selectButton.setText("Select All");
                    SaveUnsavedWorkflowsDialog.this.saveSelectedButton.setEnabled(false);
                } else {
                    SaveUnsavedWorkflowsDialog.this.selectAll(true);
                    SaveUnsavedWorkflowsDialog.this.selectButton.setText("Deselect All");
                    SaveUnsavedWorkflowsDialog.this.saveSelectedButton.setEnabled(true);
                }
            }
        });
    }

    private void selectAll(boolean bl) {
        WorkflowFileListTableModel workflowFileListTableModel = (WorkflowFileListTableModel)this.unsavedWorkflowsTable.getModel();
        for (int i = 0; i < workflowFileListTableModel.getRowCount(); ++i) {
            workflowFileListTableModel.setValueAt(new Boolean(bl), i, 0);
        }
    }

    private void createSaveSelectedButton() {
        this.saveSelectedButton = new JButton("Save Selected");
        this.saveSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveUnsavedWorkflowsDialog.this.saveSelectedWorkflows();
                SaveUnsavedWorkflowsDialog.this.closeTabs = true;
                SaveUnsavedWorkflowsDialog.this.dialog.dispose();
            }
        });
    }

    private void createSaveNoneButton() {
        this.saveNoneButton = new JButton("Save None");
        this.saveNoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveUnsavedWorkflowsDialog.this.closeTabs = true;
                SaveUnsavedWorkflowsDialog.this.dialog.dispose();
            }
        });
    }

    private void createCancelButton() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SaveUnsavedWorkflowsDialog.this.closeTabs = false;
                SaveUnsavedWorkflowsDialog.this.dialog.dispose();
            }
        });
    }

    private void saveSelectedWorkflows() {
        WorkflowFileListTableModel workflowFileListTableModel = (WorkflowFileListTableModel)this.unsavedWorkflowsTable.getModel();
        for (int i = 0; i < workflowFileListTableModel.getRowCount(); ++i) {
            Boolean bl = (Boolean)workflowFileListTableModel.getValueAt(i, 0);
            if (!bl.booleanValue()) continue;
            String string = this.getWorkflowFilePath((String)workflowFileListTableModel.getValueAt(i, 1));
            String string2 = LoadedWorkflowList.getWorkflowName(string);
            ExecuteTabPanel executeTabPanel = LoadedWorkflowList.getExecuteTabPanel(string);
            FileMenu.saveItem.saveFile(string2, executeTabPanel.inputPanel);
        }
    }

    private String getWorkflowFilePath(String string) {
        int n = string.indexOf("[");
        int n2 = string.indexOf("]");
        String string2 = string.substring(n + 1, n2);
        return string2;
    }

    public boolean canCloseTabs() {
        return this.closeTabs;
    }
}

