/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.tabpopupmenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import zexplore.IconMap;
import zexplore.View;
import zexplore.addedapisworkflows.workflows.LoadedWorkflowList;
import zexplore.executedevelop.ExecuteDevelopPane;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.executedevelop.tabpopupmenu.ExecuteDevelopTabPopupMenu;

public class DeleteItem
extends JMenuItem {
    private static final long serialVersionUID = -4364033507327514448L;

    public DeleteItem() {
        this.setText("Delete                              Alt+Delete");
        this.setMnemonic(68);
        this.setIcon(new IconMap().getIcon("delete"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteItem.this.deleteSelectedWorkflow();
            }
        });
    }

    public void deleteSelectedWorkflow() {
        int n = ExecuteDevelopPane.executeTabbedPane.getSelectedIndex();
        ExecuteTabPanel executeTabPanel = (ExecuteTabPanel)ExecuteDevelopPane.executeTabbedPane.getComponentAt(n);
        File file = executeTabPanel.inputPanel.importPath;
        if (LoadedWorkflowList.isSaved(file.getAbsolutePath())) {
            if (this.deleteFile(file, true)) {
                this.removeTabDisableUndoClose(n);
            }
        } else {
            int n2 = JOptionPane.showConfirmDialog(View.frame, "This workflow cannot be deleted as it is not saved on the disk.\nDo you want to close the tab?", "Delete Failed", 0, 2);
            if (n2 == 1 || n2 == -1) {
                return;
            }
            this.removeTabDisableUndoClose(n);
        }
    }

    public boolean deleteFile(File file, boolean bl) {
        int n;
        String string = LoadedWorkflowList.sanitizeFilePath(file.getAbsolutePath());
        String string2 = LoadedWorkflowList.getWorkflowName(string);
        if (bl && ((n = JOptionPane.showConfirmDialog(View.frame, "This operation will close the workflow and delete the corresponding file from disk\n" + string2 + " [" + string + "]" + "\n\nThis is an irreversible operation. Do you want to continue?", "Delete Workflow", 0, 2)) == 1 || n == -1)) {
            return false;
        }
        if (!file.delete()) {
            JOptionPane.showMessageDialog(View.frame, "Failed to delete file\n" + LoadedWorkflowList.sanitizeFilePath(file.getAbsolutePath()), "Delete Failed", 0);
            return false;
        }
        return true;
    }

    private void removeTabDisableUndoClose(int n) {
        ExecuteDevelopPane.executeTabbedPane.removeSelectedTab(n, true, false);
        ExecuteDevelopTabPopupMenu.undoCloseTabItem.disableUndoCloseTabItem();
    }
}

