/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.tabpopupmenu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import zexplore.View;
import zexplore.executedevelop.tabpopupmenu.ExecuteDevelopTabPopupMenu;
import zexplore.executedevelop.tabpopupmenu.WorkflowFileListTableModel;

public class DeleteAllWorkflowsDialog
extends JDialog {
    private static final long serialVersionUID = 2279237751743394808L;
    private JFrame frame = View.frame;
    private JPanel mainPanel;
    private JTable savedWorkflowsTable;
    private JScrollPane scrollPane;
    private JPanel buttonsPanel;
    private JToggleButton selectButton;
    private JButton yesButton;
    private JButton noButton;
    private boolean closeWorkflows = false;
    private DeleteAllWorkflowsDialog dialog = this;

    public DeleteAllWorkflowsDialog() {
        super(View.frame, "Delete Workflows", true);
        this.dialog.setPreferredSize(new Dimension(400, 500));
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        JLabel jLabel = new JLabel();
        jLabel.setText("<html><br>&nbsp &nbsp This operation will close all open workflow tabs and delete the <br> &nbsp &nbsp following selected workflow(s) from disk:<br><br><html>");
        jLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        jPanel.add((Component)jLabel, "West");
        this.mainPanel.add((Component)jPanel, "North");
        this.createTable();
        this.scrollPane = new JScrollPane(this.savedWorkflowsTable);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.createButtonPanel();
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.dialog.getContentPane().add(this.mainPanel);
        this.dialog.setResizable(false);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.frame);
        this.dialog.setVisible(true);
    }

    private void createTable() {
        this.savedWorkflowsTable = new JTable(new WorkflowFileListTableModel(WorkflowFileListTableModel.FileType.SAVED));
        this.savedWorkflowsTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.savedWorkflowsTable.setFillsViewportHeight(true);
        this.savedWorkflowsTable.setShowGrid(false);
        this.savedWorkflowsTable.setTableHeader(null);
        this.savedWorkflowsTable.setRowHeight(30);
        this.savedWorkflowsTable.setRowMargin(10);
        TableColumn tableColumn = this.savedWorkflowsTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(50);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(50);
        this.savedWorkflowsTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                WorkflowFileListTableModel workflowFileListTableModel = (WorkflowFileListTableModel)DeleteAllWorkflowsDialog.this.savedWorkflowsTable.getModel();
                int n = workflowFileListTableModel.getRowCount();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Boolean bl = (Boolean)workflowFileListTableModel.getValueAt(i, 0);
                    if (!bl.booleanValue()) continue;
                    ++n2;
                }
                if (n2 == 0) {
                    DeleteAllWorkflowsDialog.this.selectButton.setSelected(true);
                    DeleteAllWorkflowsDialog.this.selectButton.setText("Select All");
                } else if (n2 == n) {
                    DeleteAllWorkflowsDialog.this.selectButton.setSelected(false);
                    DeleteAllWorkflowsDialog.this.selectButton.setText("Deselect All");
                }
            }
        });
    }

    private void createButtonPanel() {
        this.buttonsPanel = new JPanel(new BorderLayout());
        this.createSelectToggleButton();
        JPanel jPanel = new JPanel();
        jPanel.add(this.selectButton);
        this.buttonsPanel.add((Component)jPanel, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel("This is an irreversible operation. Do you want to continue?");
        jPanel3.add(jLabel);
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel();
        jPanel2.add((Component)jPanel4, "East");
        this.createYesButton();
        jPanel4.add(this.yesButton);
        this.createNoButton();
        jPanel4.add(this.noButton);
        this.buttonsPanel.add((Component)jPanel2, "South");
    }

    private void createSelectToggleButton() {
        this.selectButton = new JToggleButton("Deselect All");
        this.selectButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DeleteAllWorkflowsDialog.this.selectAll(false);
                    DeleteAllWorkflowsDialog.this.selectButton.setText("Select All");
                } else {
                    DeleteAllWorkflowsDialog.this.selectAll(true);
                    DeleteAllWorkflowsDialog.this.selectButton.setText("Deselect All");
                }
            }
        });
    }

    private void selectAll(boolean bl) {
        WorkflowFileListTableModel workflowFileListTableModel = (WorkflowFileListTableModel)this.savedWorkflowsTable.getModel();
        for (int i = 0; i < workflowFileListTableModel.getRowCount(); ++i) {
            workflowFileListTableModel.setValueAt(new Boolean(bl), i, 0);
        }
    }

    private void createYesButton() {
        this.yesButton = new JButton("Yes");
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteAllWorkflowsDialog.this.closeWorkflows = true;
                DeleteAllWorkflowsDialog.this.deleteSelectedWorkflows();
                DeleteAllWorkflowsDialog.this.dialog.dispose();
            }
        });
    }

    private void createNoButton() {
        this.noButton = new JButton("No");
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeleteAllWorkflowsDialog.this.closeWorkflows = false;
                DeleteAllWorkflowsDialog.this.dialog.dispose();
            }
        });
    }

    private void deleteSelectedWorkflows() {
        WorkflowFileListTableModel workflowFileListTableModel = (WorkflowFileListTableModel)this.savedWorkflowsTable.getModel();
        for (int i = 0; i < workflowFileListTableModel.getRowCount(); ++i) {
            Boolean bl = (Boolean)workflowFileListTableModel.getValueAt(i, 0);
            if (!bl.booleanValue()) continue;
            String string = this.getWorkflowFilePath((String)workflowFileListTableModel.getValueAt(i, 1));
            ExecuteDevelopTabPopupMenu.deleteItem.deleteFile(new File(string), false);
        }
    }

    private String getWorkflowFilePath(String string) {
        int n = string.indexOf("[");
        int n2 = string.indexOf("]");
        String string2 = string.substring(n + 1, n2);
        return string2;
    }

    public boolean canCloseWorkflows() {
        return this.closeWorkflows;
    }
}

