/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.tab;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import util.CustomDocument;
import zexplore.executedevelop.tab.TabLabel;

public class TabLabelEditTextArea
extends JTextArea {
    private static final long serialVersionUID = -8132975965894127962L;
    private TabLabel tabLabel;
    private String originalTabText = null;
    private static final int MAX_TABNAME_LENGTH = 32;
    private static final int MAX_FILENAME_LENGTH = 32;

    public TabLabelEditTextArea(TabLabel tabLabel) {
        this.tabLabel = tabLabel;
        this.originalTabText = this.tabLabel.getText();
        this.setFont(this.tabLabel.getFont());
        this.setSize(this.tabLabel.getWidth(), this.tabLabel.getHeight());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TabLabelEditTextArea.this.stopEditing();
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    TabLabelEditTextArea.this.stopEditing();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        CustomDocument customDocument = new CustomDocument(32);
        this.setDocument(customDocument);
        this.setText(this.tabLabel.getText());
        customDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = TabLabelEditTextArea.this.getText();
                if (string.length() <= 32) {
                    TabLabelEditTextArea.this.tabLabel.setText(TabLabelEditTextArea.this.tabLabel.getPadding() + string + TabLabelEditTextArea.this.tabLabel.getPadding());
                    TabLabelEditTextArea.this.setSize(TabLabelEditTextArea.this.tabLabel.getWidth() + 4, TabLabelEditTextArea.this.tabLabel.getHeight());
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TabLabelEditTextArea.this.tabLabel.setText(TabLabelEditTextArea.this.tabLabel.getPadding() + TabLabelEditTextArea.this.getText() + TabLabelEditTextArea.this.tabLabel.getPadding());
                TabLabelEditTextArea.this.setSize(TabLabelEditTextArea.this.tabLabel.getWidth() + 4, TabLabelEditTextArea.this.tabLabel.getHeight());
            }
        });
    }

    private void stopEditing() {
        String string = this.getText();
        if (string.trim().length() <= 0) {
            string = this.originalTabText;
        } else {
            String string2 = this.tabLabel.getPadding();
            if (!string.startsWith(string2)) {
                string = string2 + string;
            }
            if (!string.endsWith(string2)) {
                string = string + string2;
            }
        }
        this.tabLabel.setText(string);
        this.tabLabel.removeTextArea();
        this.tabLabel.revalidate();
    }
}

