/*
 * Decompiled with CFR 0.152.
 */
package zexplore.executedevelop.execute;

import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import netapp.manage.NaElement;
import util.TreeUtil;
import zexplore.Server;
import zexplore.View;
import zexplore.executedevelop.execute.ExecuteTabPanel;
import zexplore.menubar.preferences.PreferencesMenu;
import zexplore.toolbar.ToolBar;

public class ExecuteAndDisplayWorker
extends SwingWorker<Void, Void> {
    private NaElement apiInput;
    private ExecuteTabPanel executeTabPanel;
    private Server server;
    private int totalApiCount;
    private int completedApiCount;

    public void setApiInput(NaElement naElement) {
        this.apiInput = naElement;
    }

    public void setExecuteTabPanel(ExecuteTabPanel executeTabPanel) {
        this.executeTabPanel = executeTabPanel;
    }

    public void setTotalApiCount(int n) {
        this.totalApiCount = n;
    }

    public void setCompletedApiCount(int n) {
        this.completedApiCount = n;
    }

    @Override
    protected Void doInBackground() throws Exception {
        View.statusBar.setExecutionProgress(this.apiInput.getName(), this.completedApiCount - 1, this.totalApiCount);
        this.server = new Server(this.executeTabPanel.getServer());
        this.server.setApiInput(this.apiInput);
        this.server.execute();
        while (!this.server.isDone()) {
            Thread.sleep(0L);
        }
        return null;
    }

    @Override
    protected void done() {
        JEditorPane jEditorPane = this.executeTabPanel.outputTabbedPane.xmlOutputPanel.output;
        try {
            super.get();
            String string = this.server.getXmlOutput();
            long l = this.server.getExecutionTime();
            string = this.server.mergeXMLOutput(jEditorPane.getText(), string);
            jEditorPane.setText(string);
            View.statusBar.setExecutionProgress(null, this.completedApiCount, this.totalApiCount);
            if (!ToolBar.executeButton.shouldStopExecution()) {
                ToolBar.executeButton.setXMLOutput(this.executeTabPanel, string);
                this.setOutputTreeMode(string);
                View.statusBar.addExecutionTime(l);
                ToolBar.executeButton.setExecutionTime(this.executeTabPanel, View.statusBar.getExecutionTime());
                if (this.apiInput.getName().contains("-iter-start") && PreferencesMenu.optionsItem.getCurrentEnableIteratorComprehension()) {
                    String string2 = this.server.getXmlOutput();
                    int n = string2.lastIndexOf("<tag>");
                    int n2 = -1;
                    if (n >= 0) {
                        n2 = string2.lastIndexOf("</tag>");
                    }
                    String string3 = null;
                    if (n2 >= 0) {
                        string3 = string2.substring(n + 5, n2);
                    }
                    int n3 = string2.lastIndexOf("<records>");
                    int n4 = -1;
                    if (n3 >= 0) {
                        n4 = string2.lastIndexOf("</records>");
                    }
                    String string4 = "0";
                    if (n4 >= 0) {
                        string4 = string2.substring(n3 + 9, n4);
                    }
                    ToolBar.executeButton.addQueueTopElement(this.executeTabPanel, string3, string4);
                }
                ToolBar.executeButton.executeAndDisplay(this.executeTabPanel);
            } else {
                string = this.server.mergeXMLOutput(ToolBar.executeButton.getXMLOutput(this.executeTabPanel), string);
                jEditorPane.setText(string);
                this.setOutputTreeMode(string);
                long l2 = ToolBar.executeButton.getExecutionTime(this.executeTabPanel);
                View.statusBar.setExecutionTime(l2 + l);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void setOutputTreeMode(String string) {
        HashMap<DefaultMutableTreeNode, String> hashMap = new HashMap<DefaultMutableTreeNode, String>();
        DefaultTreeModel defaultTreeModel = TreeUtil.getTreeModelFromXML(string, hashMap);
        this.executeTabPanel.outputTabbedPane.treeOutputPanel.outputTree.setModel(defaultTreeModel);
    }
}

