/*
 * Decompiled with CFR 0.152.
 */
package zexplore.codegenerator;

import zexplore.codegenerator.LanguageCodeGenerator;

public class CSharpGenerator
implements LanguageCodeGenerator {
    private static StringBuffer code = new StringBuffer();

    @Override
    public void beginCode(String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, String string8) {
        code.setLength(0);
        code.append("using System;\n");
        code.append("using System.Text;\n");
        code.append("using System.Collections.Generic;\n");
        code.append("using NetApp.Manage;\n");
        code.append("\n");
        code.append("namespace NetApp.NMSDK.Example\n");
        code.append("{\n");
        code.append("  class ApiClient \n");
        code.append("  {\n");
        code.append("\t static void Main(string[] args)\n");
        code.append("\t {\n");
        code.append("\t\t try\n");
        code.append("\t\t {\n");
        if (string == null || string.isEmpty()) {
            string = "<server name or IP address>";
        }
        if (string4 == null || string4.isEmpty()) {
            string4 = "<user name>";
        }
        string5 = string5 != null && string5.equalsIgnoreCase("DFM") ? "NaServer.SERVER_TYPE.DFM" : "NaServer.SERVER_TYPE.FILER";
        string6 = string6 != null && string6.equalsIgnoreCase("HTTP") ? "NaServer.TRANSPORT_TYPE.HTTP" : "NaServer.TRANSPORT_TYPE.HTTPS";
        if (string7 == null || string7.isEmpty()) {
            string7 = string5.equals("NaServer.SERVER_TYPE.DFM") ? (string6.equals("NaServer.TRANSPORT_TYPE.HTTPS") ? "8488" : "8088") : (string6.equals("NaServer.TRANSPORT_TYPE.HTTPS") ? "443" : "80");
        }
        code.append("\t\t\tNaServer s = new NaServer(\"" + string + "\", " + string2 + " , " + string3 + ");\n");
        code.append("\t\t\ts.ServerType = " + string5 + ";\n");
        code.append("\t\t\ts.TransportType = " + string6 + ";\n");
        code.append("\t\t\ts.Port = " + string7 + ";\n");
        code.append("\t\t\ts.Style = NaServer.AUTH_STYLE.LOGIN_PASSWORD;\n");
        code.append("\t\t\ts.SetAdminUser(\"" + string4 + "\", \"<password>\");\n");
        if (string8 != null && !string8.isEmpty()) {
            if (bl) {
                code.append("\t\t\ts.Vserver = \"" + string8 + "\";\n");
            } else {
                code.append("\t\t\ts.SetVfilerTunneling(\"" + string8 + "\");\n");
            }
        }
        code.append("\n");
        code.append("\n");
    }

    @Override
    public String endCode() {
        code.append("\t\t}\n");
        code.append("\t\tcatch (NaAuthException e)\n");
        code.append("\t\t{\n");
        code.append("\t\t\tConsole.Error.WriteLine(\"Authorization Failed: \" + e.Message);\n");
        code.append("\t\t}\n");
        code.append("\t\tcatch (NaApiFailedException e)\n");
        code.append("\t\t{\n");
        code.append("\t\t\tConsole.Error.WriteLine(\"API FAILED: \" + e.Message);\n");
        code.append("\t\t}\n");
        code.append("\t\t catch (Exception e)\n");
        code.append("\t\t{\n");
        code.append("\t\t\tConsole.Error.WriteLine(e.Message);\n");
        code.append("\t\t}\n");
        code.append("\t }\n");
        code.append("  }\n");
        code.append("}\n");
        return code.toString();
    }

    @Override
    public String beginAPI(int n, String string) {
        String string2 = "api";
        if (n > 0) {
            string2 = string2 + n;
        }
        code.append("\t\t\tNaElement " + string2 + " = new NaElement(\"" + string + "\");\n");
        return string2;
    }

    @Override
    public void endAPI(int n, String string) {
        String string2 = "xo";
        if (n > 0) {
            string2 = string2 + n;
        }
        String string3 = "children";
        if (n > 0) {
            string3 = string3 + n;
        }
        code.append("\n");
        code.append("\t\t\tNaElement " + string2 + " = s.InvokeElem(" + string + ");\n");
        code.append("\t\t\tConsole.WriteLine(" + string2 + ".ToPrettyString(\"\"));\n");
        code.append("\n");
        code.append("\n");
    }

    @Override
    public String addTypeParameter(String string, String string2, int n, int n2) {
        String string3 = "xi";
        if (n > 0) {
            string3 = "xi_" + n;
        }
        if (n2 > 0) {
            string3 = n > 0 ? string3 + "_" + n2 : string3 + n2;
        }
        code.append("\n");
        code.append("\t\t\tNaElement " + string3 + " = new NaElement(\"" + string2 + "\");\n");
        code.append("\t\t\t" + string + ".AddNewChild(" + string3 + ");\n");
        return string3;
    }

    @Override
    public void addSimpleParameter(String string, String string2, String string3) {
        if (string3.isEmpty()) {
            string3 = "<" + string2 + ">";
        }
        code.append("\t\t\t" + string + ".AddNewChild(\"" + string2 + "\",\"" + string3 + "\");\n");
    }

    @Override
    public void addComment(String string) {
        code.append("\n");
        code.append("\t\t\t// " + string + "\n");
    }
}

