/*
 * Decompiled with CFR 0.152.
 */
package zexplore.apiexplorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.apiexplorer.APIExplorerPanel;
import zexplore.apiexplorer.APITree;
import zexplore.apiexplorer.APITreeModel;
import zexplore.apiexplorer.APITreePanel;

public class APISearchPanel
extends JPanel {
    private static final long serialVersionUID = -2596853325392771923L;
    private JTextComponent APISearchField;

    public APISearchPanel() {
        this.setLayout(new BorderLayout());
        this.APISearchField = new JTextField(20);
        this.APISearchField.setToolTipText("Filter APIs displayed with a regular expression");
        this.APISearchField.addKeyListener(new KeyOperationsListener());
        this.APISearchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = APISearchPanel.this.APISearchField.getText().trim();
                APISearchPanel.this.searchAndFilterApi(string);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                String string = APISearchPanel.this.APISearchField.getText().trim();
                APISearchPanel.this.searchAndFilterApi(string);
            }
        });
        String string = "search";
        ImageIcon imageIcon = new IconMap().getIcon(string);
        JLabel jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        jLabel.setToolTipText("Filter APIs displayed with a regular expression");
        this.add((Component)this.APISearchField, "Center");
        this.add((Component)jLabel, "East");
    }

    private void searchAndFilterApi(String string) {
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode;
        String string2 = APIExplorerPanel.apiDropDownComboBox.getSelectedDocName();
        if (string2 == null || string2.trim().isEmpty()) {
            return;
        }
        TreeModel treeModel = APITree.parsedTreeMap.getTreeModel(string2);
        if (treeModel == null) {
            return;
        }
        if (string.trim().isEmpty()) {
            APITreePanel.tree.setModel(treeModel);
            return;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeModel.getRoot();
        if (defaultMutableTreeNode2.getChildCount() <= 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("");
        for (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild(); defaultMutableTreeNode != null; defaultMutableTreeNode = defaultMutableTreeNode.getNextSibling()) {
            boolean bl = false;
            serializable = null;
            for (DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(); defaultMutableTreeNode4 != null; defaultMutableTreeNode4 = defaultMutableTreeNode4.getNextSibling()) {
                boolean bl2 = false;
                Matcher matcher = pattern.matcher(defaultMutableTreeNode4.getUserObject().toString());
                while (matcher.find()) {
                    bl2 = true;
                }
                if (!bl2) continue;
                if (!bl) {
                    serializable = new DefaultMutableTreeNode(defaultMutableTreeNode.getUserObject().toString());
                    defaultMutableTreeNode3.add((MutableTreeNode)((Object)serializable));
                    bl = true;
                }
                DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(defaultMutableTreeNode4.getUserObject().toString());
                ((DefaultMutableTreeNode)serializable).add(defaultMutableTreeNode5);
            }
        }
        APITreeModel aPITreeModel = new APITreeModel(defaultMutableTreeNode3);
        APITreePanel.tree.setModel(aPITreeModel);
        if (defaultMutableTreeNode3.getChildCount() > 0) {
            for (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode3.getFirstChild(); defaultMutableTreeNode != null; defaultMutableTreeNode = defaultMutableTreeNode.getNextSibling()) {
                serializable = new TreePath(defaultMutableTreeNode.getPath());
                APITreePanel.tree.expandPath((TreePath)serializable);
            }
        }
    }
}

