/*
 * Decompiled with CFR 0.152.
 */
package zexplore.addedapisworkflows.workflows;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import zexplore.IconMap;
import zexplore.KeyOperationsListener;
import zexplore.addedapisworkflows.workflows.WorkflowsTreePanel;
import zexplore.executedevelop.ExecuteDevelopPane;

public class WorkflowsDeleteButton
extends JButton {
    private static final long serialVersionUID = 5961591332702646052L;

    public WorkflowsDeleteButton() {
        super(new IconMap().getIcon("delete"));
        String string = "Press to Delete the node";
        this.setToolTipText(string);
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                WorkflowsDeleteButton.this.setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                WorkflowsDeleteButton.this.setContentAreaFilled(false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                WorkflowsDeleteButton.this.delete();
            }
        });
        this.addKeyListener(new KeyOperationsListener());
    }

    private void delete() {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)WorkflowsTreePanel.tree.getModel();
        TreePath[] treePathArray = WorkflowsTreePanel.tree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length <= 0) {
            return;
        }
        for (int i = 0; i < treePathArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            int n = defaultTreeModel.getIndexOfChild(defaultMutableTreeNode2, defaultMutableTreeNode);
            if (defaultMutableTreeNode.getLevel() == 1) {
                if (n <= WorkflowsTreePanel.tree.getPredefinedWorkflowsCount() - 1) {
                    return;
                }
                int n2 = WorkflowsTreePanel.tree.getExecuteTabPanelIndex(n);
                ExecuteDevelopPane.executeTabbedPane.removeSelectedTab(n2, true, true);
                continue;
            }
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
    }
}

