/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TreeUtil {
    private static DocumentBuilder parser = null;
    private static final String spaceIndent = "  ";

    public static DefaultTreeModel getTreeModelFromXML(String string, Map<DefaultMutableTreeNode, String> map) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        if (parser == null) {
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(null);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return null;
            }
        }
        Document document = null;
        try {
            document = parser.parse(new InputSource(new StringReader(string)));
        }
        catch (SAXException sAXException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.getTreeRootFromXMLDocument(document, map);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        return defaultTreeModel;
    }

    public static DefaultMutableTreeNode getTreeRootFromXMLStream(InputStream inputStream, Map<DefaultMutableTreeNode, String> map) {
        if (inputStream == null) {
            return null;
        }
        if (parser == null) {
            try {
                parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(null);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                return null;
            }
        }
        Document document = null;
        try {
            document = parser.parse(inputStream);
        }
        catch (SAXException sAXException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return TreeUtil.getTreeRootFromXMLDocument(document, map);
    }

    private static DefaultMutableTreeNode getTreeRootFromXMLDocument(Document document, Map<DefaultMutableTreeNode, String> map) {
        Element element = document.getDocumentElement();
        if (element == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(element.getNodeName());
        String string = "";
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 8) {
                string = node.getNodeValue();
                continue;
            }
            if (node.getNodeType() != 1) continue;
            TreeUtil.traverse(node, defaultMutableTreeNode, map, string);
            string = "";
        }
        return defaultMutableTreeNode;
    }

    private static void traverse(Node node, DefaultMutableTreeNode defaultMutableTreeNode, Map<DefaultMutableTreeNode, String> map, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        if (node.getNodeType() == 1) {
            if (!node.hasChildNodes()) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(node.getNodeName());
            } else if (node.getChildNodes().getLength() == 1) {
                Node node2 = node.getChildNodes().item(0);
                if (node2.getNodeType() == 3) {
                    String string2 = node2.getNodeValue().trim();
                    defaultMutableTreeNode2 = string2.equals("") ? new DefaultMutableTreeNode(node.getNodeName()) : new DefaultMutableTreeNode(node.getNodeName() + " = " + string2);
                }
            } else {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(node.getNodeName());
                String string3 = "";
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node3 = nodeList.item(i);
                    if (node3.getNodeType() == 8) {
                        string3 = node3.getNodeValue();
                        continue;
                    }
                    if (node3.getNodeType() != 1) continue;
                    TreeUtil.traverse(node3, defaultMutableTreeNode2, map, string3);
                    string3 = "";
                }
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (map != null || !string.trim().equals("")) {
                map.put(defaultMutableTreeNode2, string);
            }
        }
    }

    public static void getXMLFromTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, String string, StringBuffer stringBuffer, Map<DefaultMutableTreeNode, String> map) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (string == null) {
            string = "";
        }
        String string2 = "";
        if (map != null) {
            string2 = map.get(defaultMutableTreeNode);
            string2 = string2 != null && !string2.isEmpty() ? string + "<!--" + string2 + "-->\n" : "";
        }
        if (defaultMutableTreeNode.isLeaf()) {
            String string3 = (String)defaultMutableTreeNode.getUserObject();
            if (string3.contains("=")) {
                String[] stringArray = string3.split("=");
                String string4 = stringArray[0].trim();
                String string5 = stringArray[1].trim();
                stringBuffer.append(string2 + string + "<" + string4 + ">" + string5 + "</" + string4 + ">\n");
            } else if (stringBuffer.toString().isEmpty()) {
                stringBuffer.append(string2 + string + "<" + string3 + "/>\n");
            } else {
                stringBuffer.append(string2 + string + "<" + string3 + "></" + string3 + ">\n");
            }
            return;
        }
        stringBuffer.append(string2 + string + "<" + defaultMutableTreeNode.getUserObject() + ">\n");
        for (DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(); defaultMutableTreeNode2 != null; defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextSibling()) {
            TreeUtil.getXMLFromTreeNode(defaultMutableTreeNode2, string + spaceIndent, stringBuffer, map);
        }
        stringBuffer.append(string + "</" + defaultMutableTreeNode.getUserObject() + ">\n");
    }

    public static DefaultMutableTreeNode createClonedTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.clone();
        if (defaultMutableTreeNode.getChildCount() > 0) {
            for (DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild(); defaultMutableTreeNode3 != null; defaultMutableTreeNode3 = defaultMutableTreeNode3.getNextSibling()) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = TreeUtil.createClonedTreeNode(defaultMutableTreeNode3);
                defaultMutableTreeNode2.add(defaultMutableTreeNode4);
            }
        }
        return defaultMutableTreeNode2;
    }
}

