/*
 * Decompiled with CFR 0.152.
 */
package netapp.manage;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import netapp.manage.NaElement;
import netapp.manage.NaError;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class NaParser {
    private static final boolean DO_SYSLOG = false;
    private static final boolean VALIDATE = false;
    private static SAXParserFactory _factory = SAXParserFactory.newInstance();

    private NaParser() {
    }

    static NaElement parseTree(Reader reader) throws IOException, SAXException {
        XMLReader xMLReader;
        try {
            xMLReader = _factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new NaError("Failed to get XML parser", parserConfigurationException);
        }
        xMLReader.setFeature("http://xml.org/sax/features/validation", false);
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        NaHandler naHandler = new NaHandler();
        xMLReader.setContentHandler(naHandler);
        xMLReader.parse(new InputSource(reader));
        return naHandler._rootElem;
    }

    static {
        _factory.setValidating(false);
        _factory.setNamespaceAware(true);
    }

    private static class NaHandler
    extends DefaultHandler {
        private StringBuffer _currentToken = new StringBuffer();
        private Stack _tokens = new Stack();
        private Stack _elementStack = new Stack();
        private NaElement _currentElem = null;
        NaElement _rootElem = null;

        NaHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this._tokens.push(this._currentToken);
            this._currentToken = new StringBuffer();
            this._elementStack.push(this._currentElem);
            this._currentElem = new NaElement(string3, null, attributes);
        }

        public void endElement(String string, String string2, String string3) {
            if (0 < this._currentToken.length()) {
                this._currentElem.setContent(this._currentToken.toString());
            }
            this._currentToken = (StringBuffer)this._tokens.pop();
            NaElement naElement = (NaElement)this._elementStack.pop();
            if (null == naElement) {
                this._rootElem = this._currentElem;
            } else {
                naElement.addChildElem(this._currentElem);
            }
            this._currentElem = naElement;
        }

        public void characters(char[] cArray, int n, int n2) {
            this._currentToken.append(cArray, n, n2);
        }
    }
}

