/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.zapi.parser.Api;
import com.netapp.zapi.parser.Block;
import com.netapp.zapi.parser.Category;
import com.netapp.zapi.parser.Errdef;
import com.netapp.zapi.parser.InternableFields;
import com.netapp.zapi.parser.MsgKey;
import com.netapp.zapi.parser.Namespace;
import com.netapp.zapi.parser.Tag;
import com.netapp.zapi.parser.Type;
import com.netapp.zapi.parser.Typedef;
import com.netapp.zapi.parser.ZapidocFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;

public class ZapidocParser {
    static final NALogger logger = NALogger.getLogger(ZapidocParser.class);
    private List<File> docFiles;
    private ZapidocFilter filter;
    private InternableFields internableFields;
    private InputStream inputStream;
    private boolean printLogEnabled = true;
    List<Block> blocks;
    private Map<String, Category> categories;
    private Category currentCategory;
    private Map<String, Namespace> namespaces;
    private Namespace lastNamespace;
    private Map<Integer, Errdef> errdefs = new TreeMap<Integer, Errdef>();
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();

    public ZapidocParser(List<File> zapidocFiles) throws IOException {
        this(zapidocFiles, new ZapidocFilter());
    }

    public ZapidocParser(List<File> zapidocFiles, ZapidocFilter filter) throws IOException {
        this(zapidocFiles, filter, Collections.emptyList());
    }

    public ZapidocParser(List<File> zapidocFiles, ZapidocFilter filter, List<File> internableFieldFiles) throws IOException {
        this.docFiles = zapidocFiles;
        this.categories = new TreeMap<String, Category>();
        this.namespaces = new HashMap<String, Namespace>();
        this.filter = filter;
        this.internableFields = internableFieldFiles == null ? InternableFields.EMPTY_INTERNABLE_FIELDS : InternableFields.load(internableFieldFiles);
        this.parseInput();
        this.checkErrnos();
    }

    public ZapidocParser(InputStream inputStream, ZapidocFilter filter, boolean printLogEnabled) throws IOException {
        this.inputStream = inputStream;
        this.categories = new TreeMap<String, Category>();
        this.namespaces = new HashMap<String, Namespace>();
        this.filter = filter;
        this.internableFields = InternableFields.EMPTY_INTERNABLE_FIELDS;
        this.printLogEnabled = printLogEnabled;
        this.parseInputStream();
    }

    Category getCurrentCategory() {
        return this.currentCategory;
    }

    public Namespace getNamespace(String name) {
        Namespace n = this.namespaces.get(name = name.toLowerCase());
        if (n == null) {
            n = new Namespace(name);
            this.namespaces.put(name, n);
        }
        return n;
    }

    public Collection<Errdef> getErrdefs() {
        return this.errdefs.values();
    }

    public Map<String, Errdef> getErrdefsMap() {
        HashMap<String, Errdef> errdefsMap = new HashMap<String, Errdef>();
        for (Errdef errdef : this.getErrdefs()) {
            errdefsMap.put(errdef.getName(), errdef);
        }
        return errdefsMap;
    }

    public Collection<Namespace> getNamespaces() {
        return this.namespaces.values();
    }

    void setLastNamespace(Namespace namespace) {
        this.lastNamespace = namespace;
    }

    Namespace getLastNamespace() {
        if (this.lastNamespace == null) {
            this.lastNamespace = this.getNamespace("filer");
        }
        return this.lastNamespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInput() throws IOException {
        this.blocks = new ArrayList<Block>();
        for (File docFile : this.docFiles) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(docFile));
                this.blocks.addAll(Block.readBlocks(reader));
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        for (Block block : this.blocks) {
            this.processBlock(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInputStream() throws IOException {
        this.blocks = new ArrayList<Block>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.inputStream));
            this.blocks.addAll(Block.readBlocks(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        for (Block block : this.blocks) {
            this.processBlock(block);
        }
    }

    protected ZapidocFilter getFilter() {
        return this.filter;
    }

    private void processBlock(Block block) {
        if (block.getTags().isEmpty()) {
            return;
        }
        Queue<Tag> queue = block.getTags();
        Tag tag = queue.poll();
        block7: while (tag != null) {
            logger.internal("Processing: %s", tag);
            switch (tag.getType()) {
                case CATEGORY: {
                    Category cat = this.categories.get(tag.getFirstWord());
                    if (cat == null) {
                        cat = new Category(tag.getFirstWord());
                        this.categories.put(cat.getName(), cat);
                    }
                    cat.populate(queue);
                    this.currentCategory = cat;
                    break;
                }
                case API: {
                    Api api = new Api(this, tag.getFirstWord());
                    api.populate(queue);
                    break;
                }
                case TYPEDEF: {
                    Typedef typedef = new Typedef(this, tag.getFirstWord());
                    typedef.populate(queue);
                    break;
                }
                case ERRDEF: {
                    String[] tmp = tag.getValue().split("\\s+");
                    Errdef errdef = new Errdef(tmp[0], Integer.parseInt(tmp[1]));
                    errdef.populate(queue);
                    Errdef existingErrdef = this.errdefs.get(errdef.getCode());
                    if (existingErrdef != null) {
                        if (!this.printLogEnabled) break;
                        this.appendWarning(MsgKey.ZAPI_PARSER_DUPLICATE_ERRDEF, errdef.getCode(), existingErrdef.getName(), errdef.getName());
                        break;
                    }
                    this.errdefs.put(errdef.getCode(), errdef);
                    break;
                }
                case REMARK: {
                    break;
                }
                default: {
                    logger.internal("Stopping block on " + (Object)((Object)tag.getType()));
                    break block7;
                }
            }
            tag = queue.poll();
        }
    }

    private void checkErrnos() {
        Map<String, Errdef> errdefsMap = this.getErrdefsMap();
        for (Namespace namespace : this.getNamespaces()) {
            for (Type type : namespace.getTypes()) {
                if (!(type instanceof Api)) continue;
                Api api = (Api)type;
                for (String errno : api.getErrors()) {
                    if (errdefsMap.containsKey(errno)) continue;
                    this.appendError(MsgKey.ZAPI_PARSER_UNKNOWN_ERRNO, errno, api.getName());
                }
            }
        }
    }

    protected void appendError(MsgKey messageKey, Object ... params) {
        if (this.printLogEnabled) {
            this.errors.add(logger.error((MessageKey)messageKey, params));
        }
    }

    protected void appendWarning(MsgKey messageKey, Object ... params) {
        if (this.printLogEnabled) {
            this.warnings.add(logger.warn((MessageKey)messageKey, params));
        }
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<String> getWarnings() {
        return Collections.unmodifiableList(this.errors);
    }

    public void enablePrintLog(boolean value) {
        this.printLogEnabled = value;
    }

    public boolean isPrintLogEnabled() {
        return this.printLogEnabled;
    }

    public Collection<String> getInternableValues(String typeName, String fieldName) {
        return this.internableFields.getInternableValues(typeName, fieldName);
    }
}

