/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.zapi.parser.Field;
import com.netapp.zapi.parser.IncompatibleTypesException;
import com.netapp.zapi.parser.MsgKey;
import com.netapp.zapi.parser.PrimitiveType;
import com.netapp.zapi.parser.Tag;
import com.netapp.zapi.parser.Type;
import com.netapp.zapi.parser.ZapidocParser;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Typedef
extends Type {
    private static final NALogger logger = NALogger.getLogger(Typedef.class);
    private static final Pattern TYPE_MODIFIER_PATTERN = Pattern.compile("(\\S+)\\s*,\\s*(.*)");
    private String type;

    Typedef(ZapidocParser parser, String name) {
        super(parser, name);
    }

    public String getType() {
        return this.type;
    }

    protected TypedefField getField(String fieldName) {
        TypedefField field = null;
        for (Field f : this.fields) {
            if (!fieldName.equals(f.getName())) continue;
            field = (TypedefField)f;
            break;
        }
        return field;
    }

    @Override
    public void populate(Queue<Tag> q) {
        logger.internal("Processing Field " + this.name);
        Tag tag = q.peek();
        block8: while (tag != null) {
            Field field = null;
            boolean keepField = true;
            switch (tag.getType()) {
                case DESC: {
                    this.setDesc(tag.getValue());
                    break;
                }
                case TYPE: {
                    if (this.fields.isEmpty()) {
                        String destinationType = tag.getValue().toLowerCase();
                        Matcher matcher = TYPE_MODIFIER_PATTERN.matcher(destinationType);
                        if (matcher.matches()) {
                            this.parser.appendWarning(MsgKey.ZAPI_PARSER_TYPEDEF_ALIAS_MODIFER, this, matcher.group(2));
                            destinationType = matcher.group(1);
                        }
                        if (PrimitiveType.PRIMITIVE_TYPES.containsKey(destinationType)) {
                            this.type = destinationType;
                            break;
                        }
                        this.parser.appendWarning(MsgKey.ZAPI_PARSER_INVALID_TYPEDEF_ALIAS_TYPE, destinationType, this);
                        this.type = destinationType;
                        break;
                    }
                    this.parser.appendError(MsgKey.ZAPI_PARSER_INVALID_TYPEDEF_ALIAS, this);
                    break;
                }
                case ELEMENT: {
                    if (this.type == null) {
                        field = new TypedefField(tag.getFirstWord());
                        if (this.getField(tag.getFirstWord()) == null) break;
                        this.parser.appendError(MsgKey.ZAPI_PARSER_API_FIELD_DEFINED_TWICE, this, ((TypedefField)field).name);
                        keepField = false;
                        break;
                    }
                    this.parser.appendError(MsgKey.ZAPI_PARSER_INVALID_TYPEDEF_ALIAS, this);
                    break;
                }
                case NAMESPACE: {
                    this.setNamespace(tag.getFirstWord());
                    break;
                }
                case ATTRIBUTE: {
                    if (!this.parser.isPrintLogEnabled()) break;
                    logger.info((MessageKey)MsgKey.ZAPI_PARSER_UNHANDLED_TYPEDEF_ATTRIBUTE, tag.getFirstWord(), this);
                    break;
                }
                case REMARK: 
                case SCOPE: {
                    break;
                }
                default: {
                    logger.internal("Stopping Typedef on " + (Object)((Object)tag.getType()));
                    break block8;
                }
            }
            q.poll();
            if (field != null) {
                field.populate(q);
                if (keepField && this.parser.getFilter().includeField(field)) {
                    this.fields.add(field);
                }
            }
            tag = q.peek();
        }
        if (this.namespace == null) {
            this.setNamespace(this.parser.getLastNamespace());
        }
        this.namespace.addType(this);
    }

    @Override
    public boolean isAlias() {
        return this.type != null;
    }

    @Override
    public Type getRootType() {
        if (this.type == null) {
            return this;
        }
        return this.namespace.getType(this.type).getRootType();
    }

    @Override
    public void assertEquivalentTo(Type that) throws IncompatibleTypesException {
        this.assertEquivalientTo(that, this.fields, that.fields);
    }

    public class TypedefField
    extends Field {
        public TypedefField(String name) {
            super(Typedef.this, name);
        }
    }
}

