/*
 * Decompiled with CFR 0.152.
 */
package com.netapp.zapi.parser;

import com.netapp.nmsdk.common.logging.MessageKey;
import com.netapp.nmsdk.common.logging.NALogger;
import com.netapp.zapi.generator.GeneratorFactory;
import com.netapp.zapi.parser.Api;
import com.netapp.zapi.parser.IncompatibleTypesException;
import com.netapp.zapi.parser.MsgKey;
import com.netapp.zapi.parser.PrimitiveType;
import com.netapp.zapi.parser.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class Namespace {
    private static final NALogger logger = NALogger.getLogger(Namespace.class);
    private String name;
    private Map<String, Type> types = new TreeMap<String, Type>();

    Namespace(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addType(Type type) {
        Type existingType = this.types.get(type.getName());
        if (existingType != null) {
            try {
                existingType.assertEquivalentTo(type);
            }
            catch (IncompatibleTypesException e) {
                if (existingType.parser.isPrintLogEnabled()) {
                    logger.error((MessageKey)MsgKey.ZAPI_PARSER_INCOMPATIBLE_DUPLICATE_TYPES, e.getType1().getQualifiedName(), e.getType2().getQualifiedName(), e.getLocalizedMessage());
                }
            }
        } else {
            this.types.put(type.getName(), type);
        }
    }

    public Collection<Type> getTypes() {
        return this.types.values();
    }

    public Type getType(String name) {
        Type type = this.types.get(name);
        if (type == null) {
            type = PrimitiveType.PRIMITIVE_TYPES.get(name);
        }
        return type;
    }

    public Collection<Api> getApis() {
        LinkedList<Api> apis = new LinkedList<Api>();
        for (Type type : this.types.values()) {
            if (!(type instanceof Api)) continue;
            apis.add((Api)type);
        }
        return apis;
    }

    public void addWordReplacements(GeneratorFactory<?, ?, ?, ?> generatorFactory) {
        for (Type type : this.getTypes()) {
            type.addWordReplacements(generatorFactory);
        }
    }

    public String toString() {
        return this.getName();
    }

    public Map<String, Type> getTypeMap() {
        return this.types;
    }
}

